/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.support.Destructors;
import org.clank.support.NativePointer;
import org.clank.support.aliases.type;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.mc.MCInstPrinter;
import org.llvm.mc.MCOperand;
import org.llvm.support.SMLoc;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class MCInst
implements Destructors.ClassWithDestructor {
    private int Opcode;
    private SMLoc Loc;
    private SmallVector<MCOperand> Operands;

    public MCInst() {
        this.Opcode = 0;
        this.Loc = new SMLoc();
        this.Operands = new SmallVector<MCOperand>(8, new MCOperand());
    }

    public void setOpcode(int Op2) {
        this.Opcode = Op2;
    }

    public int getOpcode() {
        return this.Opcode;
    }

    public void setLoc(SMLoc loc) {
        this.Loc.$assign(loc);
    }

    public SMLoc getLoc() {
        return new SMLoc(this.Loc);
    }

    public MCOperand getOperand$Const(int i) {
        return (MCOperand)this.Operands.$at$Const(i);
    }

    public MCOperand getOperand(int i) {
        return (MCOperand)this.Operands.$at(i);
    }

    public int getNumOperands() {
        return this.Operands.size();
    }

    public void addOperand(MCOperand Op2) {
        this.Operands.push_back(Op2);
    }

    public void clear() {
        this.Operands.clear();
    }

    public void erase(type.ptr<MCOperand> I) {
        this.Operands.erase(I);
    }

    public int size() {
        return this.Operands.size();
    }

    public type.ptr<MCOperand> begin() {
        return this.Operands.begin();
    }

    public type.ptr<MCOperand> begin$Const() {
        return this.Operands.begin$Const();
    }

    public type.ptr<MCOperand> end() {
        return this.Operands.end();
    }

    public type.ptr<MCOperand> end$Const() {
        return this.Operands.end$Const();
    }

    public type.ptr<MCOperand> insert(type.ptr<MCOperand> I, MCOperand Op2) {
        return this.Operands.insert_iterator$T$value_T$C$R(I, Op2);
    }

    public void print(raw_ostream OS) {
        OS.$out("<MCInst ").$out_uint(this.getOpcode());
        int e = this.getNumOperands();
        for (int i = 0; i != e; ++i) {
            OS.$out(NativePointer.$SPACE);
            this.getOperand$Const(i).print(OS);
        }
        OS.$out(NativePointer.$GT);
    }

    public void dump() {
        this.print(llvm.dbgs());
        llvm.dbgs().$out(NativePointer.$LF);
    }

    public void dump_pretty(raw_ostream OS) {
        this.dump_pretty(OS, null, new StringRef(NativePointer.$SPACE));
    }

    public void dump_pretty(raw_ostream OS, MCInstPrinter Printer) {
        this.dump_pretty(OS, Printer, new StringRef(NativePointer.$SPACE));
    }

    public void dump_pretty(raw_ostream OS, MCInstPrinter Printer, StringRef Separator) {
        OS.$out("<MCInst #").$out_uint(this.getOpcode());
        if (Printer != null) {
            OS.$out_char((byte)32).$out(Printer.getOpcodeName(this.getOpcode()));
        }
        int e = this.getNumOperands();
        for (int i = 0; i != e; ++i) {
            OS.$out(Separator);
            this.getOperand$Const(i).print(OS);
        }
        OS.$out(NativePointer.$GT);
    }

    public MCInst(MCInst $Prm0) {
        this.Opcode = $Prm0.Opcode;
        this.Loc = new SMLoc($Prm0.Loc);
        this.Operands = new SmallVector<MCOperand>($Prm0.Operands);
    }

    public void $destroy() {
        this.Operands.$destroy();
    }

    public MCInst $assign(MCInst $Prm0) {
        this.Opcode = $Prm0.Opcode;
        this.Loc.$assign($Prm0.Loc);
        this.Operands.$assign($Prm0.Operands);
        return this;
    }

    public String toString() {
        return "Opcode=" + this.Opcode + ", Loc=" + this.Loc + ", Operands=" + this.Operands;
    }
}

