/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.long;
import org.clank.support.aliases.type;
import org.llvm.adt.aliases.DenseMapTypeULong;
import org.llvm.adt.java.ADTRTTI;
import org.llvm.mc.MCAsmInfo;
import org.llvm.mc.MCAsmLayout;
import org.llvm.mc.MCAssembler;
import org.llvm.mc.MCBinaryExpr;
import org.llvm.mc.MCConstantExpr;
import org.llvm.mc.MCFixup;
import org.llvm.mc.MCFragment;
import org.llvm.mc.MCSection;
import org.llvm.mc.MCSymbol;
import org.llvm.mc.MCSymbolRefExpr;
import org.llvm.mc.MCUnaryExpr;
import org.llvm.mc.MCValue;
import org.llvm.mc.impl.MCExprStatics;
import org.llvm.mc.stats.impl.StatsStatics;
import org.llvm.support.AdtsupportLlvmGlobals;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;

public class MCExpr {
    private ExprKind Kind;

    protected MCExpr(MCExpr $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected void $assign(MCExpr $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    private boolean evaluateAsAbsolute(long.ref Res, MCAssembler Asm, MCAsmLayout Layout, DenseMapTypeULong<MCSection> Addrs) {
        return this.evaluateAsAbsolute(Res, Asm, Layout, Addrs, Addrs != null);
    }

    private boolean evaluateAsAbsolute(long.ref Res, MCAssembler Asm, MCAsmLayout Layout, DenseMapTypeULong<MCSection> Addrs, boolean InSet) {
        MCValue Value = new MCValue();
        MCConstantExpr CE = ADTRTTI.dyn_cast_MCConstantExpr(this);
        if (CE != null) {
            Res.$set(CE.getValue());
            return true;
        }
        boolean IsRelocatable = this.evaluateAsRelocatableImpl(Value, Asm, Layout, null, Addrs, InSet);
        Res.$set(Value.getConstant());
        return IsRelocatable && Value.isAbsolute();
    }

    protected MCExpr(ExprKind Kind2) {
        this.Kind = Kind2;
    }

    protected boolean evaluateAsRelocatableImpl(MCValue Res, MCAssembler Asm, MCAsmLayout Layout, MCFixup Fixup, DenseMapTypeULong<MCSection> Addrs, boolean InSet) {
        StatsStatics.MCExprEvaluate.$preInc();
        switch ((ExprKind)this.getKind()) {
            case Target: {
                return ADTRTTI.cast_MCTargetExpr(this).evaluateAsRelocatableImpl(Res, Layout, Fixup);
            }
            case Constant: {
                Res.$assignMove(MCValue.get(ADTRTTI.cast_MCConstantExpr(this).getValue()));
                return true;
            }
            case SymbolRef: {
                MCSymbolRefExpr SRE = ADTRTTI.cast_MCSymbolRefExpr(this);
                MCSymbol Sym = SRE.getSymbol();
                if (Sym.isVariable() && SRE.getKind() == MCSymbolRefExpr.VariantKind.VK_None && MCExprStatics.canExpand(Sym, InSet)) {
                    boolean IsMachO = SRE.hasSubsectionsViaSymbols();
                    if (Sym.getVariableValue().evaluateAsRelocatableImpl(Res, Asm, Layout, Fixup, Addrs, InSet || IsMachO)) {
                        if (!IsMachO) {
                            return true;
                        }
                        MCSymbolRefExpr A = Res.getSymA();
                        MCSymbolRefExpr B = Res.getSymB();
                        if (A == null && B == null) {
                            return true;
                        }
                    }
                }
                Res.$assignMove(MCValue.get(SRE, null, 0L));
                return true;
            }
            case Unary: {
                MCUnaryExpr AUE = ADTRTTI.cast_MCUnaryExpr(this);
                MCValue Value = new MCValue();
                if (!AUE.getSubExpr().evaluateAsRelocatableImpl(Value, Asm, Layout, Fixup, Addrs, InSet)) {
                    return false;
                }
                switch (AUE.getOpcode()) {
                    case LNot: {
                        if (!Value.isAbsolute()) {
                            return false;
                        }
                        Res.$assignMove(MCValue.get(Value.getConstant() == 0L ? 1 : 0));
                        break;
                    }
                    case Minus: {
                        if (Value.getSymA() != null && Value.getSymB() == null) {
                            return false;
                        }
                        Res.$assignMove(MCValue.get(Value.getSymB(), Value.getSymA(), -Value.getConstant()));
                        break;
                    }
                    case Not: {
                        if (!Value.isAbsolute()) {
                            return false;
                        }
                        Res.$assignMove(MCValue.get(Value.getConstant() ^ 0xFFFFFFFFFFFFFFFFL));
                        break;
                    }
                    case Plus: {
                        Res.$assign(Value);
                    }
                }
                return true;
            }
            case Binary: {
                MCBinaryExpr ABE = ADTRTTI.cast_MCBinaryExpr(this);
                MCValue LHSValue = new MCValue();
                MCValue RHSValue = new MCValue();
                if (!ABE.getLHS().evaluateAsRelocatableImpl(LHSValue, Asm, Layout, Fixup, Addrs, InSet) || !ABE.getRHS().evaluateAsRelocatableImpl(RHSValue, Asm, Layout, Fixup, Addrs, InSet)) {
                    return false;
                }
                if (!LHSValue.isAbsolute() || !RHSValue.isAbsolute()) {
                    switch (ABE.getOpcode()) {
                        default: {
                            return false;
                        }
                        case Sub: {
                            return MCExprStatics.EvaluateSymbolicAdd(Asm, Layout, Addrs, InSet, LHSValue, (type.ref<MCSymbolRefExpr>)NativePointer.create_type$ref((Object)RHSValue.getSymB()), (type.ref<MCSymbolRefExpr>)NativePointer.create_type$ref((Object)RHSValue.getSymA()), -RHSValue.getConstant(), Res);
                        }
                        case Add: 
                    }
                    return MCExprStatics.EvaluateSymbolicAdd(Asm, Layout, Addrs, InSet, LHSValue, (type.ref<MCSymbolRefExpr>)NativePointer.create_type$ref((Object)RHSValue.getSymA()), (type.ref<MCSymbolRefExpr>)NativePointer.create_type$ref((Object)RHSValue.getSymB()), RHSValue.getConstant(), Res);
                }
                long LHS = LHSValue.getConstant();
                long RHS = RHSValue.getConstant();
                long Result = 0L;
                switch (ABE.getOpcode()) {
                    case AShr: {
                        Result = LHS >> (int)RHS;
                        break;
                    }
                    case Add: {
                        Result = LHS + RHS;
                        break;
                    }
                    case And: {
                        Result = LHS & RHS;
                        break;
                    }
                    case Div: {
                        if (RHS == 0L) {
                            return false;
                        }
                        Result = LHS / RHS;
                        break;
                    }
                    case EQ: {
                        Result = LHS == RHS ? 1 : 0;
                        break;
                    }
                    case GT: {
                        Result = LHS > RHS ? 1 : 0;
                        break;
                    }
                    case GTE: {
                        Result = LHS >= RHS ? 1 : 0;
                        break;
                    }
                    case LAnd: {
                        Result = LHS != 0L && RHS != 0L ? 1 : 0;
                        break;
                    }
                    case LOr: {
                        Result = LHS != 0L || RHS != 0L ? 1 : 0;
                        break;
                    }
                    case LShr: {
                        Result = LHS >>> (int)RHS;
                        break;
                    }
                    case LT: {
                        Result = LHS < RHS ? 1 : 0;
                        break;
                    }
                    case LTE: {
                        Result = LHS <= RHS ? 1 : 0;
                        break;
                    }
                    case Mod: {
                        Result = LHS % RHS;
                        break;
                    }
                    case Mul: {
                        Result = LHS * RHS;
                        break;
                    }
                    case NE: {
                        Result = LHS != RHS ? 1 : 0;
                        break;
                    }
                    case Or: {
                        Result = LHS | RHS;
                        break;
                    }
                    case Shl: {
                        Result = LHS << (int)RHS;
                        break;
                    }
                    case Sub: {
                        Result = LHS - RHS;
                        break;
                    }
                    case Xor: {
                        Result = LHS ^ RHS;
                    }
                }
                Res.$assignMove(MCValue.get(Result));
                return true;
            }
        }
        throw new llvm_unreachable("Invalid assembly expression kind!");
    }

    public Native.NativeUShortEnum getKind() {
        return this.Kind;
    }

    public void print(raw_ostream OS, MCAsmInfo MAI) {
        this.print(OS, MAI, false);
    }

    public void print(raw_ostream OS, MCAsmInfo MAI, boolean InParens) {
        switch ((ExprKind)this.getKind()) {
            case Target: {
                ADTRTTI.cast_MCTargetExpr(this).printImpl(OS, MAI);
                return;
            }
            case Constant: {
                OS.$out_llong(ADTRTTI.cast_MCConstantExpr(this).getValue());
                return;
            }
            case SymbolRef: {
                boolean UseParens;
                MCSymbolRefExpr SRE = ADTRTTI.cast_MCSymbolRefExpr(this);
                MCSymbol Sym = SRE.getSymbol();
                boolean bl = UseParens = !InParens && Sym.getName().size() != 0 && Sym.getName().$at(0) == 36;
                if (UseParens) {
                    OS.$out_char((byte)40);
                    Sym.print(OS, MAI);
                    OS.$out_char((byte)41);
                } else {
                    Sym.print(OS, MAI);
                }
                if (SRE.getKind() != MCSymbolRefExpr.VariantKind.VK_None) {
                    SRE.printVariantKind(OS);
                }
                return;
            }
            case Unary: {
                MCUnaryExpr UE = ADTRTTI.cast_MCUnaryExpr(this);
                switch (UE.getOpcode()) {
                    case LNot: {
                        OS.$out_char((byte)33);
                        break;
                    }
                    case Minus: {
                        OS.$out_char((byte)45);
                        break;
                    }
                    case Not: {
                        OS.$out_char((byte)126);
                        break;
                    }
                    case Plus: {
                        OS.$out_char((byte)43);
                    }
                }
                UE.getSubExpr().print(OS, MAI);
                return;
            }
            case Binary: {
                MCBinaryExpr BE = ADTRTTI.cast_MCBinaryExpr(this);
                if (ADTRTTI.isa_MCConstantExpr(BE.getLHS()) || ADTRTTI.isa_MCSymbolRefExpr(BE.getLHS())) {
                    BE.getLHS().print(OS, MAI);
                } else {
                    OS.$out_char((byte)40);
                    BE.getLHS().print(OS, MAI);
                    OS.$out_char((byte)41);
                }
                switch (BE.getOpcode()) {
                    case Add: {
                        MCConstantExpr RHSC = ADTRTTI.dyn_cast_MCConstantExpr(BE.getRHS());
                        if (RHSC != null && RHSC.getValue() < 0L) {
                            OS.$out_llong(RHSC.getValue());
                            return;
                        }
                        OS.$out_char((byte)43);
                        break;
                    }
                    case AShr: {
                        OS.$out(NativePointer.$GT_GT);
                        break;
                    }
                    case And: {
                        OS.$out_char((byte)38);
                        break;
                    }
                    case Div: {
                        OS.$out_char((byte)47);
                        break;
                    }
                    case EQ: {
                        OS.$out(NativePointer.$EQ_EQ);
                        break;
                    }
                    case GT: {
                        OS.$out_char((byte)62);
                        break;
                    }
                    case GTE: {
                        OS.$out(NativePointer.$GT_EQ);
                        break;
                    }
                    case LAnd: {
                        OS.$out(NativePointer.$AMP_AMP);
                        break;
                    }
                    case LOr: {
                        OS.$out(NativePointer.$PIPE_PIPE);
                        break;
                    }
                    case LShr: {
                        OS.$out(NativePointer.$GT_GT);
                        break;
                    }
                    case LT: {
                        OS.$out_char((byte)60);
                        break;
                    }
                    case LTE: {
                        OS.$out(NativePointer.$LT_EQ);
                        break;
                    }
                    case Mod: {
                        OS.$out_char((byte)37);
                        break;
                    }
                    case Mul: {
                        OS.$out_char((byte)42);
                        break;
                    }
                    case NE: {
                        OS.$out(NativePointer.$EXCLAIM_EQ);
                        break;
                    }
                    case Or: {
                        OS.$out_char((byte)124);
                        break;
                    }
                    case Shl: {
                        OS.$out(NativePointer.$LT_LT);
                        break;
                    }
                    case Sub: {
                        OS.$out_char((byte)45);
                        break;
                    }
                    case Xor: {
                        OS.$out_char((byte)94);
                    }
                }
                if (ADTRTTI.isa_MCConstantExpr(BE.getRHS()) || ADTRTTI.isa_MCSymbolRefExpr(BE.getRHS())) {
                    BE.getRHS().print(OS, MAI);
                } else {
                    OS.$out_char((byte)40);
                    BE.getRHS().print(OS, MAI);
                    OS.$out_char((byte)41);
                }
                return;
            }
        }
        throw new llvm_unreachable("Invalid expression kind!");
    }

    public void dump() {
        AdtsupportLlvmGlobals.$out_raw_ostream_MCExpr$C(llvm.dbgs(), this);
        llvm.dbgs().$out_char((byte)10);
    }

    public boolean evaluateAsAbsolute(long.ref Res, MCAsmLayout Layout, DenseMapTypeULong<MCSection> Addrs) {
        return this.evaluateAsAbsolute(Res, (MCAssembler)Native.$AddrOf((Object)Layout.getAssembler()), (MCAsmLayout)Native.$AddrOf((Object)Layout), (DenseMapTypeULong)Native.$AddrOf(Addrs));
    }

    public boolean evaluateAsAbsolute(long.ref Res) {
        return this.evaluateAsAbsolute(Res, null, null, null);
    }

    public boolean evaluateAsAbsolute(long.ref Res, MCAssembler Asm) {
        return this.evaluateAsAbsolute(Res, (MCAssembler)Native.$AddrOf((Object)Asm), null, null);
    }

    public boolean evaluateAsAbsolute(long.ref Res, MCAsmLayout Layout) {
        return this.evaluateAsAbsolute(Res, (MCAssembler)Native.$AddrOf((Object)Layout.getAssembler()), (MCAsmLayout)Native.$AddrOf((Object)Layout), null);
    }

    public boolean evaluateKnownAbsolute(long.ref Res, MCAsmLayout Layout) {
        return this.evaluateAsAbsolute(Res, (MCAssembler)Native.$AddrOf((Object)Layout.getAssembler()), (MCAsmLayout)Native.$AddrOf((Object)Layout), null, true);
    }

    public boolean evaluateAsRelocatable(MCValue Res, MCAsmLayout Layout, MCFixup Fixup) {
        MCAssembler Assembler = Layout != null ? (MCAssembler)Native.$AddrOf((Object)Layout.getAssembler()) : null;
        return this.evaluateAsRelocatableImpl(Res, Assembler, Layout, Fixup, null, false);
    }

    public boolean evaluateAsValue(MCValue Res, MCAsmLayout Layout) {
        MCAssembler Assembler = (MCAssembler)Native.$AddrOf((Object)Layout.getAssembler());
        return this.evaluateAsRelocatableImpl(Res, Assembler, (MCAsmLayout)Native.$AddrOf((Object)Layout), null, null, true);
    }

    public MCFragment findAssociatedFragment() {
        switch ((ExprKind)this.getKind()) {
            case Target: {
                return ADTRTTI.cast_MCTargetExpr(this).findAssociatedFragment();
            }
            case Constant: {
                return MCSymbol.AbsolutePseudoFragment;
            }
            case SymbolRef: {
                MCSymbolRefExpr SRE = ADTRTTI.cast_MCSymbolRefExpr(this);
                MCSymbol Sym = SRE.getSymbol();
                return Sym.getFragment();
            }
            case Unary: {
                return ADTRTTI.cast_MCUnaryExpr(this).getSubExpr().findAssociatedFragment();
            }
            case Binary: {
                MCBinaryExpr BE = ADTRTTI.cast_MCBinaryExpr(this);
                MCFragment LHS_F = BE.getLHS().findAssociatedFragment();
                MCFragment RHS_F = BE.getRHS().findAssociatedFragment();
                if (LHS_F == MCSymbol.AbsolutePseudoFragment) {
                    return RHS_F;
                }
                if (RHS_F == MCSymbol.AbsolutePseudoFragment) {
                    return LHS_F;
                }
                if (BE.getOpcode() == MCBinaryExpr.Opcode.Sub) {
                    return MCSymbol.AbsolutePseudoFragment;
                }
                return LHS_F != null ? LHS_F : RHS_F;
            }
        }
        throw new llvm_unreachable("Invalid assembly expression kind!");
    }

    public void $destroy() {
    }

    public String toString() {
        return "Kind=" + (Object)((Object)this.Kind);
    }

    public static final class ExprKind
    extends Enum<ExprKind>
    implements Native.NativeUShortEnum {
        public static final /* enum */ ExprKind Binary = new ExprKind(0);
        public static final /* enum */ ExprKind Constant = new ExprKind(Binary.getValue() + '\u0001');
        public static final /* enum */ ExprKind SymbolRef = new ExprKind(Constant.getValue() + '\u0001');
        public static final /* enum */ ExprKind Unary = new ExprKind(SymbolRef.getValue() + '\u0001');
        public static final /* enum */ ExprKind Target = new ExprKind(Unary.getValue() + '\u0001');
        private final char value;
        private static final /* synthetic */ ExprKind[] $VALUES;

        public static ExprKind[] values() {
            return (ExprKind[])$VALUES.clone();
        }

        public static ExprKind valueOf(String name) {
            return Enum.valueOf(ExprKind.class, name);
        }

        public static ExprKind valueOf(int val) {
            ExprKind out;
            ExprKind exprKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private ExprKind(int val) {
            this.value = (char)val;
        }

        public final char getValue() {
            return this.value;
        }

        static {
            $VALUES = new ExprKind[]{Binary, Constant, SymbolRef, Unary, Target};
        }

        private static final class Values {
            private static final ExprKind[] VALUES;
            private static final ExprKind[] _VALUES;

            private Values() {
            }

            static {
                char max = '\u0000';
                char min = '\u0000';
                for (ExprKind kind : ExprKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new ExprKind[min < '\u0000' ? 1 - min : 0];
                VALUES = new ExprKind[max >= '\u0000' ? '\u0001' + max : 0];
                for (ExprKind kind : ExprKind.values()) {
                    if (kind.value < '\u0000') {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((ExprKind)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((ExprKind)kind).value] = kind;
                }
            }
        }
    }
}

