/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.support.JavaDifferentiators;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMoveable;
import org.clank.support.Unsigned;

public class MCDwarfLoc
implements NativeCloneable<MCDwarfLoc>,
NativeMoveable<MCDwarfLoc> {
    private int FileNum;
    private int Line;
    private char Column;
    private byte Flags;
    private byte Isa;
    private int Discriminator;
    public static final int DWARF2_LINE_DEFAULT_IS_STMT = 1;
    public static final int DWARF2_FLAG_IS_STMT = 1;
    public static final int DWARF2_FLAG_BASIC_BLOCK = 2;
    public static final int DWARF2_FLAG_PROLOGUE_END = 4;
    public static final int DWARF2_FLAG_EPILOGUE_BEGIN = 8;

    public MCDwarfLoc(int fileNum, int line, int column, int flags, int isa, int discriminator) {
        this.FileNum = fileNum;
        this.Line = line;
        this.Column = Unsigned.$uint2ushort((int)column);
        this.Flags = Unsigned.$uint2uchar((int)flags);
        this.Isa = Unsigned.$uint2uchar((int)isa);
        this.Discriminator = discriminator;
    }

    public int getFileNum() {
        return this.FileNum;
    }

    public int getLine() {
        return this.Line;
    }

    public int getColumn() {
        return Unsigned.$ushort2uint((char)this.Column);
    }

    public int getFlags() {
        return Unsigned.$uchar2uint((byte)this.Flags);
    }

    public int getIsa() {
        return Unsigned.$uchar2uint((byte)this.Isa);
    }

    public int getDiscriminator() {
        return this.Discriminator;
    }

    public void setFileNum(int fileNum) {
        this.FileNum = fileNum;
    }

    public void setLine(int line) {
        this.Line = line;
    }

    public void setColumn(int column) {
        assert (Unsigned.$lesseq_uint((int)column, (int)65535));
        this.Column = Unsigned.$uint2ushort((int)column);
    }

    public void setFlags(int flags) {
        assert (Unsigned.$lesseq_uint((int)flags, (int)255));
        this.Flags = Unsigned.$uint2uchar((int)flags);
    }

    public void setIsa(int isa) {
        assert (Unsigned.$lesseq_uint((int)isa, (int)255));
        this.Isa = Unsigned.$uint2uchar((int)isa);
    }

    public void setDiscriminator(int discriminator) {
        this.Discriminator = discriminator;
    }

    public MCDwarfLoc(MCDwarfLoc $Prm0) {
        this.FileNum = $Prm0.FileNum;
        this.Line = $Prm0.Line;
        this.Column = $Prm0.Column;
        this.Flags = $Prm0.Flags;
        this.Isa = $Prm0.Isa;
        this.Discriminator = $Prm0.Discriminator;
    }

    public MCDwarfLoc(JavaDifferentiators.JD.Move _dparam, MCDwarfLoc $Prm0) {
        this.FileNum = $Prm0.FileNum;
        this.Line = $Prm0.Line;
        this.Column = $Prm0.Column;
        this.Flags = $Prm0.Flags;
        this.Isa = $Prm0.Isa;
        this.Discriminator = $Prm0.Discriminator;
    }

    public MCDwarfLoc $assignMove(MCDwarfLoc $Prm0) {
        this.FileNum = $Prm0.FileNum;
        this.Line = $Prm0.Line;
        this.Column = $Prm0.Column;
        this.Flags = $Prm0.Flags;
        this.Isa = $Prm0.Isa;
        this.Discriminator = $Prm0.Discriminator;
        return this;
    }

    MCDwarfLoc() {
    }

    public MCDwarfLoc clone() {
        assert (this.getClass() == MCDwarfLoc.class) : "Must be overridden in " + this.getClass();
        return new MCDwarfLoc(this);
    }

    public MCDwarfLoc move() {
        assert (this.getClass() == MCDwarfLoc.class) : "Must be overridden in " + this.getClass();
        return new MCDwarfLoc(JavaDifferentiators.JD.Move.INSTANCE, this);
    }

    public String toString() {
        return "FileNum=" + this.FileNum + ", Line=" + this.Line + ", Column=" + Unsigned.$ushort2uint((char)this.Column) + ", Flags=" + Unsigned.$uchar2uint((byte)this.Flags) + ", Isa=" + Unsigned.$uchar2uint((byte)this.Isa) + ", Discriminator=" + this.Discriminator;
    }
}

