/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.java.std;
import org.clank.java.std_map;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.mc.MCContext;
import org.llvm.mc.MCDwarfFile;
import org.llvm.mc.MCDwarfLineEntry;
import org.llvm.mc.MCDwarfLineTableHeader;
import org.llvm.mc.MCDwarfLineTableParams;
import org.llvm.mc.MCLineSection;
import org.llvm.mc.MCObjectStreamer;
import org.llvm.mc.MCSection;
import org.llvm.mc.MCStreamer;
import org.llvm.mc.MCSymbol;
import org.llvm.mc.impl.MCDwarfStatics;

public class MCDwarfLineTable
implements Destructors.ClassWithDestructor {
    private MCDwarfLineTableHeader Header = new MCDwarfLineTableHeader();
    private MCLineSection MCLineSections = new MCLineSection();

    public static void Emit(MCObjectStreamer MCOS, MCDwarfLineTableParams Params) {
        MCContext context = MCOS.getContext();
        std_map.mapUIntType<MCDwarfLineTable> LineTables = context.getMCDwarfLineTables();
        if (LineTables.empty()) {
            return;
        }
        MCOS.SwitchSection(context.getObjectFileInfo().getDwarfLineSection());
        for (std_pair.pairUIntType CUIDTablePair : LineTables) {
            ((MCDwarfLineTable)CUIDTablePair.second).EmitCU(MCOS, new MCDwarfLineTableParams(Params));
        }
    }

    public void EmitCU(MCObjectStreamer MCOS, MCDwarfLineTableParams Params) {
        MCSymbol LineEndSym = (MCSymbol)this.Header.Emit((MCStreamer)MCOS, (MCDwarfLineTableParams)new MCDwarfLineTableParams((MCDwarfLineTableParams)Params)).second;
        for (std_pair.pair pair2 : this.MCLineSections.getMCLineEntries()) {
            MCDwarfStatics.EmitDwarfLineTable(MCOS, (MCSection)pair2.first, (std.vector<MCDwarfLineEntry>)((std.vector)pair2.second));
        }
        MCOS.EmitLabel(LineEndSym);
    }

    public int getFile(StringRef Directory, StringRef FileName) {
        return this.getFile(Directory, FileName, 0);
    }

    public int getFile(StringRef Directory, StringRef FileName, int FileNumber) {
        return this.Header.getFile(Directory, FileName, FileNumber);
    }

    public MCSymbol getLabel() {
        return this.Header.Label;
    }

    public void setLabel(MCSymbol Label) {
        this.Header.Label = Label;
    }

    public void setCompilationDir(StringRef CompilationDir) {
        this.Header.CompilationDir.$assign(CompilationDir);
    }

    public SmallVectorImpl<std.string> getMCDwarfDirs$Const() {
        return this.Header.MCDwarfDirs;
    }

    public SmallVectorImpl<std.string> getMCDwarfDirs() {
        return this.Header.MCDwarfDirs;
    }

    public SmallVectorImpl<MCDwarfFile> getMCDwarfFiles$Const() {
        return this.Header.MCDwarfFiles;
    }

    public SmallVectorImpl<MCDwarfFile> getMCDwarfFiles() {
        return this.Header.MCDwarfFiles;
    }

    public MCLineSection getMCLineSections$Const() {
        return this.MCLineSections;
    }

    public MCLineSection getMCLineSections() {
        return this.MCLineSections;
    }

    public void $destroy() {
        this.MCLineSections.$destroy();
        this.Header.$destroy();
    }

    public String toString() {
        return "Header=" + this.Header + ", MCLineSections=" + this.MCLineSections;
    }
}

