/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.support.Native;
import org.llvm.mc.MCContext;
import org.llvm.mc.MCContextGlobals;
import org.llvm.mc.MCExpr;

public class MCBinaryExpr
extends MCExpr {
    private Opcode Op;
    private MCExpr LHS;
    private MCExpr RHS;

    private MCBinaryExpr(Opcode Op2, MCExpr LHS, MCExpr RHS) {
        super(MCExpr.ExprKind.Binary);
        this.Op = Op2;
        this.LHS = LHS;
        this.RHS = RHS;
    }

    public static MCBinaryExpr create(Opcode Opc, MCExpr LHS, MCExpr RHS, MCContext Ctx) {
        return (MCBinaryExpr)MCContextGlobals.$new_uint_MCContext_uint(Ctx, New$Mem -> new MCBinaryExpr(Opc, LHS, RHS));
    }

    public static MCBinaryExpr createAdd(MCExpr LHS, MCExpr RHS, MCContext Ctx) {
        return MCBinaryExpr.create(Opcode.Add, LHS, RHS, Ctx);
    }

    public static MCBinaryExpr createAnd(MCExpr LHS, MCExpr RHS, MCContext Ctx) {
        return MCBinaryExpr.create(Opcode.And, LHS, RHS, Ctx);
    }

    public static MCBinaryExpr createDiv(MCExpr LHS, MCExpr RHS, MCContext Ctx) {
        return MCBinaryExpr.create(Opcode.Div, LHS, RHS, Ctx);
    }

    public static MCBinaryExpr createEQ(MCExpr LHS, MCExpr RHS, MCContext Ctx) {
        return MCBinaryExpr.create(Opcode.EQ, LHS, RHS, Ctx);
    }

    public static MCBinaryExpr createGT(MCExpr LHS, MCExpr RHS, MCContext Ctx) {
        return MCBinaryExpr.create(Opcode.GT, LHS, RHS, Ctx);
    }

    public static MCBinaryExpr createGTE(MCExpr LHS, MCExpr RHS, MCContext Ctx) {
        return MCBinaryExpr.create(Opcode.GTE, LHS, RHS, Ctx);
    }

    public static MCBinaryExpr createLAnd(MCExpr LHS, MCExpr RHS, MCContext Ctx) {
        return MCBinaryExpr.create(Opcode.LAnd, LHS, RHS, Ctx);
    }

    public static MCBinaryExpr createLOr(MCExpr LHS, MCExpr RHS, MCContext Ctx) {
        return MCBinaryExpr.create(Opcode.LOr, LHS, RHS, Ctx);
    }

    public static MCBinaryExpr createLT(MCExpr LHS, MCExpr RHS, MCContext Ctx) {
        return MCBinaryExpr.create(Opcode.LT, LHS, RHS, Ctx);
    }

    public static MCBinaryExpr createLTE(MCExpr LHS, MCExpr RHS, MCContext Ctx) {
        return MCBinaryExpr.create(Opcode.LTE, LHS, RHS, Ctx);
    }

    public static MCBinaryExpr createMod(MCExpr LHS, MCExpr RHS, MCContext Ctx) {
        return MCBinaryExpr.create(Opcode.Mod, LHS, RHS, Ctx);
    }

    public static MCBinaryExpr createMul(MCExpr LHS, MCExpr RHS, MCContext Ctx) {
        return MCBinaryExpr.create(Opcode.Mul, LHS, RHS, Ctx);
    }

    public static MCBinaryExpr createNE(MCExpr LHS, MCExpr RHS, MCContext Ctx) {
        return MCBinaryExpr.create(Opcode.NE, LHS, RHS, Ctx);
    }

    public static MCBinaryExpr createOr(MCExpr LHS, MCExpr RHS, MCContext Ctx) {
        return MCBinaryExpr.create(Opcode.Or, LHS, RHS, Ctx);
    }

    public static MCBinaryExpr createShl(MCExpr LHS, MCExpr RHS, MCContext Ctx) {
        return MCBinaryExpr.create(Opcode.Shl, LHS, RHS, Ctx);
    }

    public static MCBinaryExpr createAShr(MCExpr LHS, MCExpr RHS, MCContext Ctx) {
        return MCBinaryExpr.create(Opcode.AShr, LHS, RHS, Ctx);
    }

    public static MCBinaryExpr createLShr(MCExpr LHS, MCExpr RHS, MCContext Ctx) {
        return MCBinaryExpr.create(Opcode.LShr, LHS, RHS, Ctx);
    }

    public static MCBinaryExpr createSub(MCExpr LHS, MCExpr RHS, MCContext Ctx) {
        return MCBinaryExpr.create(Opcode.Sub, LHS, RHS, Ctx);
    }

    public static MCBinaryExpr createXor(MCExpr LHS, MCExpr RHS, MCContext Ctx) {
        return MCBinaryExpr.create(Opcode.Xor, LHS, RHS, Ctx);
    }

    public Opcode getOpcode() {
        return this.Op;
    }

    public MCExpr getLHS() {
        return this.LHS;
    }

    public MCExpr getRHS() {
        return this.RHS;
    }

    public static boolean classof(MCExpr E) {
        return E.getKind() == MCExpr.ExprKind.Binary;
    }

    @Override
    public String toString() {
        return "Op=" + (Object)((Object)this.Op) + ", LHS=[MCExpr], RHS=[MCExpr]" + super.toString();
    }

    public static final class Opcode
    extends Enum<Opcode>
    implements Native.NativeUIntEnum {
        public static final /* enum */ Opcode Add = new Opcode(0);
        public static final /* enum */ Opcode And = new Opcode(Add.getValue() + 1);
        public static final /* enum */ Opcode Div = new Opcode(And.getValue() + 1);
        public static final /* enum */ Opcode EQ = new Opcode(Div.getValue() + 1);
        public static final /* enum */ Opcode GT = new Opcode(EQ.getValue() + 1);
        public static final /* enum */ Opcode GTE = new Opcode(GT.getValue() + 1);
        public static final /* enum */ Opcode LAnd = new Opcode(GTE.getValue() + 1);
        public static final /* enum */ Opcode LOr = new Opcode(LAnd.getValue() + 1);
        public static final /* enum */ Opcode LT = new Opcode(LOr.getValue() + 1);
        public static final /* enum */ Opcode LTE = new Opcode(LT.getValue() + 1);
        public static final /* enum */ Opcode Mod = new Opcode(LTE.getValue() + 1);
        public static final /* enum */ Opcode Mul = new Opcode(Mod.getValue() + 1);
        public static final /* enum */ Opcode NE = new Opcode(Mul.getValue() + 1);
        public static final /* enum */ Opcode Or = new Opcode(NE.getValue() + 1);
        public static final /* enum */ Opcode Shl = new Opcode(Or.getValue() + 1);
        public static final /* enum */ Opcode AShr = new Opcode(Shl.getValue() + 1);
        public static final /* enum */ Opcode LShr = new Opcode(AShr.getValue() + 1);
        public static final /* enum */ Opcode Sub = new Opcode(LShr.getValue() + 1);
        public static final /* enum */ Opcode Xor = new Opcode(Sub.getValue() + 1);
        private final int value;
        private static final /* synthetic */ Opcode[] $VALUES;

        public static Opcode[] values() {
            return (Opcode[])$VALUES.clone();
        }

        public static Opcode valueOf(String name) {
            return Enum.valueOf(Opcode.class, name);
        }

        public static Opcode valueOf(int val) {
            Opcode out;
            Opcode opcode = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private Opcode(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Opcode[]{Add, And, Div, EQ, GT, GTE, LAnd, LOr, LT, LTE, Mod, Mul, NE, Or, Shl, AShr, LShr, Sub, Xor};
        }

        private static final class Values {
            private static final Opcode[] VALUES;
            private static final Opcode[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Opcode kind : Opcode.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Opcode[min < 0 ? 1 - min : 0];
                VALUES = new Opcode[max >= 0 ? 1 + max : 0];
                for (Opcode kind : Opcode.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((Opcode)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((Opcode)kind).value] = kind;
                }
            }
        }
    }
}

