/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.ulong;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.adt.aliases.DenseMapInfo$LikePtr;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.ilist_iterator;
import org.llvm.adt.java.ADTRTTI;
import org.llvm.mc.MCAssembler;
import org.llvm.mc.MCExpr;
import org.llvm.mc.MCFragment;
import org.llvm.mc.MCSection;
import org.llvm.mc.MCSymbol;
import org.llvm.mc.MCSymbolRefExpr;
import org.llvm.mc.MCValue;
import org.llvm.mc.ilist_traitsMCFragment;
import org.llvm.mc.impl.MCFragmentLlvmGlobals;
import org.llvm.mc.impl.MCFragmentStatics;
import org.llvm.mc.stats.impl.StatsStatics;
import org.llvm.support.SMLoc;
import org.llvm.support.llvm;

public class MCAsmLayout
implements Destructors.ClassWithDestructor {
    private final MCAssembler Assembler;
    private SmallVector<MCSection> SectionOrder;
    private DenseMap<MCSection, MCFragment> LastValidFragment;

    private void ensureValid(MCFragment F) {
        MCSection Sec = F.getParent();
        ilist_iterator<MCFragment> I = new ilist_iterator<MCFragment>(ilist_traitsMCFragment.$instance());
        MCFragment Cur = (MCFragment)this.LastValidFragment.$at_T1$RR(Sec);
        if (Cur != null) {
            I.$assign(new ilist_iterator<MCFragment>(Cur, ilist_traitsMCFragment.$instance()).$preInc());
        } else {
            I.$assignMove(Sec.begin());
        }
        while (!this.isFragmentValid(F)) {
            assert (I.$noteq(Sec.end())) : "Layout bookkeeping error";
            this.layoutFragment((MCFragment)Native.$AddrOf((Object)((MCFragment)I.$star())));
            I.$preInc();
        }
    }

    private boolean isFragmentValid(MCFragment F) {
        MCSection Sec = F.getParent();
        MCFragment LastValid = (MCFragment)this.LastValidFragment.lookup(Sec);
        if (LastValid == null) {
            return false;
        }
        assert (LastValid.getParent() == Sec);
        return Unsigned.$lesseq_uint((int)F.getLayoutOrder(), (int)LastValid.getLayoutOrder());
    }

    public MCAsmLayout(MCAssembler Asm) {
        this.Assembler = Asm;
        this.SectionOrder = new SmallVector<MCSection>(16, (MCSection)null);
        this.LastValidFragment = new DenseMap(DenseMapInfo$LikePtr.$Info(), (MCFragment)null);
        for (MCSection Sec : Asm) {
            if (Sec.isVirtualSection()) continue;
            this.SectionOrder.push_back((MCSection)Native.$AddrOf((Object)Sec));
        }
        for (MCSection Sec : Asm) {
            if (!Sec.isVirtualSection()) continue;
            this.SectionOrder.push_back((MCSection)Native.$AddrOf((Object)Sec));
        }
    }

    public MCAssembler getAssembler() {
        return this.Assembler;
    }

    public void invalidateFragmentsFrom(MCFragment F) {
        if (!this.isFragmentValid(F)) {
            return;
        }
        this.LastValidFragment.$set(F.getParent(), (MCFragment)F.getPrevNode());
    }

    public void layoutFragment(MCFragment F) {
        MCFragment Prev = (MCFragment)F.getPrevNode();
        assert (!this.isFragmentValid(F)) : "Attempt to recompute a valid fragment!";
        assert (Prev == null || this.isFragmentValid(Prev)) : "Attempt to compute fragment before its predecessor!";
        StatsStatics.FragmentLayouts.$preInc();
        F.Offset = Prev != null ? Prev.Offset + this.getAssembler().computeFragmentSize(this, (MCFragment)Native.$Deref((Object)Prev)) : Unsigned.$int2ulong((int)0);
        this.LastValidFragment.$set(F.getParent(), F);
        if (this.Assembler.isBundlingEnabled() && F.hasInstructions()) {
            long RequiredBundlePadding;
            assert (ADTRTTI.isa_MCEncodedFragment(F)) : "Only MCEncodedFragment implementations have instructions";
            long FSize = this.Assembler.computeFragmentSize(this, (MCFragment)Native.$Deref((Object)F));
            if (!this.Assembler.getRelaxAll() && Unsigned.$greater_ulong_uint((long)FSize, (int)this.Assembler.getBundleAlignSize())) {
                llvm.report_fatal_error(NativePointer.$((String)"Fragment can't be larger than a bundle size"));
            }
            if (Unsigned.$greater_ulong_uint((long)(RequiredBundlePadding = MCFragmentLlvmGlobals.computeBundlePadding(this.Assembler, F, F.Offset, FSize)), (int)-1)) {
                llvm.report_fatal_error(NativePointer.$((String)"Padding cannot exceed 255 bytes"));
            }
            F.setBundlePadding(Unsigned.$ulong2uchar((long)RequiredBundlePadding));
            F.Offset += RequiredBundlePadding;
        }
    }

    public SmallVectorImpl<MCSection> getSectionOrder() {
        return this.SectionOrder;
    }

    public SmallVectorImpl<MCSection> getSectionOrder$Const() {
        return this.SectionOrder;
    }

    public long getFragmentOffset(MCFragment F) {
        this.ensureValid(F);
        assert (F.Offset != -1L) : "Address not set!";
        return F.Offset;
    }

    public long getSectionAddressSize(MCSection Sec) {
        MCFragment F = Sec.getFragmentList$Const().back$Const();
        return this.getFragmentOffset((MCFragment)Native.$AddrOf((Object)F)) + this.getAssembler().computeFragmentSize(this, F);
    }

    public long getSectionFileSize(MCSection Sec) {
        if (Sec.isVirtualSection()) {
            return Unsigned.$int2ulong((int)0);
        }
        return this.getSectionAddressSize(Sec);
    }

    public boolean getSymbolOffset(MCSymbol S2, ulong.ref Val) {
        return MCFragmentStatics.getSymbolOffsetImpl(this, S2, false, Val);
    }

    public long getSymbolOffset(MCSymbol S2) {
        ulong.ref Val = NativePointer.create_ulong$ref();
        MCFragmentStatics.getSymbolOffsetImpl(this, S2, true, Val);
        return Val.$deref();
    }

    public MCSymbol getBaseSymbol(MCSymbol Symbol) {
        MCValue Value;
        if (!Symbol.isVariable()) {
            return (MCSymbol)Native.$AddrOf((Object)Symbol);
        }
        MCExpr Expr = Symbol.getVariableValue();
        if (!Expr.evaluateAsValue(Value = new MCValue(), this)) {
            this.Assembler.getContext().reportError(new SMLoc(), new Twine("expression could not be evaluated"));
            return null;
        }
        MCSymbolRefExpr RefB = Value.getSymB();
        if (RefB != null) {
            this.Assembler.getContext().reportError(new SMLoc(), llvm.$add_Twine$C(llvm.$add_Twine$C(new Twine("symbol '"), new Twine(RefB.getSymbol().getName())), new Twine("' could not be evaluated in a subtraction expression")));
            return null;
        }
        MCSymbolRefExpr A = Value.getSymA();
        if (A == null) {
            return null;
        }
        MCSymbol ASym = A.getSymbol();
        MCAssembler Asm = this.getAssembler();
        if (ASym.isCommon()) {
            Asm.getContext().reportError(new SMLoc(), llvm.$add_Twine$C(llvm.$add_char$ptr$C_StringRef$C("Common symbol '", ASym.getName()), new Twine("' cannot be used in assignment expr")));
            return null;
        }
        return (MCSymbol)Native.$AddrOf((Object)ASym);
    }

    public void $destroy() {
        this.LastValidFragment.$destroy();
        this.SectionOrder.$destroy();
    }

    public String toString() {
        return "Assembler=" + this.Assembler + ", SectionOrder=" + this.SectionOrder + ", LastValidFragment=" + this.LastValidFragment;
    }
}

