/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.java.std;
import org.clank.java.std_map;
import org.clank.java.std_pair;
import org.clank.java.stdimpl.aliases.StdMapUIntType;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.NoneType;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.ArrayRefUInt;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.StringMapIteratorUInt;
import org.llvm.adt.aliases.StringMapUInt;
import org.llvm.mc.MCAsmLayout;
import org.llvm.mc.MCCVDefRangeFragment;
import org.llvm.mc.MCCVInlineLineTableFragment;
import org.llvm.mc.MCCVLineEntry;
import org.llvm.mc.MCDataFragment;
import org.llvm.mc.MCObjectStreamer;
import org.llvm.mc.MCSymbol;
import org.llvm.support.llvm;

public class CodeViewContext
implements Destructors.ClassWithDestructor {
    private StringMapUInt StringTable = new StringMapUInt(0);
    private MCDataFragment StrTabFragment = null;
    private boolean InsertedStrTabFragment = false;
    private SmallVector<StringRef> Filenames = new SmallVector<StringRef>(4, new StringRef());
    private std_map.mapUIntType<std_pair.pairUIntUInt> MCCVLineStartStop = new std_map.mapUIntType((Object)new std_pair.pairUIntUInt());
    private std.vector<MCCVLineEntry> MCCVLines = new std.vector((Object)new MCCVLineEntry());

    public void $destroy() {
        if (!this.InsertedStrTabFragment && this.StrTabFragment != null) {
            this.StrTabFragment.$destroy();
        }
        this.MCCVLines.$destroy();
        this.MCCVLineStartStop.$destroy();
        this.Filenames.$destroy();
        this.StringTable.$destroy();
    }

    public boolean isValidFileNumber(int FileNumber) {
        int Idx = FileNumber - 1;
        if (Unsigned.$less_uint((int)Idx, (int)this.Filenames.size())) {
            return !((StringRef)this.Filenames.$at$Const(Idx)).empty();
        }
        return false;
    }

    public boolean addFile(int FileNumber, StringRef Filename) {
        assert (Unsigned.$greater_uint((int)FileNumber, (int)0));
        Filename.$assignMove(this.addToStringTable(new StringRef(Filename)));
        int Idx = FileNumber - 1;
        if (Unsigned.$greatereq_uint((int)Idx, (int)this.Filenames.size())) {
            this.Filenames.resize(Idx + 1);
        }
        if (Filename.empty()) {
            Filename.$assignMove("<stdin>");
        }
        if (!((StringRef)this.Filenames.$at(Idx)).empty()) {
            return false;
        }
        Filename.$assignMove(this.addToStringTable(new StringRef(Filename)));
        ((StringRef)this.Filenames.$at(Idx)).$assign(Filename);
        return true;
    }

    public ArrayRef<StringRef> getFilenames() {
        return new ArrayRef<StringRef>(this.Filenames, false);
    }

    public void addLineEntry(MCCVLineEntry LineEntry) {
        int Offset = this.MCCVLines.size();
        std_pair.pairTypeBool I = this.MCCVLineStartStop.insert(new std_pair.pairUIntType(JavaDifferentiators.JD$T$RR_T1$C$R.INSTANCE, LineEntry.getFunctionId(), (Object)new std_pair.pairUIntUInt(JavaDifferentiators.JD$T$RR_T1$RR.INSTANCE, Offset, Offset + 1)));
        if (!I.second) {
            ((std_pair.pairUIntUInt)((StdMapUIntType.iterator)I.first).$arrow().second).second = Offset + 1;
        }
        this.MCCVLines.push_back_T$C$R((Object)LineEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public std.vector<MCCVLineEntry> getFunctionLineEntries(int FuncId) {
        std.vector FilteredLines = null;
        try {
            FilteredLines = new std.vector((Object)new MCCVLineEntry());
            StdMapUIntType.iterator I = this.MCCVLineStartStop.find(Integer.valueOf(FuncId));
            if (I.$noteq((Object)this.MCCVLineStartStop.end())) {
                int End = ((std_pair.pairUIntUInt)I.$arrow().second).second;
                for (int Idx = ((std_pair.pairUIntUInt)I.$arrow().second).first; Idx != End; ++Idx) {
                    if (((MCCVLineEntry)this.MCCVLines.$at(Idx)).getFunctionId() != FuncId) continue;
                    FilteredLines.push_back_T$C$R((Object)((MCCVLineEntry)this.MCCVLines.$at(Idx)));
                }
            }
            std.vector vector2 = new std.vector(JavaDifferentiators.JD.Move.INSTANCE, FilteredLines);
            return vector2;
        }
        finally {
            if (FilteredLines != null) {
                FilteredLines.$destroy();
            }
        }
    }

    public std_pair.pairUIntUInt getLineExtent(int FuncId) {
        StdMapUIntType.iterator I = this.MCCVLineStartStop.find(Integer.valueOf(FuncId));
        if (I.$eq((Object)this.MCCVLineStartStop.end())) {
            return new std_pair.pairUIntUInt(JavaDifferentiators.JD$T$RR_T1$RR.INSTANCE, -1L, 0);
        }
        return new std_pair.pairUIntUInt((std_pair.pairUIntUInt)I.$arrow().second);
    }

    public ArrayRef<MCCVLineEntry> getLinesForExtent(int L, int R2) {
        if (Unsigned.$lesseq_uint((int)R2, (int)L)) {
            return new ArrayRef<NoneType>(llvm.None, false);
        }
        if (Unsigned.$greatereq_uint((int)L, (int)this.MCCVLines.size())) {
            return new ArrayRef<NoneType>(llvm.None, false);
        }
        return llvm.makeArrayRef((MCCVLineEntry)Native.$AddrOf((Object)((MCCVLineEntry)this.MCCVLines.$at(L))), R2 - L);
    }

    public void emitLineTableForFunction(MCObjectStreamer OS, int FuncId, MCSymbol FuncBegin, MCSymbol FuncEnd) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public void emitInlineLineTableForFunction(MCObjectStreamer OS, int PrimaryFunctionId, int SourceFileId, int SourceLineNum, MCSymbol FnStartSym, MCSymbol FnEndSym, ArrayRefUInt SecondaryFunctionIds) {
        new MCCVInlineLineTableFragment(PrimaryFunctionId, SourceFileId, SourceLineNum, FnStartSym, FnEndSym, new ArrayRefUInt(SecondaryFunctionIds), OS.getCurrentSectionOnly());
    }

    public void encodeInlineLineTable(MCAsmLayout Layout, MCCVInlineLineTableFragment Frag) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public void emitDefRange(MCObjectStreamer OS, ArrayRef<std_pair.pairPtrPtr<MCSymbol, MCSymbol>> Ranges, StringRef FixedSizePortion) {
        new MCCVDefRangeFragment(new ArrayRef<std_pair.pairPtrPtr<MCSymbol, MCSymbol>>(Ranges), new StringRef(FixedSizePortion), OS.getCurrentSectionOnly());
    }

    public void encodeDefRange(MCAsmLayout Layout, MCCVDefRangeFragment Frag) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public void emitStringTable(MCObjectStreamer OS) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public void emitFileChecksums(MCObjectStreamer OS) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    private MCDataFragment getStringTableFragment() {
        if (this.StrTabFragment == null) {
            this.StrTabFragment = new MCDataFragment();
            this.StrTabFragment.getContents().push_back((byte)0);
        }
        return this.StrTabFragment;
    }

    private StringRef addToStringTable(StringRef S2) {
        SmallString Contents2 = this.getStringTableFragment().getContents();
        std_pair.pairTypeBool<StringMapIteratorUInt> Insertion = this.StringTable.insert((std_pair.pairTypeUInt<StringRef>)std.make_pair_T_uint((Object)((StringRef)Native.$Clone((NativeCloneable)S2)), (int)Contents2.size()));
        S2.$assignMove(((StringMapIteratorUInt)Insertion.first).$arrow().first());
        if (Insertion.second) {
            Contents2.append_T((char.iterator<?>)S2.begin(), (char.iterator<?>)((char.iterator)S2.end().$add(1)));
        }
        return new StringRef(JavaDifferentiators.JD.Move.INSTANCE, S2);
    }

    private int getStringTableOffset(StringRef S2) {
        if (S2.empty()) {
            return 0;
        }
        StringMapIteratorUInt I = this.StringTable.find(S2);
        assert (I.$noteq(this.StringTable.end()));
        return I.$arrow().second;
    }

    public String toString() {
        return "StringTable=" + this.StringTable + ", StrTabFragment=" + this.StrTabFragment + ", InsertedStrTabFragment=" + this.InsertedStrTabFragment + ", Filenames=" + this.Filenames + ", MCCVLineStartStop=" + this.MCCVLineStartStop + ", MCCVLines=" + this.MCCVLines;
    }
}

