/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.cl;

import org.clank.support.Native;
import org.clank.support.aliases.type;
import org.llvm.adt.Twine;
import org.llvm.cl.Option;
import org.llvm.cl.OptionValue;
import org.llvm.cl.opt_storage;

public class opt_storage_impl_external<DataType>
implements opt_storage<DataType> {
    private final boolean ExternalStorage = false;
    private final boolean isClass = true;
    private type.ref<DataType> Location = null;
    private OptionValue<DataType> Default;

    private void check() {
        assert (Native.$noteq(this.Location, (Object)0)) : "cl::location(...) not specified for a command line option with external storage, or cl::init specified before cl::location()!!";
    }

    @Override
    public boolean setLocation(Option O, type.ref<DataType> L) {
        if (this.Location != null) {
            return O.error(new Twine("cl::location(x) specified more than once!"));
        }
        this.Location = (type.ref)Native.$AddrOf(L);
        this.Default = new OptionValue<Object>(L.$deref());
        return false;
    }

    @Override
    public void setValue(DataType V) {
        this.setValue(V, false);
    }

    @Override
    public void setValue(DataType V, boolean initial) {
        this.check();
        this.Location.$set(V);
        if (initial) {
            this.Default.$assign(V);
        }
    }

    @Override
    public DataType getValue() {
        this.check();
        return (DataType)Native.$Deref((Object)this.Location.$deref());
    }

    @Override
    public DataType $T() {
        return this.getValue();
    }

    @Override
    public OptionValue<DataType> getDefault() {
        return this.Default;
    }

    public String toString() {
        return "opt_storage_impl_internal{isClass=true, ExternalStorage=false, Location=[" + this.Location + "], Default=[" + this.Default + "]}";
    }
}

