/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.cl;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.SmallPtrSet;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.DenseMapInfo$LikePtr;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.cl.ClGlobals;
import org.llvm.cl.FormattingFlags;
import org.llvm.cl.LocationClass;
import org.llvm.cl.NumOccurrencesFlag;
import org.llvm.cl.OptionCategory;
import org.llvm.cl.OptionHidden;
import org.llvm.cl.SubCommand;
import org.llvm.cl.ValueExpected;
import org.llvm.cl.ValuesClass;
import org.llvm.cl.aliasopt;
import org.llvm.cl.basic_parser;
import org.llvm.cl.cat;
import org.llvm.cl.desc;
import org.llvm.cl.initializer;
import org.llvm.cl.sub;
import org.llvm.cl.value_desc;
import org.llvm.support.impl.CommandLineStatics;
import org.llvm.support.llvm;

public abstract class Option
implements Destructors.ClassWithDestructor {
    private int NumOccurrences;
    private NumOccurrencesFlag Occurrences;
    private ValueExpected Value;
    private OptionHidden HiddenFlag;
    private FormattingFlags Formatting;
    private byte Misc;
    private int Position;
    private int AdditionalVals;
    public StringRef ArgStr;
    public StringRef HelpStr;
    public StringRef ValueStr;
    public OptionCategory Category;
    public SmallPtrSet<SubCommand> Subs;
    public boolean FullyInitialized;
    public Option NextRegistered;

    protected abstract boolean handleOccurrence(int var1, StringRef var2, StringRef var3);

    protected ValueExpected getValueExpectedFlagDefault() {
        return ValueExpected.ValueOptional;
    }

    protected void anchor() {
    }

    public NumOccurrencesFlag getNumOccurrencesFlag() {
        return this.Occurrences;
    }

    public ValueExpected getValueExpectedFlag() {
        return this.Value != null ? this.Value : this.getValueExpectedFlagDefault();
    }

    public OptionHidden getOptionHiddenFlag() {
        return this.HiddenFlag;
    }

    public FormattingFlags getFormattingFlag() {
        return this.Formatting;
    }

    public int getMiscFlags() {
        return this.Misc;
    }

    public int getPosition() {
        return this.Position;
    }

    public int getNumAdditionalVals() {
        return this.AdditionalVals;
    }

    public boolean hasArgStr() {
        return !this.ArgStr.empty();
    }

    public boolean isPositional() {
        return this.getFormattingFlag() == FormattingFlags.Positional;
    }

    public boolean isSink() {
        return (this.getMiscFlags() & 4) != 0;
    }

    public boolean isConsumeAfter() {
        return this.getNumOccurrencesFlag() == NumOccurrencesFlag.ConsumeAfter;
    }

    public boolean isInAllSubCommands() {
        return std.any_of((type.iterator)this.Subs.begin(), (type.iterator)this.Subs.end(), SC -> SC == Native.$AddrOf((Object)ClGlobals.AllSubCommands.$star()));
    }

    public void setArgStr(StringRef S2) {
        if (this.FullyInitialized) {
            CommandLineStatics.GlobalParser.$arrow().updateArgStr(this, new StringRef(S2));
        }
        this.ArgStr.$assign(S2);
    }

    public void setDescription(StringRef S2) {
        this.HelpStr.$assign(S2);
    }

    public void setValueStr(StringRef S2) {
        this.ValueStr.$assign(S2);
    }

    public void setNumOccurrencesFlag(NumOccurrencesFlag Val) {
        this.Occurrences = Val;
    }

    public void setValueExpectedFlag(ValueExpected Val) {
        this.Value = Val;
    }

    public void setHiddenFlag(OptionHidden Val) {
        this.HiddenFlag = Val;
    }

    public void setFormattingFlag(FormattingFlags V) {
        this.Formatting = V;
    }

    public void setMiscFlag(int M) {
        this.Misc = (byte)(this.Misc | Unsigned.$int2uint_3bits((int)M));
    }

    public void setPosition(int pos) {
        this.Position = pos;
    }

    public void setCategory(OptionCategory C2) {
        this.Category = (OptionCategory)Native.$AddrOf((Object)C2);
    }

    public void addSubCommand(SubCommand S2) {
        this.Subs.insert((SubCommand)Native.$AddrOf((Object)S2));
    }

    protected Option(NumOccurrencesFlag OccurrencesFlag, OptionHidden Hidden) {
        this.NumOccurrences = 0;
        this.Occurrences = OccurrencesFlag;
        this.Value = null;
        this.HiddenFlag = Hidden;
        this.Formatting = FormattingFlags.NormalFormatting;
        this.Misc = 0;
        this.Position = 0;
        this.AdditionalVals = 0;
        this.ArgStr = new StringRef(NativePointer.$EMPTY);
        this.HelpStr = new StringRef(NativePointer.$EMPTY);
        this.ValueStr = new StringRef(NativePointer.$EMPTY);
        this.Category = (OptionCategory)Native.$AddrOf((Object)ClGlobals.GeneralCategory);
        this.Subs = new SmallPtrSet(DenseMapInfo$LikePtr.$Info(), 4);
        this.FullyInitialized = false;
        this.NextRegistered = null;
    }

    protected void setNumAdditionalVals(int n) {
        this.AdditionalVals = n;
    }

    public void addArgument() {
        assert (this.NextRegistered == null) : "argument multiply registered!";
        this.NextRegistered = CommandLineStatics.RegisteredOptionList;
        CommandLineStatics.RegisteredOptionList = this;
        CommandLineStatics.MarkOptionsChanged();
    }

    public void removeArgument() {
        CommandLineStatics.GlobalParser.$arrow().removeOption(this);
        Option Prev = null;
        Option O = CommandLineStatics.RegisteredOptionList;
        while (O != null) {
            if (O == this) {
                if (Prev != null) {
                    Prev.NextRegistered = this.NextRegistered;
                } else {
                    assert (CommandLineStatics.RegisteredOptionList == this);
                    CommandLineStatics.RegisteredOptionList = this.NextRegistered;
                }
                return;
            }
            Prev = O;
            O = O.NextRegistered;
        }
    }

    public abstract int getOptionWidth();

    public abstract void printOptionInfo(int var1);

    public abstract void printOptionValue(int var1, boolean var2);

    public void getExtraOptionNames(SmallVectorImpl<StringRef> $Prm0) {
    }

    public boolean addOccurrence(int pos, StringRef ArgName, StringRef Value) {
        return this.addOccurrence(pos, ArgName, Value, false);
    }

    public boolean addOccurrence(int pos, StringRef ArgName, StringRef Value, boolean MultiArg) {
        if (!MultiArg) {
            ++this.NumOccurrences;
        }
        switch (this.getNumOccurrencesFlag()) {
            case Optional: {
                if (this.NumOccurrences <= 1) break;
                return this.error(new Twine("may only occur zero or one times!"), new StringRef(ArgName));
            }
            case Required: {
                if (this.NumOccurrences <= 1) break;
                return this.error(new Twine("must occur exactly one time!"), new StringRef(ArgName));
            }
        }
        return this.handleOccurrence(pos, new StringRef(ArgName), new StringRef(Value));
    }

    public boolean error(Twine Message) {
        return this.error(Message, new StringRef());
    }

    public boolean error(Twine Message, StringRef ArgName) {
        if (ArgName.data() == null) {
            ArgName.$assign(this.ArgStr);
        }
        if (ArgName.empty()) {
            llvm.errs().$out(this.HelpStr);
        } else {
            llvm.errs().$out(CommandLineStatics.ProgramName).$out(": for the -").$out(ArgName);
        }
        llvm.$out_raw_ostream_Twine$C(llvm.errs().$out(" option: "), Message).$out(NativePointer.$LF);
        return true;
    }

    public int getNumOccurrences() {
        return this.NumOccurrences;
    }

    public void reset() {
        this.NumOccurrences = 0;
    }

    public void $destroy() {
        this.Subs.$destroy();
    }

    public Option(Option $Prm0) {
        this.NumOccurrences = $Prm0.NumOccurrences;
        this.Occurrences = $Prm0.Occurrences;
        this.Value = $Prm0.Value;
        this.HiddenFlag = $Prm0.HiddenFlag;
        this.Formatting = $Prm0.Formatting;
        this.Misc = $Prm0.Misc;
        this.Position = $Prm0.Position;
        this.AdditionalVals = $Prm0.AdditionalVals;
        this.NextRegistered = $Prm0.NextRegistered;
        this.ArgStr = new StringRef($Prm0.ArgStr);
        this.HelpStr = new StringRef($Prm0.HelpStr);
        this.ValueStr = new StringRef($Prm0.ValueStr);
        this.Category = $Prm0.Category;
        this.Subs = new SmallPtrSet<SubCommand>($Prm0.Subs);
        this.FullyInitialized = $Prm0.FullyInitialized;
    }

    public Option getNextRegisteredOption() {
        return this.NextRegistered;
    }

    protected final void apply(FormattingFlags FF) {
        this.setFormattingFlag(FF);
    }

    protected final void applyMiscFlags(int MF) {
        this.setMiscFlag(MF);
    }

    protected final void apply(String Str) {
        this.setArgStr(new StringRef(Str));
    }

    protected final void apply(char.ptr Str) {
        this.setArgStr(new StringRef(Str));
    }

    protected final void apply(NumOccurrencesFlag NO) {
        this.setNumOccurrencesFlag(NO);
    }

    protected final void apply(ValueExpected VE) {
        this.setValueExpectedFlag(VE);
    }

    protected final void apply(OptionHidden Val) {
        this.setHiddenFlag(Val);
    }

    public boolean setLocation(type.ref L) {
        throw new UnsupportedOperationException("Why not implemented in " + this.getClass());
    }

    public void setInitialValue(Object Val) {
        throw new UnsupportedOperationException("Why not implemented in " + this.getClass());
    }

    protected basic_parser getParser() {
        throw new UnsupportedOperationException("Why not implemented in " + this.getClass());
    }

    void apply(Option $this, Object ... Ms) {
        assert ($this == this);
        for (Object f : Ms) {
            if (f instanceof FormattingFlags) {
                this.apply((FormattingFlags)((Object)f));
                continue;
            }
            if (f instanceof Integer) {
                this.applyMiscFlags((Integer)f);
                continue;
            }
            if (f instanceof String) {
                this.apply((String)f);
                continue;
            }
            if (f instanceof char.ptr) {
                this.apply((char.ptr)f);
                continue;
            }
            if (f instanceof NumOccurrencesFlag) {
                this.apply((NumOccurrencesFlag)((Object)f));
                continue;
            }
            if (f instanceof ValueExpected) {
                this.apply((ValueExpected)((Object)f));
                continue;
            }
            if (f instanceof OptionHidden) {
                this.apply((OptionHidden)((Object)f));
                continue;
            }
            if (f instanceof desc) {
                ((desc)f).apply(this);
                continue;
            }
            if (f instanceof value_desc) {
                ((value_desc)f).apply(this);
                continue;
            }
            if (f instanceof initializer) {
                ((initializer)f).apply(this);
                continue;
            }
            if (f instanceof LocationClass) {
                ((LocationClass)f).apply(this);
                continue;
            }
            if (f instanceof cat) {
                ((cat)f).apply(this);
                continue;
            }
            if (f instanceof aliasopt) {
                ((aliasopt)f).apply(this);
                continue;
            }
            if (f instanceof sub) {
                ((sub)f).apply(this);
                continue;
            }
            if (f instanceof ValuesClass) {
                ((ValuesClass)f).apply(this);
                continue;
            }
            String text = "Unexpected class: opt.opt(" + f.getClass() + ":" + f + ")";
            throw (IllegalArgumentException)NativeTrace.registerReason((Throwable)new IllegalArgumentException(text));
        }
    }

    public String toString() {
        return "NumOccurrences=" + this.NumOccurrences + ", ArgStr=[" + this.ArgStr.toJavaString() + "], ValueStr=[" + this.ValueStr.toJavaString() + "], HelpStr=[" + this.HelpStr.toJavaString() + "], Occurrences=" + (Object)((Object)this.Occurrences) + ", Value=" + (Object)((Object)this.Value) + ", HiddenFlag=" + (Object)((Object)this.HiddenFlag) + ", Formatting=" + (Object)((Object)this.Formatting) + ", Misc=" + Unsigned.$uchar2uint((byte)this.Misc) + ", Position=" + this.Position + ", AdditionalVals=" + this.AdditionalVals + ", Category=" + this.Category + ", Subs=" + this.Subs + ", FullyInitialized=" + this.FullyInitialized;
    }
}

