/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.impl;

import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.Statistic;
import org.llvm.support.impl.LlvmStatics;
import org.llvm.support.impl.StatisticInfo;
import org.llvm.support.impl.StatisticStatics;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public final class StatisticLlvmGlobals {
    public static void EnableStatistics() {
        StatisticStatics.Enabled.setValue(true);
    }

    public static boolean AreStatisticsEnabled() {
        return (Boolean)StatisticStatics.Enabled.$T();
    }

    public static void PrintStatistics() {
        std_ptr.unique_ptr OutStream = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            StatisticInfo Stats = StatisticStatics.StatInfo.$star();
            if (Stats.Stats.empty()) {
                return;
            }
            OutStream = (std_ptr.unique_ptr)$c$.clean((Object)new std_ptr.unique_ptr(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, $c$.track(LlvmStatics.CreateInfoOutputFile())));
            if (((Boolean)StatisticStatics.StatsAsJSON.$T()).booleanValue()) {
                StatisticLlvmGlobals.PrintStatisticsJSON((raw_ostream)OutStream.$star());
            } else {
                StatisticLlvmGlobals.PrintStatistics((raw_ostream)OutStream.$star());
            }
        }
        finally {
            if (OutStream != null) {
                OutStream.$destroy();
            }
            $c$.$destroy();
        }
    }

    public static void PrintStatistics(raw_ostream OS) {
        int i;
        StatisticInfo Stats = StatisticStatics.StatInfo.$star();
        int MaxDebugTypeLen = 0;
        int MaxValLen = 0;
        int e = Stats.Stats.size();
        for (i = 0; i != e; ++i) {
            MaxValLen = std.max((int)MaxValLen, (int)llvm.utostr(Unsigned.$uint2ulong((int)((Statistic)Stats.Stats.$at(i)).getValue())).size());
            MaxDebugTypeLen = std.max((int)MaxDebugTypeLen, (int)std.strlen((char.ptr)((Statistic)Stats.Stats.$at(i)).getDebugType()));
        }
        Stats.sort();
        OS.$out("===").$out(new std.string(73, 45)).$out("===\n").$out("                          ... Statistics Collected ...\n").$out("===").$out(new std.string(73, 45)).$out("===\n\n");
        e = Stats.Stats.size();
        for (i = 0; i != e; ++i) {
            OS.$out(llvm.format("%" + MaxValLen + "d %-" + MaxDebugTypeLen + "s - %s\n", Unsigned.$uint2ulong((int)((Statistic)Stats.Stats.$at(i)).getValue()), ((Statistic)Stats.Stats.$at(i)).getDebugType(), ((Statistic)Stats.Stats.$at(i)).getDesc()));
        }
        OS.$out_char((byte)10);
        OS.flush();
    }

    public static void PrintStatisticsJSON(raw_ostream OS) {
        StatisticInfo Stats = StatisticStatics.StatInfo.$star();
        Stats.sort();
        OS.$out("{\n");
        char.ptr delim = NativePointer.$EMPTY;
        for (Statistic Stat : Stats.Stats) {
            OS.$out(delim);
            OS.$out("\t\"");
            StatisticStatics.write_json_string_escaped(OS, Stat.getDebugType());
            OS.$out_char((byte)46);
            StatisticStatics.write_json_string_escaped(OS, Stat.getName());
            OS.$out("\": ").$out_uint(Stat.getValue());
            delim = Native.$tryClone((char.ptr)NativePointer.$((String)",\n"));
        }
        OS.$out("\n}\n");
        OS.flush();
    }

    public static void java$shutdown() {
        StatisticStatics.java$shutdown();
    }
}

