/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeSwappable;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.JavaIteratorUShort;
import org.clank.support.aliases.NativeContainerUShort;
import org.clank.support.aliases.type;
import org.clank.support.aliases.ushort;

public abstract class SmallVectorImplUShort
extends NativeTrace.CreateDestroy$Tracker
implements Native.assignable<SmallVectorImplUShort>,
Native.NativeComparable<SmallVectorImplUShort>,
Native.ComparableLower,
NativeType.SizeofCapable,
NativeSwappable,
Iterable<Character>,
Native.NativeIterable<ushort.ptr>,
Native.NativeReverseIterable<std.reverse_iteratorUShort>,
NativeContainerUShort {
    protected final char defaultValue;
    private char[] array;
    private static final char[] EMPTY = NativePointer.new$ushort((int)0);
    private int end;

    public final char[] $array() {
        assert (this.checkAlive());
        return this.array;
    }

    protected SmallVectorImplUShort(int capacity, char defaultValue) {
        this.array = capacity == 0 ? EMPTY : NativePointer.new$ushort((int)capacity);
        this.end = 0;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplUShort(int capacity, int initialSize, char defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImplUShort(JavaDifferentiators.JD$UInt_T$C$R _dparam, int capacity, int initialSize, char defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImplUShort(JavaDifferentiators.JD$UInt_T$C$R _dparam, int capacity, int initialSize, char value, char defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, value);
    }

    protected SmallVectorImplUShort(char[] array2, char defaultValue) {
        this.array = array2;
        this.end = array2 == null ? 0 : array2.length;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplUShort(int capacity, ushort.iterator<?> iter, int length, char defaultValue) {
        this(capacity, iter, (ushort.iterator)iter.$add(length), defaultValue);
    }

    protected SmallVectorImplUShort(int capacity, ushort.iterator<?> begin, ushort.iterator<?> end, char defaultValue) {
        this(capacity, defaultValue);
        this.append_T(begin, end);
    }

    protected SmallVectorImplUShort(SmallVectorImplUShort other) {
        assert (other.checkAlive());
        this.defaultValue = other.defaultValue;
        int capacity = other.size();
        this.array = capacity == 0 ? EMPTY : NativePointer.new$ushort((int)capacity);
        this.append_T((ushort.iterator<?>)other.begin(), (ushort.iterator<?>)other.end());
    }

    protected SmallVectorImplUShort(JavaDifferentiators.JD.Move _dparam, SmallVectorImplUShort other) {
        assert (other.checkAlive());
        this.defaultValue = other.defaultValue;
        this.array = other.array;
        this.end = other.end;
        other.array = EMPTY;
        other.end = 0;
    }

    public final SmallVectorImplUShort $assign(SmallVectorImplUShort other) {
        assert (this.checkAlive());
        assert (other.checkAlive());
        if (this == other) {
            return this;
        }
        this.clear();
        this.array = EMPTY;
        this.append_T((ushort.iterator<?>)other.begin(), (ushort.iterator<?>)other.end());
        return this;
    }

    public final SmallVectorImplUShort $assignMove(SmallVectorImplUShort other) {
        assert (this.checkAlive());
        assert (other.checkAlive());
        assert (this != other) : "moving self";
        this.array = other.array;
        this.end = other.end;
        other.array = EMPTY;
        other.end = 0;
        return this;
    }

    public final void clear() {
        assert (this.checkAlive());
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    public final boolean resize(int newSize) {
        assert (this.checkAlive());
        return this.resize(newSize, this.defaultValue);
    }

    public final boolean resize(int newSize, char defaultValue) {
        assert (this.checkAlive());
        assert (newSize >= 0) : "can not be negative " + newSize;
        boolean grown = false;
        if (newSize < this.end) {
            this.destroy_range(newSize, this.end);
        } else if (newSize > this.end) {
            if (this.capacity() < newSize) {
                this.grow(newSize);
                grown = true;
            }
            for (int i = this.end; i < newSize; ++i) {
                this.array[i] = Native.$tryClone((char)defaultValue);
            }
        }
        this.setEnd(newSize);
        return grown;
    }

    public final void reserve(int N) {
        assert (this.checkAlive());
        assert (N >= 0) : "can not be negative " + N;
        if (this.capacity() < N) {
            this.grow(N);
        }
    }

    public final void assign(int NumElts, char Elt) {
        assert (this.checkAlive());
        assert (NumElts >= 0) : "can not be negative " + NumElts;
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.$set(i, Elt);
        }
    }

    public final void assign$T(ushort.iterator<?> __first, ushort.iterator<?> __last) {
        assert (this.checkAlive());
        this.clear();
        this.append_T(__first, __last);
    }

    public final void swap(NativeSwappable _RHS) {
        assert (this.checkAlive());
        SmallVectorImplUShort RHS = (SmallVectorImplUShort)_RHS;
        char[] arrTmp = this.array;
        this.array = RHS.array;
        RHS.array = arrTmp;
        int endTmp = this.end;
        this.end = RHS.end;
        RHS.end = endTmp;
    }

    public final int find(char elem) {
        assert (this.checkAlive());
        return this.find(elem, 0);
    }

    public final int find(char elem, int from) {
        assert (this.checkAlive());
        boolean isDataPointerLike = this.isDataPointerLike();
        for (int i = from; i < this.end; ++i) {
            if (!Native.$eq((char)this.array[i], (char)elem, (boolean)isDataPointerLike)) continue;
            return i;
        }
        return std.string.npos;
    }

    public final boolean contains(char elem) {
        assert (this.checkAlive());
        return this.find(elem) != std.string.npos;
    }

    public final boolean erase(char elem) {
        assert (this.checkAlive());
        int index = this.find(elem);
        if (index == std.string.npos) {
            return false;
        }
        this.destroy_range(index, index + 1);
        --this.end;
        if (index < this.end) {
            NativePointer.copy$Object((char[])this.array, (int)(index + 1), (char[])this.array, (int)index, (int)(this.end - index));
        }
        this.$set(this.end, this.defaultValue);
        return true;
    }

    public final ushort.ptr erase(ushort.ptr I) {
        assert (this.checkAlive());
        assert (I.$greatereq((Object)this.begin())) : "Iterator to erase is out of bounds.";
        assert (I.$less((Object)this.end())) : "Erasing at past-the-end iterator.";
        ushort.ptr N = I;
        std.copy((ushort.iterator)((ushort.iterator)I.$add(1)), (ushort.iterator)this.end(), (ushort.iterator)I);
        this.pop_back();
        return N;
    }

    public final ushort.ptr erase(ushort.ptr S2, ushort.ptr E) {
        assert (this.checkAlive());
        assert (S2.$greatereq((Object)this.begin())) : "Range to erase is out of bounds.";
        assert (S2.$lesseq((Object)E)) : "Trying to erase invalid range.";
        assert (E.$lesseq((Object)this.end())) : "Trying to erase past the end.";
        ushort.ptr N = S2;
        ushort.ptr I = (ushort.ptr)std.copy((ushort.iterator)E, (ushort.iterator)this.end(), (ushort.iterator)S2);
        this.destroy_range(I, this.end());
        this.setEnd(I);
        return N;
    }

    public ushort.ptr insert_iterator$T$value_T$RR(ushort.ptr I, char Elt) {
        assert (this.checkAlive());
        if (I.$eq((Object)this.end())) {
            this.push_back_T$RR(Elt);
            return (ushort.ptr)this.end().$sub(1);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub((abstract_iterator)this.begin());
            this.grow();
            I = (ushort.ptr)this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward((ushort.iterator)I, (ushort.iterator)((ushort.iterator)this.end().$sub(1)), (ushort.iterator)this.end());
        I.$set(((Character)Native.$tryMove((Object)Character.valueOf(I.$star()), (Object)Character.valueOf(Elt), (boolean)this.isDataPointerLike())).charValue());
        return I;
    }

    public ushort.ptr insert_iterator$T_T$C$R(ushort.ptr I, char Elt) {
        return this.insert(I, Elt);
    }

    public ushort.ptr insert_iterator$T$value_T$C$R(ushort.ptr I, char Elt) {
        return this.insert(I, Elt);
    }

    public final ushort.ptr insert(ushort.ptr I, char Elt) {
        assert (this.checkAlive());
        if (I.$eq((Object)this.end())) {
            this.push_back(Elt);
            return (ushort.ptr)this.end().$sub(1);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub((abstract_iterator)this.begin());
            this.grow();
            I = (ushort.ptr)this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward((ushort.iterator)I, (ushort.iterator)((ushort.iterator)this.end().$sub(1)), (ushort.iterator)this.end());
        I.$set(((Character)Native.$tryAssign(null, (Object)Character.valueOf(Elt), (boolean)this.isDataPointerLike())).charValue());
        return I;
    }

    public final ushort.ptr insert(ushort.ptr I, int NumToInsert, char Elt) {
        assert (this.checkAlive());
        assert (NumToInsert >= 0) : "can not be negative " + NumToInsert;
        int InsertElt = I.$sub((abstract_iterator)this.begin());
        if (I.$eq((Object)this.end())) {
            this.append(NumToInsert, Elt);
            return (ushort.ptr)this.begin().$add(InsertElt);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        this.reserve(this.size() + NumToInsert);
        I = (ushort.ptr)this.begin().$add(InsertElt);
        if (this.end().$sub((abstract_iterator)I) >= NumToInsert) {
            ushort.ptr OldEnd = this.end();
            this.append_T((ushort.iterator<?>)((ushort.iterator)this.end().$sub(NumToInsert)), (ushort.iterator<?>)this.end());
            std.copy_backward((ushort.iterator)I, (ushort.iterator)((ushort.iterator)OldEnd.$sub(NumToInsert)), (ushort.iterator)OldEnd);
            std.fill_n((ushort.iterator)I, (int)NumToInsert, (char)Elt);
            return I;
        }
        ushort.ptr OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        int NumOverwritten = OldEnd.$sub((abstract_iterator)I);
        std.copy((ushort.iterator)I, (ushort.iterator)OldEnd, (ushort.iterator)((ushort.ptr)this.end().$sub(NumOverwritten)));
        std.fill_n((ushort.iterator)I, (int)NumOverwritten, (char)Elt);
        std.fill_n((ushort.iterator)OldEnd, (int)(NumToInsert - NumOverwritten), (char)Elt);
        return I;
    }

    public final ushort.ptr insert$T(ushort.ptr I, ushort.iterator<?> From, ushort.iterator<?> To) {
        assert (this.checkAlive());
        return this.insert(I, From, To);
    }

    public final ushort.ptr insert$T$value_T(ushort.ptr I, ushort.iterator<?> From, ushort.iterator<?> To) {
        assert (this.checkAlive());
        return this.insert(I, From, To);
    }

    public final ushort.ptr insert_iterator$T_T(ushort.ptr I, ushort.iterator<?> From, ushort.iterator<?> To) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public final ushort.ptr insert(ushort.ptr I, ushort.iterator<?> From, ushort.iterator<?> To) {
        assert (this.checkAlive());
        return this.insert_iterator$T$value_T(I, From, To);
    }

    public final ushort.ptr insert_iterator$T$value_T(ushort.ptr I, ushort.iterator<?> From, ushort.iterator<?> To) {
        int NumOverwritten;
        assert (this.checkAlive());
        int InsertElt = I.$sub((abstract_iterator)this.begin());
        if (I.$eq((Object)this.end())) {
            this.append_T(From, To);
            return (ushort.ptr)this.begin().$add(InsertElt);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        int NumToInsert = std.distance(From, To);
        assert (NumToInsert >= 0) : "Unexpected negative value " + NumToInsert;
        this.reserve(this.size() + NumToInsert);
        I = (ushort.ptr)this.begin().$add(InsertElt);
        if (NumToInsert == 0) {
            return I;
        }
        if (this.end().$sub((abstract_iterator)I) >= NumToInsert) {
            ushort.ptr OldEnd = this.end();
            this.append_T((ushort.iterator<?>)((ushort.iterator)this.end().$sub(NumToInsert)), (ushort.iterator<?>)this.end());
            std.copy_backward((ushort.iterator)I, (ushort.iterator)((ushort.iterator)OldEnd.$sub(NumToInsert)), (ushort.iterator)OldEnd);
            std.copy(From, To, (ushort.iterator)I);
            return I;
        }
        ushort.ptr OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        std.copy((ushort.iterator)I, (ushort.iterator)OldEnd, (ushort.iterator)((ushort.ptr)this.end().$sub(NumOverwritten)));
        if (NumOverwritten > 0) {
            From = (ushort.iterator)Native.$Clone(From);
            ushort.ptr J = (ushort.ptr)Native.$Clone((NativeCloneable)I);
            for (NumOverwritten = OldEnd.$sub((abstract_iterator)I); NumOverwritten > 0; --NumOverwritten) {
                J.star$ref().$set(From.$star());
                J.$preInc();
                From.$preInc();
            }
        }
        std.copy((ushort.iterator)From, To, (ushort.iterator)OldEnd);
        return I;
    }

    public final void append_T(ushort.iterator<?> in_start, ushort.iterator<?> in_end) {
        assert (this.checkAlive());
        int NumInputs = std.distance(in_start, in_end);
        assert (NumInputs >= 0) : "Unexpected negative value " + NumInputs;
        if (NumInputs == 0) {
            return;
        }
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        ushort.iterator iter = (ushort.iterator)Native.$Clone(in_start);
        while (!iter.$eq(in_end)) {
            this.$set(this.end, iter.$star());
            ++this.end;
            iter.$preInc();
        }
    }

    public final <F> void append_T(type.iterator<?, F> in_start, type.iterator<?, F> in_end, NativeCallback.Converter<F, Character> converter) {
        assert (this.checkAlive());
        int NumInputs = std.distance(in_start, in_end);
        assert (NumInputs >= 0) : "Unexpected negative value " + NumInputs;
        if (NumInputs == 0) {
            return;
        }
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        type.iterator iter = (type.iterator)Native.$Clone(in_start);
        while (!iter.$eq(in_end)) {
            this.$set(this.end, ((Character)converter.$call(iter.$star())).charValue());
            ++this.end;
            iter.$preInc();
        }
    }

    public final void append(char[] a) {
        assert (this.checkAlive());
        this.append(a, 0, a.length);
    }

    public final void append(char[] a, int fromIndex, int count) {
        assert (this.checkAlive());
        if (count > this.capacity() - this.size()) {
            this.grow(this.size() + count);
        }
        while (count-- > 0) {
            char el = a[fromIndex++];
            this.$set(this.end, el);
            ++this.end;
        }
    }

    public final void append(int NumInputs, char Elt) {
        assert (this.checkAlive());
        assert (NumInputs >= 0) : "can not be negative " + NumInputs;
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        for (int i = 0; i < NumInputs; ++i) {
            this.$set(this.end, Elt);
            ++this.end;
        }
    }

    public final void append_size_type$T$value_T$C$R(int NumInputs, char Elt) {
        this.append(NumInputs, Elt);
    }

    public final void append_size_type$T_T$C$R(int NumInputs, char Elt) {
        this.append(NumInputs, Elt);
    }

    public final boolean $eq(SmallVectorImplUShort RHS) {
        assert (this.checkAlive());
        assert (RHS.checkAlive());
        int size = this.size();
        if (size != RHS.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (!Native.$noteq((char)this.array[i], (char)RHS.array[i])) continue;
            return false;
        }
        return true;
    }

    public final boolean $noteq(SmallVectorImplUShort RHS) {
        return !this.$eq(RHS);
    }

    public final boolean $less(Object obj) {
        assert (this.checkAlive());
        assert (((SmallVectorImplUShort)obj).checkAlive());
        return std.lexicographical_compare((Object)this.begin(), (Object)this.end(), (Object)((SmallVectorImplUShort)obj).begin(), (Object)((SmallVectorImplUShort)obj).end());
    }

    public final boolean $lesseq(Object obj) {
        assert (this.checkAlive());
        assert (((SmallVectorImplUShort)obj).checkAlive());
        return this.$less(obj) || this.$eq((SmallVectorImplUShort)obj);
    }

    public final ushort.ref ref$at(int idx) {
        assert (this.checkAlive());
        return NativePointer.create_ushort$ref((char[])this.array, (int)idx);
    }

    public final char $at(int idx) {
        assert (this.checkAlive());
        return this.array[idx];
    }

    public final char $at$Const(int idx) {
        assert (this.checkAlive());
        return this.array[idx];
    }

    public final char $set(int idx, char value) {
        assert (this.checkAlive());
        this.array[idx] = value;
        return value;
    }

    protected final char $set$move(int idx, char value) {
        assert (this.checkAlive());
        this.array[idx] = value;
        return value;
    }

    public final boolean empty() {
        assert (this.checkAlive());
        return this.size() == 0;
    }

    public final void $destroy() {
        assert (this.checkAlive());
        this.setEnd(0);
        this.set$destroyed();
    }

    public final void push_back(char val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        this.$set(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public final void push_back_T$C$R(char val) {
        assert (this.checkAlive());
        this.push_back(val);
    }

    public final void push_back_T$RR(char val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        this.$set$move(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public final void emplace_back(char val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        int index = this.size();
        this.setEnd(index + 1);
        this.array[index] = val;
    }

    public final void emplace_back() {
        assert (this.checkAlive());
        this.push_back(this.defaultValue);
    }

    public final void pop_back() {
        assert (this.checkAlive());
        this.destroy_range(this.size() - 1, this.size());
        this.setEnd(this.size() - 1);
    }

    public final char pop_back_val() {
        assert (this.checkAlive());
        char val = this.back();
        this.setEnd(this.end - 1);
        return val;
    }

    public final ushort.ptr begin() {
        assert (this.checkAlive());
        return NativePointer.create_ushort$ptr((char[])this.array);
    }

    public final ushort.ptr begin$Const() {
        assert (this.checkAlive());
        return NativePointer.create_ushort$ptr((char[])this.array);
    }

    public final ushort.ptr end() {
        assert (this.checkAlive());
        return NativePointer.create_ushort$ptr((char[])this.array, (int)this.end);
    }

    public final ushort.ptr end$Const() {
        assert (this.checkAlive());
        return NativePointer.create_ushort$ptr((char[])this.array, (int)this.end);
    }

    public final std.reverse_iteratorUShort rbegin() {
        assert (this.checkAlive());
        return new std.reverse_iteratorUShort((ushort.iterator)NativePointer.create_ushort$ptr((char[])this.array, (int)this.end));
    }

    public final std.reverse_iteratorUShort rbegin$Const() {
        assert (this.checkAlive());
        return new std.reverse_iteratorUShort((ushort.iterator)NativePointer.create_ushort$ptr((char[])this.array, (int)this.end));
    }

    public final std.reverse_iteratorUShort rend() {
        assert (this.checkAlive());
        return new std.reverse_iteratorUShort((ushort.iterator)NativePointer.create_ushort$ptr((char[])this.array));
    }

    public final std.reverse_iteratorUShort rend$Const() {
        assert (this.checkAlive());
        return new std.reverse_iteratorUShort((ushort.iterator)NativePointer.create_ushort$ptr((char[])this.array));
    }

    public final ushort.ptr data() {
        assert (this.checkAlive());
        return NativePointer.create_ushort$ptr((char[])this.array);
    }

    public final ushort.ptr data$Const() {
        assert (this.checkAlive());
        return NativePointer.create_ushort$ptr((char[])this.array);
    }

    public final char front() {
        assert (this.checkAlive());
        return this.array[0];
    }

    public final char front$Const() {
        assert (this.checkAlive());
        return this.array[0];
    }

    public final char back() {
        assert (this.checkAlive());
        return this.array[this.end - 1];
    }

    public final char back$Const() {
        assert (this.checkAlive());
        return this.array[this.end - 1];
    }

    public final ushort.ref ref$front() {
        assert (this.checkAlive());
        return new ushort.ref(){
            private final int index = 0;

            public char $deref() {
                assert (SmallVectorImplUShort.this.checkAlive());
                return SmallVectorImplUShort.this.array[0];
            }

            public char $set(char value) {
                assert (SmallVectorImplUShort.this.checkAlive());
                ((SmallVectorImplUShort)SmallVectorImplUShort.this).array[0] = value;
                return value;
            }

            public ushort.ptr deref$ptr() {
                assert (SmallVectorImplUShort.this.checkAlive());
                return (ushort.ptr)SmallVectorImplUShort.this.data().$add(0);
            }
        };
    }

    public final ushort.ref ref$back() {
        assert (this.checkAlive());
        return new ushort.ref(){
            private final int index;
            {
                this.index = SmallVectorImplUShort.this.end - 1;
            }

            public char $deref() {
                assert (SmallVectorImplUShort.this.checkAlive());
                return SmallVectorImplUShort.this.array[this.index];
            }

            public char $set(char value) {
                assert (SmallVectorImplUShort.this.checkAlive());
                ((SmallVectorImplUShort)SmallVectorImplUShort.this).array[this.index] = value;
                return value;
            }

            public ushort.ptr deref$ptr() {
                assert (SmallVectorImplUShort.this.checkAlive());
                return (ushort.ptr)SmallVectorImplUShort.this.data().$add(this.index);
            }
        };
    }

    public final int size() {
        assert (this.checkAlive());
        return this.end;
    }

    public final int max_size() {
        assert (this.checkAlive());
        return Integer.MAX_VALUE;
    }

    public final int capacity() {
        assert (this.checkAlive());
        return this.array.length;
    }

    public final int $sizeof() {
        assert (this.checkAlive());
        return this.capacity_in_bytes();
    }

    public final int capacity_in_bytes() {
        assert (this.checkAlive());
        int oneElemSize = NativeType.sizeof((char)this.defaultValue);
        for (char elem : this.array) {
            if (elem == this.defaultValue) continue;
            oneElemSize = NativeType.sizeof((char)elem);
            break;
        }
        return this.array.length * oneElemSize;
    }

    public final ushort.ptr ptr$at(int idx) {
        assert (this.checkAlive());
        return NativePointer.create_ushort$ptr((char[])this.array, (int)idx);
    }

    public final void set_size(int N) {
        assert (this.checkAlive());
        assert (N >= 0) : "can not be negative " + N;
        assert (N <= this.capacity());
        this.setEnd(N);
    }

    private void destroy_range(int from, int to) {
    }

    private void destroy_range(ushort.ptr _from, ushort.ptr _to) {
        this.destroy_range(_from.$sub((abstract_iterator)this.begin()), _to.$sub((abstract_iterator)this.begin()));
    }

    private void grow(int capacity) {
        char[] oldArray = this.array;
        this.array = NativePointer.new$ushort((int)capacity);
        NativePointer.copy$Object((char[])oldArray, (int)0, (char[])this.array, (int)0, (int)oldArray.length);
    }

    private void grow() {
        int capacity = this.capacity();
        this.grow(capacity == 0 ? 1 : (capacity < 1024 ? capacity * 2 : capacity + 1024));
    }

    private void setEnd(int to) {
        this.end = to;
    }

    private void setEnd(ushort.ptr to) {
        this.setEnd(to.$sub((abstract_iterator)this.begin()));
    }

    @Override
    public Iterator<Character> iterator() {
        assert (this.checkAlive());
        return new JavaIteratorUShort((ushort.iterator)this.begin(), (ushort.iterator)this.end());
    }

    public boolean isDataPointerLike() {
        return false;
    }

    public String toString() {
        String extra;
        String string2 = extra = super.is$destroyed() ? "DESTROYED" : "";
        if (this.end == 0) {
            return extra + "<EMPTY>";
        }
        StringBuilder out = new StringBuilder("\nSmallVectorImplUShort{\n");
        out.append(extra).append("end = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            char element = this.array[i];
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(element).append('\n');
        }
        out.append("}SmallVectorImplUShort}\n");
        return out.toString();
    }

    protected final boolean checkAlive() {
        return this.check$Alive();
    }
}

