/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeSwappable;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.JavaIteratorShort;
import org.clank.support.aliases.NativeContainerShort;
import org.clank.support.aliases.short;
import org.clank.support.aliases.type;

public abstract class SmallVectorImplShort
extends NativeTrace.CreateDestroy$Tracker
implements Native.assignable<SmallVectorImplShort>,
Native.NativeComparable<SmallVectorImplShort>,
Native.ComparableLower,
NativeType.SizeofCapable,
NativeSwappable,
Iterable<Short>,
Native.NativeIterable<short.ptr>,
Native.NativeReverseIterable<std.reverse_iteratorShort>,
NativeContainerShort {
    protected final short defaultValue;
    private short[] array;
    private static final short[] EMPTY = NativePointer.new$short((int)0);
    private int end;

    public final short[] $array() {
        assert (this.checkAlive());
        return this.array;
    }

    protected SmallVectorImplShort(int capacity, short defaultValue) {
        this.array = capacity == 0 ? EMPTY : NativePointer.new$short((int)capacity);
        this.end = 0;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplShort(int capacity, int initialSize, short defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImplShort(JavaDifferentiators.JD$UInt_T$C$R _dparam, int capacity, int initialSize, short defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImplShort(JavaDifferentiators.JD$UInt_T$C$R _dparam, int capacity, int initialSize, short value, short defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, value);
    }

    protected SmallVectorImplShort(short[] array2, short defaultValue) {
        this.array = array2;
        this.end = array2 == null ? 0 : array2.length;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplShort(int capacity, short.iterator<?> iter, int length, short defaultValue) {
        this(capacity, iter, (short.iterator)iter.$add(length), defaultValue);
    }

    protected SmallVectorImplShort(int capacity, short.iterator<?> begin, short.iterator<?> end, short defaultValue) {
        this(capacity, defaultValue);
        this.append_T(begin, end);
    }

    protected SmallVectorImplShort(SmallVectorImplShort other) {
        assert (other.checkAlive());
        this.defaultValue = other.defaultValue;
        int capacity = other.size();
        this.array = capacity == 0 ? EMPTY : NativePointer.new$short((int)capacity);
        this.append_T((short.iterator<?>)other.begin(), (short.iterator<?>)other.end());
    }

    protected SmallVectorImplShort(JavaDifferentiators.JD.Move _dparam, SmallVectorImplShort other) {
        assert (other.checkAlive());
        this.defaultValue = other.defaultValue;
        this.array = other.array;
        this.end = other.end;
        other.array = EMPTY;
        other.end = 0;
    }

    public final SmallVectorImplShort $assign(SmallVectorImplShort other) {
        assert (this.checkAlive());
        assert (other.checkAlive());
        if (this == other) {
            return this;
        }
        this.clear();
        this.array = EMPTY;
        this.append_T((short.iterator<?>)other.begin(), (short.iterator<?>)other.end());
        return this;
    }

    public final SmallVectorImplShort $assignMove(SmallVectorImplShort other) {
        assert (this.checkAlive());
        assert (other.checkAlive());
        assert (this != other) : "moving self";
        this.array = other.array;
        this.end = other.end;
        other.array = EMPTY;
        other.end = 0;
        return this;
    }

    public final void clear() {
        assert (this.checkAlive());
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    public final boolean resize(int newSize) {
        assert (this.checkAlive());
        return this.resize(newSize, this.defaultValue);
    }

    public final boolean resize(int newSize, short defaultValue) {
        assert (this.checkAlive());
        assert (newSize >= 0) : "can not be negative " + newSize;
        boolean grown = false;
        if (newSize < this.end) {
            this.destroy_range(newSize, this.end);
        } else if (newSize > this.end) {
            if (this.capacity() < newSize) {
                this.grow(newSize);
                grown = true;
            }
            for (int i = this.end; i < newSize; ++i) {
                this.array[i] = Native.$tryClone((short)defaultValue);
            }
        }
        this.setEnd(newSize);
        return grown;
    }

    public final void reserve(int N) {
        assert (this.checkAlive());
        assert (N >= 0) : "can not be negative " + N;
        if (this.capacity() < N) {
            this.grow(N);
        }
    }

    public final void assign(int NumElts, short Elt) {
        assert (this.checkAlive());
        assert (NumElts >= 0) : "can not be negative " + NumElts;
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.$set(i, Elt);
        }
    }

    public final void assign$T(short.iterator<?> __first, short.iterator<?> __last) {
        assert (this.checkAlive());
        this.clear();
        this.append_T(__first, __last);
    }

    public final void swap(NativeSwappable _RHS) {
        assert (this.checkAlive());
        SmallVectorImplShort RHS = (SmallVectorImplShort)_RHS;
        short[] arrTmp = this.array;
        this.array = RHS.array;
        RHS.array = arrTmp;
        int endTmp = this.end;
        this.end = RHS.end;
        RHS.end = endTmp;
    }

    public final int find(short elem) {
        assert (this.checkAlive());
        return this.find(elem, 0);
    }

    public final int find(short elem, int from) {
        assert (this.checkAlive());
        boolean isDataPointerLike = this.isDataPointerLike();
        for (int i = from; i < this.end; ++i) {
            if (!Native.$eq((short)this.array[i], (short)elem, (boolean)isDataPointerLike)) continue;
            return i;
        }
        return std.string.npos;
    }

    public final boolean contains(short elem) {
        assert (this.checkAlive());
        return this.find(elem) != std.string.npos;
    }

    public final boolean erase(short elem) {
        assert (this.checkAlive());
        int index = this.find(elem);
        if (index == std.string.npos) {
            return false;
        }
        this.destroy_range(index, index + 1);
        --this.end;
        if (index < this.end) {
            NativePointer.copy$Object((short[])this.array, (int)(index + 1), (short[])this.array, (int)index, (int)(this.end - index));
        }
        this.$set(this.end, this.defaultValue);
        return true;
    }

    public final short.ptr erase(short.ptr I) {
        assert (this.checkAlive());
        assert (I.$greatereq((Object)this.begin())) : "Iterator to erase is out of bounds.";
        assert (I.$less((Object)this.end())) : "Erasing at past-the-end iterator.";
        short.ptr N = I;
        std.copy((short.iterator)((short.iterator)I.$add(1)), (short.iterator)this.end(), (short.iterator)I);
        this.pop_back();
        return N;
    }

    public final short.ptr erase(short.ptr S2, short.ptr E) {
        assert (this.checkAlive());
        assert (S2.$greatereq((Object)this.begin())) : "Range to erase is out of bounds.";
        assert (S2.$lesseq((Object)E)) : "Trying to erase invalid range.";
        assert (E.$lesseq((Object)this.end())) : "Trying to erase past the end.";
        short.ptr N = S2;
        short.ptr I = (short.ptr)std.copy((short.iterator)E, (short.iterator)this.end(), (short.iterator)S2);
        this.destroy_range(I, this.end());
        this.setEnd(I);
        return N;
    }

    public short.ptr insert_iterator$T$value_T$RR(short.ptr I, short Elt) {
        assert (this.checkAlive());
        if (I.$eq((Object)this.end())) {
            this.push_back_T$RR(Elt);
            return (short.ptr)this.end().$sub(1);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub((abstract_iterator)this.begin());
            this.grow();
            I = (short.ptr)this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward((short.iterator)I, (short.iterator)((short.iterator)this.end().$sub(1)), (short.iterator)this.end());
        I.$set(((Short)Native.$tryMove((Object)I.$star(), (Object)Elt, (boolean)this.isDataPointerLike())).shortValue());
        return I;
    }

    public short.ptr insert_iterator$T_T$C$R(short.ptr I, short Elt) {
        return this.insert(I, Elt);
    }

    public short.ptr insert_iterator$T$value_T$C$R(short.ptr I, short Elt) {
        return this.insert(I, Elt);
    }

    public final short.ptr insert(short.ptr I, short Elt) {
        assert (this.checkAlive());
        if (I.$eq((Object)this.end())) {
            this.push_back(Elt);
            return (short.ptr)this.end().$sub(1);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub((abstract_iterator)this.begin());
            this.grow();
            I = (short.ptr)this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward((short.iterator)I, (short.iterator)((short.iterator)this.end().$sub(1)), (short.iterator)this.end());
        I.$set(((Short)Native.$tryAssign(null, (Object)Elt, (boolean)this.isDataPointerLike())).shortValue());
        return I;
    }

    public final short.ptr insert(short.ptr I, int NumToInsert, short Elt) {
        assert (this.checkAlive());
        assert (NumToInsert >= 0) : "can not be negative " + NumToInsert;
        int InsertElt = I.$sub((abstract_iterator)this.begin());
        if (I.$eq((Object)this.end())) {
            this.append(NumToInsert, Elt);
            return (short.ptr)this.begin().$add(InsertElt);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        this.reserve(this.size() + NumToInsert);
        I = (short.ptr)this.begin().$add(InsertElt);
        if (this.end().$sub((abstract_iterator)I) >= NumToInsert) {
            short.ptr OldEnd = this.end();
            this.append_T((short.iterator<?>)((short.iterator)this.end().$sub(NumToInsert)), (short.iterator<?>)this.end());
            std.copy_backward((short.iterator)I, (short.iterator)((short.iterator)OldEnd.$sub(NumToInsert)), (short.iterator)OldEnd);
            std.fill_n((short.iterator)I, (int)NumToInsert, (short)Elt);
            return I;
        }
        short.ptr OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        int NumOverwritten = OldEnd.$sub((abstract_iterator)I);
        std.copy((short.iterator)I, (short.iterator)OldEnd, (short.iterator)((short.ptr)this.end().$sub(NumOverwritten)));
        std.fill_n((short.iterator)I, (int)NumOverwritten, (short)Elt);
        std.fill_n((short.iterator)OldEnd, (int)(NumToInsert - NumOverwritten), (short)Elt);
        return I;
    }

    public final short.ptr insert$T(short.ptr I, short.iterator<?> From, short.iterator<?> To) {
        assert (this.checkAlive());
        return this.insert(I, From, To);
    }

    public final short.ptr insert$T$value_T(short.ptr I, short.iterator<?> From, short.iterator<?> To) {
        assert (this.checkAlive());
        return this.insert(I, From, To);
    }

    public final short.ptr insert_iterator$T_T(short.ptr I, short.iterator<?> From, short.iterator<?> To) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public final short.ptr insert(short.ptr I, short.iterator<?> From, short.iterator<?> To) {
        assert (this.checkAlive());
        return this.insert_iterator$T$value_T(I, From, To);
    }

    public final short.ptr insert_iterator$T$value_T(short.ptr I, short.iterator<?> From, short.iterator<?> To) {
        int NumOverwritten;
        assert (this.checkAlive());
        int InsertElt = I.$sub((abstract_iterator)this.begin());
        if (I.$eq((Object)this.end())) {
            this.append_T(From, To);
            return (short.ptr)this.begin().$add(InsertElt);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        int NumToInsert = std.distance(From, To);
        assert (NumToInsert >= 0) : "Unexpected negative value " + NumToInsert;
        this.reserve(this.size() + NumToInsert);
        I = (short.ptr)this.begin().$add(InsertElt);
        if (NumToInsert == 0) {
            return I;
        }
        if (this.end().$sub((abstract_iterator)I) >= NumToInsert) {
            short.ptr OldEnd = this.end();
            this.append_T((short.iterator<?>)((short.iterator)this.end().$sub(NumToInsert)), (short.iterator<?>)this.end());
            std.copy_backward((short.iterator)I, (short.iterator)((short.iterator)OldEnd.$sub(NumToInsert)), (short.iterator)OldEnd);
            std.copy(From, To, (short.iterator)I);
            return I;
        }
        short.ptr OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        std.copy((short.iterator)I, (short.iterator)OldEnd, (short.iterator)((short.ptr)this.end().$sub(NumOverwritten)));
        if (NumOverwritten > 0) {
            From = (short.iterator)Native.$Clone(From);
            short.ptr J = (short.ptr)Native.$Clone((NativeCloneable)I);
            for (NumOverwritten = OldEnd.$sub((abstract_iterator)I); NumOverwritten > 0; --NumOverwritten) {
                J.star$ref().$set(From.$star());
                J.$preInc();
                From.$preInc();
            }
        }
        std.copy((short.iterator)From, To, (short.iterator)OldEnd);
        return I;
    }

    public final void append_T(short.iterator<?> in_start, short.iterator<?> in_end) {
        assert (this.checkAlive());
        int NumInputs = std.distance(in_start, in_end);
        assert (NumInputs >= 0) : "Unexpected negative value " + NumInputs;
        if (NumInputs == 0) {
            return;
        }
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        short.iterator iter = (short.iterator)Native.$Clone(in_start);
        while (!iter.$eq(in_end)) {
            this.$set(this.end, iter.$star());
            ++this.end;
            iter.$preInc();
        }
    }

    public final <F> void append_T(type.iterator<?, F> in_start, type.iterator<?, F> in_end, NativeCallback.Converter<F, Short> converter) {
        assert (this.checkAlive());
        int NumInputs = std.distance(in_start, in_end);
        assert (NumInputs >= 0) : "Unexpected negative value " + NumInputs;
        if (NumInputs == 0) {
            return;
        }
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        type.iterator iter = (type.iterator)Native.$Clone(in_start);
        while (!iter.$eq(in_end)) {
            this.$set(this.end, (Short)converter.$call(iter.$star()));
            ++this.end;
            iter.$preInc();
        }
    }

    public final void append(short[] a) {
        assert (this.checkAlive());
        this.append(a, 0, a.length);
    }

    public final void append(short[] a, int fromIndex, int count) {
        assert (this.checkAlive());
        if (count > this.capacity() - this.size()) {
            this.grow(this.size() + count);
        }
        while (count-- > 0) {
            short el = a[fromIndex++];
            this.$set(this.end, el);
            ++this.end;
        }
    }

    public final void append(int NumInputs, short Elt) {
        assert (this.checkAlive());
        assert (NumInputs >= 0) : "can not be negative " + NumInputs;
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        for (int i = 0; i < NumInputs; ++i) {
            this.$set(this.end, Elt);
            ++this.end;
        }
    }

    public final void append_size_type$T$value_T$C$R(int NumInputs, short Elt) {
        this.append(NumInputs, Elt);
    }

    public final void append_size_type$T_T$C$R(int NumInputs, short Elt) {
        this.append(NumInputs, Elt);
    }

    public final boolean $eq(SmallVectorImplShort RHS) {
        assert (this.checkAlive());
        assert (RHS.checkAlive());
        int size = this.size();
        if (size != RHS.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (!Native.$noteq((int)this.array[i], (int)RHS.array[i])) continue;
            return false;
        }
        return true;
    }

    public final boolean $noteq(SmallVectorImplShort RHS) {
        return !this.$eq(RHS);
    }

    public final boolean $less(Object obj) {
        assert (this.checkAlive());
        assert (((SmallVectorImplShort)obj).checkAlive());
        return std.lexicographical_compare((Object)this.begin(), (Object)this.end(), (Object)((SmallVectorImplShort)obj).begin(), (Object)((SmallVectorImplShort)obj).end());
    }

    public final boolean $lesseq(Object obj) {
        assert (this.checkAlive());
        assert (((SmallVectorImplShort)obj).checkAlive());
        return this.$less(obj) || this.$eq((SmallVectorImplShort)obj);
    }

    public final short.ref ref$at(int idx) {
        assert (this.checkAlive());
        return NativePointer.create_short$ref((short[])this.array, (int)idx);
    }

    public final short $at(int idx) {
        assert (this.checkAlive());
        return this.array[idx];
    }

    public final short $at$Const(int idx) {
        assert (this.checkAlive());
        return this.array[idx];
    }

    public final short $set(int idx, short value) {
        assert (this.checkAlive());
        this.array[idx] = value;
        return value;
    }

    protected final short $set$move(int idx, short value) {
        assert (this.checkAlive());
        this.array[idx] = value;
        return value;
    }

    public final boolean empty() {
        assert (this.checkAlive());
        return this.size() == 0;
    }

    public final void $destroy() {
        assert (this.checkAlive());
        this.setEnd(0);
        this.set$destroyed();
    }

    public final void push_back(short val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        this.$set(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public final void push_back_T$C$R(short val) {
        assert (this.checkAlive());
        this.push_back(val);
    }

    public final void push_back_T$RR(short val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        this.$set$move(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public final void emplace_back(short val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        int index = this.size();
        this.setEnd(index + 1);
        this.array[index] = val;
    }

    public final void emplace_back() {
        assert (this.checkAlive());
        this.push_back(this.defaultValue);
    }

    public final void pop_back() {
        assert (this.checkAlive());
        this.destroy_range(this.size() - 1, this.size());
        this.setEnd(this.size() - 1);
    }

    public final short pop_back_val() {
        assert (this.checkAlive());
        short val = this.back();
        this.setEnd(this.end - 1);
        return val;
    }

    public final short.ptr begin() {
        assert (this.checkAlive());
        return NativePointer.create_short$ptr((short[])this.array);
    }

    public final short.ptr begin$Const() {
        assert (this.checkAlive());
        return NativePointer.create_short$ptr((short[])this.array);
    }

    public final short.ptr end() {
        assert (this.checkAlive());
        return NativePointer.create_short$ptr((short[])this.array, (int)this.end);
    }

    public final short.ptr end$Const() {
        assert (this.checkAlive());
        return NativePointer.create_short$ptr((short[])this.array, (int)this.end);
    }

    public final std.reverse_iteratorShort rbegin() {
        assert (this.checkAlive());
        return new std.reverse_iteratorShort((short.iterator)NativePointer.create_short$ptr((short[])this.array, (int)this.end));
    }

    public final std.reverse_iteratorShort rbegin$Const() {
        assert (this.checkAlive());
        return new std.reverse_iteratorShort((short.iterator)NativePointer.create_short$ptr((short[])this.array, (int)this.end));
    }

    public final std.reverse_iteratorShort rend() {
        assert (this.checkAlive());
        return new std.reverse_iteratorShort((short.iterator)NativePointer.create_short$ptr((short[])this.array));
    }

    public final std.reverse_iteratorShort rend$Const() {
        assert (this.checkAlive());
        return new std.reverse_iteratorShort((short.iterator)NativePointer.create_short$ptr((short[])this.array));
    }

    public final short.ptr data() {
        assert (this.checkAlive());
        return NativePointer.create_short$ptr((short[])this.array);
    }

    public final short.ptr data$Const() {
        assert (this.checkAlive());
        return NativePointer.create_short$ptr((short[])this.array);
    }

    public final short front() {
        assert (this.checkAlive());
        return this.array[0];
    }

    public final short front$Const() {
        assert (this.checkAlive());
        return this.array[0];
    }

    public final short back() {
        assert (this.checkAlive());
        return this.array[this.end - 1];
    }

    public final short back$Const() {
        assert (this.checkAlive());
        return this.array[this.end - 1];
    }

    public final short.ref ref$front() {
        assert (this.checkAlive());
        return new short.ref(){
            private final int index = 0;

            public short $deref() {
                assert (SmallVectorImplShort.this.checkAlive());
                return SmallVectorImplShort.this.array[0];
            }

            public short $set(short value) {
                assert (SmallVectorImplShort.this.checkAlive());
                ((SmallVectorImplShort)SmallVectorImplShort.this).array[0] = value;
                return value;
            }

            public short.ptr deref$ptr() {
                assert (SmallVectorImplShort.this.checkAlive());
                return (short.ptr)SmallVectorImplShort.this.data().$add(0);
            }
        };
    }

    public final short.ref ref$back() {
        assert (this.checkAlive());
        return new short.ref(){
            private final int index;
            {
                this.index = SmallVectorImplShort.this.end - 1;
            }

            public short $deref() {
                assert (SmallVectorImplShort.this.checkAlive());
                return SmallVectorImplShort.this.array[this.index];
            }

            public short $set(short value) {
                assert (SmallVectorImplShort.this.checkAlive());
                ((SmallVectorImplShort)SmallVectorImplShort.this).array[this.index] = value;
                return value;
            }

            public short.ptr deref$ptr() {
                assert (SmallVectorImplShort.this.checkAlive());
                return (short.ptr)SmallVectorImplShort.this.data().$add(this.index);
            }
        };
    }

    public final int size() {
        assert (this.checkAlive());
        return this.end;
    }

    public final int max_size() {
        assert (this.checkAlive());
        return Integer.MAX_VALUE;
    }

    public final int capacity() {
        assert (this.checkAlive());
        return this.array.length;
    }

    public final int $sizeof() {
        assert (this.checkAlive());
        return this.capacity_in_bytes();
    }

    public final int capacity_in_bytes() {
        assert (this.checkAlive());
        int oneElemSize = NativeType.sizeof((short)this.defaultValue);
        for (short elem : this.array) {
            if (elem == this.defaultValue) continue;
            oneElemSize = NativeType.sizeof((short)elem);
            break;
        }
        return this.array.length * oneElemSize;
    }

    public final short.ptr ptr$at(int idx) {
        assert (this.checkAlive());
        return NativePointer.create_short$ptr((short[])this.array, (int)idx);
    }

    public final void set_size(int N) {
        assert (this.checkAlive());
        assert (N >= 0) : "can not be negative " + N;
        assert (N <= this.capacity());
        this.setEnd(N);
    }

    private void destroy_range(int from, int to) {
    }

    private void destroy_range(short.ptr _from, short.ptr _to) {
        this.destroy_range(_from.$sub((abstract_iterator)this.begin()), _to.$sub((abstract_iterator)this.begin()));
    }

    private void grow(int capacity) {
        short[] oldArray = this.array;
        this.array = NativePointer.new$short((int)capacity);
        NativePointer.copy$Object((short[])oldArray, (int)0, (short[])this.array, (int)0, (int)oldArray.length);
    }

    private void grow() {
        int capacity = this.capacity();
        this.grow(capacity == 0 ? 1 : (capacity < 1024 ? capacity * 2 : capacity + 1024));
    }

    private void setEnd(int to) {
        this.end = to;
    }

    private void setEnd(short.ptr to) {
        this.setEnd(to.$sub((abstract_iterator)this.begin()));
    }

    @Override
    public Iterator<Short> iterator() {
        assert (this.checkAlive());
        return new JavaIteratorShort((short.iterator)this.begin(), (short.iterator)this.end());
    }

    public boolean isDataPointerLike() {
        return false;
    }

    public String toString() {
        String extra;
        String string2 = extra = super.is$destroyed() ? "DESTROYED" : "";
        if (this.end == 0) {
            return extra + "<EMPTY>";
        }
        StringBuilder out = new StringBuilder("\nSmallVectorImplShort{\n");
        out.append(extra).append("end = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            short element = this.array[i];
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(element).append('\n');
        }
        out.append("}SmallVectorImplShort}\n");
        return out.toString();
    }

    protected final boolean checkAlive() {
        return this.check$Alive();
    }
}

