/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeSwappable;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.JavaIteratorDouble;
import org.clank.support.aliases.NativeContainerDouble;
import org.clank.support.aliases.double;
import org.clank.support.aliases.type;

public abstract class SmallVectorImplDouble
extends NativeTrace.CreateDestroy$Tracker
implements Native.assignable<SmallVectorImplDouble>,
Native.NativeComparable<SmallVectorImplDouble>,
Native.ComparableLower,
NativeType.SizeofCapable,
NativeSwappable,
Iterable<Double>,
Native.NativeIterable<double.ptr>,
Native.NativeReverseIterable<std.reverse_iteratorDouble>,
NativeContainerDouble {
    protected final double defaultValue;
    private double[] array;
    private static final double[] EMPTY = NativePointer.new$double((int)0);
    private int end;

    public final double[] $array() {
        assert (this.checkAlive());
        return this.array;
    }

    protected SmallVectorImplDouble(int capacity, double defaultValue) {
        this.array = capacity == 0 ? EMPTY : NativePointer.new$double((int)capacity);
        this.end = 0;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplDouble(int capacity, int initialSize, double defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImplDouble(JavaDifferentiators.JD$UInt_T$C$R _dparam, int capacity, int initialSize, double defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImplDouble(JavaDifferentiators.JD$UInt_T$C$R _dparam, int capacity, int initialSize, double value, double defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, value);
    }

    protected SmallVectorImplDouble(double[] array2, double defaultValue) {
        this.array = array2;
        this.end = array2 == null ? 0 : array2.length;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplDouble(int capacity, double.iterator<?> iter, int length, double defaultValue) {
        this(capacity, iter, (double.iterator)iter.$add(length), defaultValue);
    }

    protected SmallVectorImplDouble(int capacity, double.iterator<?> begin, double.iterator<?> end, double defaultValue) {
        this(capacity, defaultValue);
        this.append_T(begin, end);
    }

    protected SmallVectorImplDouble(SmallVectorImplDouble other) {
        assert (other.checkAlive());
        this.defaultValue = other.defaultValue;
        int capacity = other.size();
        this.array = capacity == 0 ? EMPTY : NativePointer.new$double((int)capacity);
        this.append_T((double.iterator<?>)other.begin(), (double.iterator<?>)other.end());
    }

    protected SmallVectorImplDouble(JavaDifferentiators.JD.Move _dparam, SmallVectorImplDouble other) {
        assert (other.checkAlive());
        this.defaultValue = other.defaultValue;
        this.array = other.array;
        this.end = other.end;
        other.array = EMPTY;
        other.end = 0;
    }

    public final SmallVectorImplDouble $assign(SmallVectorImplDouble other) {
        assert (this.checkAlive());
        assert (other.checkAlive());
        if (this == other) {
            return this;
        }
        this.clear();
        this.array = EMPTY;
        this.append_T((double.iterator<?>)other.begin(), (double.iterator<?>)other.end());
        return this;
    }

    public final SmallVectorImplDouble $assignMove(SmallVectorImplDouble other) {
        assert (this.checkAlive());
        assert (other.checkAlive());
        assert (this != other) : "moving self";
        this.array = other.array;
        this.end = other.end;
        other.array = EMPTY;
        other.end = 0;
        return this;
    }

    public final void clear() {
        assert (this.checkAlive());
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    public final boolean resize(int newSize) {
        assert (this.checkAlive());
        return this.resize(newSize, this.defaultValue);
    }

    public final boolean resize(int newSize, double defaultValue) {
        assert (this.checkAlive());
        assert (newSize >= 0) : "can not be negative " + newSize;
        boolean grown = false;
        if (newSize < this.end) {
            this.destroy_range(newSize, this.end);
        } else if (newSize > this.end) {
            if (this.capacity() < newSize) {
                this.grow(newSize);
                grown = true;
            }
            for (int i = this.end; i < newSize; ++i) {
                this.array[i] = (Double)Native.$tryClone((Object)defaultValue);
            }
        }
        this.setEnd(newSize);
        return grown;
    }

    public final void reserve(int N) {
        assert (this.checkAlive());
        assert (N >= 0) : "can not be negative " + N;
        if (this.capacity() < N) {
            this.grow(N);
        }
    }

    public final void assign(int NumElts, double Elt) {
        assert (this.checkAlive());
        assert (NumElts >= 0) : "can not be negative " + NumElts;
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.$set(i, Elt);
        }
    }

    public final void assign$T(double.iterator<?> __first, double.iterator<?> __last) {
        assert (this.checkAlive());
        this.clear();
        this.append_T(__first, __last);
    }

    public final void swap(NativeSwappable _RHS) {
        assert (this.checkAlive());
        SmallVectorImplDouble RHS = (SmallVectorImplDouble)_RHS;
        double[] arrTmp = this.array;
        this.array = RHS.array;
        RHS.array = arrTmp;
        int endTmp = this.end;
        this.end = RHS.end;
        RHS.end = endTmp;
    }

    public final int find(double elem) {
        assert (this.checkAlive());
        return this.find(elem, 0);
    }

    public final int find(double elem, int from) {
        assert (this.checkAlive());
        boolean isDataPointerLike = this.isDataPointerLike();
        for (int i = from; i < this.end; ++i) {
            if (!Native.$eq((Object)this.array[i], (Object)elem, (boolean)isDataPointerLike)) continue;
            return i;
        }
        return std.string.npos;
    }

    public final boolean contains(double elem) {
        assert (this.checkAlive());
        return this.find(elem) != std.string.npos;
    }

    public final boolean erase(double elem) {
        assert (this.checkAlive());
        int index = this.find(elem);
        if (index == std.string.npos) {
            return false;
        }
        this.destroy_range(index, index + 1);
        --this.end;
        if (index < this.end) {
            NativePointer.copy$Object((double[])this.array, (int)(index + 1), (double[])this.array, (int)index, (int)(this.end - index));
        }
        this.$set(this.end, this.defaultValue);
        return true;
    }

    public final double.ptr erase(double.ptr I) {
        assert (this.checkAlive());
        assert (I.$greatereq((Object)this.begin())) : "Iterator to erase is out of bounds.";
        assert (I.$less((Object)this.end())) : "Erasing at past-the-end iterator.";
        double.ptr N = I;
        std.copy((double.iterator)((double.iterator)I.$add(1)), (double.iterator)this.end(), (double.iterator)I);
        this.pop_back();
        return N;
    }

    public final double.ptr erase(double.ptr S2, double.ptr E) {
        assert (this.checkAlive());
        assert (S2.$greatereq((Object)this.begin())) : "Range to erase is out of bounds.";
        assert (S2.$lesseq((Object)E)) : "Trying to erase invalid range.";
        assert (E.$lesseq((Object)this.end())) : "Trying to erase past the end.";
        double.ptr N = S2;
        double.ptr I = (double.ptr)std.copy((double.iterator)E, (double.iterator)this.end(), (double.iterator)S2);
        this.destroy_range(I, this.end());
        this.setEnd(I);
        return N;
    }

    public double.ptr insert_iterator$T$value_T$RR(double.ptr I, double Elt) {
        assert (this.checkAlive());
        if (I.$eq((Object)this.end())) {
            this.push_back_T$RR(Elt);
            return (double.ptr)this.end().$sub(1);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub((abstract_iterator)this.begin());
            this.grow();
            I = (double.ptr)this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward((double.iterator)I, (double.iterator)((double.iterator)this.end().$sub(1)), (double.iterator)this.end());
        I.$set(((Double)Native.$tryMove((Object)I.$star(), (Object)Elt, (boolean)this.isDataPointerLike())).doubleValue());
        return I;
    }

    public double.ptr insert_iterator$T_T$C$R(double.ptr I, double Elt) {
        return this.insert(I, Elt);
    }

    public double.ptr insert_iterator$T$value_T$C$R(double.ptr I, double Elt) {
        return this.insert(I, Elt);
    }

    public final double.ptr insert(double.ptr I, double Elt) {
        assert (this.checkAlive());
        if (I.$eq((Object)this.end())) {
            this.push_back(Elt);
            return (double.ptr)this.end().$sub(1);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub((abstract_iterator)this.begin());
            this.grow();
            I = (double.ptr)this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward((double.iterator)I, (double.iterator)((double.iterator)this.end().$sub(1)), (double.iterator)this.end());
        I.$set(((Double)Native.$tryAssign(null, (Object)Elt, (boolean)this.isDataPointerLike())).doubleValue());
        return I;
    }

    public final double.ptr insert(double.ptr I, int NumToInsert, double Elt) {
        assert (this.checkAlive());
        assert (NumToInsert >= 0) : "can not be negative " + NumToInsert;
        int InsertElt = I.$sub((abstract_iterator)this.begin());
        if (I.$eq((Object)this.end())) {
            this.append(NumToInsert, Elt);
            return (double.ptr)this.begin().$add(InsertElt);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        this.reserve(this.size() + NumToInsert);
        I = (double.ptr)this.begin().$add(InsertElt);
        if (this.end().$sub((abstract_iterator)I) >= NumToInsert) {
            double.ptr OldEnd = this.end();
            this.append_T((double.iterator<?>)((double.iterator)this.end().$sub(NumToInsert)), (double.iterator<?>)this.end());
            std.copy_backward((double.iterator)I, (double.iterator)((double.iterator)OldEnd.$sub(NumToInsert)), (double.iterator)OldEnd);
            std.fill_n((double.iterator)I, (int)NumToInsert, (double)Elt);
            return I;
        }
        double.ptr OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        int NumOverwritten = OldEnd.$sub((abstract_iterator)I);
        std.copy((double.iterator)I, (double.iterator)OldEnd, (double.iterator)((double.ptr)this.end().$sub(NumOverwritten)));
        std.fill_n((double.iterator)I, (int)NumOverwritten, (double)Elt);
        std.fill_n((double.iterator)OldEnd, (int)(NumToInsert - NumOverwritten), (double)Elt);
        return I;
    }

    public final double.ptr insert$T(double.ptr I, double.iterator<?> From, double.iterator<?> To) {
        assert (this.checkAlive());
        return this.insert(I, From, To);
    }

    public final double.ptr insert$T$value_T(double.ptr I, double.iterator<?> From, double.iterator<?> To) {
        assert (this.checkAlive());
        return this.insert(I, From, To);
    }

    public final double.ptr insert_iterator$T_T(double.ptr I, double.iterator<?> From, double.iterator<?> To) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public final double.ptr insert(double.ptr I, double.iterator<?> From, double.iterator<?> To) {
        assert (this.checkAlive());
        return this.insert_iterator$T$value_T(I, From, To);
    }

    public final double.ptr insert_iterator$T$value_T(double.ptr I, double.iterator<?> From, double.iterator<?> To) {
        int NumOverwritten;
        assert (this.checkAlive());
        int InsertElt = I.$sub((abstract_iterator)this.begin());
        if (I.$eq((Object)this.end())) {
            this.append_T(From, To);
            return (double.ptr)this.begin().$add(InsertElt);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        int NumToInsert = std.distance(From, To);
        assert (NumToInsert >= 0) : "Unexpected negative value " + NumToInsert;
        this.reserve(this.size() + NumToInsert);
        I = (double.ptr)this.begin().$add(InsertElt);
        if (NumToInsert == 0) {
            return I;
        }
        if (this.end().$sub((abstract_iterator)I) >= NumToInsert) {
            double.ptr OldEnd = this.end();
            this.append_T((double.iterator<?>)((double.iterator)this.end().$sub(NumToInsert)), (double.iterator<?>)this.end());
            std.copy_backward((double.iterator)I, (double.iterator)((double.iterator)OldEnd.$sub(NumToInsert)), (double.iterator)OldEnd);
            std.copy(From, To, (double.iterator)I);
            return I;
        }
        double.ptr OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        std.copy((double.iterator)I, (double.iterator)OldEnd, (double.iterator)((double.ptr)this.end().$sub(NumOverwritten)));
        if (NumOverwritten > 0) {
            From = (double.iterator)Native.$Clone(From);
            double.ptr J = (double.ptr)Native.$Clone((NativeCloneable)I);
            for (NumOverwritten = OldEnd.$sub((abstract_iterator)I); NumOverwritten > 0; --NumOverwritten) {
                J.star$ref().$set(From.$star());
                J.$preInc();
                From.$preInc();
            }
        }
        std.copy((double.iterator)From, To, (double.iterator)OldEnd);
        return I;
    }

    public final void append_T(double.iterator<?> in_start, double.iterator<?> in_end) {
        assert (this.checkAlive());
        int NumInputs = std.distance(in_start, in_end);
        assert (NumInputs >= 0) : "Unexpected negative value " + NumInputs;
        if (NumInputs == 0) {
            return;
        }
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        double.iterator iter = (double.iterator)Native.$Clone(in_start);
        while (!iter.$eq(in_end)) {
            this.$set(this.end, iter.$star());
            ++this.end;
            iter.$preInc();
        }
    }

    public final <F> void append_T(type.iterator<?, F> in_start, type.iterator<?, F> in_end, NativeCallback.Converter<F, Double> converter) {
        assert (this.checkAlive());
        int NumInputs = std.distance(in_start, in_end);
        assert (NumInputs >= 0) : "Unexpected negative value " + NumInputs;
        if (NumInputs == 0) {
            return;
        }
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        type.iterator iter = (type.iterator)Native.$Clone(in_start);
        while (!iter.$eq(in_end)) {
            this.$set(this.end, (Double)converter.$call(iter.$star()));
            ++this.end;
            iter.$preInc();
        }
    }

    public final void append(double[] a) {
        assert (this.checkAlive());
        this.append(a, 0, a.length);
    }

    public final void append(double[] a, int fromIndex, int count) {
        assert (this.checkAlive());
        if (count > this.capacity() - this.size()) {
            this.grow(this.size() + count);
        }
        while (count-- > 0) {
            double el = a[fromIndex++];
            this.$set(this.end, el);
            ++this.end;
        }
    }

    public final void append(int NumInputs, double Elt) {
        assert (this.checkAlive());
        assert (NumInputs >= 0) : "can not be negative " + NumInputs;
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        for (int i = 0; i < NumInputs; ++i) {
            this.$set(this.end, Elt);
            ++this.end;
        }
    }

    public final void append_size_type$T$value_T$C$R(int NumInputs, double Elt) {
        this.append(NumInputs, Elt);
    }

    public final void append_size_type$T_T$C$R(int NumInputs, double Elt) {
        this.append(NumInputs, Elt);
    }

    public final boolean $eq(SmallVectorImplDouble RHS) {
        assert (this.checkAlive());
        assert (RHS.checkAlive());
        int size = this.size();
        if (size != RHS.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (!Native.$noteq((Object)this.array[i], (Object)RHS.array[i])) continue;
            return false;
        }
        return true;
    }

    public final boolean $noteq(SmallVectorImplDouble RHS) {
        return !this.$eq(RHS);
    }

    public final boolean $less(Object obj) {
        assert (this.checkAlive());
        assert (((SmallVectorImplDouble)obj).checkAlive());
        return std.lexicographical_compare((Object)this.begin(), (Object)this.end(), (Object)((SmallVectorImplDouble)obj).begin(), (Object)((SmallVectorImplDouble)obj).end());
    }

    public final boolean $lesseq(Object obj) {
        assert (this.checkAlive());
        assert (((SmallVectorImplDouble)obj).checkAlive());
        return this.$less(obj) || this.$eq((SmallVectorImplDouble)obj);
    }

    public final double.ref ref$at(int idx) {
        assert (this.checkAlive());
        return NativePointer.create_double$ref((double[])this.array, (int)idx);
    }

    public final double $at(int idx) {
        assert (this.checkAlive());
        return this.array[idx];
    }

    public final double $at$Const(int idx) {
        assert (this.checkAlive());
        return this.array[idx];
    }

    public final double $set(int idx, double value) {
        assert (this.checkAlive());
        this.array[idx] = value;
        return value;
    }

    protected final double $set$move(int idx, double value) {
        assert (this.checkAlive());
        this.array[idx] = value;
        return value;
    }

    public final boolean empty() {
        assert (this.checkAlive());
        return this.size() == 0;
    }

    public final void $destroy() {
        assert (this.checkAlive());
        this.setEnd(0);
        this.set$destroyed();
    }

    public final void push_back(double val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        this.$set(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public final void push_back_T$C$R(double val) {
        assert (this.checkAlive());
        this.push_back(val);
    }

    public final void push_back_T$RR(double val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        this.$set$move(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public final void emplace_back(double val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        int index = this.size();
        this.setEnd(index + 1);
        this.array[index] = val;
    }

    public final void emplace_back() {
        assert (this.checkAlive());
        this.push_back(this.defaultValue);
    }

    public final void pop_back() {
        assert (this.checkAlive());
        this.destroy_range(this.size() - 1, this.size());
        this.setEnd(this.size() - 1);
    }

    public final double pop_back_val() {
        assert (this.checkAlive());
        double val = this.back();
        this.setEnd(this.end - 1);
        return val;
    }

    public final double.ptr begin() {
        assert (this.checkAlive());
        return NativePointer.create_double$ptr((double[])this.array);
    }

    public final double.ptr begin$Const() {
        assert (this.checkAlive());
        return NativePointer.create_double$ptr((double[])this.array);
    }

    public final double.ptr end() {
        assert (this.checkAlive());
        return NativePointer.create_double$ptr((double[])this.array, (int)this.end);
    }

    public final double.ptr end$Const() {
        assert (this.checkAlive());
        return NativePointer.create_double$ptr((double[])this.array, (int)this.end);
    }

    public final std.reverse_iteratorDouble rbegin() {
        assert (this.checkAlive());
        return new std.reverse_iteratorDouble((double.iterator)NativePointer.create_double$ptr((double[])this.array, (int)this.end));
    }

    public final std.reverse_iteratorDouble rbegin$Const() {
        assert (this.checkAlive());
        return new std.reverse_iteratorDouble((double.iterator)NativePointer.create_double$ptr((double[])this.array, (int)this.end));
    }

    public final std.reverse_iteratorDouble rend() {
        assert (this.checkAlive());
        return new std.reverse_iteratorDouble((double.iterator)NativePointer.create_double$ptr((double[])this.array));
    }

    public final std.reverse_iteratorDouble rend$Const() {
        assert (this.checkAlive());
        return new std.reverse_iteratorDouble((double.iterator)NativePointer.create_double$ptr((double[])this.array));
    }

    public final double.ptr data() {
        assert (this.checkAlive());
        return NativePointer.create_double$ptr((double[])this.array);
    }

    public final double.ptr data$Const() {
        assert (this.checkAlive());
        return NativePointer.create_double$ptr((double[])this.array);
    }

    public final double front() {
        assert (this.checkAlive());
        return this.array[0];
    }

    public final double front$Const() {
        assert (this.checkAlive());
        return this.array[0];
    }

    public final double back() {
        assert (this.checkAlive());
        return this.array[this.end - 1];
    }

    public final double back$Const() {
        assert (this.checkAlive());
        return this.array[this.end - 1];
    }

    public final double.ref ref$front() {
        assert (this.checkAlive());
        return new double.ref(){
            private final int index = 0;

            public double $deref() {
                assert (SmallVectorImplDouble.this.checkAlive());
                return SmallVectorImplDouble.this.array[0];
            }

            public double $set(double value) {
                assert (SmallVectorImplDouble.this.checkAlive());
                ((SmallVectorImplDouble)SmallVectorImplDouble.this).array[0] = value;
                return value;
            }

            public double.ptr deref$ptr() {
                assert (SmallVectorImplDouble.this.checkAlive());
                return (double.ptr)SmallVectorImplDouble.this.data().$add(0);
            }
        };
    }

    public final double.ref ref$back() {
        assert (this.checkAlive());
        return new double.ref(){
            private final int index;
            {
                this.index = SmallVectorImplDouble.this.end - 1;
            }

            public double $deref() {
                assert (SmallVectorImplDouble.this.checkAlive());
                return SmallVectorImplDouble.this.array[this.index];
            }

            public double $set(double value) {
                assert (SmallVectorImplDouble.this.checkAlive());
                ((SmallVectorImplDouble)SmallVectorImplDouble.this).array[this.index] = value;
                return value;
            }

            public double.ptr deref$ptr() {
                assert (SmallVectorImplDouble.this.checkAlive());
                return (double.ptr)SmallVectorImplDouble.this.data().$add(this.index);
            }
        };
    }

    public final int size() {
        assert (this.checkAlive());
        return this.end;
    }

    public final int max_size() {
        assert (this.checkAlive());
        return Integer.MAX_VALUE;
    }

    public final int capacity() {
        assert (this.checkAlive());
        return this.array.length;
    }

    public final int $sizeof() {
        assert (this.checkAlive());
        return this.capacity_in_bytes();
    }

    public final int capacity_in_bytes() {
        assert (this.checkAlive());
        int oneElemSize = NativeType.sizeof((double)this.defaultValue);
        for (double elem : this.array) {
            if (elem == this.defaultValue) continue;
            oneElemSize = NativeType.sizeof((double)elem);
            break;
        }
        return this.array.length * oneElemSize;
    }

    public final double.ptr ptr$at(int idx) {
        assert (this.checkAlive());
        return NativePointer.create_double$ptr((double[])this.array, (int)idx);
    }

    public final void set_size(int N) {
        assert (this.checkAlive());
        assert (N >= 0) : "can not be negative " + N;
        assert (N <= this.capacity());
        this.setEnd(N);
    }

    private void destroy_range(int from, int to) {
    }

    private void destroy_range(double.ptr _from, double.ptr _to) {
        this.destroy_range(_from.$sub((abstract_iterator)this.begin()), _to.$sub((abstract_iterator)this.begin()));
    }

    private void grow(int capacity) {
        double[] oldArray = this.array;
        this.array = NativePointer.new$double((int)capacity);
        NativePointer.copy$Object((double[])oldArray, (int)0, (double[])this.array, (int)0, (int)oldArray.length);
    }

    private void grow() {
        int capacity = this.capacity();
        this.grow(capacity == 0 ? 1 : (capacity < 1024 ? capacity * 2 : capacity + 1024));
    }

    private void setEnd(int to) {
        this.end = to;
    }

    private void setEnd(double.ptr to) {
        this.setEnd(to.$sub((abstract_iterator)this.begin()));
    }

    @Override
    public Iterator<Double> iterator() {
        assert (this.checkAlive());
        return new JavaIteratorDouble((double.iterator)this.begin(), (double.iterator)this.end());
    }

    public boolean isDataPointerLike() {
        return false;
    }

    public String toString() {
        String extra;
        String string2 = extra = super.is$destroyed() ? "DESTROYED" : "";
        if (this.end == 0) {
            return extra + "<EMPTY>";
        }
        StringBuilder out = new StringBuilder("\nSmallVectorImplDouble{\n");
        out.append(extra).append("end = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            double element = this.array[i];
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(element).append('\n');
        }
        out.append("}SmallVectorImplDouble}\n");
        return out.toString();
    }

    protected final boolean checkAlive() {
        return this.check$Alive();
    }
}

