/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeSwappable;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.JavaIteratorBool;
import org.clank.support.aliases.NativeContainerBool;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.type;

public abstract class SmallVectorImplBool
extends NativeTrace.CreateDestroy$Tracker
implements Native.assignable<SmallVectorImplBool>,
Native.NativeComparable<SmallVectorImplBool>,
Native.ComparableLower,
NativeType.SizeofCapable,
NativeSwappable,
Iterable<Boolean>,
Native.NativeIterable<bool.ptr>,
Native.NativeReverseIterable<std.reverse_iteratorBool>,
NativeContainerBool {
    protected final boolean defaultValue;
    private boolean[] array;
    private static final boolean[] EMPTY = NativePointer.new$bool((int)0);
    private int end;

    public final boolean[] $array() {
        assert (this.checkAlive());
        return this.array;
    }

    protected SmallVectorImplBool(int capacity, boolean defaultValue) {
        this.array = capacity == 0 ? EMPTY : NativePointer.new$bool((int)capacity);
        this.end = 0;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplBool(int capacity, int initialSize, boolean defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImplBool(JavaDifferentiators.JD$UInt_T$C$R _dparam, int capacity, int initialSize, boolean defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImplBool(JavaDifferentiators.JD$UInt_T$C$R _dparam, int capacity, int initialSize, boolean value, boolean defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, value);
    }

    protected SmallVectorImplBool(boolean[] array2, boolean defaultValue) {
        this.array = array2;
        this.end = array2 == null ? 0 : array2.length;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplBool(int capacity, bool.iterator<?> iter, int length, boolean defaultValue) {
        this(capacity, iter, (bool.iterator)iter.$add(length), defaultValue);
    }

    protected SmallVectorImplBool(int capacity, bool.iterator<?> begin, bool.iterator<?> end, boolean defaultValue) {
        this(capacity, defaultValue);
        this.append_T(begin, end);
    }

    protected SmallVectorImplBool(SmallVectorImplBool other) {
        assert (other.checkAlive());
        this.defaultValue = other.defaultValue;
        int capacity = other.size();
        this.array = capacity == 0 ? EMPTY : NativePointer.new$bool((int)capacity);
        this.append_T((bool.iterator<?>)other.begin(), (bool.iterator<?>)other.end());
    }

    protected SmallVectorImplBool(JavaDifferentiators.JD.Move _dparam, SmallVectorImplBool other) {
        assert (other.checkAlive());
        this.defaultValue = other.defaultValue;
        this.array = other.array;
        this.end = other.end;
        other.array = EMPTY;
        other.end = 0;
    }

    public final SmallVectorImplBool $assign(SmallVectorImplBool other) {
        assert (this.checkAlive());
        assert (other.checkAlive());
        if (this == other) {
            return this;
        }
        this.clear();
        this.array = EMPTY;
        this.append_T((bool.iterator<?>)other.begin(), (bool.iterator<?>)other.end());
        return this;
    }

    public final SmallVectorImplBool $assignMove(SmallVectorImplBool other) {
        assert (this.checkAlive());
        assert (other.checkAlive());
        assert (this != other) : "moving self";
        this.array = other.array;
        this.end = other.end;
        other.array = EMPTY;
        other.end = 0;
        return this;
    }

    public final void clear() {
        assert (this.checkAlive());
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    public final boolean resize(int newSize) {
        assert (this.checkAlive());
        return this.resize(newSize, this.defaultValue);
    }

    public final boolean resize(int newSize, boolean defaultValue) {
        assert (this.checkAlive());
        assert (newSize >= 0) : "can not be negative " + newSize;
        boolean grown = false;
        if (newSize < this.end) {
            this.destroy_range(newSize, this.end);
        } else if (newSize > this.end) {
            if (this.capacity() < newSize) {
                this.grow(newSize);
                grown = true;
            }
            for (int i = this.end; i < newSize; ++i) {
                this.array[i] = Native.$tryClone((boolean)defaultValue);
            }
        }
        this.setEnd(newSize);
        return grown;
    }

    public final void reserve(int N) {
        assert (this.checkAlive());
        assert (N >= 0) : "can not be negative " + N;
        if (this.capacity() < N) {
            this.grow(N);
        }
    }

    public final void assign(int NumElts, boolean Elt) {
        assert (this.checkAlive());
        assert (NumElts >= 0) : "can not be negative " + NumElts;
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.$set(i, Elt);
        }
    }

    public final void assign$T(bool.iterator<?> __first, bool.iterator<?> __last) {
        assert (this.checkAlive());
        this.clear();
        this.append_T(__first, __last);
    }

    public final void swap(NativeSwappable _RHS) {
        assert (this.checkAlive());
        SmallVectorImplBool RHS = (SmallVectorImplBool)_RHS;
        boolean[] arrTmp = this.array;
        this.array = RHS.array;
        RHS.array = arrTmp;
        int endTmp = this.end;
        this.end = RHS.end;
        RHS.end = endTmp;
    }

    public final int find(boolean elem) {
        assert (this.checkAlive());
        return this.find(elem, 0);
    }

    public final int find(boolean elem, int from) {
        assert (this.checkAlive());
        boolean isDataPointerLike = this.isDataPointerLike();
        for (int i = from; i < this.end; ++i) {
            if (!Native.$eq((boolean)this.array[i], (boolean)elem, (boolean)isDataPointerLike)) continue;
            return i;
        }
        return std.string.npos;
    }

    public final boolean contains(boolean elem) {
        assert (this.checkAlive());
        return this.find(elem) != std.string.npos;
    }

    public final boolean erase(boolean elem) {
        assert (this.checkAlive());
        int index = this.find(elem);
        if (index == std.string.npos) {
            return false;
        }
        this.destroy_range(index, index + 1);
        --this.end;
        if (index < this.end) {
            NativePointer.copy$Object((boolean[])this.array, (int)(index + 1), (boolean[])this.array, (int)index, (int)(this.end - index));
        }
        this.$set(this.end, this.defaultValue);
        return true;
    }

    public final bool.ptr erase(bool.ptr I) {
        assert (this.checkAlive());
        assert (I.$greatereq((Object)this.begin())) : "Iterator to erase is out of bounds.";
        assert (I.$less((Object)this.end())) : "Erasing at past-the-end iterator.";
        bool.ptr N = I;
        std.copy((bool.iterator)((bool.iterator)I.$add(1)), (bool.iterator)this.end(), (bool.iterator)I);
        this.pop_back();
        return N;
    }

    public final bool.ptr erase(bool.ptr S2, bool.ptr E) {
        assert (this.checkAlive());
        assert (S2.$greatereq((Object)this.begin())) : "Range to erase is out of bounds.";
        assert (S2.$lesseq((Object)E)) : "Trying to erase invalid range.";
        assert (E.$lesseq((Object)this.end())) : "Trying to erase past the end.";
        bool.ptr N = S2;
        bool.ptr I = (bool.ptr)std.copy((bool.iterator)E, (bool.iterator)this.end(), (bool.iterator)S2);
        this.destroy_range(I, this.end());
        this.setEnd(I);
        return N;
    }

    public bool.ptr insert_iterator$T$value_T$RR(bool.ptr I, boolean Elt) {
        assert (this.checkAlive());
        if (I.$eq((Object)this.end())) {
            this.push_back_T$RR(Elt);
            return (bool.ptr)this.end().$sub(1);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub((abstract_iterator)this.begin());
            this.grow();
            I = (bool.ptr)this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward((bool.iterator)I, (bool.iterator)((bool.iterator)this.end().$sub(1)), (bool.iterator)this.end());
        I.$set(((Boolean)Native.$tryMove((Object)I.$star(), (Object)Elt, (boolean)this.isDataPointerLike())).booleanValue());
        return I;
    }

    public bool.ptr insert_iterator$T_T$C$R(bool.ptr I, boolean Elt) {
        return this.insert(I, Elt);
    }

    public bool.ptr insert_iterator$T$value_T$C$R(bool.ptr I, boolean Elt) {
        return this.insert(I, Elt);
    }

    public final bool.ptr insert(bool.ptr I, boolean Elt) {
        assert (this.checkAlive());
        if (I.$eq((Object)this.end())) {
            this.push_back(Elt);
            return (bool.ptr)this.end().$sub(1);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub((abstract_iterator)this.begin());
            this.grow();
            I = (bool.ptr)this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward((bool.iterator)I, (bool.iterator)((bool.iterator)this.end().$sub(1)), (bool.iterator)this.end());
        I.$set(((Boolean)Native.$tryAssign(null, (Object)Elt, (boolean)this.isDataPointerLike())).booleanValue());
        return I;
    }

    public final bool.ptr insert(bool.ptr I, int NumToInsert, boolean Elt) {
        assert (this.checkAlive());
        assert (NumToInsert >= 0) : "can not be negative " + NumToInsert;
        int InsertElt = I.$sub((abstract_iterator)this.begin());
        if (I.$eq((Object)this.end())) {
            this.append(NumToInsert, Elt);
            return (bool.ptr)this.begin().$add(InsertElt);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        this.reserve(this.size() + NumToInsert);
        I = (bool.ptr)this.begin().$add(InsertElt);
        if (this.end().$sub((abstract_iterator)I) >= NumToInsert) {
            bool.ptr OldEnd = this.end();
            this.append_T((bool.iterator<?>)((bool.iterator)this.end().$sub(NumToInsert)), (bool.iterator<?>)this.end());
            std.copy_backward((bool.iterator)I, (bool.iterator)((bool.iterator)OldEnd.$sub(NumToInsert)), (bool.iterator)OldEnd);
            std.fill_n((bool.iterator)I, (int)NumToInsert, (boolean)Elt);
            return I;
        }
        bool.ptr OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        int NumOverwritten = OldEnd.$sub((abstract_iterator)I);
        std.copy((bool.iterator)I, (bool.iterator)OldEnd, (bool.iterator)((bool.ptr)this.end().$sub(NumOverwritten)));
        std.fill_n((bool.iterator)I, (int)NumOverwritten, (boolean)Elt);
        std.fill_n((bool.iterator)OldEnd, (int)(NumToInsert - NumOverwritten), (boolean)Elt);
        return I;
    }

    public final bool.ptr insert$T(bool.ptr I, bool.iterator<?> From, bool.iterator<?> To) {
        assert (this.checkAlive());
        return this.insert(I, From, To);
    }

    public final bool.ptr insert$T$value_T(bool.ptr I, bool.iterator<?> From, bool.iterator<?> To) {
        assert (this.checkAlive());
        return this.insert(I, From, To);
    }

    public final bool.ptr insert_iterator$T_T(bool.ptr I, bool.iterator<?> From, bool.iterator<?> To) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public final bool.ptr insert(bool.ptr I, bool.iterator<?> From, bool.iterator<?> To) {
        assert (this.checkAlive());
        return this.insert_iterator$T$value_T(I, From, To);
    }

    public final bool.ptr insert_iterator$T$value_T(bool.ptr I, bool.iterator<?> From, bool.iterator<?> To) {
        int NumOverwritten;
        assert (this.checkAlive());
        int InsertElt = I.$sub((abstract_iterator)this.begin());
        if (I.$eq((Object)this.end())) {
            this.append_T(From, To);
            return (bool.ptr)this.begin().$add(InsertElt);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        int NumToInsert = std.distance(From, To);
        assert (NumToInsert >= 0) : "Unexpected negative value " + NumToInsert;
        this.reserve(this.size() + NumToInsert);
        I = (bool.ptr)this.begin().$add(InsertElt);
        if (NumToInsert == 0) {
            return I;
        }
        if (this.end().$sub((abstract_iterator)I) >= NumToInsert) {
            bool.ptr OldEnd = this.end();
            this.append_T((bool.iterator<?>)((bool.iterator)this.end().$sub(NumToInsert)), (bool.iterator<?>)this.end());
            std.copy_backward((bool.iterator)I, (bool.iterator)((bool.iterator)OldEnd.$sub(NumToInsert)), (bool.iterator)OldEnd);
            std.copy(From, To, (bool.iterator)I);
            return I;
        }
        bool.ptr OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        std.copy((bool.iterator)I, (bool.iterator)OldEnd, (bool.iterator)((bool.ptr)this.end().$sub(NumOverwritten)));
        if (NumOverwritten > 0) {
            From = (bool.iterator)Native.$Clone(From);
            bool.ptr J = (bool.ptr)Native.$Clone((NativeCloneable)I);
            for (NumOverwritten = OldEnd.$sub((abstract_iterator)I); NumOverwritten > 0; --NumOverwritten) {
                J.star$ref().$set(From.$star());
                J.$preInc();
                From.$preInc();
            }
        }
        std.copy((bool.iterator)From, To, (bool.iterator)OldEnd);
        return I;
    }

    public final void append_T(bool.iterator<?> in_start, bool.iterator<?> in_end) {
        assert (this.checkAlive());
        int NumInputs = std.distance(in_start, in_end);
        assert (NumInputs >= 0) : "Unexpected negative value " + NumInputs;
        if (NumInputs == 0) {
            return;
        }
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        bool.iterator iter = (bool.iterator)Native.$Clone(in_start);
        while (!iter.$eq(in_end)) {
            this.$set(this.end, iter.$star());
            ++this.end;
            iter.$preInc();
        }
    }

    public final <F> void append_T(type.iterator<?, F> in_start, type.iterator<?, F> in_end, NativeCallback.Converter<F, Boolean> converter) {
        assert (this.checkAlive());
        int NumInputs = std.distance(in_start, in_end);
        assert (NumInputs >= 0) : "Unexpected negative value " + NumInputs;
        if (NumInputs == 0) {
            return;
        }
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        type.iterator iter = (type.iterator)Native.$Clone(in_start);
        while (!iter.$eq(in_end)) {
            this.$set(this.end, (Boolean)converter.$call(iter.$star()));
            ++this.end;
            iter.$preInc();
        }
    }

    public final void append(boolean[] a) {
        assert (this.checkAlive());
        this.append(a, 0, a.length);
    }

    public final void append(boolean[] a, int fromIndex, int count) {
        assert (this.checkAlive());
        if (count > this.capacity() - this.size()) {
            this.grow(this.size() + count);
        }
        while (count-- > 0) {
            boolean el = a[fromIndex++];
            this.$set(this.end, el);
            ++this.end;
        }
    }

    public final void append(int NumInputs, boolean Elt) {
        assert (this.checkAlive());
        assert (NumInputs >= 0) : "can not be negative " + NumInputs;
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        for (int i = 0; i < NumInputs; ++i) {
            this.$set(this.end, Elt);
            ++this.end;
        }
    }

    public final void append_size_type$T$value_T$C$R(int NumInputs, boolean Elt) {
        this.append(NumInputs, Elt);
    }

    public final void append_size_type$T_T$C$R(int NumInputs, boolean Elt) {
        this.append(NumInputs, Elt);
    }

    public final boolean $eq(SmallVectorImplBool RHS) {
        assert (this.checkAlive());
        assert (RHS.checkAlive());
        int size = this.size();
        if (size != RHS.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (!Native.$noteq((boolean)this.array[i], (boolean)RHS.array[i])) continue;
            return false;
        }
        return true;
    }

    public final boolean $noteq(SmallVectorImplBool RHS) {
        return !this.$eq(RHS);
    }

    public final boolean $less(Object obj) {
        assert (this.checkAlive());
        assert (((SmallVectorImplBool)obj).checkAlive());
        return std.lexicographical_compare((Object)this.begin(), (Object)this.end(), (Object)((SmallVectorImplBool)obj).begin(), (Object)((SmallVectorImplBool)obj).end());
    }

    public final boolean $lesseq(Object obj) {
        assert (this.checkAlive());
        assert (((SmallVectorImplBool)obj).checkAlive());
        return this.$less(obj) || this.$eq((SmallVectorImplBool)obj);
    }

    public final bool.ref ref$at(int idx) {
        assert (this.checkAlive());
        return NativePointer.create_bool$ref((boolean[])this.array, (int)idx);
    }

    public final boolean $at(int idx) {
        assert (this.checkAlive());
        return this.array[idx];
    }

    public final boolean $at$Const(int idx) {
        assert (this.checkAlive());
        return this.array[idx];
    }

    public final boolean $set(int idx, boolean value) {
        assert (this.checkAlive());
        this.array[idx] = value;
        return value;
    }

    protected final boolean $set$move(int idx, boolean value) {
        assert (this.checkAlive());
        this.array[idx] = value;
        return value;
    }

    public final boolean empty() {
        assert (this.checkAlive());
        return this.size() == 0;
    }

    public final void $destroy() {
        assert (this.checkAlive());
        this.setEnd(0);
        this.set$destroyed();
    }

    public final void push_back(boolean val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        this.$set(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public final void push_back_T$C$R(boolean val) {
        assert (this.checkAlive());
        this.push_back(val);
    }

    public final void push_back_T$RR(boolean val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        this.$set$move(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public final void emplace_back(boolean val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        int index = this.size();
        this.setEnd(index + 1);
        this.array[index] = val;
    }

    public final void emplace_back() {
        assert (this.checkAlive());
        this.push_back(this.defaultValue);
    }

    public final void pop_back() {
        assert (this.checkAlive());
        this.destroy_range(this.size() - 1, this.size());
        this.setEnd(this.size() - 1);
    }

    public final boolean pop_back_val() {
        assert (this.checkAlive());
        boolean val = this.back();
        this.setEnd(this.end - 1);
        return val;
    }

    public final bool.ptr begin() {
        assert (this.checkAlive());
        return NativePointer.create_bool$ptr((boolean[])this.array);
    }

    public final bool.ptr begin$Const() {
        assert (this.checkAlive());
        return NativePointer.create_bool$ptr((boolean[])this.array);
    }

    public final bool.ptr end() {
        assert (this.checkAlive());
        return NativePointer.create_bool$ptr((boolean[])this.array, (int)this.end);
    }

    public final bool.ptr end$Const() {
        assert (this.checkAlive());
        return NativePointer.create_bool$ptr((boolean[])this.array, (int)this.end);
    }

    public final std.reverse_iteratorBool rbegin() {
        assert (this.checkAlive());
        return new std.reverse_iteratorBool((bool.iterator)NativePointer.create_bool$ptr((boolean[])this.array, (int)this.end));
    }

    public final std.reverse_iteratorBool rbegin$Const() {
        assert (this.checkAlive());
        return new std.reverse_iteratorBool((bool.iterator)NativePointer.create_bool$ptr((boolean[])this.array, (int)this.end));
    }

    public final std.reverse_iteratorBool rend() {
        assert (this.checkAlive());
        return new std.reverse_iteratorBool((bool.iterator)NativePointer.create_bool$ptr((boolean[])this.array));
    }

    public final std.reverse_iteratorBool rend$Const() {
        assert (this.checkAlive());
        return new std.reverse_iteratorBool((bool.iterator)NativePointer.create_bool$ptr((boolean[])this.array));
    }

    public final bool.ptr data() {
        assert (this.checkAlive());
        return NativePointer.create_bool$ptr((boolean[])this.array);
    }

    public final bool.ptr data$Const() {
        assert (this.checkAlive());
        return NativePointer.create_bool$ptr((boolean[])this.array);
    }

    public final boolean front() {
        assert (this.checkAlive());
        return this.array[0];
    }

    public final boolean front$Const() {
        assert (this.checkAlive());
        return this.array[0];
    }

    public final boolean back() {
        assert (this.checkAlive());
        return this.array[this.end - 1];
    }

    public final boolean back$Const() {
        assert (this.checkAlive());
        return this.array[this.end - 1];
    }

    public final bool.ref ref$front() {
        assert (this.checkAlive());
        return new bool.ref(){
            private final int index = 0;

            public boolean $deref() {
                assert (SmallVectorImplBool.this.checkAlive());
                return SmallVectorImplBool.this.array[0];
            }

            public boolean $set(boolean value) {
                assert (SmallVectorImplBool.this.checkAlive());
                ((SmallVectorImplBool)SmallVectorImplBool.this).array[0] = value;
                return value;
            }

            public bool.ptr deref$ptr() {
                assert (SmallVectorImplBool.this.checkAlive());
                return (bool.ptr)SmallVectorImplBool.this.data().$add(0);
            }
        };
    }

    public final bool.ref ref$back() {
        assert (this.checkAlive());
        return new bool.ref(){
            private final int index;
            {
                this.index = SmallVectorImplBool.this.end - 1;
            }

            public boolean $deref() {
                assert (SmallVectorImplBool.this.checkAlive());
                return SmallVectorImplBool.this.array[this.index];
            }

            public boolean $set(boolean value) {
                assert (SmallVectorImplBool.this.checkAlive());
                ((SmallVectorImplBool)SmallVectorImplBool.this).array[this.index] = value;
                return value;
            }

            public bool.ptr deref$ptr() {
                assert (SmallVectorImplBool.this.checkAlive());
                return (bool.ptr)SmallVectorImplBool.this.data().$add(this.index);
            }
        };
    }

    public final int size() {
        assert (this.checkAlive());
        return this.end;
    }

    public final int max_size() {
        assert (this.checkAlive());
        return Integer.MAX_VALUE;
    }

    public final int capacity() {
        assert (this.checkAlive());
        return this.array.length;
    }

    public final int $sizeof() {
        assert (this.checkAlive());
        return this.capacity_in_bytes();
    }

    public final int capacity_in_bytes() {
        assert (this.checkAlive());
        int oneElemSize = NativeType.sizeof((boolean)this.defaultValue);
        for (boolean elem : this.array) {
            if (elem == this.defaultValue) continue;
            oneElemSize = NativeType.sizeof((boolean)elem);
            break;
        }
        return this.array.length * oneElemSize;
    }

    public final bool.ptr ptr$at(int idx) {
        assert (this.checkAlive());
        return NativePointer.create_bool$ptr((boolean[])this.array, (int)idx);
    }

    public final void set_size(int N) {
        assert (this.checkAlive());
        assert (N >= 0) : "can not be negative " + N;
        assert (N <= this.capacity());
        this.setEnd(N);
    }

    private void destroy_range(int from, int to) {
    }

    private void destroy_range(bool.ptr _from, bool.ptr _to) {
        this.destroy_range(_from.$sub((abstract_iterator)this.begin()), _to.$sub((abstract_iterator)this.begin()));
    }

    private void grow(int capacity) {
        boolean[] oldArray = this.array;
        this.array = NativePointer.new$bool((int)capacity);
        NativePointer.copy$Object((boolean[])oldArray, (int)0, (boolean[])this.array, (int)0, (int)oldArray.length);
    }

    private void grow() {
        int capacity = this.capacity();
        this.grow(capacity == 0 ? 1 : (capacity < 1024 ? capacity * 2 : capacity + 1024));
    }

    private void setEnd(int to) {
        this.end = to;
    }

    private void setEnd(bool.ptr to) {
        this.setEnd(to.$sub((abstract_iterator)this.begin()));
    }

    @Override
    public Iterator<Boolean> iterator() {
        assert (this.checkAlive());
        return new JavaIteratorBool((bool.iterator)this.begin(), (bool.iterator)this.end());
    }

    public boolean isDataPointerLike() {
        return false;
    }

    public String toString() {
        String extra;
        String string2 = extra = super.is$destroyed() ? "DESTROYED" : "";
        if (this.end == 0) {
            return extra + "<EMPTY>";
        }
        StringBuilder out = new StringBuilder("\nSmallVectorImplBool{\n");
        out.append(extra).append("end = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            boolean element = this.array[i];
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(element).append('\n');
        }
        out.append("}SmallVectorImplBool}\n");
        return out.toString();
    }

    protected final boolean checkAlive() {
        return this.check$Alive();
    }
}

