/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.JavaIterator;
import org.llvm.adt.FoldingSetNodeID;
import org.llvm.adt.FoldingSetTrait;
import org.llvm.adt.aliases.ImmutableSetPtr;
import org.llvm.adt.aliases.ImutAVLFactoryPtrBoolPtr;
import org.llvm.adt.aliases.ImutAVLTreePtrBoolPtr;
import org.llvm.adt.aliases.ImutAVLValueIteratorPtrBoolPtr;

public class ImmutableSetRefPtr<KeyT>
extends NativeTrace.CreateDestroy$Tracker
implements Destructors.ClassWithDestructor,
Native.NativeComparable<ImmutableSetRefPtr>,
Iterable<KeyT>,
FoldingSetTrait.Profilable {
    private ImutAVLTreePtrBoolPtr<KeyT, KeyT> Root;
    private ImutAVLFactoryPtrBoolPtr<KeyT, KeyT> Factory;

    public ImmutableSetRefPtr(ImutAVLTreePtrBoolPtr<KeyT, KeyT> R2, ImutAVLFactoryPtrBoolPtr<KeyT, KeyT> F) {
        this.Root = R2;
        this.Factory = F;
        if (this.Root != null) {
            this.Root.retain();
        }
    }

    public ImmutableSetRefPtr(ImmutableSetRefPtr<KeyT> X2) {
        assert (X2.checkAlive());
        this.Root = X2.Root;
        this.Factory = X2.Factory;
        if (this.Root != null) {
            this.Root.retain();
        }
    }

    public ImmutableSetRefPtr<KeyT> $assign(ImmutableSetRefPtr<KeyT> X2) {
        assert (X2.checkAlive());
        assert (this.checkAlive());
        if (this.Root != X2.Root) {
            if (X2.Root != null) {
                X2.Root.retain();
            }
            if (this.Root != null) {
                this.Root.release();
            }
            this.Root = X2.Root;
            this.Factory = X2.Factory;
        }
        return this;
    }

    public void $destroy() {
        assert (this.checkAlive());
        if (this.Root != null) {
            this.Root.release();
        }
        this.set$destroyed();
    }

    public static <KeyT> ImmutableSetRefPtr<KeyT> getEmptySet(ImutAVLFactoryPtrBoolPtr<KeyT, KeyT> F) {
        return new ImmutableSetRefPtr<KeyT>(null, F);
    }

    public ImmutableSetRefPtr<KeyT> add(KeyT V) {
        assert (this.checkAlive());
        return new ImmutableSetRefPtr<KeyT>(this.Factory.add(this.Root, V), this.Factory);
    }

    public ImmutableSetRefPtr<KeyT> remove(KeyT V) {
        assert (this.checkAlive());
        return new ImmutableSetRefPtr<KeyT>(this.Factory.remove(this.Root, V), this.Factory);
    }

    public boolean contains(KeyT V) {
        assert (this.checkAlive());
        return this.Root != null ? this.Root.contains(V) : false;
    }

    public ImmutableSetPtr<KeyT> asImmutableSet() {
        assert (this.checkAlive());
        return this.asImmutableSet(true);
    }

    public ImmutableSetPtr<KeyT> asImmutableSet(boolean canonicalize) {
        assert (this.checkAlive());
        return new ImmutableSetPtr<KeyT>(canonicalize ? this.Factory.getCanonicalTree(this.Root) : this.Root);
    }

    public ImutAVLTreePtrBoolPtr<KeyT, KeyT> getRootWithoutRetain() {
        assert (this.checkAlive());
        return this.Root;
    }

    public boolean $eq(ImmutableSetRefPtr<KeyT> RHS) {
        assert (RHS.checkAlive());
        assert (this.checkAlive());
        return this.Root != null && RHS.Root != null ? this.Root.isEqual(RHS.Root) : this.Root == RHS.Root;
    }

    public boolean $noteq(ImmutableSetRefPtr<KeyT> RHS) {
        assert (RHS.checkAlive());
        assert (this.checkAlive());
        return !this.$eq(RHS);
    }

    public boolean isEmpty() {
        assert (this.checkAlive());
        return this.Root == null;
    }

    public boolean isSingleton() {
        assert (this.checkAlive());
        return Native.$eq((int)this.getHeight(), (int)1);
    }

    public ImutAVLValueIteratorPtrBoolPtr<KeyT> begin() {
        assert (this.checkAlive());
        return new ImutAVLValueIteratorPtrBoolPtr<KeyT>(this.Root);
    }

    public ImutAVLValueIteratorPtrBoolPtr<KeyT> end() {
        assert (this.checkAlive());
        return new ImutAVLValueIteratorPtrBoolPtr();
    }

    public int getHeight() {
        assert (this.checkAlive());
        return this.Root != null ? this.Root.getHeight() : 0;
    }

    public static <KeyT> void Profile(FoldingSetNodeID ID, ImmutableSetRefPtr<KeyT> S2) {
        assert (S2.checkAlive());
        ID.AddPointer(S2.Root);
    }

    @Override
    public void Profile(FoldingSetNodeID ID) {
        assert (this.checkAlive());
        ImmutableSetRefPtr.Profile(ID, this);
    }

    public void validateTree() {
        assert (this.checkAlive());
        if (this.Root != null) {
            this.Root.validateTree();
        }
    }

    @Override
    public Iterator<KeyT> iterator() {
        assert (this.checkAlive());
        return new JavaIterator(this.begin(), this.end());
    }

    public String toString() {
        return (super.is$destroyed() ? "DESTROYED " : "") + "Root=" + this.Root + ", Factory=" + this.Factory;
    }

    final boolean checkAlive() {
        return this.check$Alive();
    }
}

