/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.JavaIterator;
import org.llvm.adt.FoldingSetNodeID;
import org.llvm.adt.FoldingSetTrait;
import org.llvm.adt.aliases.ImmutableSet;
import org.llvm.adt.aliases.ImutAVLFactoryTypeBoolType;
import org.llvm.adt.aliases.ImutAVLTreeTypeBoolType;
import org.llvm.adt.aliases.ImutAVLValueIteratorTypeBoolType;

public class ImmutableSetRef<KeyT>
extends NativeTrace.CreateDestroy$Tracker
implements Destructors.ClassWithDestructor,
Native.NativeComparable<ImmutableSetRef>,
Iterable<KeyT>,
FoldingSetTrait.Profilable {
    private ImutAVLTreeTypeBoolType<KeyT, KeyT> Root;
    private ImutAVLFactoryTypeBoolType<KeyT, KeyT> Factory;

    public ImmutableSetRef(ImutAVLTreeTypeBoolType<KeyT, KeyT> R2, ImutAVLFactoryTypeBoolType<KeyT, KeyT> F) {
        this.Root = R2;
        this.Factory = F;
        if (this.Root != null) {
            this.Root.retain();
        }
    }

    public ImmutableSetRef(ImmutableSetRef<KeyT> X2) {
        assert (X2.checkAlive());
        this.Root = X2.Root;
        this.Factory = X2.Factory;
        if (this.Root != null) {
            this.Root.retain();
        }
    }

    public ImmutableSetRef<KeyT> $assign(ImmutableSetRef<KeyT> X2) {
        assert (X2.checkAlive());
        assert (this.checkAlive());
        if (this.Root != X2.Root) {
            if (X2.Root != null) {
                X2.Root.retain();
            }
            if (this.Root != null) {
                this.Root.release();
            }
            this.Root = X2.Root;
            this.Factory = X2.Factory;
        }
        return this;
    }

    public void $destroy() {
        assert (this.checkAlive());
        if (this.Root != null) {
            this.Root.release();
        }
        this.set$destroyed();
    }

    public static <KeyT> ImmutableSetRef<KeyT> getEmptySet(ImutAVLFactoryTypeBoolType<KeyT, KeyT> F) {
        return new ImmutableSetRef<KeyT>(null, F);
    }

    public ImmutableSetRef<KeyT> add(KeyT V) {
        assert (this.checkAlive());
        return new ImmutableSetRef<KeyT>(this.Factory.add(this.Root, V), this.Factory);
    }

    public ImmutableSetRef<KeyT> remove(KeyT V) {
        assert (this.checkAlive());
        return new ImmutableSetRef<KeyT>(this.Factory.remove(this.Root, V), this.Factory);
    }

    public boolean contains(KeyT V) {
        assert (this.checkAlive());
        return this.Root != null ? this.Root.contains(V) : false;
    }

    public ImmutableSet<KeyT> asImmutableSet() {
        assert (this.checkAlive());
        return this.asImmutableSet(true);
    }

    public ImmutableSet<KeyT> asImmutableSet(boolean canonicalize) {
        assert (this.checkAlive());
        return new ImmutableSet<KeyT>(canonicalize ? this.Factory.getCanonicalTree(this.Root) : this.Root);
    }

    public ImutAVLTreeTypeBoolType<KeyT, KeyT> getRootWithoutRetain() {
        assert (this.checkAlive());
        return this.Root;
    }

    public boolean $eq(ImmutableSetRef<KeyT> RHS) {
        assert (RHS.checkAlive());
        assert (this.checkAlive());
        return this.Root != null && RHS.Root != null ? this.Root.isEqual(RHS.Root) : this.Root == RHS.Root;
    }

    public boolean $noteq(ImmutableSetRef<KeyT> RHS) {
        assert (RHS.checkAlive());
        assert (this.checkAlive());
        return !this.$eq(RHS);
    }

    public boolean isEmpty() {
        assert (this.checkAlive());
        return this.Root == null;
    }

    public boolean isSingleton() {
        assert (this.checkAlive());
        return Native.$eq((int)this.getHeight(), (int)1);
    }

    public ImutAVLValueIteratorTypeBoolType<KeyT> begin() {
        assert (this.checkAlive());
        return new ImutAVLValueIteratorTypeBoolType<KeyT>(this.Root);
    }

    public ImutAVLValueIteratorTypeBoolType<KeyT> end() {
        assert (this.checkAlive());
        return new ImutAVLValueIteratorTypeBoolType();
    }

    public int getHeight() {
        assert (this.checkAlive());
        return this.Root != null ? this.Root.getHeight() : 0;
    }

    public static <KeyT> void Profile(FoldingSetNodeID ID, ImmutableSetRef<KeyT> S2) {
        assert (S2.checkAlive());
        ID.AddPointer(S2.Root);
    }

    @Override
    public void Profile(FoldingSetNodeID ID) {
        assert (this.checkAlive());
        ImmutableSetRef.Profile(ID, this);
    }

    public void validateTree() {
        assert (this.checkAlive());
        if (this.Root != null) {
            this.Root.validateTree();
        }
    }

    @Override
    public Iterator<KeyT> iterator() {
        assert (this.checkAlive());
        return new JavaIterator(this.begin(), this.end());
    }

    public String toString() {
        return (super.is$destroyed() ? "DESTROYED " : "") + "Root=" + this.Root + ", Factory=" + this.Factory;
    }

    final boolean checkAlive() {
        return this.check$Alive();
    }
}

