/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeTrace;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.type;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.aliases.DenseMapIteratorTypeChar;
import org.llvm.adt.aliases.DenseMapTypeChar;

public class DenseSet<ValueT>
extends NativeTrace.CreateDestroy$Tracker
implements Iterable<ValueT>,
Destructors.ClassWithDestructor {
    private final DenseMapTypeChar<ValueT> TheMap;

    public DenseSet(DenseSet<ValueT> Other) {
        assert (Other.checkAlive());
        this.TheMap = new DenseMapTypeChar<ValueT>(Other.TheMap);
    }

    public DenseSet(JavaDifferentiators.JD.Move _dparm, DenseSet<ValueT> Other) {
        this.TheMap = new DenseMapTypeChar<ValueT>(JavaDifferentiators.JD.Move.INSTANCE, Other.TheMap);
    }

    public DenseSet(DenseMapInfo<ValueT> ValueInfo) {
        this(ValueInfo, 0);
    }

    public DenseSet(DenseMapInfo<ValueT> ValueInfo, int NumInitBuckets) {
        assert (NumInitBuckets >= 0) : "can not be negative " + NumInitBuckets;
        this.TheMap = new DenseMapTypeChar<ValueT>(ValueInfo, NumInitBuckets, 0);
    }

    public boolean empty() {
        assert (this.checkAlive());
        return this.TheMap.empty();
    }

    public int size() {
        assert (this.checkAlive());
        return this.TheMap.size();
    }

    public int getMemorySize() {
        assert (this.checkAlive());
        return this.TheMap.getMemorySize();
    }

    public void resize(int Size) {
        assert (this.checkAlive());
        this.TheMap.resize(Size);
    }

    public void clear() {
        assert (this.checkAlive());
        this.TheMap.clear();
    }

    public int count(ValueT V) {
        assert (this.checkAlive());
        return this.TheMap.count(V);
    }

    public boolean erase(ValueT V) {
        assert (this.checkAlive());
        return this.TheMap.erase(V);
    }

    public void swap(DenseSet<ValueT> RHS) {
        assert (this.checkAlive());
        this.TheMap.swap(RHS.TheMap);
    }

    public DenseSet<ValueT> $assign(DenseSet<ValueT> RHS) {
        assert (this.checkAlive());
        assert (RHS.checkAlive());
        this.TheMap.$assign(RHS.TheMap);
        return this;
    }

    public void $destroy() {
        assert (this.checkAlive());
        this.TheMap.$destroy();
        super.set$destroyed();
    }

    public void insert$T(type.ptr<ValueT> begin, type.ptr<ValueT> end) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public iterator<ValueT> begin() {
        assert (this.checkAlive());
        return new iterator(this.TheMap.begin());
    }

    public iterator<ValueT> begin$Const() {
        assert (this.checkAlive());
        return new iterator(this.TheMap.begin());
    }

    public iterator<ValueT> end() {
        assert (this.checkAlive());
        return new iterator(this.TheMap.end());
    }

    public iterator<ValueT> end$Const() {
        assert (this.checkAlive());
        return new iterator(this.TheMap.end());
    }

    public iterator<ValueT> find(ValueT V) {
        assert (this.checkAlive());
        return new iterator<ValueT>(this.TheMap.find(V));
    }

    public <LookupKeyT> iterator<ValueT> find_as(LookupKeyT V) {
        assert (this.checkAlive());
        return new iterator(this.TheMap.find_as(V));
    }

    public <LookupKeyT> iterator<ValueT> find_as_T$C$R(LookupKeyT V) {
        assert (this.checkAlive());
        return this.find_as(V);
    }

    public void erase(iterator<ValueT> I) {
        assert (this.checkAlive());
        this.TheMap.erase(((iterator)I).I);
    }

    public std_pair.pairTypeBool<iterator> insert(ValueT V) {
        assert (this.checkAlive());
        std_pair.pairTypeBool mapPair = this.TheMap.insert(std.make_pair_T_char(V, (byte)0));
        return std.make_pair_T_bool(new iterator((DenseMapIteratorTypeChar)mapPair.first), (boolean)mapPair.second);
    }

    public <LookupKeyT> std_pair.pairTypeBool<iterator> insert_as(ValueT V, LookupKeyT LookupKey) {
        assert (this.checkAlive());
        std_pair.pairTypeBool mapPair = this.TheMap.insert_as(std.make_pair_T_char(V, (byte)0), LookupKey);
        return std.make_pair_T_bool(new iterator((DenseMapIteratorTypeChar)mapPair.first), (boolean)mapPair.second);
    }

    public void insert(type.iterator<?, ValueT> I, type.iterator<?, ValueT> E) {
        assert (this.checkAlive());
        I = (type.iterator)Native.$tryClone(I);
        while (Native.$noteq_iter((abstract_iterator)I, E)) {
            this.insert(I.$star());
            I.$preInc();
        }
    }

    @Override
    public Iterator<ValueT> iterator() {
        assert (this.checkAlive());
        return new JavaIterator(this.begin(), this.end());
    }

    public String toString() {
        return "DenseSet " + (this.is$destroyed() ? "DESTROYED" : "") + "{DenseMap=" + this.TheMap + "}";
    }

    protected final boolean checkAlive() {
        return this.check$Alive();
    }

    public static class iterator<ValueT>
    implements type.iterator<iterator<ValueT>, ValueT> {
        private DenseMapIteratorTypeChar<ValueT> I;

        public iterator(DenseMapIteratorTypeChar<ValueT> i) {
            this.I = (DenseMapIteratorTypeChar)Native.$tryClone(i);
        }

        public ValueT $star() {
            return (ValueT)this.I.$star().first;
        }

        public type.ref<ValueT> star$ref() {
            return new type.ref<ValueT>(){
                private DenseMapIteratorTypeChar<ValueT> localIter;
                {
                    this.localIter = (DenseMapIteratorTypeChar)Native.$tryClone((NativeCloneable)I);
                }

                public ValueT $deref() {
                    return this.localIter.$star().first;
                }

                public ValueT $set(ValueT value) {
                    this.localIter.$star().first = Native.$tryClone(value);
                    return this.localIter.$star().first;
                }
            };
        }

        public ValueT $arrow() {
            return (ValueT)this.I.$star().first;
        }

        public iterator<ValueT> $preInc() {
            this.I.$preInc();
            return this;
        }

        public boolean $eq(iterator<ValueT> X2) {
            return Native.$eq_iter(this.I, X2.I);
        }

        public boolean $noteq(iterator<ValueT> X2) {
            return Native.$noteq_iter(this.I, X2.I);
        }

        public boolean $noteq(Object other) {
            if (other instanceof iterator) {
                return this.$noteq((iterator)other);
            }
            return true;
        }

        public boolean $eq(Object other) {
            if (other instanceof iterator) {
                return this.$eq((iterator)other);
            }
            return false;
        }

        public iterator<ValueT> clone() {
            return new iterator<ValueT>(this.I);
        }

        public iterator<ValueT> const_clone() {
            return new iterator<ValueT>(this.I);
        }

        public String toString() {
            return "" + this.I;
        }
    }
}

