/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.type;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.aliases.DenseMapTypeChar;

public class DenseMapIteratorTypeChar<KeyT>
implements type.iterator<DenseMapIteratorTypeChar<KeyT>, std_pair.pairTypeChar<KeyT>> {
    private final DenseMapInfo<KeyT> keyInfoT;
    private std_pair.pairTypeChar<KeyT>[] Buckets;
    private int Ptr;
    private int End;
    private static final int INVALID_INDEX = Integer.MAX_VALUE;

    public DenseMapIteratorTypeChar() {
        this.keyInfoT = null;
        this.Ptr = Integer.MAX_VALUE;
        this.End = Integer.MAX_VALUE;
        this.Buckets = null;
    }

    public DenseMapIteratorTypeChar(DenseMapInfo<KeyT> keyInfoT) {
        this.keyInfoT = keyInfoT;
        this.Ptr = Integer.MAX_VALUE;
        this.End = Integer.MAX_VALUE;
        this.Buckets = null;
    }

    public DenseMapIteratorTypeChar(DenseMapInfo<KeyT> keyInfoT, std_pair.pairTypeChar<KeyT>[] Buckets, int Pos, int E) {
        this(keyInfoT, Buckets, Pos, E, false);
    }

    public DenseMapIteratorTypeChar(DenseMapInfo<KeyT> keyInfoT, std_pair.pairTypeChar<KeyT>[] Buckets, int Pos, int E, boolean NoAdvance) {
        this.keyInfoT = keyInfoT;
        this.Ptr = Pos;
        this.End = E;
        this.Buckets = Buckets;
        if (!NoAdvance) {
            this.AdvancePastEmptyBuckets();
        }
    }

    public DenseMapIteratorTypeChar<KeyT> $assignMove(DenseMapIteratorTypeChar<KeyT> other) {
        this.End = other.End;
        this.Buckets = other.Buckets;
        this.Ptr = other.Ptr;
        return this;
    }

    public DenseMapIteratorTypeChar(DenseMapIteratorTypeChar<KeyT> I) {
        this.keyInfoT = I.keyInfoT;
        this.Ptr = I.Ptr;
        this.End = I.End;
        this.Buckets = I.Buckets;
    }

    public DenseMapIteratorTypeChar(JavaDifferentiators.JD.Move INSTANCE, DenseMapIteratorTypeChar<KeyT> $Prm0) {
        this.keyInfoT = $Prm0.keyInfoT;
        this.End = $Prm0.End;
        this.Buckets = $Prm0.Buckets;
        this.Ptr = $Prm0.Ptr;
        $Prm0.End = Integer.MAX_VALUE;
        $Prm0.Ptr = Integer.MAX_VALUE;
        $Prm0.Buckets = null;
    }

    public std_pair.pairTypeChar<KeyT> $star() {
        return this.Buckets[this.Ptr];
    }

    public type.ref<std_pair.pairTypeChar<KeyT>> star$ref() {
        return new type.ref<std_pair.pairTypeChar<KeyT>>(){
            int localPtr;
            {
                this.localPtr = DenseMapIteratorTypeChar.this.Ptr;
            }

            public std_pair.pairTypeChar<KeyT> $deref() {
                return DenseMapIteratorTypeChar.this.Buckets[this.localPtr];
            }

            public std_pair.pairTypeChar<KeyT> $set(std_pair.pairTypeChar<KeyT> value) {
                std_pair.pairTypeChar pairTypeChar2 = value;
                ((DenseMapIteratorTypeChar)DenseMapIteratorTypeChar.this).Buckets[this.localPtr] = pairTypeChar2;
                return pairTypeChar2;
            }

            public type.ptr<std_pair.pairTypeChar<KeyT>> deref$ptr() {
                return NativePointer.create_type$ptr((Object[])DenseMapIteratorTypeChar.this.Buckets, (int)this.localPtr);
            }
        };
    }

    public std_pair.pairTypeChar<KeyT> $arrow() {
        return this.$star();
    }

    public boolean $eq(DenseMapIteratorTypeChar<KeyT> RHS) {
        assert (this.Buckets == RHS.Buckets);
        return this.Ptr == RHS.Ptr;
    }

    public boolean $noteq(DenseMapIteratorTypeChar<KeyT> RHS) {
        assert (this.Buckets == RHS.Buckets);
        return this.Ptr != RHS.Ptr;
    }

    public DenseMapIteratorTypeChar<KeyT> $preInc() {
        ++this.Ptr;
        this.AdvancePastEmptyBuckets();
        return this;
    }

    public DenseMapIteratorTypeChar<KeyT> $postInc() {
        DenseMapIteratorTypeChar<KeyT> tmp = new DenseMapIteratorTypeChar<KeyT>(this.keyInfoT, this.Buckets, this.Ptr, this.End, true);
        this.$preInc();
        return tmp;
    }

    public final DenseMapIteratorTypeChar<KeyT> $postInc(int I) {
        assert (I == 0) : "" + I;
        return this.$postInc();
    }

    private void AdvancePastEmptyBuckets() {
        Object Empty = this.keyInfoT.getEmptyKey();
        Object Tombstone = this.keyInfoT.getTombstoneKey();
        while (this.Ptr != this.End && (this.Buckets[this.Ptr].first == Empty || this.Buckets[this.Ptr].first == Tombstone)) {
            ++this.Ptr;
        }
    }

    public int $sub(DenseMapIteratorTypeChar<KeyT> iter) {
        return std.distance(iter, (abstract_iterator)this, (JavaDifferentiators.JD$FAKE)JavaDifferentiators.JD$FAKE.TRAILING);
    }

    public DenseMapIteratorTypeChar<KeyT> clone() {
        return new DenseMapIteratorTypeChar<KeyT>(this.keyInfoT, this.Buckets, this.Ptr, this.End, true);
    }

    public DenseMapIteratorTypeChar<KeyT> const_clone() {
        return new DenseMapIteratorTypeChar<KeyT>(this.keyInfoT, this.Buckets, this.Ptr, this.End, true);
    }

    public boolean $eq(Object other) {
        if (other instanceof DenseMapIteratorTypeChar) {
            return Native.$eq((int)this.Ptr, (int)((DenseMapIteratorTypeChar)other).Ptr);
        }
        return false;
    }

    public boolean $noteq(Object other) {
        if (other instanceof DenseMapIteratorTypeChar) {
            return Native.$noteq((int)this.Ptr, (int)((DenseMapIteratorTypeChar)other).Ptr);
        }
        return true;
    }

    public String toString() {
        String msg = NativeTrace.getIdentityStr(this.keyInfoT);
        if (this.Ptr == this.End) {
            msg = "<" + (this.Ptr == Integer.MAX_VALUE ? "INVALID:" : "END:") + msg + ">";
        } else {
            StringBuilder out = new StringBuilder(msg);
            DenseMapTypeChar.BucketToString(out, this.Ptr, this.Buckets[this.Ptr], this.keyInfoT.isKeyPointerLike(), false);
            msg = out.toString();
        }
        return msg;
    }
}

