/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.type;
import org.llvm.adt.aliases.DenseMapInfoInt;
import org.llvm.adt.aliases.DenseMapIntType;

public class DenseMapIteratorIntType<ValueT>
implements type.iterator<DenseMapIteratorIntType<ValueT>, std_pair.pairIntType<ValueT>> {
    private final DenseMapInfoInt keyInfoT;
    private std_pair.pairIntType<ValueT>[] Buckets;
    private int Ptr;
    private int End;
    private static final int INVALID_INDEX = Integer.MAX_VALUE;

    public DenseMapIteratorIntType() {
        this.keyInfoT = null;
        this.Ptr = Integer.MAX_VALUE;
        this.End = Integer.MAX_VALUE;
        this.Buckets = null;
    }

    public DenseMapIteratorIntType(DenseMapInfoInt keyInfoT) {
        this.keyInfoT = keyInfoT;
        this.Ptr = Integer.MAX_VALUE;
        this.End = Integer.MAX_VALUE;
        this.Buckets = null;
    }

    public DenseMapIteratorIntType(DenseMapInfoInt keyInfoT, std_pair.pairIntType<ValueT>[] Buckets, int Pos, int E) {
        this(keyInfoT, Buckets, Pos, E, false);
    }

    public DenseMapIteratorIntType(DenseMapInfoInt keyInfoT, std_pair.pairIntType<ValueT>[] Buckets, int Pos, int E, boolean NoAdvance) {
        this.keyInfoT = keyInfoT;
        this.Ptr = Pos;
        this.End = E;
        this.Buckets = Buckets;
        if (!NoAdvance) {
            this.AdvancePastEmptyBuckets();
        }
    }

    public DenseMapIteratorIntType<ValueT> $assignMove(DenseMapIteratorIntType<ValueT> other) {
        this.End = other.End;
        this.Buckets = other.Buckets;
        this.Ptr = other.Ptr;
        return this;
    }

    public DenseMapIteratorIntType(DenseMapIteratorIntType<ValueT> I) {
        this.keyInfoT = I.keyInfoT;
        this.Ptr = I.Ptr;
        this.End = I.End;
        this.Buckets = I.Buckets;
    }

    public DenseMapIteratorIntType(JavaDifferentiators.JD.Move INSTANCE, DenseMapIteratorIntType<ValueT> $Prm0) {
        this.keyInfoT = $Prm0.keyInfoT;
        this.End = $Prm0.End;
        this.Buckets = $Prm0.Buckets;
        this.Ptr = $Prm0.Ptr;
        $Prm0.End = Integer.MAX_VALUE;
        $Prm0.Ptr = Integer.MAX_VALUE;
        $Prm0.Buckets = null;
    }

    public std_pair.pairIntType<ValueT> $star() {
        return this.Buckets[this.Ptr];
    }

    public type.ref<std_pair.pairIntType<ValueT>> star$ref() {
        return new type.ref<std_pair.pairIntType<ValueT>>(){
            int localPtr;
            {
                this.localPtr = DenseMapIteratorIntType.this.Ptr;
            }

            public std_pair.pairIntType<ValueT> $deref() {
                return DenseMapIteratorIntType.this.Buckets[this.localPtr];
            }

            public std_pair.pairIntType<ValueT> $set(std_pair.pairIntType<ValueT> value) {
                std_pair.pairIntType pairIntType2 = value;
                ((DenseMapIteratorIntType)DenseMapIteratorIntType.this).Buckets[this.localPtr] = pairIntType2;
                return pairIntType2;
            }

            public type.ptr<std_pair.pairIntType<ValueT>> deref$ptr() {
                return NativePointer.create_type$ptr((Object[])DenseMapIteratorIntType.this.Buckets, (int)this.localPtr);
            }
        };
    }

    public std_pair.pairIntType<ValueT> $arrow() {
        return this.$star();
    }

    public boolean $eq(DenseMapIteratorIntType<ValueT> RHS) {
        assert (this.Buckets == RHS.Buckets);
        return this.Ptr == RHS.Ptr;
    }

    public boolean $noteq(DenseMapIteratorIntType<ValueT> RHS) {
        assert (this.Buckets == RHS.Buckets);
        return this.Ptr != RHS.Ptr;
    }

    public DenseMapIteratorIntType<ValueT> $preInc() {
        ++this.Ptr;
        this.AdvancePastEmptyBuckets();
        return this;
    }

    public DenseMapIteratorIntType<ValueT> $postInc() {
        DenseMapIteratorIntType<ValueT> tmp = new DenseMapIteratorIntType<ValueT>(this.keyInfoT, this.Buckets, this.Ptr, this.End, true);
        this.$preInc();
        return tmp;
    }

    public final DenseMapIteratorIntType<ValueT> $postInc(int I) {
        assert (I == 0) : "" + I;
        return this.$postInc();
    }

    private void AdvancePastEmptyBuckets() {
        int Empty = this.keyInfoT.getEmptyKey();
        int Tombstone = this.keyInfoT.getTombstoneKey();
        while (this.Ptr != this.End && (this.Buckets[this.Ptr].first == Empty || this.Buckets[this.Ptr].first == Tombstone)) {
            ++this.Ptr;
        }
    }

    public int $sub(DenseMapIteratorIntType<ValueT> iter) {
        return std.distance(iter, (abstract_iterator)this, (JavaDifferentiators.JD$FAKE)JavaDifferentiators.JD$FAKE.TRAILING);
    }

    public DenseMapIteratorIntType<ValueT> clone() {
        return new DenseMapIteratorIntType<ValueT>(this.keyInfoT, this.Buckets, this.Ptr, this.End, true);
    }

    public DenseMapIteratorIntType<ValueT> const_clone() {
        return new DenseMapIteratorIntType<ValueT>(this.keyInfoT, this.Buckets, this.Ptr, this.End, true);
    }

    public boolean $eq(Object other) {
        if (other instanceof DenseMapIteratorIntType) {
            return Native.$eq((int)this.Ptr, (int)((DenseMapIteratorIntType)other).Ptr);
        }
        return false;
    }

    public boolean $noteq(Object other) {
        if (other instanceof DenseMapIteratorIntType) {
            return Native.$noteq((int)this.Ptr, (int)((DenseMapIteratorIntType)other).Ptr);
        }
        return true;
    }

    public String toString() {
        String msg = NativeTrace.getIdentityStr((Object)this.keyInfoT);
        if (this.Ptr == this.End) {
            msg = "<" + (this.Ptr == Integer.MAX_VALUE ? "INVALID:" : "END:") + msg + ">";
        } else {
            StringBuilder out = new StringBuilder(msg);
            DenseMapIntType.BucketToString(out, this.Ptr, this.Buckets[this.Ptr], this.keyInfoT.isKeyPointerLike(), true);
            msg = out.toString();
        }
        return msg;
    }
}

