/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.type;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.aliases.DenseMap;

public class DenseMapIterator<KeyT, ValueT>
implements type.iterator<DenseMapIterator<KeyT, ValueT>, std_pair.pair<KeyT, ValueT>> {
    private final DenseMapInfo<KeyT> keyInfoT;
    private std_pair.pair<KeyT, ValueT>[] Buckets;
    private int Ptr;
    private int End;
    private static final int INVALID_INDEX = Integer.MAX_VALUE;

    public DenseMapIterator() {
        this.keyInfoT = null;
        this.Ptr = Integer.MAX_VALUE;
        this.End = Integer.MAX_VALUE;
        this.Buckets = null;
    }

    public DenseMapIterator(DenseMapInfo<KeyT> keyInfoT) {
        this.keyInfoT = keyInfoT;
        this.Ptr = Integer.MAX_VALUE;
        this.End = Integer.MAX_VALUE;
        this.Buckets = null;
    }

    public DenseMapIterator(DenseMapInfo<KeyT> keyInfoT, std_pair.pair<KeyT, ValueT>[] Buckets, int Pos, int E) {
        this(keyInfoT, Buckets, Pos, E, false);
    }

    public DenseMapIterator(DenseMapInfo<KeyT> keyInfoT, std_pair.pair<KeyT, ValueT>[] Buckets, int Pos, int E, boolean NoAdvance) {
        this.keyInfoT = keyInfoT;
        this.Ptr = Pos;
        this.End = E;
        this.Buckets = Buckets;
        if (!NoAdvance) {
            this.AdvancePastEmptyBuckets();
        }
    }

    public DenseMapIterator<KeyT, ValueT> $assignMove(DenseMapIterator<KeyT, ValueT> other) {
        this.End = other.End;
        this.Buckets = other.Buckets;
        this.Ptr = other.Ptr;
        return this;
    }

    public DenseMapIterator(DenseMapIterator<KeyT, ValueT> I) {
        this.keyInfoT = I.keyInfoT;
        this.Ptr = I.Ptr;
        this.End = I.End;
        this.Buckets = I.Buckets;
    }

    public DenseMapIterator(JavaDifferentiators.JD.Move INSTANCE, DenseMapIterator<KeyT, ValueT> $Prm0) {
        this.keyInfoT = $Prm0.keyInfoT;
        this.End = $Prm0.End;
        this.Buckets = $Prm0.Buckets;
        this.Ptr = $Prm0.Ptr;
        $Prm0.End = Integer.MAX_VALUE;
        $Prm0.Ptr = Integer.MAX_VALUE;
        $Prm0.Buckets = null;
    }

    public std_pair.pair<KeyT, ValueT> $star() {
        return this.Buckets[this.Ptr];
    }

    public type.ref<std_pair.pair<KeyT, ValueT>> star$ref() {
        return new type.ref<std_pair.pair<KeyT, ValueT>>(){
            int localPtr;
            {
                this.localPtr = DenseMapIterator.this.Ptr;
            }

            public std_pair.pair<KeyT, ValueT> $deref() {
                return DenseMapIterator.this.Buckets[this.localPtr];
            }

            public std_pair.pair<KeyT, ValueT> $set(std_pair.pair<KeyT, ValueT> value) {
                std_pair.pair pair2 = value;
                ((DenseMapIterator)DenseMapIterator.this).Buckets[this.localPtr] = pair2;
                return pair2;
            }

            public type.ptr<std_pair.pair<KeyT, ValueT>> deref$ptr() {
                return NativePointer.create_type$ptr((Object[])DenseMapIterator.this.Buckets, (int)this.localPtr);
            }
        };
    }

    public std_pair.pair<KeyT, ValueT> $arrow() {
        return this.$star();
    }

    public boolean $eq(DenseMapIterator<KeyT, ValueT> RHS) {
        assert (this.Buckets == RHS.Buckets);
        return this.Ptr == RHS.Ptr;
    }

    public boolean $noteq(DenseMapIterator<KeyT, ValueT> RHS) {
        assert (this.Buckets == RHS.Buckets);
        return this.Ptr != RHS.Ptr;
    }

    public DenseMapIterator<KeyT, ValueT> $preInc() {
        ++this.Ptr;
        this.AdvancePastEmptyBuckets();
        return this;
    }

    public DenseMapIterator<KeyT, ValueT> $postInc() {
        DenseMapIterator<KeyT, ValueT> tmp = new DenseMapIterator<KeyT, ValueT>(this.keyInfoT, this.Buckets, this.Ptr, this.End, true);
        this.$preInc();
        return tmp;
    }

    public final DenseMapIterator<KeyT, ValueT> $postInc(int I) {
        assert (I == 0) : "" + I;
        return this.$postInc();
    }

    private void AdvancePastEmptyBuckets() {
        Object Empty = this.keyInfoT.getEmptyKey();
        Object Tombstone = this.keyInfoT.getTombstoneKey();
        while (this.Ptr != this.End && (this.Buckets[this.Ptr].first == Empty || this.Buckets[this.Ptr].first == Tombstone)) {
            ++this.Ptr;
        }
    }

    public int $sub(DenseMapIterator<KeyT, ValueT> iter) {
        return std.distance(iter, (abstract_iterator)this, (JavaDifferentiators.JD$FAKE)JavaDifferentiators.JD$FAKE.TRAILING);
    }

    public DenseMapIterator<KeyT, ValueT> clone() {
        return new DenseMapIterator<KeyT, ValueT>(this.keyInfoT, this.Buckets, this.Ptr, this.End, true);
    }

    public DenseMapIterator<KeyT, ValueT> const_clone() {
        return new DenseMapIterator<KeyT, ValueT>(this.keyInfoT, this.Buckets, this.Ptr, this.End, true);
    }

    public boolean $eq(Object other) {
        if (other instanceof DenseMapIterator) {
            return Native.$eq((int)this.Ptr, (int)((DenseMapIterator)other).Ptr);
        }
        return false;
    }

    public boolean $noteq(Object other) {
        if (other instanceof DenseMapIterator) {
            return Native.$noteq((int)this.Ptr, (int)((DenseMapIterator)other).Ptr);
        }
        return true;
    }

    public String toString() {
        String msg = NativeTrace.getIdentityStr(this.keyInfoT);
        if (this.Ptr == this.End) {
            msg = "<" + (this.Ptr == Integer.MAX_VALUE ? "INVALID:" : "END:") + msg + ">";
        } else {
            StringBuilder out = new StringBuilder(msg);
            DenseMap.BucketToString(out, this.Ptr, this.Buckets[this.Ptr], this.keyInfoT.isKeyPointerLike(), true);
            msg = out.toString();
        }
        return msg;
    }
}

