/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import org.clank.support.NativeTrace;

public class DenseMapInfoUInt {
    private static final DenseMapInfoUInt $INFO = new DenseMapInfoUInt();
    private final boolean allowCompareWithEmptyAndTombstone;
    protected final int emptyKey;
    protected final int tombstoneKey;

    public static DenseMapInfoUInt $Info() {
        return $INFO;
    }

    public DenseMapInfoUInt() {
        this(-1, -2);
    }

    public DenseMapInfoUInt(int emptyKey, int tombstoneKey) {
        this(emptyKey, tombstoneKey, false);
    }

    public DenseMapInfoUInt(int emptyKey, int tombstoneKey, boolean allowCompareWithEmptyAndTombstone) {
        this.emptyKey = emptyKey;
        this.tombstoneKey = tombstoneKey;
        this.allowCompareWithEmptyAndTombstone = allowCompareWithEmptyAndTombstone;
        assert (this.tombstoneKey != this.emptyKey) : "emptyKey [" + this.emptyKey + "] must be different from tombstoneKey [" + this.tombstoneKey + "]";
    }

    public final int getEmptyKey() {
        return this.emptyKey;
    }

    public final int getTombstoneKey() {
        return this.tombstoneKey;
    }

    public int getHashValue(int Key) {
        assert (this.allowCompareWithEmptyAndTombstone || Key != this.emptyKey) : "Key: must not be called for emptyKey";
        assert (this.allowCompareWithEmptyAndTombstone || Key != this.tombstoneKey) : "Key: must not be called for tombstoneKey";
        return Key * 37;
    }

    public int getHashValueAlt(Object AltKey) {
        throw new UnsupportedOperationException("Override to support alternative Key types with hash same as Key");
    }

    public boolean isEqual(int LHS, int RHS) {
        assert (this.allowCompareWithEmptyAndTombstone || LHS != this.emptyKey) : "LHS: must not be called for emptyKey";
        assert (this.allowCompareWithEmptyAndTombstone || LHS != this.tombstoneKey) : "LHS: must not be called for tombstoneKey";
        assert (this.allowCompareWithEmptyAndTombstone || RHS != this.emptyKey) : "RHS: must not be called for emptyKey";
        assert (this.allowCompareWithEmptyAndTombstone || RHS != this.tombstoneKey) : "RHS: must not be called for tombstoneKey";
        return LHS == RHS;
    }

    public boolean isEqualAlt(Object AltKey, int Key) {
        assert (this.allowCompareWithEmptyAndTombstone || Key != this.emptyKey) : "Key: must not be called for emptyKey";
        assert (this.allowCompareWithEmptyAndTombstone || Key != this.tombstoneKey) : "Key: must not be called for tombstoneKey";
        throw new UnsupportedOperationException("Override to support alternative Key types comparable with Key");
    }

    public boolean isKeyPointerLike() {
        return true;
    }

    protected boolean checkKey(Object Key) {
        return this.checkKeyImpl(Key, false);
    }

    protected boolean checkAltKey(Object AltKey) {
        return this.checkKeyImpl(AltKey, true);
    }

    protected boolean checkKeyImpl(Object Key, boolean altKey) {
        if (!NativeTrace.isDebugMode()) {
            NativeTrace.printStackTraceOnce((Throwable)new Exception("must be called inside assert"));
            return true;
        }
        return true;
    }
}

