/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.aliases.DenseMapBase;
import org.llvm.adt.aliases.DenseMapIterator;

public abstract class DenseMapBase<DerivedT, KeyT, ValueT>
extends NativeTrace.CreateDestroy$Tracker
implements NativeType.SizeofCapable {
    protected final ValueT defaultValue;
    protected final DenseMapInfo<KeyT> keyInfoT;
    protected final Object emptyKey;
    protected final Object tombstoneKey;
    static final int INVALID_INDEX = Integer.MAX_VALUE;
    private static final int CANDIDATE_INDEX_MASK = Integer.MAX_VALUE;
    private static final int CANDIDATE_INDEX_FLAG = Integer.MIN_VALUE;

    protected DenseMapBase(DenseMapInfo<KeyT> keyInfo, ValueT defaultValue) {
        this.keyInfoT = keyInfo;
        this.defaultValue = defaultValue;
        this.emptyKey = this.keyInfoT.getEmptyKey();
        this.tombstoneKey = keyInfo.getTombstoneKey();
        assert (this.emptyKey != null && this.tombstoneKey != null) : "empty/tombstoneKey key marker must be non null " + this.keyInfoT;
        assert (this.keyInfoT.getEmptyKey() == this.emptyKey) : "empty key must be persistent between calls" + this.keyInfoT;
        assert (this.keyInfoT.getTombstoneKey() == this.tombstoneKey) : "tombstone key must be persistent between calls" + this.keyInfoT;
        assert (this.emptyKey != this.tombstoneKey) : "EmptyKey must be different from TombstoneKey:" + keyInfo;
        assert (NativeTrace.assertDefaultValue(defaultValue));
    }

    public DenseMapIterator<KeyT, ValueT> begin() {
        assert (this.checkAlive());
        return this.empty() ? this.end() : new DenseMapIterator<KeyT, ValueT>(this.keyInfoT, this.$Buckets(), 0, this.getNumBuckets());
    }

    public DenseMapIterator<KeyT, ValueT> end() {
        assert (this.checkAlive());
        return new DenseMapIterator<KeyT, ValueT>(this.keyInfoT, this.$Buckets(), this.getNumBuckets(), this.getNumBuckets(), true);
    }

    public final DenseMapIterator<KeyT, ValueT> begin$Const() {
        assert (this.checkAlive());
        return this.begin();
    }

    public final DenseMapIterator<KeyT, ValueT> end$Const() {
        assert (this.checkAlive());
        return this.end();
    }

    public boolean empty() {
        assert (this.checkAlive());
        return this.getNumEntries() == 0;
    }

    public int size() {
        assert (this.checkAlive());
        return this.getNumEntries();
    }

    public void resize(int Size) {
        assert (this.checkAlive());
        if (Size >= this.getNumBuckets()) {
            this.grow(Size);
        }
    }

    public void clear() {
        if (this.getNumEntries() == 0 && this.getNumTombstones() == 0) {
            assert (this.checkAlive());
            return;
        }
        if (this.getNumEntries() * 4 < this.getNumBuckets() && this.getNumBuckets() > 64) {
            this.shrink_and_clear();
            return;
        }
        Object EmptyKey = this.getEmptyKey();
        Object TombstoneKey = this.getTombstoneKey();
        std_pair.pair<KeyT, ValueT>[] Buckets = this.$Buckets();
        int P2 = 0;
        int E = this.getNumBuckets();
        while (Native.$noteq((int)P2, (int)E)) {
            if (Buckets[P2].first != EmptyKey) {
                if (Buckets[P2].first != TombstoneKey) {
                    if (!this.isDataPointerLike()) {
                        Native.destroy((Object)Buckets[P2].second);
                    }
                    this.decrementNumEntries();
                }
                Buckets[P2].first = EmptyKey;
            }
            ++P2;
        }
        this.setNumTombstones(0);
    }

    public int count(KeyT Val) {
        assert (this.checkAlive());
        return this.LookupBucketFor(Val, true) == Integer.MAX_VALUE ? 0 : 1;
    }

    public DenseMapIterator<KeyT, ValueT> find(KeyT Val) {
        assert (this.checkAlive());
        int TheBucket = this.LookupBucketFor(Val, true);
        if (TheBucket != Integer.MAX_VALUE) {
            return new DenseMapIterator<KeyT, ValueT>(this.keyInfoT, this.$Buckets(), TheBucket, this.getNumBuckets(), true);
        }
        return this.end();
    }

    public final DenseMapIterator<KeyT, ValueT> find$Const(KeyT Val) {
        assert (this.checkAlive());
        return this.find(Val);
    }

    public <LookupKeyT> DenseMapIterator<KeyT, ValueT> find_as(LookupKeyT Val) {
        assert (this.checkAlive());
        int TheBucket = this.LookupBucketForAltKey(Val, true);
        if (TheBucket != Integer.MAX_VALUE) {
            return new DenseMapIterator<KeyT, ValueT>(this.keyInfoT, this.$Buckets(), TheBucket, this.getNumBuckets(), true);
        }
        return this.end();
    }

    public final <LookupKeyT> DenseMapIterator<KeyT, ValueT> find_as$Const(LookupKeyT AltKey) {
        assert (this.checkAlive());
        return this.find_as(AltKey);
    }

    public final <LookupKeyT> DenseMapIterator<KeyT, ValueT> find_as_T$C$R(LookupKeyT AltKey) {
        assert (this.checkAlive());
        return this.find_as(AltKey);
    }

    public ValueT lookup(KeyT Val) {
        assert (this.checkAlive());
        int TheBucket = this.LookupBucketFor(Val, true);
        if (TheBucket != Integer.MAX_VALUE) {
            return (ValueT)this.$Buckets()[TheBucket].second;
        }
        return (ValueT)Native.$tryClone(this.defaultValue);
    }

    public final std_pair.pairTypeBool<DenseMapIterator<KeyT, ValueT>> insert_pair$KeyT$ValueT(std_pair.pair<KeyT, ValueT> KV) {
        assert (this.checkAlive());
        return this.insert(KV);
    }

    public std_pair.pairTypeBool<DenseMapIterator<KeyT, ValueT>> insert(std_pair.pair<KeyT, ValueT> KV) {
        assert (this.checkAlive());
        int TheBucket = this.LookupBucketFor(KV.first, false);
        assert (TheBucket != Integer.MAX_VALUE);
        if (TheBucket < 0) {
            TheBucket = this.InsertIntoBucket(KV.first, KV.second, TheBucket & Integer.MAX_VALUE);
            return std.make_pair_T_bool(new DenseMapIterator<KeyT, ValueT>(this.keyInfoT, this.$Buckets(), TheBucket, this.getNumBuckets(), true), (boolean)true);
        }
        return std.make_pair_T_bool(new DenseMapIterator<KeyT, ValueT>(this.keyInfoT, this.$Buckets(), TheBucket, this.getNumBuckets(), true), (boolean)false);
    }

    public <LookupKeyT> std_pair.pairTypeBool<DenseMapIterator<KeyT, ValueT>> insert_as(std_pair.pair<KeyT, ValueT> KV, LookupKeyT AltKey) {
        assert (this.checkAlive());
        int TheBucket = this.LookupBucketForAltKey(AltKey, false);
        assert (TheBucket != Integer.MAX_VALUE);
        if (TheBucket < 0) {
            TheBucket = this.InsertIntoBucketAltKey(KV.first, KV.second, AltKey, TheBucket & Integer.MAX_VALUE);
            return std.make_pair_T_bool(new DenseMapIterator<KeyT, ValueT>(this.keyInfoT, this.$Buckets(), TheBucket, this.getNumBuckets(), true), (boolean)true);
        }
        return std.make_pair_T_bool(new DenseMapIterator<KeyT, ValueT>(this.keyInfoT, this.$Buckets(), TheBucket, this.getNumBuckets(), true), (boolean)false);
    }

    public void insert(type.iterator<?, std_pair.pair<KeyT, ValueT>> I, type.iterator<?, std_pair.pair<KeyT, ValueT>> E) {
        assert (this.checkAlive());
        while (Native.$noteq_iter(I, E)) {
            this.insert((std_pair.pair)I.$star());
            I.$preInc();
        }
    }

    public boolean erase(KeyT Val) {
        assert (this.checkAlive());
        int TheBucketIdx = this.LookupBucketFor(Val, true);
        if (TheBucketIdx == Integer.MAX_VALUE) {
            return false;
        }
        std_pair.pair<KeyT, ValueT> TheBucket = this.$Buckets()[TheBucketIdx];
        if (!this.isDataPointerLike()) {
            Native.destroy((Object)TheBucket.second);
        }
        TheBucket.first = this.getTombstoneKey();
        this.decrementNumEntries();
        this.incrementNumTombstones();
        return true;
    }

    public void erase(DenseMapIterator<KeyT, ValueT> I) {
        assert (this.checkAlive());
        std_pair.pair<KeyT, ValueT> TheBucket = I.$arrow();
        if (!this.isDataPointerLike()) {
            Native.destroy((Object)TheBucket.second);
        }
        TheBucket.first = this.getTombstoneKey();
        this.decrementNumEntries();
        this.incrementNumTombstones();
    }

    public std_pair.pair<KeyT, ValueT> FindAndConstruct(KeyT Key) {
        assert (this.checkAlive());
        int TheBucket = this.LookupBucketFor(Key, false);
        if (TheBucket < 0) {
            TheBucket = this.InsertIntoBucket(Key, this.isDataPointerLike() ? null : Native.$tryClone(this.defaultValue), TheBucket & Integer.MAX_VALUE);
        }
        return this.$Buckets()[TheBucket];
    }

    public ValueT $at(KeyT Key) {
        assert (this.checkAlive());
        return (ValueT)this.FindAndConstruct(Key).second;
    }

    public ValueT $at_T1$C$R(KeyT Key) {
        assert (this.checkAlive());
        return (ValueT)this.FindAndConstruct(Key).second;
    }

    public ValueT $at_T1$RR(KeyT Key) {
        assert (this.checkAlive());
        return (ValueT)this.FindAndConstruct(Key).second;
    }

    public ValueT $set(KeyT Key, ValueT Val) {
        assert (this.checkAlive());
        this.FindAndConstruct(Key).second = Val;
        return (ValueT)this.FindAndConstruct(Key).second;
    }

    public type.ref<ValueT> ref$at_T1$C$R(KeyT Key) {
        return this.ref$at(Key);
    }

    public type.ref<ValueT> ref$at(KeyT Key) {
        assert (this.checkAlive());
        return new type.ref_IMPL(Key, this);
    }

    public boolean isPointerIntoBucketsArray(Object Ptr2) {
        assert (this.checkAlive());
        if (Ptr2 != null && this.getBuckets() != null && this.getBucketsEnd() != null) {
            if (Ptr2 instanceof type.ref_IMPL) {
                return ((type.ref_IMPL)Ptr2).map == this;
            }
            if (Ptr2 instanceof type.ptr) {
                type.ptr Check = (type.ptr)Ptr2;
                return Native.$is_array_based((type.ptr)Check) && Check.$array() == this.$Buckets();
            }
        }
        return false;
    }

    public void.ptr getPointerIntoBucketsArray() {
        assert (this.checkAlive());
        return this.getBuckets();
    }

    protected void destroyAll() {
        assert (this.checkAlive());
        if (this.getNumBuckets() == 0) {
            return;
        }
        Object EmptyKey = this.getEmptyKey();
        Object TombstoneKey = this.getTombstoneKey();
        std_pair.pair<KeyT, ValueT>[] Buckets = this.$Buckets();
        int P2 = 0;
        int E = this.getNumBuckets();
        while (Native.$noteq((int)P2, (int)E)) {
            if (Buckets[P2].first != EmptyKey && Buckets[P2].first != TombstoneKey) {
                if (!this.isDataPointerLike()) {
                    Native.destroy((Object)Buckets[P2].second);
                }
                if (!this.isKeyPointerLike()) {
                    Native.destroy((Object)Buckets[P2].first);
                }
            }
            ++P2;
        }
    }

    protected void initEmpty() {
        assert (this.checkAlive());
        this.setNumEntries(0);
        this.setNumTombstones(0);
        Object EmptyKey = this.getEmptyKey();
        std_pair.pair<KeyT, ValueT>[] Buckets = this.$Buckets();
        int E = this.getNumBuckets();
        for (int B = 0; B != E; ++B) {
            Buckets[B].first = EmptyKey;
        }
    }

    protected void moveFromOldBuckets(std_pair.pair<KeyT, ValueT>[] OldBucketsBegin, int Num) {
        assert (this.checkAlive());
        this.initEmpty();
        Object EmptyKey = this.getEmptyKey();
        Object TombstoneKey = this.getTombstoneKey();
        std_pair.pair<KeyT, ValueT>[] Buckets = this.$Buckets();
        int E = Num;
        for (int B = 0; B != Num; ++B) {
            std_pair.pair<KeyT, ValueT> oldPair = OldBucketsBegin[B];
            Object OldKey = oldPair.first;
            if (OldKey == EmptyKey || OldKey == TombstoneKey) continue;
            int DestBucketIdx = this.LookupBucketFor(OldKey, false);
            assert (DestBucketIdx != Integer.MAX_VALUE) : "Key already in new map?";
            assert (DestBucketIdx < 0) : "Key " + System.identityHashCode(OldKey) + " already in new map?" + System.identityHashCode(Buckets[DestBucketIdx]) + ":\nWhen Inserting Key=" + OldKey + "\nFound In Map=" + Buckets[DestBucketIdx];
            assert ((DestBucketIdx &= Integer.MAX_VALUE) >= 0);
            assert (DestBucketIdx != Integer.MAX_VALUE);
            std_pair.pair<KeyT, ValueT> DestBucket = Buckets[DestBucketIdx];
            DestBucket.first = OldKey;
            DestBucket.second = oldPair.second;
            this.incrementNumEntries();
        }
    }

    protected <OtherBaseT> void copyFrom(DenseMapBase<OtherBaseT, KeyT, ValueT> other) {
        assert (this.checkAlive());
        assert (other.checkAlive());
        this.setNumEntries(other.getNumEntries());
        this.setNumTombstones(other.getNumTombstones());
        std_pair.pair<KeyT, ValueT>[] ourBuckets = this.$Buckets();
        std_pair.pair<KeyT, ValueT>[] otherBuckets = other.$Buckets();
        for (int i = 0; i < this.getNumBuckets(); ++i) {
            ourBuckets[i].first = otherBuckets[i].first;
            if (ourBuckets[i].first == this.getEmptyKey() || ourBuckets[i].first == this.getTombstoneKey()) continue;
            if (!this.isKeyPointerLike()) {
                ourBuckets[i].first = Native.$tryClone((Object)otherBuckets[i].first);
            }
            ourBuckets[i].second = this.isDataPointerLike() ? otherBuckets[i].second : Native.$tryClone((Object)otherBuckets[i].second);
        }
    }

    protected void swap(DenseMapBase<DerivedT, KeyT, ValueT> RHS) {
        assert (this.checkAlive());
        assert (RHS.checkAlive());
        int tmp = RHS.getNumEntries();
        RHS.setNumEntries(this.getNumEntries());
        this.setNumEntries(tmp);
        tmp = RHS.getNumTombstones();
        RHS.setNumTombstones(this.getNumTombstones());
        this.setNumTombstones(tmp);
    }

    protected int getHashValue(KeyT Val) {
        assert (this.checkAlive());
        return this.keyInfoT.getHashValue(Val);
    }

    protected <LookupKeyT> int getHashValueAlt(LookupKeyT Val) {
        assert (this.checkAlive());
        return this.keyInfoT.getHashValueAlt(Val);
    }

    protected final Object getEmptyKey() {
        assert (this.checkAlive());
        return this.emptyKey;
    }

    protected final Object getTombstoneKey() {
        assert (this.checkAlive());
        return this.tombstoneKey;
    }

    protected abstract int getNumEntries();

    protected abstract void setNumEntries(int var1);

    private void incrementNumEntries() {
        this.setNumEntries(this.getNumEntries() + 1);
    }

    private void decrementNumEntries() {
        this.setNumEntries(this.getNumEntries() - 1);
    }

    protected abstract int getNumTombstones();

    protected abstract void setNumTombstones(int var1);

    private void incrementNumTombstones() {
        this.setNumTombstones(this.getNumTombstones() + 1);
    }

    private void decrementNumTombstones() {
        this.setNumTombstones(this.getNumTombstones() - 1);
    }

    protected abstract type.ptr<std_pair.pair<KeyT, ValueT>> getBuckets();

    protected abstract std_pair.pair<KeyT, ValueT>[] $Buckets();

    protected abstract int getNumBuckets();

    private type.ptr<std_pair.pair<KeyT, ValueT>> getBucketsEnd() {
        return NativePointer.create_type$ptr((Object[])this.$Buckets(), (int)this.getNumBuckets());
    }

    protected abstract void grow(int var1);

    protected abstract void shrink_and_clear();

    private int InsertIntoBucket(KeyT Key, ValueT Value, int TheBucketIndex) {
        TheBucketIndex = this.InsertIntoBucketImpl(Key, TheBucketIndex);
        std_pair.pair<KeyT, ValueT> TheBucket = this.$Buckets()[TheBucketIndex];
        assert (Key != this.emptyKey);
        assert (Key != this.tombstoneKey);
        TheBucket.first = Key;
        TheBucket.second = Value;
        return TheBucketIndex;
    }

    private int InsertIntoBucketImpl(KeyT Key, int TheBucket) {
        int NumBuckets;
        int NewNumEntries = this.getNumEntries() + 1;
        if (NewNumEntries * 4 >= (NumBuckets = this.getNumBuckets()) * 3) {
            this.grow(NumBuckets * 2);
            TheBucket = this.LookupBucketFor(Key, false) & Integer.MAX_VALUE;
            NumBuckets = this.getNumBuckets();
        } else if (Native.$lesseq((int)(NumBuckets - (NewNumEntries + this.getNumTombstones())), (int)(NumBuckets / 8))) {
            this.grow(NumBuckets);
            TheBucket = this.LookupBucketFor(Key, false) & Integer.MAX_VALUE;
        }
        assert (TheBucket != Integer.MAX_VALUE);
        this.incrementNumEntries();
        Object EmptyKey = this.getEmptyKey();
        if (this.$Buckets()[TheBucket].first != EmptyKey) {
            this.decrementNumTombstones();
        }
        return TheBucket;
    }

    private <LookupKeyT> int InsertIntoBucketAltKey(KeyT Key, ValueT Value, LookupKeyT AltKey, int TheBucketIndex) {
        TheBucketIndex = this.InsertIntoBucketAltKeyImpl(AltKey, TheBucketIndex);
        std_pair.pair<KeyT, ValueT> TheBucket = this.$Buckets()[TheBucketIndex];
        assert (Key != this.emptyKey);
        assert (Key != this.tombstoneKey);
        TheBucket.first = Key;
        TheBucket.second = Value;
        return TheBucketIndex;
    }

    private <LookupKeyT> int InsertIntoBucketAltKeyImpl(LookupKeyT AltKey, int TheBucket) {
        int NumBuckets;
        int NewNumEntries = this.getNumEntries() + 1;
        if (NewNumEntries * 4 >= (NumBuckets = this.getNumBuckets()) * 3) {
            this.grow(NumBuckets * 2);
            TheBucket = this.LookupBucketForAltKey(AltKey, false) & Integer.MAX_VALUE;
            NumBuckets = this.getNumBuckets();
        } else if (Native.$lesseq((int)(NumBuckets - (NewNumEntries + this.getNumTombstones())), (int)(NumBuckets / 8))) {
            this.grow(NumBuckets);
            TheBucket = this.LookupBucketForAltKey(AltKey, false) & Integer.MAX_VALUE;
        }
        assert (TheBucket != Integer.MAX_VALUE);
        this.incrementNumEntries();
        Object EmptyKey = this.getEmptyKey();
        if (this.$Buckets()[TheBucket].first != EmptyKey) {
            this.decrementNumTombstones();
        }
        return TheBucket;
    }

    private int LookupBucketFor(KeyT Key, boolean onlyExisting) {
        int NumBuckets = this.getNumBuckets();
        if (NumBuckets == 0) {
            if (onlyExisting) {
                return Integer.MAX_VALUE;
            }
            return Integer.MIN_VALUE;
        }
        std_pair.pair<KeyT, ValueT>[] Buckets = this.$Buckets();
        int FoundTombstone = Integer.MAX_VALUE;
        Object EmptyKey = this.getEmptyKey();
        Object TombstoneKey = this.getTombstoneKey();
        assert (Key != EmptyKey) : "Empty/Tombstone value shouldn't be inserted into map!";
        assert (Key != TombstoneKey) : "Empty/Tombstone value shouldn't be inserted into map!";
        int BucketNo = this.getHashValue(Key) & NumBuckets - 1;
        int ProbeAmt = 1;
        while (true) {
            std_pair.pair<KeyT, ValueT> ThisBucket = Buckets[BucketNo];
            if (ThisBucket.first == EmptyKey) {
                int Bucket2;
                if (onlyExisting) {
                    return Integer.MAX_VALUE;
                }
                int n = Bucket2 = FoundTombstone != Integer.MAX_VALUE ? FoundTombstone : BucketNo;
                assert (Bucket2 >= 0 && Bucket2 != Integer.MAX_VALUE);
                return Bucket2 | Integer.MIN_VALUE;
            }
            if (ThisBucket.first == TombstoneKey) {
                if (FoundTombstone == Integer.MAX_VALUE) {
                    FoundTombstone = BucketNo;
                }
            } else if (this.keyInfoT.isEqual(Key, ThisBucket.first)) {
                return BucketNo;
            }
            BucketNo += ProbeAmt++;
            BucketNo &= NumBuckets - 1;
        }
    }

    private <LookupKeyT> int LookupBucketForAltKey(LookupKeyT AltKey, boolean onlyExisting) {
        int NumBuckets = this.getNumBuckets();
        if (NumBuckets == 0) {
            if (onlyExisting) {
                return Integer.MAX_VALUE;
            }
            return Integer.MIN_VALUE;
        }
        std_pair.pair<KeyT, ValueT>[] Buckets = this.$Buckets();
        int FoundTombstone = Integer.MAX_VALUE;
        Object EmptyKey = this.getEmptyKey();
        Object TombstoneKey = this.getTombstoneKey();
        int BucketNo = this.getHashValueAlt(AltKey) & NumBuckets - 1;
        int ProbeAmt = 1;
        while (true) {
            std_pair.pair<KeyT, ValueT> ThisBucket = Buckets[BucketNo];
            if (ThisBucket.first == EmptyKey) {
                int Bucket2;
                if (onlyExisting) {
                    return Integer.MAX_VALUE;
                }
                int n = Bucket2 = FoundTombstone != Integer.MAX_VALUE ? FoundTombstone : BucketNo;
                assert (Bucket2 >= 0 && Bucket2 != Integer.MAX_VALUE);
                return Bucket2 | Integer.MIN_VALUE;
            }
            if (ThisBucket.first == TombstoneKey) {
                if (FoundTombstone == Integer.MAX_VALUE) {
                    FoundTombstone = BucketNo;
                }
            } else if (this.keyInfoT.isEqualAlt(AltKey, ThisBucket.first)) {
                return BucketNo;
            }
            BucketNo += ProbeAmt++;
            BucketNo &= NumBuckets - 1;
        }
    }

    public int getMemorySize() {
        assert (this.checkAlive());
        return this.getNumBuckets() * NativeType.sizeof(type.ptr.class);
    }

    public int $sizeof() {
        assert (this.checkAlive());
        return this.getMemorySize();
    }

    protected final boolean isDataPointerLike() {
        return this.defaultValue == null;
    }

    protected final boolean isKeyPointerLike() {
        return this.keyInfoT.isKeyPointerLike();
    }

    protected String BucketsToString(std_pair.pair<KeyT, ValueT>[] Buckets) {
        String destroyed;
        String string2 = destroyed = this.is$destroyed() ? "DESTROYED" : "";
        if (Buckets == null) {
            return destroyed + "<null>";
        }
        int idx = 0;
        StringBuilder out = new StringBuilder(destroyed);
        for (std_pair.pair<KeyT, ValueT> Bucket2 : Buckets) {
            if (Bucket2.first == this.getTombstoneKey() || Bucket2.first == this.getEmptyKey()) continue;
            DenseMapBase.BucketToString(out, idx, Bucket2, this.isKeyPointerLike(), this.isDataPointerLike());
        }
        return out.toString();
    }

    protected static void BucketToString(StringBuilder out, int idx, std_pair.pair Bucket2, boolean isKeyPointerLike, boolean isDataPointerLike) {
        out.append("\n[").append(NativeTrace.formatNumber((long)idx++, (int)2)).append("]");
        out.append("{").append(isKeyPointerLike ? NativeTrace.getIdentityStr((Object)Bucket2.first) : "" + Bucket2.first);
        out.append("}=>{").append(isDataPointerLike ? NativeTrace.getIdentityStr((Object)Bucket2.second) : "" + Bucket2.second);
        out.append("}");
    }

    protected final boolean checkAlive() {
        return this.check$Alive();
    }
}

