/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMemory;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.uint;
import org.clank.support.aliases.ushort;
import org.llvm.adt.NoneType;
import org.llvm.adt.aliases.SmallVectorImplUShort;
import org.llvm.support.llvm;

public class ArrayRefUShort
implements Iterable<Character>,
Native.NativePOD<ArrayRefUShort>,
Native.NativeIterable<ushort.ptr>,
Native.NativeReverseIterable<std.reverse_iteratorUShort>,
NativeMoveable<ArrayRefUShort> {
    private static final ArrayRefUShort NONE;
    private ushort.ptr Data;
    private int Length;
    protected final boolean isDataPointerLike;
    private static final ArrayRefIterator EMPTY;

    public static ArrayRefUShort None() {
        return NONE;
    }

    public ArrayRefUShort move() {
        return new ArrayRefUShort(JavaDifferentiators.JD.Move.INSTANCE, this);
    }

    public ArrayRefUShort() {
        this(false);
    }

    public ArrayRefUShort(boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_ushort$ptr((char[])null);
        this.Length = 0;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefUShort(NoneType $Prm0) {
        this($Prm0, false);
    }

    public ArrayRefUShort(NoneType $Prm0, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_ushort$ptr((char[])null);
        this.Length = 0;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefUShort(char OneElt) {
        this(OneElt, false);
    }

    public ArrayRefUShort(char OneElt, int len, boolean isDataPointerLike) {
        this(OneElt, isDataPointerLike);
        assert (len == 1) : "you meant call to ArrayRefUShort(/*const*/ushort$ptr /*P*/ data, int len, boolean isDataPointerLike)?";
    }

    public ArrayRefUShort(char OneElt, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_ushort$ptr((char[])NativePointer.new$ushort$elem((char)OneElt));
        this.Length = 1;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefUShort(char[] data, int length) {
        this(data, length, false);
    }

    public ArrayRefUShort(char[] data, int length, boolean isDataPointerLike) {
        this(NativePointer.create_const_ushort$ptr((char[])data), length, isDataPointerLike);
    }

    public ArrayRefUShort(ushort.ptr data, int length) {
        this(data, length, false);
    }

    public ArrayRefUShort(ushort.ptr data, int length, boolean isDataPointerLike) {
        this.Data = (ushort.ptr)Native.$tryConstClone((Object)data);
        this.Length = length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefUShort(ushort.ptr begin, ushort.ptr end) {
        this(begin, end, false);
    }

    public ArrayRefUShort(ushort.ptr begin, ushort.ptr end, boolean isDataPointerLike) {
        this.Data = (ushort.ptr)Native.$tryConstClone((Object)begin);
        this.Length = std.distance((abstract_iterator)begin, (abstract_iterator)end);
        this.isDataPointerLike = isDataPointerLike;
    }

    public <U> ArrayRefUShort(SmallVectorImplUShort Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public <U> ArrayRefUShort(SmallVectorImplUShort Vec, boolean isDataPointerLike) {
        this.Data = (ushort.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public <A> ArrayRefUShort(std.vectorUShort Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public <A> ArrayRefUShort(std.vectorUShort Vec, boolean isDataPointerLike) {
        this.Data = (ushort.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public ArrayRefUShort(std.vectorString Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public ArrayRefUShort(std.vectorString Vec, boolean isDataPointerLike) {
        this.Data = (ushort.ptr)Native.$tryConstClone((Object)((ushort.ptr)Vec.data()));
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
        assert (!isDataPointerLike);
    }

    public ArrayRefUShort(char[] Arr) {
        this(Arr, false);
    }

    public ArrayRefUShort(char[] Arr, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_ushort$ptr((char[])Arr);
        this.Length = Arr.length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefUShort(ArrayRefUShort other) {
        this.Data = (ushort.ptr)Native.$tryConstClone((Object)other.Data);
        this.Length = other.size();
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public ArrayRefUShort(JavaDifferentiators.JD.Convertible _param, ArrayRefUShort other, boolean isDataPointerLike) {
        this.Data = (ushort.ptr)Native.$tryConstClone((Object)other.Data);
        this.Length = other.size();
        assert (other.isDataPointerLike == isDataPointerLike);
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public ArrayRefUShort(JavaDifferentiators.JD.Convertible _param, SmallVectorImplUShort Vec, boolean isDataPointerLike) {
        this.Data = (ushort.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public ArrayRefUShort(JavaDifferentiators.JD.Move _dparam, ArrayRefUShort other) {
        assert (other != NONE) : "use new ArrayRefUShort<>(true/false) instead?";
        this.Data = other.Data;
        this.Length = other.Length;
        this.isDataPointerLike = other.isDataPointerLike;
        other.Data = null;
        other.Length = 0;
    }

    public ushort.ptr begin() {
        return this.Data;
    }

    public ushort.ptr end() {
        return this.Length == 0 ? this.Data : (ushort.ptr)this.Data.$add(this.Length);
    }

    public std.reverse_iteratorUShort rbegin() {
        return new std.reverse_iteratorUShort((ushort.iterator)this.end());
    }

    public std.reverse_iteratorUShort rend() {
        return new std.reverse_iteratorUShort((ushort.iterator)this.begin());
    }

    public boolean empty() {
        return this.Length == 0;
    }

    public ushort.ptr data() {
        return this.Data;
    }

    public int size() {
        return this.Length;
    }

    public char front() {
        return this.Data.$at(0);
    }

    public char back() {
        return this.Data.$at(this.Length - 1);
    }

    public ArrayRefUShort copy(Class<Character> cls, NativeMemory.Allocator A) {
        ushort.ptr Buff = NativePointer.create_const_ushort$ptr((char[])NativePointer.new$ushort(cls, (int)this.Length));
        std.copy((ushort.iterator)this.begin(), (ushort.iterator)this.end(), (ushort.iterator)Buff);
        return new ArrayRefUShort(Buff, this.Length, this.isDataPointerLike);
    }

    public boolean equals(ArrayRefUShort RHS) {
        if (Native.$noteq((int)this.Length, (int)RHS.Length)) {
            return false;
        }
        ushort.ptr L = (ushort.ptr)Native.$tryClone((NativeCloneable)this.begin());
        ushort.ptr LE = this.end();
        ushort.ptr R2 = (ushort.ptr)Native.$tryClone((NativeCloneable)RHS.begin());
        while (L.$noteq((Object)LE)) {
            if (!Native.$eq((char)L.$star(), (char)R2.$star(), (boolean)this.isDataPointerLike)) {
                return false;
            }
            L.$preInc();
            R2.$preInc();
        }
        return true;
    }

    public ArrayRefUShort slice(int N) {
        return new ArrayRefUShort((ushort.ptr)this.data().$add(N), this.size() - N, this.isDataPointerLike);
    }

    public ArrayRefUShort slice(int N, int M) {
        return new ArrayRefUShort((ushort.ptr)this.data().$add(N), M, this.isDataPointerLike);
    }

    public ArrayRefUShort drop_back() {
        return this.drop_back(1);
    }

    public ArrayRefUShort drop_back(int N) {
        assert (this.size() >= N) : "Dropping more elements than exist";
        return this.slice(0, this.size() - N);
    }

    public char $at(int Index) {
        return this.Data.$at(Index);
    }

    public char $at(uint.ref Index) {
        return this.Data.$at(Index.$deref());
    }

    public ushort.ptr ptr$at(uint.ref Index) {
        return this.ptr$at(Index.$deref());
    }

    public ushort.ptr ptr$at(int Index) {
        return Index == 0 ? this.Data : (ushort.ptr)this.Data.$add(Index);
    }

    public ushort.ref ref$at(uint.ref Index) {
        return this.ref$at(Index.$deref());
    }

    public ushort.ref ref$at(int Index) {
        return ((ushort.ptr)this.Data.$add(Index)).star$ref();
    }

    public std.vectorUShort vec() {
        return new std.vectorUShort((ushort.iterator)this.Data, (ushort.iterator)this.end(), '\u0000');
    }

    public std.vectorUShort $vector() {
        return new std.vectorUShort((ushort.iterator)this.Data, (ushort.iterator)this.end(), '\u0000');
    }

    public boolean equals(TRefOrNothing ... Args) {
        if (Args.length > 16) {
            throw new IllegalArgumentException("Too many arguments passed!");
        }
        if (this.size() != llvm.array_lengthof(Args)) {
            return false;
        }
        int e = this.size();
        for (int i = 0; i != e; ++i) {
            if (!Native.$noteq((char)this.$at(i), (char)Args[i].TPtr, (boolean)this.isDataPointerLike)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.Length == 0) {
            return "<Empty>";
        }
        StringBuilder out = new StringBuilder("\nArRef{");
        String fmt = "%" + (int)Math.ceil(Math.log10(this.Length + 1)) + "d";
        for (int i = 0; i < this.Length; ++i) {
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append("{").append(this.$at(i)).append("}\n");
        }
        out.append("}ArRef\n");
        return out.toString();
    }

    public ArrayRefUShort $assign(ArrayRefUShort other) {
        this.Data = other.Data;
        this.Length = other.Length;
        return this;
    }

    public ArrayRefUShort $assignMove(ArrayRefUShort other) {
        assert (other != NONE) : "use new ArrayRefUShort<>(" + this.isDataPointerLike + ") instead?";
        assert (this.isDataPointerLike == other.isDataPointerLike);
        ushort.ptr DataTmp = this.Data;
        int LengthTmp = this.Length;
        this.Data = other.Data;
        this.Length = other.Length;
        other.Data = null;
        other.Length = 0;
        return this;
    }

    public ArrayRefUShort clone() {
        if (this.getClass() != ArrayRefUShort.class) {
            throw new UnsupportedOperationException("Must be overridden in derived " + this.getClass());
        }
        return new ArrayRefUShort(this);
    }

    public boolean $eq(ArrayRefUShort other) {
        return this.equals(other);
    }

    @Override
    public Iterator<Character> iterator() {
        return this.Length == 0 ? EMPTY : new ArrayRefIterator(this.Data, this.Length);
    }

    static {
        ArrayRefUShort obj;
        NONE = obj = new ArrayRefUShort(NoneType.None);
        EMPTY = new ArrayRefIterator(null, 0);
    }

    private static final class ArrayRefIterator
    implements Iterator<Character> {
        private final ushort.ptr localData;
        private final int localLength;
        private int pos = 0;

        public ArrayRefIterator(ushort.ptr Data, int Length) {
            this.localData = (ushort.ptr)Native.$tryClone((NativeCloneable)Data);
            this.localLength = Length;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.localLength;
        }

        @Override
        public Character next() {
            Character val = Character.valueOf(this.localData.$star());
            this.localData.$preInc();
            ++this.pos;
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static class TRefOrNothing {
        public char TPtr;

        public TRefOrNothing() {
            this.TPtr = '\u0000';
        }

        public TRefOrNothing(char TRef) {
            this.TPtr = TRef;
        }

        public String toString() {
            return "TPtr=" + this.TPtr;
        }
    }
}

