/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMemory;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.uint;
import org.clank.support.aliases.ulong;
import org.llvm.adt.NoneType;
import org.llvm.adt.aliases.SmallVectorImplULong;
import org.llvm.support.llvm;

public class ArrayRefULong
implements Iterable<Long>,
Native.NativePOD<ArrayRefULong>,
Native.NativeIterable<ulong.ptr>,
Native.NativeReverseIterable<std.reverse_iteratorULong>,
NativeMoveable<ArrayRefULong> {
    private static final ArrayRefULong NONE;
    private ulong.ptr Data;
    private int Length;
    protected final boolean isDataPointerLike;
    private static final ArrayRefIterator EMPTY;

    public static ArrayRefULong None() {
        return NONE;
    }

    public ArrayRefULong move() {
        return new ArrayRefULong(JavaDifferentiators.JD.Move.INSTANCE, this);
    }

    public ArrayRefULong() {
        this(false);
    }

    public ArrayRefULong(boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_ulong$ptr((long[])null);
        this.Length = 0;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefULong(NoneType $Prm0) {
        this($Prm0, false);
    }

    public ArrayRefULong(NoneType $Prm0, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_ulong$ptr((long[])null);
        this.Length = 0;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefULong(long OneElt) {
        this(OneElt, false);
    }

    public ArrayRefULong(long OneElt, int len, boolean isDataPointerLike) {
        this(OneElt, isDataPointerLike);
        assert (len == 1) : "you meant call to ArrayRefULong(/*const*/ulong$ptr /*P*/ data, int len, boolean isDataPointerLike)?";
    }

    public ArrayRefULong(long OneElt, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_ulong$ptr((long[])NativePointer.new$ulong$elem((long)OneElt));
        this.Length = 1;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefULong(long[] data, int length) {
        this(data, length, false);
    }

    public ArrayRefULong(long[] data, int length, boolean isDataPointerLike) {
        this(NativePointer.create_const_ulong$ptr((long[])data), length, isDataPointerLike);
    }

    public ArrayRefULong(ulong.ptr data, int length) {
        this(data, length, false);
    }

    public ArrayRefULong(ulong.ptr data, int length, boolean isDataPointerLike) {
        this.Data = (ulong.ptr)Native.$tryConstClone((Object)data);
        this.Length = length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefULong(ulong.ptr begin, ulong.ptr end) {
        this(begin, end, false);
    }

    public ArrayRefULong(ulong.ptr begin, ulong.ptr end, boolean isDataPointerLike) {
        this.Data = (ulong.ptr)Native.$tryConstClone((Object)begin);
        this.Length = std.distance((abstract_iterator)begin, (abstract_iterator)end);
        this.isDataPointerLike = isDataPointerLike;
    }

    public <U> ArrayRefULong(SmallVectorImplULong Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public <U> ArrayRefULong(SmallVectorImplULong Vec, boolean isDataPointerLike) {
        this.Data = (ulong.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public <A> ArrayRefULong(std.vectorULong Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public <A> ArrayRefULong(std.vectorULong Vec, boolean isDataPointerLike) {
        this.Data = (ulong.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public ArrayRefULong(std.vectorString Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public ArrayRefULong(std.vectorString Vec, boolean isDataPointerLike) {
        this.Data = (ulong.ptr)Native.$tryConstClone((Object)((ulong.ptr)Vec.data()));
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
        assert (!isDataPointerLike);
    }

    public ArrayRefULong(long[] Arr) {
        this(Arr, false);
    }

    public ArrayRefULong(long[] Arr, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_ulong$ptr((long[])Arr);
        this.Length = Arr.length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefULong(ArrayRefULong other) {
        this.Data = (ulong.ptr)Native.$tryConstClone((Object)other.Data);
        this.Length = other.size();
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public ArrayRefULong(JavaDifferentiators.JD.Convertible _param, ArrayRefULong other, boolean isDataPointerLike) {
        this.Data = (ulong.ptr)Native.$tryConstClone((Object)other.Data);
        this.Length = other.size();
        assert (other.isDataPointerLike == isDataPointerLike);
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public ArrayRefULong(JavaDifferentiators.JD.Convertible _param, SmallVectorImplULong Vec, boolean isDataPointerLike) {
        this.Data = (ulong.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public ArrayRefULong(JavaDifferentiators.JD.Move _dparam, ArrayRefULong other) {
        assert (other != NONE) : "use new ArrayRefULong<>(true/false) instead?";
        this.Data = other.Data;
        this.Length = other.Length;
        this.isDataPointerLike = other.isDataPointerLike;
        other.Data = null;
        other.Length = 0;
    }

    public ulong.ptr begin() {
        return this.Data;
    }

    public ulong.ptr end() {
        return this.Length == 0 ? this.Data : (ulong.ptr)this.Data.$add(this.Length);
    }

    public std.reverse_iteratorULong rbegin() {
        return new std.reverse_iteratorULong((ulong.iterator)this.end());
    }

    public std.reverse_iteratorULong rend() {
        return new std.reverse_iteratorULong((ulong.iterator)this.begin());
    }

    public boolean empty() {
        return this.Length == 0;
    }

    public ulong.ptr data() {
        return this.Data;
    }

    public int size() {
        return this.Length;
    }

    public long front() {
        return this.Data.$at(0);
    }

    public long back() {
        return this.Data.$at(this.Length - 1);
    }

    public ArrayRefULong copy(Class<Long> cls, NativeMemory.Allocator A) {
        ulong.ptr Buff = NativePointer.create_const_ulong$ptr((long[])NativePointer.new$ulong(cls, (int)this.Length));
        std.copy((ulong.iterator)this.begin(), (ulong.iterator)this.end(), (ulong.iterator)Buff);
        return new ArrayRefULong(Buff, this.Length, this.isDataPointerLike);
    }

    public boolean equals(ArrayRefULong RHS) {
        if (Native.$noteq((int)this.Length, (int)RHS.Length)) {
            return false;
        }
        ulong.ptr L = (ulong.ptr)Native.$tryClone((NativeCloneable)this.begin());
        ulong.ptr LE = this.end();
        ulong.ptr R2 = (ulong.ptr)Native.$tryClone((NativeCloneable)RHS.begin());
        while (L.$noteq((Object)LE)) {
            if (!Native.$eq((long)L.$star(), (long)R2.$star(), (boolean)this.isDataPointerLike)) {
                return false;
            }
            L.$preInc();
            R2.$preInc();
        }
        return true;
    }

    public ArrayRefULong slice(int N) {
        return new ArrayRefULong((ulong.ptr)this.data().$add(N), this.size() - N, this.isDataPointerLike);
    }

    public ArrayRefULong slice(int N, int M) {
        return new ArrayRefULong((ulong.ptr)this.data().$add(N), M, this.isDataPointerLike);
    }

    public ArrayRefULong drop_back() {
        return this.drop_back(1);
    }

    public ArrayRefULong drop_back(int N) {
        assert (this.size() >= N) : "Dropping more elements than exist";
        return this.slice(0, this.size() - N);
    }

    public long $at(int Index) {
        return this.Data.$at(Index);
    }

    public long $at(uint.ref Index) {
        return this.Data.$at(Index.$deref());
    }

    public ulong.ptr ptr$at(uint.ref Index) {
        return this.ptr$at(Index.$deref());
    }

    public ulong.ptr ptr$at(int Index) {
        return Index == 0 ? this.Data : (ulong.ptr)this.Data.$add(Index);
    }

    public ulong.ref ref$at(uint.ref Index) {
        return this.ref$at(Index.$deref());
    }

    public ulong.ref ref$at(int Index) {
        return ((ulong.ptr)this.Data.$add(Index)).star$ref();
    }

    public std.vectorULong vec() {
        return new std.vectorULong((ulong.iterator)this.Data, (ulong.iterator)this.end(), 0L);
    }

    public std.vectorULong $vector() {
        return new std.vectorULong((ulong.iterator)this.Data, (ulong.iterator)this.end(), 0L);
    }

    public boolean equals(TRefOrNothing ... Args) {
        if (Args.length > 16) {
            throw new IllegalArgumentException("Too many arguments passed!");
        }
        if (this.size() != llvm.array_lengthof(Args)) {
            return false;
        }
        int e = this.size();
        for (int i = 0; i != e; ++i) {
            if (!Native.$noteq((long)this.$at(i), (long)Args[i].TPtr, (boolean)this.isDataPointerLike)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.Length == 0) {
            return "<Empty>";
        }
        StringBuilder out = new StringBuilder("\nArRef{");
        String fmt = "%" + (int)Math.ceil(Math.log10(this.Length + 1)) + "d";
        for (int i = 0; i < this.Length; ++i) {
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append("{").append(this.$at(i)).append("}\n");
        }
        out.append("}ArRef\n");
        return out.toString();
    }

    public ArrayRefULong $assign(ArrayRefULong other) {
        this.Data = other.Data;
        this.Length = other.Length;
        return this;
    }

    public ArrayRefULong $assignMove(ArrayRefULong other) {
        assert (other != NONE) : "use new ArrayRefULong<>(" + this.isDataPointerLike + ") instead?";
        assert (this.isDataPointerLike == other.isDataPointerLike);
        ulong.ptr DataTmp = this.Data;
        int LengthTmp = this.Length;
        this.Data = other.Data;
        this.Length = other.Length;
        other.Data = null;
        other.Length = 0;
        return this;
    }

    public ArrayRefULong clone() {
        if (this.getClass() != ArrayRefULong.class) {
            throw new UnsupportedOperationException("Must be overridden in derived " + this.getClass());
        }
        return new ArrayRefULong(this);
    }

    public boolean $eq(ArrayRefULong other) {
        return this.equals(other);
    }

    @Override
    public Iterator<Long> iterator() {
        return this.Length == 0 ? EMPTY : new ArrayRefIterator(this.Data, this.Length);
    }

    static {
        ArrayRefULong obj;
        NONE = obj = new ArrayRefULong(NoneType.None);
        EMPTY = new ArrayRefIterator(null, 0);
    }

    private static final class ArrayRefIterator
    implements Iterator<Long> {
        private final ulong.ptr localData;
        private final int localLength;
        private int pos = 0;

        public ArrayRefIterator(ulong.ptr Data, int Length) {
            this.localData = (ulong.ptr)Native.$tryClone((NativeCloneable)Data);
            this.localLength = Length;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.localLength;
        }

        @Override
        public Long next() {
            Long val = this.localData.$star();
            this.localData.$preInc();
            ++this.pos;
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static class TRefOrNothing {
        public long TPtr;

        public TRefOrNothing() {
            this.TPtr = 0L;
        }

        public TRefOrNothing(long TRef) {
            this.TPtr = TRef;
        }

        public String toString() {
            return "TPtr=" + this.TPtr;
        }
    }
}

