/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMemory;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.uint;
import org.llvm.adt.NoneType;
import org.llvm.adt.aliases.SmallVectorImplUInt;
import org.llvm.support.llvm;

public class ArrayRefUInt
implements Iterable<Integer>,
Native.NativePOD<ArrayRefUInt>,
Native.NativeIterable<uint.ptr>,
Native.NativeReverseIterable<std.reverse_iteratorUInt>,
NativeMoveable<ArrayRefUInt> {
    private static final ArrayRefUInt NONE;
    private uint.ptr Data;
    private int Length;
    protected final boolean isDataPointerLike;
    private static final ArrayRefIterator EMPTY;

    public static ArrayRefUInt None() {
        return NONE;
    }

    public ArrayRefUInt move() {
        return new ArrayRefUInt(JavaDifferentiators.JD.Move.INSTANCE, this);
    }

    public ArrayRefUInt() {
        this(false);
    }

    public ArrayRefUInt(boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_uint$ptr((int[])null);
        this.Length = 0;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefUInt(NoneType $Prm0) {
        this($Prm0, false);
    }

    public ArrayRefUInt(NoneType $Prm0, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_uint$ptr((int[])null);
        this.Length = 0;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefUInt(int OneElt) {
        this(OneElt, false);
    }

    public ArrayRefUInt(int OneElt, int len, boolean isDataPointerLike) {
        this(OneElt, isDataPointerLike);
        assert (len == 1) : "you meant call to ArrayRefUInt(/*const*/uint$ptr /*P*/ data, int len, boolean isDataPointerLike)?";
    }

    public ArrayRefUInt(int OneElt, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_uint$ptr((int[])NativePointer.new$uint$elem((int)OneElt));
        this.Length = 1;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefUInt(int[] data, int length) {
        this(data, length, false);
    }

    public ArrayRefUInt(int[] data, int length, boolean isDataPointerLike) {
        this(NativePointer.create_const_uint$ptr((int[])data), length, isDataPointerLike);
    }

    public ArrayRefUInt(uint.ptr data, int length) {
        this(data, length, false);
    }

    public ArrayRefUInt(uint.ptr data, int length, boolean isDataPointerLike) {
        this.Data = (uint.ptr)Native.$tryConstClone((Object)data);
        this.Length = length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefUInt(uint.ptr begin, uint.ptr end) {
        this(begin, end, false);
    }

    public ArrayRefUInt(uint.ptr begin, uint.ptr end, boolean isDataPointerLike) {
        this.Data = (uint.ptr)Native.$tryConstClone((Object)begin);
        this.Length = std.distance((abstract_iterator)begin, (abstract_iterator)end);
        this.isDataPointerLike = isDataPointerLike;
    }

    public <U> ArrayRefUInt(SmallVectorImplUInt Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public <U> ArrayRefUInt(SmallVectorImplUInt Vec, boolean isDataPointerLike) {
        this.Data = (uint.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public <A> ArrayRefUInt(std.vectorUInt Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public <A> ArrayRefUInt(std.vectorUInt Vec, boolean isDataPointerLike) {
        this.Data = (uint.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public ArrayRefUInt(std.vectorString Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public ArrayRefUInt(std.vectorString Vec, boolean isDataPointerLike) {
        this.Data = (uint.ptr)Native.$tryConstClone((Object)((uint.ptr)Vec.data()));
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
        assert (!isDataPointerLike);
    }

    public ArrayRefUInt(int[] Arr) {
        this(Arr, false);
    }

    public ArrayRefUInt(int[] Arr, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_uint$ptr((int[])Arr);
        this.Length = Arr.length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefUInt(ArrayRefUInt other) {
        this.Data = (uint.ptr)Native.$tryConstClone((Object)other.Data);
        this.Length = other.size();
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public ArrayRefUInt(JavaDifferentiators.JD.Convertible _param, ArrayRefUInt other, boolean isDataPointerLike) {
        this.Data = (uint.ptr)Native.$tryConstClone((Object)other.Data);
        this.Length = other.size();
        assert (other.isDataPointerLike == isDataPointerLike);
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public ArrayRefUInt(JavaDifferentiators.JD.Convertible _param, SmallVectorImplUInt Vec, boolean isDataPointerLike) {
        this.Data = (uint.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public ArrayRefUInt(JavaDifferentiators.JD.Move _dparam, ArrayRefUInt other) {
        assert (other != NONE) : "use new ArrayRefUInt<>(true/false) instead?";
        this.Data = other.Data;
        this.Length = other.Length;
        this.isDataPointerLike = other.isDataPointerLike;
        other.Data = null;
        other.Length = 0;
    }

    public uint.ptr begin() {
        return this.Data;
    }

    public uint.ptr end() {
        return this.Length == 0 ? this.Data : (uint.ptr)this.Data.$add(this.Length);
    }

    public std.reverse_iteratorUInt rbegin() {
        return new std.reverse_iteratorUInt((uint.iterator)this.end());
    }

    public std.reverse_iteratorUInt rend() {
        return new std.reverse_iteratorUInt((uint.iterator)this.begin());
    }

    public boolean empty() {
        return this.Length == 0;
    }

    public uint.ptr data() {
        return this.Data;
    }

    public int size() {
        return this.Length;
    }

    public int front() {
        return this.Data.$at(0);
    }

    public int back() {
        return this.Data.$at(this.Length - 1);
    }

    public ArrayRefUInt copy(Class<Integer> cls, NativeMemory.Allocator A) {
        uint.ptr Buff = NativePointer.create_const_uint$ptr((int[])NativePointer.new$uint(cls, (int)this.Length));
        std.copy((uint.iterator)this.begin(), (uint.iterator)this.end(), (uint.iterator)Buff);
        return new ArrayRefUInt(Buff, this.Length, this.isDataPointerLike);
    }

    public boolean equals(ArrayRefUInt RHS) {
        if (Native.$noteq((int)this.Length, (int)RHS.Length)) {
            return false;
        }
        uint.ptr L = (uint.ptr)Native.$tryClone((NativeCloneable)this.begin());
        uint.ptr LE = this.end();
        uint.ptr R2 = (uint.ptr)Native.$tryClone((NativeCloneable)RHS.begin());
        while (L.$noteq((Object)LE)) {
            if (!Native.$eq((int)L.$star(), (int)R2.$star(), (boolean)this.isDataPointerLike)) {
                return false;
            }
            L.$preInc();
            R2.$preInc();
        }
        return true;
    }

    public ArrayRefUInt slice(int N) {
        return new ArrayRefUInt((uint.ptr)this.data().$add(N), this.size() - N, this.isDataPointerLike);
    }

    public ArrayRefUInt slice(int N, int M) {
        return new ArrayRefUInt((uint.ptr)this.data().$add(N), M, this.isDataPointerLike);
    }

    public ArrayRefUInt drop_back() {
        return this.drop_back(1);
    }

    public ArrayRefUInt drop_back(int N) {
        assert (this.size() >= N) : "Dropping more elements than exist";
        return this.slice(0, this.size() - N);
    }

    public int $at(int Index) {
        return this.Data.$at(Index);
    }

    public int $at(uint.ref Index) {
        return this.Data.$at(Index.$deref());
    }

    public uint.ptr ptr$at(uint.ref Index) {
        return this.ptr$at(Index.$deref());
    }

    public uint.ptr ptr$at(int Index) {
        return Index == 0 ? this.Data : (uint.ptr)this.Data.$add(Index);
    }

    public uint.ref ref$at(uint.ref Index) {
        return this.ref$at(Index.$deref());
    }

    public uint.ref ref$at(int Index) {
        return ((uint.ptr)this.Data.$add(Index)).star$ref();
    }

    public std.vectorUInt vec() {
        return new std.vectorUInt((uint.iterator)this.Data, (uint.iterator)this.end(), 0);
    }

    public std.vectorUInt $vector() {
        return new std.vectorUInt((uint.iterator)this.Data, (uint.iterator)this.end(), 0);
    }

    public boolean equals(TRefOrNothing ... Args) {
        if (Args.length > 16) {
            throw new IllegalArgumentException("Too many arguments passed!");
        }
        if (this.size() != llvm.array_lengthof(Args)) {
            return false;
        }
        int e = this.size();
        for (int i = 0; i != e; ++i) {
            if (!Native.$noteq((int)this.$at(i), (int)Args[i].TPtr, (boolean)this.isDataPointerLike)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.Length == 0) {
            return "<Empty>";
        }
        StringBuilder out = new StringBuilder("\nArRef{");
        String fmt = "%" + (int)Math.ceil(Math.log10(this.Length + 1)) + "d";
        for (int i = 0; i < this.Length; ++i) {
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append("{").append(this.$at(i)).append("}\n");
        }
        out.append("}ArRef\n");
        return out.toString();
    }

    public ArrayRefUInt $assign(ArrayRefUInt other) {
        this.Data = other.Data;
        this.Length = other.Length;
        return this;
    }

    public ArrayRefUInt $assignMove(ArrayRefUInt other) {
        assert (other != NONE) : "use new ArrayRefUInt<>(" + this.isDataPointerLike + ") instead?";
        assert (this.isDataPointerLike == other.isDataPointerLike);
        uint.ptr DataTmp = this.Data;
        int LengthTmp = this.Length;
        this.Data = other.Data;
        this.Length = other.Length;
        other.Data = null;
        other.Length = 0;
        return this;
    }

    public ArrayRefUInt clone() {
        if (this.getClass() != ArrayRefUInt.class) {
            throw new UnsupportedOperationException("Must be overridden in derived " + this.getClass());
        }
        return new ArrayRefUInt(this);
    }

    public boolean $eq(ArrayRefUInt other) {
        return this.equals(other);
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.Length == 0 ? EMPTY : new ArrayRefIterator(this.Data, this.Length);
    }

    static {
        ArrayRefUInt obj;
        NONE = obj = new ArrayRefUInt(NoneType.None);
        EMPTY = new ArrayRefIterator(null, 0);
    }

    private static final class ArrayRefIterator
    implements Iterator<Integer> {
        private final uint.ptr localData;
        private final int localLength;
        private int pos = 0;

        public ArrayRefIterator(uint.ptr Data, int Length) {
            this.localData = (uint.ptr)Native.$tryClone((NativeCloneable)Data);
            this.localLength = Length;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.localLength;
        }

        @Override
        public Integer next() {
            Integer val = this.localData.$star();
            this.localData.$preInc();
            ++this.pos;
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static class TRefOrNothing {
        public int TPtr;

        public TRefOrNothing() {
            this.TPtr = 0;
        }

        public TRefOrNothing(int TRef) {
            this.TPtr = TRef;
        }

        public String toString() {
            return "TPtr=" + this.TPtr;
        }
    }
}

