/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMemory;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.long;
import org.clank.support.aliases.uint;
import org.llvm.adt.NoneType;
import org.llvm.adt.aliases.SmallVectorImplLong;
import org.llvm.support.llvm;

public class ArrayRefLong
implements Iterable<Long>,
Native.NativePOD<ArrayRefLong>,
Native.NativeIterable<long.ptr>,
Native.NativeReverseIterable<std.reverse_iteratorLong>,
NativeMoveable<ArrayRefLong> {
    private static final ArrayRefLong NONE;
    private long.ptr Data;
    private int Length;
    protected final boolean isDataPointerLike;
    private static final ArrayRefIterator EMPTY;

    public static ArrayRefLong None() {
        return NONE;
    }

    public ArrayRefLong move() {
        return new ArrayRefLong(JavaDifferentiators.JD.Move.INSTANCE, this);
    }

    public ArrayRefLong() {
        this(false);
    }

    public ArrayRefLong(boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_long$ptr((long[])null);
        this.Length = 0;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefLong(NoneType $Prm0) {
        this($Prm0, false);
    }

    public ArrayRefLong(NoneType $Prm0, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_long$ptr((long[])null);
        this.Length = 0;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefLong(long OneElt) {
        this(OneElt, false);
    }

    public ArrayRefLong(long OneElt, int len, boolean isDataPointerLike) {
        this(OneElt, isDataPointerLike);
        assert (len == 1) : "you meant call to ArrayRefLong(/*const*/long$ptr /*P*/ data, int len, boolean isDataPointerLike)?";
    }

    public ArrayRefLong(long OneElt, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_long$ptr((long[])NativePointer.new$long$elem((long)OneElt));
        this.Length = 1;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefLong(long[] data, int length) {
        this(data, length, false);
    }

    public ArrayRefLong(long[] data, int length, boolean isDataPointerLike) {
        this(NativePointer.create_const_long$ptr((long[])data), length, isDataPointerLike);
    }

    public ArrayRefLong(long.ptr data, int length) {
        this(data, length, false);
    }

    public ArrayRefLong(long.ptr data, int length, boolean isDataPointerLike) {
        this.Data = (long.ptr)Native.$tryConstClone((Object)data);
        this.Length = length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefLong(long.ptr begin, long.ptr end) {
        this(begin, end, false);
    }

    public ArrayRefLong(long.ptr begin, long.ptr end, boolean isDataPointerLike) {
        this.Data = (long.ptr)Native.$tryConstClone((Object)begin);
        this.Length = std.distance((abstract_iterator)begin, (abstract_iterator)end);
        this.isDataPointerLike = isDataPointerLike;
    }

    public <U> ArrayRefLong(SmallVectorImplLong Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public <U> ArrayRefLong(SmallVectorImplLong Vec, boolean isDataPointerLike) {
        this.Data = (long.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public <A> ArrayRefLong(std.vectorLong Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public <A> ArrayRefLong(std.vectorLong Vec, boolean isDataPointerLike) {
        this.Data = (long.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public ArrayRefLong(std.vectorString Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public ArrayRefLong(std.vectorString Vec, boolean isDataPointerLike) {
        this.Data = (long.ptr)Native.$tryConstClone((Object)((long.ptr)Vec.data()));
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
        assert (!isDataPointerLike);
    }

    public ArrayRefLong(long[] Arr) {
        this(Arr, false);
    }

    public ArrayRefLong(long[] Arr, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_long$ptr((long[])Arr);
        this.Length = Arr.length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefLong(ArrayRefLong other) {
        this.Data = (long.ptr)Native.$tryConstClone((Object)other.Data);
        this.Length = other.size();
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public ArrayRefLong(JavaDifferentiators.JD.Convertible _param, ArrayRefLong other, boolean isDataPointerLike) {
        this.Data = (long.ptr)Native.$tryConstClone((Object)other.Data);
        this.Length = other.size();
        assert (other.isDataPointerLike == isDataPointerLike);
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public ArrayRefLong(JavaDifferentiators.JD.Convertible _param, SmallVectorImplLong Vec, boolean isDataPointerLike) {
        this.Data = (long.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public ArrayRefLong(JavaDifferentiators.JD.Move _dparam, ArrayRefLong other) {
        assert (other != NONE) : "use new ArrayRefLong<>(true/false) instead?";
        this.Data = other.Data;
        this.Length = other.Length;
        this.isDataPointerLike = other.isDataPointerLike;
        other.Data = null;
        other.Length = 0;
    }

    public long.ptr begin() {
        return this.Data;
    }

    public long.ptr end() {
        return this.Length == 0 ? this.Data : (long.ptr)this.Data.$add(this.Length);
    }

    public std.reverse_iteratorLong rbegin() {
        return new std.reverse_iteratorLong((long.iterator)this.end());
    }

    public std.reverse_iteratorLong rend() {
        return new std.reverse_iteratorLong((long.iterator)this.begin());
    }

    public boolean empty() {
        return this.Length == 0;
    }

    public long.ptr data() {
        return this.Data;
    }

    public int size() {
        return this.Length;
    }

    public long front() {
        return this.Data.$at(0);
    }

    public long back() {
        return this.Data.$at(this.Length - 1);
    }

    public ArrayRefLong copy(Class<Long> cls, NativeMemory.Allocator A) {
        long.ptr Buff = NativePointer.create_const_long$ptr((long[])NativePointer.new$long(cls, (int)this.Length));
        std.copy((long.iterator)this.begin(), (long.iterator)this.end(), (long.iterator)Buff);
        return new ArrayRefLong(Buff, this.Length, this.isDataPointerLike);
    }

    public boolean equals(ArrayRefLong RHS) {
        if (Native.$noteq((int)this.Length, (int)RHS.Length)) {
            return false;
        }
        long.ptr L = (long.ptr)Native.$tryClone((NativeCloneable)this.begin());
        long.ptr LE = this.end();
        long.ptr R2 = (long.ptr)Native.$tryClone((NativeCloneable)RHS.begin());
        while (L.$noteq((Object)LE)) {
            if (!Native.$eq((long)L.$star(), (long)R2.$star(), (boolean)this.isDataPointerLike)) {
                return false;
            }
            L.$preInc();
            R2.$preInc();
        }
        return true;
    }

    public ArrayRefLong slice(int N) {
        return new ArrayRefLong((long.ptr)this.data().$add(N), this.size() - N, this.isDataPointerLike);
    }

    public ArrayRefLong slice(int N, int M) {
        return new ArrayRefLong((long.ptr)this.data().$add(N), M, this.isDataPointerLike);
    }

    public ArrayRefLong drop_back() {
        return this.drop_back(1);
    }

    public ArrayRefLong drop_back(int N) {
        assert (this.size() >= N) : "Dropping more elements than exist";
        return this.slice(0, this.size() - N);
    }

    public long $at(int Index) {
        return this.Data.$at(Index);
    }

    public long $at(uint.ref Index) {
        return this.Data.$at(Index.$deref());
    }

    public long.ptr ptr$at(uint.ref Index) {
        return this.ptr$at(Index.$deref());
    }

    public long.ptr ptr$at(int Index) {
        return Index == 0 ? this.Data : (long.ptr)this.Data.$add(Index);
    }

    public long.ref ref$at(uint.ref Index) {
        return this.ref$at(Index.$deref());
    }

    public long.ref ref$at(int Index) {
        return ((long.ptr)this.Data.$add(Index)).star$ref();
    }

    public std.vectorLong vec() {
        return new std.vectorLong((long.iterator)this.Data, (long.iterator)this.end(), 0L);
    }

    public std.vectorLong $vector() {
        return new std.vectorLong((long.iterator)this.Data, (long.iterator)this.end(), 0L);
    }

    public boolean equals(TRefOrNothing ... Args) {
        if (Args.length > 16) {
            throw new IllegalArgumentException("Too many arguments passed!");
        }
        if (this.size() != llvm.array_lengthof(Args)) {
            return false;
        }
        int e = this.size();
        for (int i = 0; i != e; ++i) {
            if (!Native.$noteq((long)this.$at(i), (long)Args[i].TPtr, (boolean)this.isDataPointerLike)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.Length == 0) {
            return "<Empty>";
        }
        StringBuilder out = new StringBuilder("\nArRef{");
        String fmt = "%" + (int)Math.ceil(Math.log10(this.Length + 1)) + "d";
        for (int i = 0; i < this.Length; ++i) {
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append("{").append(this.$at(i)).append("}\n");
        }
        out.append("}ArRef\n");
        return out.toString();
    }

    public ArrayRefLong $assign(ArrayRefLong other) {
        this.Data = other.Data;
        this.Length = other.Length;
        return this;
    }

    public ArrayRefLong $assignMove(ArrayRefLong other) {
        assert (other != NONE) : "use new ArrayRefLong<>(" + this.isDataPointerLike + ") instead?";
        assert (this.isDataPointerLike == other.isDataPointerLike);
        long.ptr DataTmp = this.Data;
        int LengthTmp = this.Length;
        this.Data = other.Data;
        this.Length = other.Length;
        other.Data = null;
        other.Length = 0;
        return this;
    }

    public ArrayRefLong clone() {
        if (this.getClass() != ArrayRefLong.class) {
            throw new UnsupportedOperationException("Must be overridden in derived " + this.getClass());
        }
        return new ArrayRefLong(this);
    }

    public boolean $eq(ArrayRefLong other) {
        return this.equals(other);
    }

    @Override
    public Iterator<Long> iterator() {
        return this.Length == 0 ? EMPTY : new ArrayRefIterator(this.Data, this.Length);
    }

    static {
        ArrayRefLong obj;
        NONE = obj = new ArrayRefLong(NoneType.None);
        EMPTY = new ArrayRefIterator(null, 0);
    }

    private static final class ArrayRefIterator
    implements Iterator<Long> {
        private final long.ptr localData;
        private final int localLength;
        private int pos = 0;

        public ArrayRefIterator(long.ptr Data, int Length) {
            this.localData = (long.ptr)Native.$tryClone((NativeCloneable)Data);
            this.localLength = Length;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.localLength;
        }

        @Override
        public Long next() {
            Long val = this.localData.$star();
            this.localData.$preInc();
            ++this.pos;
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static class TRefOrNothing {
        public long TPtr;

        public TRefOrNothing() {
            this.TPtr = 0L;
        }

        public TRefOrNothing(long TRef) {
            this.TPtr = TRef;
        }

        public String toString() {
            return "TPtr=" + this.TPtr;
        }
    }
}

