/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMemory;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.double;
import org.clank.support.aliases.uint;
import org.llvm.adt.NoneType;
import org.llvm.adt.aliases.SmallVectorImplDouble;
import org.llvm.support.llvm;

public class ArrayRefDouble
implements Iterable<Double>,
Native.NativePOD<ArrayRefDouble>,
Native.NativeIterable<double.ptr>,
Native.NativeReverseIterable<std.reverse_iteratorDouble>,
NativeMoveable<ArrayRefDouble> {
    private static final ArrayRefDouble NONE;
    private double.ptr Data;
    private int Length;
    protected final boolean isDataPointerLike;
    private static final ArrayRefIterator EMPTY;

    public static ArrayRefDouble None() {
        return NONE;
    }

    public ArrayRefDouble move() {
        return new ArrayRefDouble(JavaDifferentiators.JD.Move.INSTANCE, this);
    }

    public ArrayRefDouble() {
        this(false);
    }

    public ArrayRefDouble(boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_double$ptr((double[])null);
        this.Length = 0;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefDouble(NoneType $Prm0) {
        this($Prm0, false);
    }

    public ArrayRefDouble(NoneType $Prm0, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_double$ptr((double[])null);
        this.Length = 0;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefDouble(double OneElt) {
        this(OneElt, false);
    }

    public ArrayRefDouble(double OneElt, int len, boolean isDataPointerLike) {
        this(OneElt, isDataPointerLike);
        assert (len == 1) : "you meant call to ArrayRefDouble(/*const*/double$ptr /*P*/ data, int len, boolean isDataPointerLike)?";
    }

    public ArrayRefDouble(double OneElt, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_double$ptr((double[])NativePointer.new$double$elem((double)OneElt));
        this.Length = 1;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefDouble(double[] data, int length) {
        this(data, length, false);
    }

    public ArrayRefDouble(double[] data, int length, boolean isDataPointerLike) {
        this(NativePointer.create_const_double$ptr((double[])data), length, isDataPointerLike);
    }

    public ArrayRefDouble(double.ptr data, int length) {
        this(data, length, false);
    }

    public ArrayRefDouble(double.ptr data, int length, boolean isDataPointerLike) {
        this.Data = (double.ptr)Native.$tryConstClone((Object)data);
        this.Length = length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefDouble(double.ptr begin, double.ptr end) {
        this(begin, end, false);
    }

    public ArrayRefDouble(double.ptr begin, double.ptr end, boolean isDataPointerLike) {
        this.Data = (double.ptr)Native.$tryConstClone((Object)begin);
        this.Length = std.distance((abstract_iterator)begin, (abstract_iterator)end);
        this.isDataPointerLike = isDataPointerLike;
    }

    public <U> ArrayRefDouble(SmallVectorImplDouble Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public <U> ArrayRefDouble(SmallVectorImplDouble Vec, boolean isDataPointerLike) {
        this.Data = (double.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public <A> ArrayRefDouble(std.vectorDouble Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public <A> ArrayRefDouble(std.vectorDouble Vec, boolean isDataPointerLike) {
        this.Data = (double.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public ArrayRefDouble(std.vectorString Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public ArrayRefDouble(std.vectorString Vec, boolean isDataPointerLike) {
        this.Data = (double.ptr)Native.$tryConstClone((Object)((double.ptr)Vec.data()));
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
        assert (!isDataPointerLike);
    }

    public ArrayRefDouble(double[] Arr) {
        this(Arr, false);
    }

    public ArrayRefDouble(double[] Arr, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_double$ptr((double[])Arr);
        this.Length = Arr.length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefDouble(ArrayRefDouble other) {
        this.Data = (double.ptr)Native.$tryConstClone((Object)other.Data);
        this.Length = other.size();
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public ArrayRefDouble(JavaDifferentiators.JD.Convertible _param, ArrayRefDouble other, boolean isDataPointerLike) {
        this.Data = (double.ptr)Native.$tryConstClone((Object)other.Data);
        this.Length = other.size();
        assert (other.isDataPointerLike == isDataPointerLike);
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public ArrayRefDouble(JavaDifferentiators.JD.Convertible _param, SmallVectorImplDouble Vec, boolean isDataPointerLike) {
        this.Data = (double.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public ArrayRefDouble(JavaDifferentiators.JD.Move _dparam, ArrayRefDouble other) {
        assert (other != NONE) : "use new ArrayRefDouble<>(true/false) instead?";
        this.Data = other.Data;
        this.Length = other.Length;
        this.isDataPointerLike = other.isDataPointerLike;
        other.Data = null;
        other.Length = 0;
    }

    public double.ptr begin() {
        return this.Data;
    }

    public double.ptr end() {
        return this.Length == 0 ? this.Data : (double.ptr)this.Data.$add(this.Length);
    }

    public std.reverse_iteratorDouble rbegin() {
        return new std.reverse_iteratorDouble((double.iterator)this.end());
    }

    public std.reverse_iteratorDouble rend() {
        return new std.reverse_iteratorDouble((double.iterator)this.begin());
    }

    public boolean empty() {
        return this.Length == 0;
    }

    public double.ptr data() {
        return this.Data;
    }

    public int size() {
        return this.Length;
    }

    public double front() {
        return this.Data.$at(0);
    }

    public double back() {
        return this.Data.$at(this.Length - 1);
    }

    public ArrayRefDouble copy(Class<Double> cls, NativeMemory.Allocator A) {
        double.ptr Buff = NativePointer.create_const_double$ptr((double[])NativePointer.new$double(cls, (int)this.Length));
        std.copy((double.iterator)this.begin(), (double.iterator)this.end(), (double.iterator)Buff);
        return new ArrayRefDouble(Buff, this.Length, this.isDataPointerLike);
    }

    public boolean equals(ArrayRefDouble RHS) {
        if (Native.$noteq((int)this.Length, (int)RHS.Length)) {
            return false;
        }
        double.ptr L = (double.ptr)Native.$tryClone((NativeCloneable)this.begin());
        double.ptr LE = this.end();
        double.ptr R2 = (double.ptr)Native.$tryClone((NativeCloneable)RHS.begin());
        while (L.$noteq((Object)LE)) {
            if (!Native.$eq((Object)L.$star(), (Object)R2.$star(), (boolean)this.isDataPointerLike)) {
                return false;
            }
            L.$preInc();
            R2.$preInc();
        }
        return true;
    }

    public ArrayRefDouble slice(int N) {
        return new ArrayRefDouble((double.ptr)this.data().$add(N), this.size() - N, this.isDataPointerLike);
    }

    public ArrayRefDouble slice(int N, int M) {
        return new ArrayRefDouble((double.ptr)this.data().$add(N), M, this.isDataPointerLike);
    }

    public ArrayRefDouble drop_back() {
        return this.drop_back(1);
    }

    public ArrayRefDouble drop_back(int N) {
        assert (this.size() >= N) : "Dropping more elements than exist";
        return this.slice(0, this.size() - N);
    }

    public double $at(int Index) {
        return this.Data.$at(Index);
    }

    public double $at(uint.ref Index) {
        return this.Data.$at(Index.$deref());
    }

    public double.ptr ptr$at(uint.ref Index) {
        return this.ptr$at(Index.$deref());
    }

    public double.ptr ptr$at(int Index) {
        return Index == 0 ? this.Data : (double.ptr)this.Data.$add(Index);
    }

    public double.ref ref$at(uint.ref Index) {
        return this.ref$at(Index.$deref());
    }

    public double.ref ref$at(int Index) {
        return ((double.ptr)this.Data.$add(Index)).star$ref();
    }

    public std.vectorDouble vec() {
        return new std.vectorDouble((double.iterator)this.Data, (double.iterator)this.end(), 0.0);
    }

    public std.vectorDouble $vector() {
        return new std.vectorDouble((double.iterator)this.Data, (double.iterator)this.end(), 0.0);
    }

    public boolean equals(TRefOrNothing ... Args) {
        if (Args.length > 16) {
            throw new IllegalArgumentException("Too many arguments passed!");
        }
        if (this.size() != llvm.array_lengthof(Args)) {
            return false;
        }
        int e = this.size();
        for (int i = 0; i != e; ++i) {
            if (!Native.$noteq((Object)this.$at(i), (Object)Args[i].TPtr, (boolean)this.isDataPointerLike)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.Length == 0) {
            return "<Empty>";
        }
        StringBuilder out = new StringBuilder("\nArRef{");
        String fmt = "%" + (int)Math.ceil(Math.log10(this.Length + 1)) + "d";
        for (int i = 0; i < this.Length; ++i) {
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append("{").append(this.$at(i)).append("}\n");
        }
        out.append("}ArRef\n");
        return out.toString();
    }

    public ArrayRefDouble $assign(ArrayRefDouble other) {
        this.Data = other.Data;
        this.Length = other.Length;
        return this;
    }

    public ArrayRefDouble $assignMove(ArrayRefDouble other) {
        assert (other != NONE) : "use new ArrayRefDouble<>(" + this.isDataPointerLike + ") instead?";
        assert (this.isDataPointerLike == other.isDataPointerLike);
        double.ptr DataTmp = this.Data;
        int LengthTmp = this.Length;
        this.Data = other.Data;
        this.Length = other.Length;
        other.Data = null;
        other.Length = 0;
        return this;
    }

    public ArrayRefDouble clone() {
        if (this.getClass() != ArrayRefDouble.class) {
            throw new UnsupportedOperationException("Must be overridden in derived " + this.getClass());
        }
        return new ArrayRefDouble(this);
    }

    public boolean $eq(ArrayRefDouble other) {
        return this.equals(other);
    }

    @Override
    public Iterator<Double> iterator() {
        return this.Length == 0 ? EMPTY : new ArrayRefIterator(this.Data, this.Length);
    }

    static {
        ArrayRefDouble obj;
        NONE = obj = new ArrayRefDouble(NoneType.None);
        EMPTY = new ArrayRefIterator(null, 0);
    }

    private static final class ArrayRefIterator
    implements Iterator<Double> {
        private final double.ptr localData;
        private final int localLength;
        private int pos = 0;

        public ArrayRefIterator(double.ptr Data, int Length) {
            this.localData = (double.ptr)Native.$tryClone((NativeCloneable)Data);
            this.localLength = Length;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.localLength;
        }

        @Override
        public Double next() {
            Double val = this.localData.$star();
            this.localData.$preInc();
            ++this.pos;
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static class TRefOrNothing {
        public double TPtr;

        public TRefOrNothing() {
            this.TPtr = 0.0;
        }

        public TRefOrNothing(double TRef) {
            this.TPtr = TRef;
        }

        public String toString() {
            return "TPtr=" + this.TPtr;
        }
    }
}

