/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeMemory;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.uchar;
import org.clank.support.aliases.uint;
import org.llvm.adt.NoneType;
import org.llvm.adt.aliases.SmallVectorImplUChar;
import org.llvm.support.llvm;

public class ArrayRefByte$C
implements Iterable<Byte>,
Native.NativePOD<ArrayRefByte$C>,
Native.NativeIterable<uchar.ptr>,
Native.NativeReverseIterable<std.reverse_iteratorUChar>,
NativeMoveable<ArrayRefByte$C> {
    private static final ArrayRefByte$C NONE;
    private uchar.ptr Data;
    private int Length;
    protected final boolean isDataPointerLike;
    private static final ArrayRefIterator EMPTY;

    public static ArrayRefByte$C None() {
        return NONE;
    }

    public ArrayRefByte$C move() {
        return new ArrayRefByte$C(JavaDifferentiators.JD.Move.INSTANCE, this);
    }

    public ArrayRefByte$C() {
        this(false);
    }

    public ArrayRefByte$C(boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_uchar$ptr((byte[])null);
        this.Length = 0;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefByte$C(NoneType $Prm0) {
        this($Prm0, false);
    }

    public ArrayRefByte$C(NoneType $Prm0, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_uchar$ptr((byte[])null);
        this.Length = 0;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefByte$C(byte OneElt) {
        this(OneElt, false);
    }

    public ArrayRefByte$C(byte OneElt, int len, boolean isDataPointerLike) {
        this(OneElt, isDataPointerLike);
        assert (len == 1) : "you meant call to ArrayRefByte$C(/*const*/uchar$ptr /*P*/ data, int len, boolean isDataPointerLike)?";
    }

    public ArrayRefByte$C(byte OneElt, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_uchar$ptr((byte[])NativePointer.new$uchar$elem((byte)OneElt));
        this.Length = 1;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefByte$C(byte[] data, int length) {
        this(data, length, false);
    }

    public ArrayRefByte$C(byte[] data, int length, boolean isDataPointerLike) {
        this(NativePointer.create_const_uchar$ptr((byte[])data), length, isDataPointerLike);
    }

    public ArrayRefByte$C(uchar.ptr data, int length) {
        this(data, length, false);
    }

    public ArrayRefByte$C(uchar.ptr data, int length, boolean isDataPointerLike) {
        this.Data = (uchar.ptr)Native.$tryConstClone((Object)data);
        this.Length = length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefByte$C(uchar.ptr begin, uchar.ptr end) {
        this(begin, end, false);
    }

    public ArrayRefByte$C(uchar.ptr begin, uchar.ptr end, boolean isDataPointerLike) {
        this.Data = (uchar.ptr)Native.$tryConstClone((Object)begin);
        this.Length = std.distance((abstract_iterator)begin, (abstract_iterator)end);
        this.isDataPointerLike = isDataPointerLike;
    }

    public <U> ArrayRefByte$C(SmallVectorImplUChar Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public <U> ArrayRefByte$C(SmallVectorImplUChar Vec, boolean isDataPointerLike) {
        this.Data = (uchar.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public <A> ArrayRefByte$C(std.vectorUChar Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public <A> ArrayRefByte$C(std.vectorUChar Vec, boolean isDataPointerLike) {
        this.Data = (uchar.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public ArrayRefByte$C(std.vectorString Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public ArrayRefByte$C(std.vectorString Vec, boolean isDataPointerLike) {
        this.Data = (uchar.ptr)Native.$tryConstClone((Object)((uchar.ptr)Vec.data()));
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
        assert (!isDataPointerLike);
    }

    public ArrayRefByte$C(byte[] Arr) {
        this(Arr, false);
    }

    public ArrayRefByte$C(byte[] Arr, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_uchar$ptr((byte[])Arr);
        this.Length = Arr.length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefByte$C(ArrayRefByte$C other) {
        this.Data = (uchar.ptr)Native.$tryConstClone((Object)other.Data);
        this.Length = other.size();
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public ArrayRefByte$C(JavaDifferentiators.JD.Convertible _param, ArrayRefByte$C other, boolean isDataPointerLike) {
        this.Data = (uchar.ptr)Native.$tryConstClone((Object)other.Data);
        this.Length = other.size();
        assert (other.isDataPointerLike == isDataPointerLike);
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public ArrayRefByte$C(JavaDifferentiators.JD.Convertible _param, SmallVectorImplUChar Vec, boolean isDataPointerLike) {
        this.Data = (uchar.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public ArrayRefByte$C(JavaDifferentiators.JD.Move _dparam, ArrayRefByte$C other) {
        assert (other != NONE) : "use new ArrayRefByte$C<>(true/false) instead?";
        this.Data = other.Data;
        this.Length = other.Length;
        this.isDataPointerLike = other.isDataPointerLike;
        other.Data = null;
        other.Length = 0;
    }

    public uchar.ptr begin() {
        return this.Data;
    }

    public uchar.ptr end() {
        return this.Length == 0 ? this.Data : (uchar.ptr)this.Data.$add(this.Length);
    }

    public std.reverse_iteratorUChar rbegin() {
        return new std.reverse_iteratorUChar((uchar.iterator)this.end());
    }

    public std.reverse_iteratorUChar rend() {
        return new std.reverse_iteratorUChar((uchar.iterator)this.begin());
    }

    public boolean empty() {
        return this.Length == 0;
    }

    public uchar.ptr data() {
        return this.Data;
    }

    public int size() {
        return this.Length;
    }

    public byte front() {
        return this.Data.$at(0);
    }

    public byte back() {
        return this.Data.$at(this.Length - 1);
    }

    public ArrayRefByte$C copy(Class<Byte> cls, NativeMemory.Allocator A) {
        uchar.ptr Buff = NativePointer.create_const_uchar$ptr((byte[])NativePointer.new$uchar(cls, (int)this.Length));
        std.copy((uchar.iterator)this.begin(), (uchar.iterator)this.end(), (uchar.iterator)Buff);
        return new ArrayRefByte$C(Buff, this.Length, this.isDataPointerLike);
    }

    public boolean equals(ArrayRefByte$C RHS) {
        if (Native.$noteq((int)this.Length, (int)RHS.Length)) {
            return false;
        }
        uchar.ptr L = Native.$tryClone((uchar.ptr)this.begin());
        uchar.ptr LE = this.end();
        uchar.ptr R2 = Native.$tryClone((uchar.ptr)RHS.begin());
        while (L.$noteq((Object)LE)) {
            if (!Native.$eq((byte)L.$star(), (byte)R2.$star(), (boolean)this.isDataPointerLike)) {
                return false;
            }
            L.$preInc();
            R2.$preInc();
        }
        return true;
    }

    public ArrayRefByte$C slice(int N) {
        return new ArrayRefByte$C((uchar.ptr)this.data().$add(N), this.size() - N, this.isDataPointerLike);
    }

    public ArrayRefByte$C slice(int N, int M) {
        return new ArrayRefByte$C((uchar.ptr)this.data().$add(N), M, this.isDataPointerLike);
    }

    public ArrayRefByte$C drop_back() {
        return this.drop_back(1);
    }

    public ArrayRefByte$C drop_back(int N) {
        assert (this.size() >= N) : "Dropping more elements than exist";
        return this.slice(0, this.size() - N);
    }

    public byte $at(int Index) {
        return this.Data.$at(Index);
    }

    public byte $at(uint.ref Index) {
        return this.Data.$at(Index.$deref());
    }

    public uchar.ptr ptr$at(uint.ref Index) {
        return this.ptr$at(Index.$deref());
    }

    public uchar.ptr ptr$at(int Index) {
        return Index == 0 ? this.Data : (uchar.ptr)this.Data.$add(Index);
    }

    public uchar.ref ref$at(uint.ref Index) {
        return this.ref$at(Index.$deref());
    }

    public uchar.ref ref$at(int Index) {
        return ((uchar.ptr)this.Data.$add(Index)).star$ref();
    }

    public std.vectorUChar vec() {
        return new std.vectorUChar((uchar.iterator)this.Data, (uchar.iterator)this.end(), 0);
    }

    public std.vectorUChar $vector() {
        return new std.vectorUChar((uchar.iterator)this.Data, (uchar.iterator)this.end(), 0);
    }

    public boolean equals(TRefOrNothing ... Args) {
        if (Args.length > 16) {
            throw new IllegalArgumentException("Too many arguments passed!");
        }
        if (this.size() != llvm.array_lengthof(Args)) {
            return false;
        }
        int e = this.size();
        for (int i = 0; i != e; ++i) {
            if (!Native.$noteq((byte)this.$at(i), (byte)Args[i].TPtr, (boolean)this.isDataPointerLike)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.Length == 0) {
            return "<Empty>";
        }
        StringBuilder out = new StringBuilder("\nArRef{");
        String fmt = "%" + (int)Math.ceil(Math.log10(this.Length + 1)) + "d";
        for (int i = 0; i < this.Length; ++i) {
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append("{").append(this.$at(i)).append("}\n");
        }
        out.append("}ArRef\n");
        return out.toString();
    }

    public ArrayRefByte$C $assign(ArrayRefByte$C other) {
        this.Data = other.Data;
        this.Length = other.Length;
        return this;
    }

    public ArrayRefByte$C $assignMove(ArrayRefByte$C other) {
        assert (other != NONE) : "use new ArrayRefByte$C<>(" + this.isDataPointerLike + ") instead?";
        assert (this.isDataPointerLike == other.isDataPointerLike);
        uchar.ptr DataTmp = this.Data;
        int LengthTmp = this.Length;
        this.Data = other.Data;
        this.Length = other.Length;
        other.Data = null;
        other.Length = 0;
        return this;
    }

    public ArrayRefByte$C clone() {
        if (this.getClass() != ArrayRefByte$C.class) {
            throw new UnsupportedOperationException("Must be overridden in derived " + this.getClass());
        }
        return new ArrayRefByte$C(this);
    }

    public boolean $eq(ArrayRefByte$C other) {
        return this.equals(other);
    }

    @Override
    public Iterator<Byte> iterator() {
        return this.Length == 0 ? EMPTY : new ArrayRefIterator(this.Data, this.Length);
    }

    static {
        ArrayRefByte$C obj;
        NONE = obj = new ArrayRefByte$C(NoneType.None);
        EMPTY = new ArrayRefIterator(null, 0);
    }

    private static final class ArrayRefIterator
    implements Iterator<Byte> {
        private final uchar.ptr localData;
        private final int localLength;
        private int pos = 0;

        public ArrayRefIterator(uchar.ptr Data, int Length) {
            this.localData = Native.$tryClone((uchar.ptr)Data);
            this.localLength = Length;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.localLength;
        }

        @Override
        public Byte next() {
            Byte val = this.localData.$star();
            this.localData.$preInc();
            ++this.pos;
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static class TRefOrNothing {
        public byte TPtr;

        public TRefOrNothing() {
            this.TPtr = 0;
        }

        public TRefOrNothing(byte TRef) {
            this.TPtr = TRef;
        }

        public String toString() {
            return "TPtr=" + this.TPtr;
        }
    }
}

