/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import java.util.Objects;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;
import org.llvm.support.raw_svector_ostream;

public final class Twine
implements Native.NativePOD<Twine> {
    public static final Twine T$EMPTY = new Twine();
    public static final Twine T$SPACE = new Twine(StringRef.R$SPACE);
    public static final Twine T$MINUS = new Twine(StringRef.R$MINUS);
    public static final Twine T$PLUS = new Twine(StringRef.R$PLUS);
    public static final Twine T$DOT = new Twine(StringRef.R$DOT);
    public static final Twine T$0 = new Twine(StringRef.R$0);
    public static final Twine T$1 = new Twine(StringRef.R$1);
    public static final Twine T$2 = new Twine(StringRef.R$2);
    public static final Twine T$3 = new Twine(StringRef.R$3);
    public static final Twine T$SLASH = new Twine(StringRef.R$SLASH);
    public static final Twine T$DOT_DOT = new Twine(StringRef.R$DOT_DOT);
    public static final Twine T$scratch_space_marker = new Twine(StringRef.R$scratch_space_marker);
    public static final Twine T$invalid_marker = new Twine(StringRef.R$invalid_marker);
    public static final Twine T$built_in_marker = new Twine(StringRef.R$built_in_marker);
    private static final Child DUMMY_CHILD = NativeTrace.isDebugMode() ? new DummyChild() : new Child();
    private final Child LHS;
    private final Child RHS;
    private final char LHSKind;
    private final char RHSKind;
    private static final Twine NullKindTwine = new Twine(true);

    public static Twine $new(StringRef stringRef) {
        return new Twine(stringRef);
    }

    public Twine(JavaDifferentiators.JD.Long.C INSTANCE, long TargetLocation) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Twine(JavaDifferentiators.JD.ConstULLongRef INSTANCE, long FragmentOffset) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private Twine(boolean nodeKindFlag) {
        this.LHS = DUMMY_CHILD;
        this.RHS = DUMMY_CHILD;
        this.LHSKind = '\u0000';
        this.RHSKind = '\u0001';
        assert (this.isNullary()) : "Invalid kind!";
    }

    private Twine(Twine _LHS, Twine _RHS) {
        this.LHS = new Child();
        this.RHS = new Child();
        this.LHSKind = (char)2;
        this.RHSKind = (char)2;
        this.LHS.setTwine(_LHS);
        this.RHS.setTwine(_RHS);
        assert (this.isValid()) : "Invalid twine!";
    }

    private Twine(Child _LHS, char _LHSKind, Child _RHS, char _RHSKind) {
        this.LHS = new Child(_LHS);
        this.RHS = new Child(_RHS);
        this.LHSKind = _LHSKind;
        this.RHSKind = _RHSKind;
        assert (this.isValid()) : "Invalid twine!";
    }

    private boolean isNull() {
        return this.getLHSKind() == '\u0000';
    }

    private boolean isEmpty() {
        return this.getLHSKind() == '\u0001';
    }

    private boolean isNullary() {
        return this.isNull() || this.isEmpty();
    }

    private boolean isUnary() {
        return this.getRHSKind() == '\u0001' && !this.isNullary();
    }

    private boolean isBinary() {
        return this.getLHSKind() != '\u0000' && this.getRHSKind() != '\u0001';
    }

    private boolean isValid() {
        if (this.isNullary() && this.getRHSKind() != '\u0001') {
            return false;
        }
        if (this.getRHSKind() == '\u0000') {
            return false;
        }
        if (this.getRHSKind() != '\u0001' && this.getLHSKind() == '\u0001') {
            return false;
        }
        if (this.getLHSKind() == '\u0002' && !this.LHS.getTwine().isBinary()) {
            return false;
        }
        return this.getRHSKind() != '\u0002' || this.RHS.getTwine().isBinary();
    }

    private char getLHSKind() {
        return this.LHSKind;
    }

    private char getRHSKind() {
        return this.RHSKind;
    }

    private void printOneChild(raw_ostream OS, Child Ptr2, char Kind2) {
        switch (Kind2) {
            case '\u0000': {
                break;
            }
            case '\u0001': {
                break;
            }
            case '\u0002': {
                Ptr2.getTwine().print(OS);
                break;
            }
            case '\u0003': {
                OS.$out(Ptr2.getCString());
                break;
            }
            case '\u0004': {
                OS.$out((std.string)Native.$Deref((Object)Ptr2.getStdString()));
                break;
            }
            case '\u0005': {
                OS.$out((StringRef)Native.$Deref((Object)Ptr2.getStringRef()));
                break;
            }
            case '\u0006': {
                OS.$out((SmallString)Native.$Deref((Object)Ptr2.getSmallString()));
                break;
            }
            case '\u0007': {
                OS.$out_char(Ptr2.getCharacter());
                break;
            }
            case '\b': {
                OS.$out_uint(Ptr2.getDecUI());
                break;
            }
            case '\t': {
                OS.$out_int(Ptr2.getDecI());
                break;
            }
            case '\n': {
                OS.$out_ulong(Ptr2.getDecUL());
                break;
            }
            case '\u000b': {
                OS.$out_long(Ptr2.getDecL());
                break;
            }
            case '\f': {
                OS.$out_ullong(Ptr2.getDecULL());
                break;
            }
            case '\r': {
                OS.$out_llong(Ptr2.getDecLL());
                break;
            }
            case '\u000e': {
                OS.write_hex(Ptr2.getUHex());
                break;
            }
            default: {
                assert (false) : "Unexpected kind " + Kind2;
                break;
            }
        }
    }

    private void printOneChildRepr(raw_ostream OS, Child Ptr2, char Kind2) {
        switch (Kind2) {
            case '\u0000': {
                OS.$out("null");
                break;
            }
            case '\u0001': {
                OS.$out("empty");
                break;
            }
            case '\u0002': {
                OS.$out("rope:");
                Ptr2.getTwine().printRepr(OS);
                break;
            }
            case '\u0003': {
                OS.$out("cstring:\"").$out(Ptr2.getCString()).$out(NativePointer.$DBL_QUOTE);
                break;
            }
            case '\u0004': {
                OS.$out("std::string:\"").$out(Ptr2.getStdString()).$out(NativePointer.$DBL_QUOTE);
                break;
            }
            case '\u0005': {
                OS.$out("stringref:\"").$out(Ptr2.getStringRef()).$out(NativePointer.$DBL_QUOTE);
                break;
            }
            case '\u0006': {
                OS.$out("smallstring:\"").$out((SmallString)Native.$Deref((Object)Ptr2.getSmallString())).$out(NativePointer.$DBL_QUOTE);
                break;
            }
            case '\u0007': {
                OS.$out("char:\"").$out_char(Ptr2.getCharacter()).$out(NativePointer.$DBL_QUOTE);
                break;
            }
            case '\b': {
                OS.$out("decUI:\"").$out_uint(Ptr2.getDecUI()).$out(NativePointer.$DBL_QUOTE);
                break;
            }
            case '\t': {
                OS.$out("decI:\"").$out_int(Ptr2.getDecI()).$out(NativePointer.$DBL_QUOTE);
                break;
            }
            case '\n': {
                OS.$out("decUL:\"").$out_ulong(Ptr2.getDecUL()).$out(NativePointer.$DBL_QUOTE);
                break;
            }
            case '\u000b': {
                OS.$out("decL:\"").$out_long(Ptr2.getDecL()).$out(NativePointer.$DBL_QUOTE);
                break;
            }
            case '\f': {
                OS.$out("decULL:\"").$out_ullong(Ptr2.getDecULL()).$out(NativePointer.$DBL_QUOTE);
                break;
            }
            case '\r': {
                OS.$out("decLL:\"").$out_llong(Ptr2.getDecLL()).$out(NativePointer.$DBL_QUOTE);
                break;
            }
            case '\u000e': {
                OS.$out("uhex:\"").$out_hex(Ptr2.getUHex()).$out(NativePointer.$DBL_QUOTE);
                break;
            }
            default: {
                assert (false) : "Unexpected kind " + Kind2;
                break;
            }
        }
    }

    public Twine() {
        this.LHS = DUMMY_CHILD;
        this.RHS = DUMMY_CHILD;
        this.LHSKind = '\u0001';
        this.RHSKind = '\u0001';
        assert (this.isValid()) : "Invalid twine!";
    }

    public Twine(char.ptr Str) {
        this.RHS = DUMMY_CHILD;
        this.RHSKind = '\u0001';
        if (Str.$at(0) != 0) {
            this.LHS = new Child();
            this.LHS.setCString(Str);
            this.LHSKind = (char)3;
        } else {
            this.LHS = DUMMY_CHILD;
            this.LHSKind = '\u0001';
        }
        assert (this.isValid()) : "Invalid twine!";
    }

    public Twine(char.iterator<?> Str) {
        this(Str.star$ref().deref$ptr());
    }

    public Twine(byte[] Str) {
        this(NativePointer.create_char$ptr((byte[])Str));
    }

    public Twine(SmallString Str) {
        this.LHS = new Child();
        this.RHS = new Child();
        this.LHSKind = (char)6;
        this.RHSKind = '\u0001';
        this.LHS.setSmallString(Str);
        assert (this.isValid()) : "Invalid twine!";
    }

    public Twine(std.string Str) {
        this.LHS = new Child();
        this.RHS = DUMMY_CHILD;
        this.LHSKind = (char)4;
        this.RHSKind = '\u0001';
        this.LHS.setStdString(Str);
        assert (this.isValid()) : "Invalid twine!";
    }

    public Twine(StringRef Str) {
        this.LHS = new Child();
        this.RHS = DUMMY_CHILD;
        this.LHSKind = (char)5;
        this.RHSKind = '\u0001';
        this.LHS.setStringRef(Str);
        assert (this.isValid()) : "Invalid twine!";
    }

    public Twine(String Str) {
        this(NativePointer.create_char$ptr((CharSequence)Str));
    }

    public Twine(char.ptr _LHS, StringRef _RHS) {
        this.LHS = new Child();
        this.RHS = new Child();
        this.LHSKind = (char)3;
        this.RHSKind = (char)5;
        this.LHS.setCString(_LHS);
        this.RHS.setStringRef(_RHS);
        assert (this.isValid()) : "Invalid twine!";
    }

    public Twine(char.ptr _LHS, char.ptr _RHS) {
        this.LHS = new Child();
        this.RHS = new Child();
        this.LHSKind = (char)3;
        this.RHSKind = (char)3;
        this.LHS.setCString(_LHS);
        this.RHS.setCString(_RHS);
        assert (this.isValid()) : "Invalid twine!";
    }

    public Twine(String _LHS, char.ptr _RHS) {
        this(NativePointer.create_char$ptr((CharSequence)_LHS), _RHS);
    }

    public Twine(char.ptr _LHS, String _RHS) {
        this(_LHS, NativePointer.create_char$ptr((CharSequence)_RHS));
    }

    public Twine(String _LHS, StringRef _RHS) {
        this(NativePointer.create_char$ptr((CharSequence)_LHS), _RHS);
    }

    public Twine(StringRef _LHS, char.ptr _RHS) {
        this.LHS = new Child();
        this.RHS = new Child();
        this.LHSKind = (char)5;
        this.RHSKind = (char)3;
        this.LHS.setStringRef(_LHS);
        this.RHS.setCString(_RHS);
        assert (this.isValid()) : "Invalid twine!";
    }

    public Twine(StringRef _LHS, String _RHS) {
        this(_LHS, NativePointer.create_char$ptr((CharSequence)_RHS));
    }

    public Twine(JavaDifferentiators.JD$Char _dparam, byte Val) {
        this.LHS = new Child();
        this.RHS = DUMMY_CHILD;
        this.LHSKind = (char)7;
        this.RHSKind = '\u0001';
        this.LHS.setCharacter(Val);
    }

    public Twine(JavaDifferentiators.JD.SChar _dparam, byte Val) {
        this.LHS = new Child();
        this.RHS = DUMMY_CHILD;
        this.LHSKind = (char)7;
        this.RHSKind = '\u0001';
        this.LHS.setCharacter(Val);
    }

    public Twine(JavaDifferentiators.JD.UChar _dparam, short Val) {
        this.LHS = new Child();
        this.RHS = DUMMY_CHILD;
        this.LHSKind = (char)7;
        this.RHSKind = '\u0001';
        this.LHS.setCharacter((byte)Val);
    }

    public Twine(JavaDifferentiators.JD.UInt _dparam, int Val) {
        this.LHS = new Child();
        this.RHS = DUMMY_CHILD;
        this.LHSKind = (char)8;
        this.RHSKind = '\u0001';
        assert (Val >= 0) : "forgot about unsigned conversion?";
        this.LHS.setDecUI(Val);
    }

    public Twine(JavaDifferentiators.JD.Int _dparam, int Val) {
        this.LHS = new Child();
        this.RHS = DUMMY_CHILD;
        this.LHSKind = (char)9;
        this.RHSKind = '\u0001';
        this.LHS.setDecI(Val);
    }

    public Twine(JavaDifferentiators.JD.ULong _dparam, long Val) {
        this.LHS = new Child();
        this.RHS = DUMMY_CHILD;
        this.LHSKind = (char)10;
        this.RHSKind = '\u0001';
        this.LHS.setDecUL(Val);
    }

    public Twine(JavaDifferentiators.JD.Long _dparam, long Val) {
        this.LHS = new Child();
        this.RHS = DUMMY_CHILD;
        this.LHSKind = (char)11;
        this.RHSKind = '\u0001';
        this.LHS.setDecL(Val);
    }

    public Twine(JavaDifferentiators.JD.ULLong _dparam, long Val) {
        this.LHS = new Child();
        this.RHS = DUMMY_CHILD;
        this.LHSKind = (char)12;
        this.RHSKind = '\u0001';
        this.LHS.setDecULL(Val);
    }

    public Twine(JavaDifferentiators.JD.LLong _dparam, long Val) {
        this.LHS = new Child();
        this.RHS = DUMMY_CHILD;
        this.LHSKind = (char)13;
        this.RHSKind = '\u0001';
        this.LHS.setDecLL(Val);
    }

    public static Twine createNull() {
        return NullKindTwine;
    }

    public static Twine utohexstr(long Val) {
        Child LHS = new Child();
        Child RHS = DUMMY_CHILD;
        LHS.setUHex(Val);
        return new Twine(LHS, '\u000e', RHS, '\u0001');
    }

    public boolean isTriviallyEmpty() {
        return this.isNullary();
    }

    public boolean isSingleStringRef() {
        if (this.getRHSKind() != '\u0001') {
            return false;
        }
        switch (this.getLHSKind()) {
            case '\u0001': 
            case '\u0003': 
            case '\u0004': 
            case '\u0005': 
            case '\u0006': {
                return true;
            }
        }
        return false;
    }

    public Twine concat(Twine Suffix) {
        if (this.isNull() || Suffix.isNull()) {
            return NullKindTwine;
        }
        if (this.isEmpty()) {
            return Suffix;
        }
        if (Suffix.isEmpty()) {
            return this;
        }
        Child NewLHS = new Child();
        Child NewRHS = new Child();
        NewLHS.setTwine(this);
        NewRHS.setTwine(Suffix);
        char NewLHSKind = '\u0002';
        char NewRHSKind = '\u0002';
        if (this.isUnary()) {
            NewLHS.$assign(this.LHS);
            NewLHSKind = this.getLHSKind();
        }
        if (Suffix.isUnary()) {
            NewRHS.$assign(Suffix.LHS);
            NewRHSKind = Suffix.getLHSKind();
        }
        return new Twine(NewLHS, NewLHSKind, NewRHS, NewRHSKind);
    }

    public std.string str() {
        if (this.LHSKind == '\u0004' && this.RHSKind == '\u0001') {
            return (std.string)Native.$Deref((Object)((std.string)Native.$Deref((Object)this.LHS.getStdString())));
        }
        SmallString Vec = new SmallString(256);
        return this.toStringRef(Vec).str();
    }

    public void toVector(SmallString Out) {
        raw_svector_ostream OS = null;
        try {
            OS = new raw_svector_ostream(Out);
            this.print(OS);
        }
        finally {
            if (OS != null) {
                OS.$destroy();
            }
        }
    }

    public StringRef getSingleStringRef() {
        assert (this.isSingleStringRef()) : "This cannot be had as a single stringref!";
        switch (this.getLHSKind()) {
            default: {
                llvm.llvm_unreachable_internal("Out of sync with isSingleStringRef");
            }
            case '\u0001': {
                return StringRef.R$EMPTY;
            }
            case '\u0003': {
                return new StringRef(this.LHS.getCString());
            }
            case '\u0004': {
                return new StringRef((std.string)Native.$Deref((Object)((std.string)Native.$Deref((Object)this.LHS.getStdString()))));
            }
            case '\u0005': {
                return (StringRef)Native.$Deref((Object)((StringRef)Native.$Deref((Object)this.LHS.getStringRef())));
            }
            case '\u0006': 
        }
        return this.LHS.getSmallString().$StringRef();
    }

    public StringRef toStringRef(SmallString Out) {
        if (this.isSingleStringRef()) {
            return this.getSingleStringRef();
        }
        this.toVector(Out);
        return new StringRef(Out.data(), Out.size());
    }

    public StringRef toStringRef(SmallString Out, StringRef OutStrRef) {
        if (this.isSingleStringRef()) {
            return this.getSingleStringRef();
        }
        this.toVector(Out);
        return OutStrRef.$assign(Out.data(), Out.size());
    }

    public StringRef toNullTerminatedStringRef(SmallString Out) {
        if (this.isUnary()) {
            switch (this.getLHSKind()) {
                case '\u0003': {
                    return new StringRef(this.LHS.getCString());
                }
                case '\u0004': {
                    std.string str = this.LHS.getStdString();
                    return new StringRef(str.c_str(), str.size());
                }
            }
        }
        this.toVector(Out);
        Out.push_back((byte)0);
        Out.pop_back();
        return new StringRef(Out.data(), Out.size());
    }

    public void print(raw_ostream OS) {
        this.printOneChild(OS, this.LHS, this.getLHSKind());
        this.printOneChild(OS, this.RHS, this.getRHSKind());
    }

    public void dump() {
        this.print(llvm.dbgs());
    }

    public void printRepr(raw_ostream OS) {
        OS.$out("(Twine ");
        this.printOneChildRepr(OS, this.LHS, this.getLHSKind());
        OS.$out(" ");
        this.printOneChildRepr(OS, this.RHS, this.getRHSKind());
        OS.$out(")");
    }

    public void dumpRepr() {
        this.printRepr(llvm.dbgs());
    }

    public Twine(Twine $Prm0) {
        this.LHS = new Child($Prm0.LHS);
        this.RHS = new Child($Prm0.RHS);
        this.LHSKind = $Prm0.LHSKind;
        this.RHSKind = $Prm0.RHSKind;
    }

    public Twine $assign(Twine value) {
        throw new UnsupportedOperationException();
    }

    public Twine clone() {
        return new Twine(this);
    }

    public boolean $noteq(Twine other) {
        return !this.$eq(other);
    }

    public boolean $eq(Twine other) {
        if (this.LHSKind != other.LHSKind) {
            return false;
        }
        if (this.RHSKind != other.RHSKind) {
            return false;
        }
        if (!Objects.equals(this.LHS, other.LHS)) {
            return false;
        }
        return Objects.equals(this.RHS, other.RHS);
    }

    public String toString() {
        return "Twine{[" + this.toJavaString() + "]:" + Twine.getKindName(this.getLHSKind()) + "|" + Twine.getKindName(this.getRHSKind()) + "}";
    }

    public String toJavaString() {
        return this.str().toJavaString();
    }

    private static String getKindName(char kind) {
        switch (kind) {
            case '\u0000': {
                return "NullKind";
            }
            case '\u0001': {
                return "EmptyKind";
            }
            case '\u0002': {
                return "TwineKind";
            }
            case '\u0003': {
                return "CStringKind";
            }
            case '\u0004': {
                return "StdStringKind";
            }
            case '\u0005': {
                return "StringRefKind";
            }
            case '\u0006': {
                return "SmallStringKind";
            }
            case '\u0007': {
                return "CharKind";
            }
            case '\b': {
                return "DecUIKind";
            }
            case '\t': {
                return "DecIKind";
            }
            case '\n': {
                return "DecULKind";
            }
            case '\u000b': {
                return "DecLKind";
            }
            case '\f': {
                return "DecULLKind";
            }
            case '\r': {
                return "DecLLKind";
            }
            case '\u000e': {
                return "UHexKind";
            }
        }
        llvm.llvm_unreachable_internal("Unknown " + Unsigned.$ushort2uint((char)kind));
        return "Unknown " + Unsigned.$ushort2uint((char)kind);
    }

    private static final class DummyChild
    extends Child {
        private DummyChild() {
        }

        @Override
        public Child $assign(Child $Prm0) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }

        @Override
        public void setUHex(long Val) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }

        @Override
        public void setDecLL(long Val) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }

        @Override
        public void setDecULL(long Val) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }

        @Override
        public void setDecL(long Val) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }

        @Override
        public void setDecUL(long Val) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }

        @Override
        public void setDecI(int Val) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }

        @Override
        public void setDecUI(int Val) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }

        @Override
        public void setCharacter(byte Val) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }

        @Override
        public void setStringRef(StringRef stringRef) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }

        @Override
        public void setStdString(std.string stdString) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }

        @Override
        public void setCString(char.ptr cString) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }

        @Override
        public void setTwine(Twine twine) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }
    }

    private static class Child {
        private Object refVal;
        private long numVal;

        public Child() {
        }

        public Child(Child $Prm0) {
            this.$assign($Prm0);
        }

        public Child $assign(Child $Prm0) {
            this.numVal = $Prm0.numVal;
            this.refVal = $Prm0.refVal;
            return this;
        }

        public Twine getTwine() {
            return (Twine)this.refVal;
        }

        public void setTwine(Twine twine) {
            this.refVal = twine;
        }

        public char.ptr getCString() {
            return (char.ptr)this.refVal;
        }

        public void setCString(char.ptr cString) {
            this.refVal = cString;
        }

        public std.string getStdString() {
            return (std.string)this.refVal;
        }

        public void setStdString(std.string stdString) {
            this.refVal = stdString;
        }

        public StringRef getStringRef() {
            return (StringRef)this.refVal;
        }

        public void setStringRef(StringRef stringRef) {
            this.refVal = stringRef;
        }

        public SmallString getSmallString() {
            return (SmallString)this.refVal;
        }

        public void setSmallString(SmallString smallString) {
            this.refVal = smallString;
        }

        public byte getCharacter() {
            return (byte)this.numVal;
        }

        public void setCharacter(byte Val) {
            this.numVal = Val;
        }

        public int getDecUI() {
            return Unsigned.$long2uint((long)this.numVal);
        }

        public void setDecUI(int Val) {
            this.numVal = Unsigned.$uint2long((int)Val);
        }

        public int getDecI() {
            return (int)this.numVal;
        }

        public void setDecI(int Val) {
            this.numVal = Val;
        }

        public long getDecUL() {
            return this.numVal;
        }

        public void setDecUL(long Val) {
            this.numVal = Val;
        }

        public long getDecL() {
            return this.numVal;
        }

        public void setDecL(long Val) {
            this.numVal = Val;
        }

        public long getDecULL() {
            return this.numVal;
        }

        public void setDecULL(long Val) {
            this.numVal = Val;
        }

        public long getDecLL() {
            return this.numVal;
        }

        public void setDecLL(long Val) {
            this.numVal = Val;
        }

        public long getUHex() {
            return this.numVal;
        }

        public void setUHex(long Val) {
            this.numVal = Val;
        }
    }

    private static final class NodeKind {
        public static final char NullKind = '\u0000';
        public static final char EmptyKind = '\u0001';
        public static final char TwineKind = '\u0002';
        public static final char CStringKind = '\u0003';
        public static final char StdStringKind = '\u0004';
        public static final char StringRefKind = '\u0005';
        public static final char SmallStringKind = '\u0006';
        public static final char CharKind = '\u0007';
        public static final char DecUIKind = '\b';
        public static final char DecIKind = '\t';
        public static final char DecULKind = '\n';
        public static final char DecLKind = '\u000b';
        public static final char DecULLKind = '\f';
        public static final char DecLLKind = '\r';
        public static final char UHexKind = '\u000e';

        private NodeKind() {
        }
    }
}

