/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.type;
import org.llvm.adt.MutableArrayRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.java.SmallVectorImplCommon;

public class TinyPtrVector<EltTy>
implements NativeCloneable<TinyPtrVector<EltTy>>,
Native.NativeIterable<type.ptr<EltTy>>,
Destructors.ClassWithDestructor,
Iterable<EltTy> {
    private final Object[] Val = new Object[]{null};
    private boolean $vector;

    private boolean $isNull() {
        return this.Val[0] == null;
    }

    private boolean $isElement() {
        return !this.$vector;
    }

    private EltTy $getAsElement() {
        return (EltTy)(this.$isElement() ? this.Val[0] : null);
    }

    private boolean $isVector() {
        return this.$vector;
    }

    private SmallVector<EltTy> $getAsVector() {
        return this.$isVector() ? (SmallVector)this.Val[0] : null;
    }

    public TinyPtrVector() {
        this.Val[0] = null;
        this.$vector = false;
    }

    public void $destroy() {
        SmallVector<EltTy> V = this.$getAsVector();
        if (V != null) {
            Destructors.$destroy(V);
        }
    }

    public TinyPtrVector(TinyPtrVector<EltTy> RHS) {
        this.Val[0] = RHS.Val[0];
        this.$vector = RHS.$vector;
        SmallVector<EltTy> V = this.$getAsVector();
        if (V != null) {
            this.Val[0] = new SmallVector((SmallVector)Native.$star(V));
        }
    }

    public TinyPtrVector<EltTy> $assign(TinyPtrVector<EltTy> RHS) {
        if (Native.$eq((Object)this, (Object)Native.$AddrOf(RHS))) {
            return (TinyPtrVector)Native.$star((Object)this);
        }
        if (RHS.empty()) {
            this.clear();
            return (TinyPtrVector)Native.$star((Object)this);
        }
        if (this.$isElement()) {
            if (Native.$eq((int)RHS.size(), (int)1)) {
                this.Val[0] = RHS.front();
                this.$vector = false;
            } else {
                this.Val[0] = new SmallVector((SmallVector)Native.$star((Object)((SmallVector)RHS.Val[0])));
                this.$vector = true;
            }
            return (TinyPtrVector)Native.$star((Object)this);
        }
        if (super.$isElement()) {
            this.$getAsVector().clear();
            this.$getAsVector().push_back(RHS.front());
        } else {
            ((SmallVector)Native.$star(this.$getAsVector())).$assign((SmallVectorImpl)Native.$star(super.$getAsVector()));
        }
        return (TinyPtrVector)Native.$star((Object)this);
    }

    public TinyPtrVector(JavaDifferentiators.JD.Move _dparam, TinyPtrVector<EltTy> RHS) {
        this.Val[0] = RHS.Val[0];
        this.$vector = RHS.$vector;
        RHS.Val[0] = null;
        RHS.$vector = false;
    }

    public TinyPtrVector<EltTy> $assignMove(TinyPtrVector<EltTy> RHS) {
        if (Native.$eq((Object)this, (Object)Native.$AddrOf(RHS))) {
            return (TinyPtrVector)Native.$star((Object)this);
        }
        if (RHS.empty()) {
            this.clear();
            return (TinyPtrVector)Native.$star((Object)this);
        }
        SmallVector<EltTy> V = this.$getAsVector();
        if (V != null) {
            if (super.$isElement()) {
                V.clear();
                V.push_back(RHS.front());
                return (TinyPtrVector)Native.$star((Object)this);
            }
            Destructors.$destroy(V);
        }
        this.Val[0] = RHS.Val[0];
        this.$vector = RHS.$vector;
        RHS.Val[0] = null;
        RHS.$vector = false;
        return (TinyPtrVector)Native.$star((Object)this);
    }

    public TinyPtrVector(ArrayRef<EltTy> Elts) {
        if (Native.$eq((int)Elts.size(), (int)1)) {
            this.Val[0] = Elts.$at(0);
            this.$vector = false;
        } else {
            this.Val[0] = new SmallVector<Object>(4, (type.iterator<?, Object>)Elts.begin(), (type.iterator<?, Object>)Elts.end(), null);
            this.$vector = true;
        }
    }

    public ArrayRef<EltTy> $ArrayRef() {
        if (this.$isNull()) {
            return ArrayRef.None();
        }
        if (this.$isElement()) {
            return new ArrayRef<Object>(Native.$star(this.$getAsElement()), true);
        }
        return new ArrayRef((SmallVectorImplCommon)Native.$star(this.$getAsVector()));
    }

    public MutableArrayRef<EltTy> $MutableArrayRef$EltTy() {
        if (this.$isNull()) {
            return MutableArrayRef.None();
        }
        if (this.$isElement()) {
            return new MutableArrayRef<Object>(Native.$star(this.$getAsElement()), true);
        }
        return new MutableArrayRef((SmallVectorImpl)Native.$star(this.$getAsVector()));
    }

    public boolean empty() {
        if (this.$isNull()) {
            return true;
        }
        SmallVector<EltTy> Vec = this.$getAsVector();
        if (Vec != null) {
            return Vec.empty();
        }
        return false;
    }

    public int size() {
        if (this.empty()) {
            return 0;
        }
        if (this.$isElement()) {
            return 1;
        }
        return this.$getAsVector().size();
    }

    public type.ptr<EltTy> begin() {
        if (this.$isElement()) {
            return NativePointer.create_type$ptr((Object[])this.Val);
        }
        return this.$getAsVector().begin();
    }

    public type.ptr<EltTy> end() {
        if (this.$isElement()) {
            return Native.$add(this.begin(), (int)(this.$isNull() ? 0 : 1));
        }
        return this.$getAsVector().end();
    }

    public EltTy $at(int i) {
        assert (!this.$isNull()) : "can't index into an empty vector";
        EltTy V = this.$getAsElement();
        if (V != null) {
            assert (i == 0) : "tinyvector index out of range";
            return V;
        }
        assert (Native.$less((int)i, (int)this.$getAsVector().size())) : "tinyvector index out of range";
        return (EltTy)((SmallVector)Native.$star(this.$getAsVector())).$at(i);
    }

    public EltTy front() {
        assert (!this.empty()) : "vector empty";
        EltTy V = this.$getAsElement();
        if (V != null) {
            return V;
        }
        return (EltTy)this.$getAsVector().front();
    }

    public EltTy back() {
        assert (!this.empty()) : "vector empty";
        EltTy V = this.$getAsElement();
        if (V != null) {
            return V;
        }
        return (EltTy)this.$getAsVector().back();
    }

    public void push_back(EltTy NewVal) {
        assert (NewVal != null) : "Can't add a null value";
        if (this.$isNull()) {
            this.Val[0] = NewVal;
            this.$vector = false;
            return;
        }
        EltTy V = this.$getAsElement();
        if (V != null) {
            this.Val[0] = new SmallVector<Object>(4, null);
            this.$vector = true;
            this.$getAsVector().push_back(V);
        }
        this.$getAsVector().push_back(NewVal);
    }

    public void pop_back() {
        if (this.$isElement()) {
            this.Val[0] = null;
        } else {
            SmallVector<EltTy> Vec = this.$getAsVector();
            if (Vec != null) {
                assert (!Vec.empty()) : "JAVA: why pop back from empty vector?";
                Vec.pop_back();
            }
        }
    }

    public void clear() {
        if (this.$isElement()) {
            this.Val[0] = null;
        } else {
            SmallVector<EltTy> Vec = this.$getAsVector();
            if (Vec != null) {
                Vec.clear();
            }
        }
    }

    public type.ptr<EltTy> erase(type.ptr<EltTy> I) {
        assert (Native.$greatereq(I, this.begin())) : "Iterator to erase is out of bounds.";
        assert (Native.$less(I, this.end())) : "Erasing at past-the-end iterator.";
        if (this.$isElement()) {
            if (Native.$eq_ptr(I, this.begin())) {
                this.Val[0] = null;
            }
        } else {
            SmallVector<EltTy> Vec = this.$getAsVector();
            if (Vec != null) {
                return Vec.erase(I);
            }
        }
        return this.end();
    }

    public type.ptr<EltTy> erase(type.ptr<EltTy> S2, type.ptr<EltTy> E) {
        assert (Native.$greatereq_ptr(S2, this.begin())) : "Range to erase is out of bounds.";
        assert (Native.$lesseq_ptr(S2, E)) : "Trying to erase invalid range.";
        assert (Native.$lesseq_ptr(E, this.end())) : "Trying to erase past the end.";
        if (this.$isElement()) {
            if (Native.$eq_ptr(S2, this.begin()) && Native.$noteq_ptr(S2, E)) {
                this.Val[0] = null;
            }
        } else {
            SmallVector<EltTy> Vec = this.$getAsVector();
            if (Vec != null) {
                return Vec.erase(S2, E);
            }
        }
        return this.end();
    }

    public type.ptr<EltTy> insert(type.ptr<EltTy> I, EltTy Elt) {
        assert (Native.$greatereq(I, this.begin())) : "Insertion iterator is out of bounds.";
        assert (Native.$lesseq(I, this.end())) : "Inserting past the end of the vector.";
        if (Native.$eq_ptr(I, this.end())) {
            this.push_back(Elt);
            return (type.ptr)std.prev(this.end());
        }
        assert (!this.$isNull()) : "Null value with non-end insert iterator.";
        EltTy V = this.$getAsElement();
        if (V != null) {
            assert (Native.$eq_ptr(I, this.begin()));
            this.Val[0] = Elt;
            this.push_back(V);
            return this.begin();
        }
        return this.$getAsVector().insert(I, Elt);
    }

    public type.ptr<EltTy> insert(type.ptr<EltTy> I, type.iterator<?, EltTy> From, type.iterator<?, EltTy> To) {
        return this.insert$T(I, From, To);
    }

    public type.ptr<EltTy> insert$T(type.ptr<EltTy> I, type.iterator<?, EltTy> From, type.iterator<?, EltTy> To) {
        assert (Native.$greatereq_ptr(I, this.begin())) : "Insertion iterator is out of bounds.";
        assert (Native.$lesseq_ptr(I, this.end())) : "Inserting past the end of the vector.";
        if (Native.$eq_iter(From, To)) {
            return I;
        }
        int Offset = I.$sub(this.begin());
        if (this.$isNull()) {
            if (Native.$eq_iter((abstract_iterator)std.next((abstract_iterator)((type.iterator)Native.$tryClone(From))), To)) {
                this.Val[0] = Native.$star(From);
                return this.begin();
            }
            this.Val[0] = new SmallVector<Object>(4, null);
            this.$vector = true;
        } else {
            EltTy V = this.$getAsElement();
            if (V != null) {
                this.Val[0] = new SmallVector<Object>(4, null);
                this.$vector = true;
                this.$getAsVector().push_back(V);
            }
        }
        return this.$getAsVector().insert(Native.$add(this.begin(), (int)Offset), From, To);
    }

    public TinyPtrVector<EltTy> clone() {
        return new TinyPtrVector<EltTy>(this);
    }

    @Override
    public Iterator<EltTy> iterator() {
        return new JavaIterator(this.begin(), this.end());
    }

    public String toString() {
        return "Val=" + this.Val;
    }
}

