/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.CollectionUtils;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.ulong;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVectorChar;
import org.llvm.adt.aliases.SmallVectorImplChar;

public class SmallString
extends SmallVectorChar
implements std.ConvertableToStdString {
    public SmallString(int InternalLen) {
        super(InternalLen);
    }

    public SmallString(int InternalLen, StringRef S2) {
        super(InternalLen, (char.iterator<?>)S2.begin(), (char.iterator<?>)S2.end());
    }

    @Deprecated
    public SmallString(StringRef S2, int InternalLen) {
        super(InternalLen, (char.iterator<?>)S2.begin(), (char.iterator<?>)S2.end());
    }

    public SmallString(std.string S2) {
        this(S2.length(), new StringRef(S2));
    }

    public SmallString(String S2) {
        this(S2.length(), new StringRef(S2));
    }

    public SmallString(int capacity, int initialSize) {
        super(capacity, initialSize, (byte)48);
    }

    public SmallString(int capacity, int initialSize, byte defaultValue) {
        super(capacity, initialSize, defaultValue);
    }

    public <ItTy extends char.iterator> SmallString(ItTy S2, ItTy E, int InternalLen) {
        super(InternalLen, S2, E);
    }

    public SmallString(SmallString RHS) {
        super(RHS);
    }

    public SmallString(int capacity, ulong.ptr begin, ulong.ptr end) {
        super(capacity, (char.iterator<?>)CollectionUtils.transform_ulong2char$ptr((ulong.iterator)begin), std.distance((abstract_iterator)begin, (abstract_iterator)end));
    }

    public void assign(int NumElts, char Elt) {
        super.assign(NumElts, (byte)Elt);
    }

    public void assign(StringRef RHS) {
        this.clear();
        this.append(RHS);
    }

    public void assign(SmallVectorImplChar RHS) {
        this.clear();
        this.append(RHS);
    }

    public void append(StringRef RHS) {
        this.append(RHS, 0, RHS.size());
    }

    public void append(StringRef RHS, int fromIndex, int toIndexExclusive) {
        int count = toIndexExclusive - fromIndex;
        int end = this.size();
        this.reserve(end + count);
        while (fromIndex < toIndexExclusive) {
            this.$set(end, RHS.$at(fromIndex));
            ++end;
            ++fromIndex;
        }
        this.set_size(end);
    }

    public void append(std.string RHS) {
        this.append(RHS, 0, RHS.size());
    }

    public void append(std.string RHS, int fromIndex, int toIndexExclusive) {
        int count = toIndexExclusive - fromIndex;
        int end = this.size();
        this.reserve(end + count);
        while (fromIndex < toIndexExclusive) {
            this.$set(end, RHS.$at(fromIndex));
            ++end;
            ++fromIndex;
        }
        this.set_size(end);
    }

    public void append(String RHS) {
        this.append(RHS, 0, RHS.length());
    }

    public void append(String RHS, int fromIndex, int toIndexExclusive) {
        int count = toIndexExclusive - fromIndex;
        int end = this.size();
        this.reserve(end + count);
        while (fromIndex < toIndexExclusive) {
            this.$set(end, NativePointer.$((char)RHS.charAt(fromIndex)));
            ++end;
            ++fromIndex;
        }
        this.set_size(end);
    }

    public final void append$T(char.ptr in_start, char.ptr in_end) {
        this.append(in_start, in_end);
    }

    public final void append(char.ptr in_start, char.ptr in_end) {
        if (NativeTrace.isDebugMode()) {
            NativeTrace.printStackTraceOnce((Throwable)new Exception("Try to use other varians to prevent creation of second param char$ptr (i.e. append(str, str.$add(strlen(str))) can be replaced by append(str, strlen(str)) "));
        }
        this.append(in_start, in_end.$index() - in_start.$index());
    }

    public final void append(char.ptr in_start) {
        this.append(in_start, std.strlen((char.ptr)in_start));
    }

    public final void append$T(char.ptr in_start, int count) {
        this.append(in_start, count);
    }

    public final void append(char.ptr in_start, int count) {
        int end = this.size();
        this.reserve(end + count);
        for (int i = 0; i < count; ++i) {
            this.$set(end, in_start.$at(i));
            ++end;
        }
        this.set_size(end);
    }

    public void append(SmallVectorImplChar RHS) {
        this.append(RHS, 0, RHS.size());
    }

    public void append(SmallVectorImplChar RHS, int fromIdx, int toIdxExclusive) {
        int count = toIdxExclusive - fromIdx;
        super.append(RHS.$array(), fromIdx, count);
    }

    public boolean equals(StringRef RHS) {
        int Len = RHS.size();
        return this.size() == Len && std.memcmp((char.ptr)RHS.data(), (int)0, (byte[])this.$array(), (int)0, (int)Len) == 0;
    }

    public boolean equals(String RHS) {
        int Len = RHS.length();
        return this.size() == Len && std.memcmp((byte[])this.$array(), (int)0, (CharSequence)RHS, (int)Len) == 0;
    }

    public boolean equals_lower(StringRef RHS) {
        return this.str().equals_lower(RHS);
    }

    public int compare(StringRef RHS) {
        return this.str().compare(RHS);
    }

    public int compare_lower(StringRef RHS) {
        return this.str().compare_lower(RHS);
    }

    public int compare_numeric(StringRef RHS) {
        return this.str().compare_numeric(RHS);
    }

    public boolean startswith(StringRef Prefix) {
        return this.str().startswith(Prefix);
    }

    public boolean endswith(StringRef Suffix) {
        return this.str().endswith(Suffix);
    }

    public int find(StringRef Str) {
        return this.find(Str, 0);
    }

    public int find(StringRef Str, int From) {
        return this.str().find(Str, From);
    }

    public int rfind(byte C2) {
        return this.rfind(C2, StringRef.npos);
    }

    public int rfind(byte C2, int From) {
        return this.str().rfind(C2, From);
    }

    public int rfind(StringRef Str) {
        return this.str().rfind(Str);
    }

    public int find_first_of(byte C2) {
        return this.find_first_of(C2, 0);
    }

    public int find_first_of(byte C2, int From) {
        return this.str().find_first_of(C2, From);
    }

    public int find_first_of(StringRef Chars) {
        return this.find_first_of(Chars, 0);
    }

    public int find_first_of(StringRef Chars, int From) {
        return this.str().find_first_of(Chars, From);
    }

    public int find_first_not_of(byte C2) {
        return this.find_first_not_of(C2, 0);
    }

    public int find_first_not_of(byte C2, int From) {
        return this.str().find_first_not_of(C2, From);
    }

    public int find_first_not_of(StringRef Chars) {
        return this.find_first_not_of(Chars, 0);
    }

    public int find_first_not_of(StringRef Chars, int From) {
        return this.str().find_first_not_of(Chars, From);
    }

    public int find_last_of(byte C2) {
        return this.find_last_of(C2, StringRef.npos);
    }

    public int find_last_of(byte C2, int From) {
        return this.str().find_last_of(C2, From);
    }

    public int find_last_of(StringRef Chars) {
        return this.find_last_of(Chars, StringRef.npos);
    }

    public int find_last_of(StringRef Chars, int From) {
        return this.str().find_last_of(Chars, From);
    }

    public int count(byte C2) {
        return this.str().count(C2);
    }

    public int count(StringRef Str) {
        return this.str().count(Str);
    }

    public StringRef substr(int Start) {
        return this.substr(Start, StringRef.npos);
    }

    public StringRef substr(int Start, int N) {
        return this.str().substr(Start, N);
    }

    public StringRef slice(int Start, int End) {
        return this.str().slice(Start, End);
    }

    public StringRef str() {
        return new StringRef(this.$array(), this.size());
    }

    public char.ptr c_str() {
        this.push_back((byte)0);
        this.pop_back();
        return this.data();
    }

    public StringRef $StringRef() {
        return this.str();
    }

    public SmallString $assign(StringRef RHS) {
        return this.$assign(RHS, 0, RHS.size());
    }

    public SmallString $assign(StringRef RHS, int fromIndex, int toIndexExclusive) {
        this.clear();
        return this.$addassign(RHS, fromIndex, toIndexExclusive);
    }

    public SmallString $assign(char.ptr RHS) {
        return this.$assign(RHS, std.strlen((char.ptr)RHS));
    }

    public SmallString $assign(char.ptr RHS, int Len) {
        this.clear();
        return this.$addassign(RHS, Len);
    }

    public SmallString $assign(std.string RHS) {
        this.clear();
        return this.$addassign(RHS);
    }

    public SmallString $assign(String RHS) {
        this.clear();
        return this.$addassign(RHS);
    }

    public SmallString $addassign(StringRef RHS) {
        return this.$addassign(RHS, 0, RHS.size());
    }

    public SmallString $addassign(StringRef RHS, int fromIndex, int toIndexExclusive) {
        this.append(RHS, fromIndex, toIndexExclusive);
        return this;
    }

    public SmallString $addassign(std.string RHS) {
        this.append(RHS);
        return this;
    }

    public SmallString $addassign(SmallVectorImplChar RHS) {
        this.append(RHS);
        return this;
    }

    public SmallString $addassign(String RHS) {
        this.append(RHS);
        return this;
    }

    public SmallString $addassign(char.ptr RHS) {
        return this.$addassign(RHS, std.strlen((char.ptr)RHS));
    }

    public SmallString $addassign(char.ptr RHS, int Len) {
        this.append(RHS, Len);
        return this;
    }

    public SmallString $addassign(byte C2) {
        this.push_back(C2);
        return this;
    }

    @Override
    public SmallString clone() {
        return new SmallString(this);
    }

    public String toJavaString() {
        return Casts.toJavaString((byte[])this.$array(), (int)0, (int)this.size());
    }

    public void toStringBuilder(StringBuilder out) {
        Casts.toStringBuilder((StringBuilder)out, (byte[])this.$array(), (int)0, (int)this.size());
    }

    @Override
    public String toString() {
        return "SmallString{" + this.toJavaString() + "}";
    }

    public std.string std$string() {
        return new std.string(this.$array(), 0, this.size());
    }
}

