/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeSwappable;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uint;
import org.llvm.adt.BitVector;
import org.llvm.adt.BitVectorTy;
import org.llvm.support.llvm;

public class SmallBitVector
implements BitVectorTy<SmallBitVector>,
NativeSwappable,
Destructors.ClassWithDestructor,
Native.NativeComparable<SmallBitVector> {
    private long X;
    public static final int NumBaseBits = 64;
    public static final int SmallNumRawBits = NumBaseBits - 1;
    public static final int SmallNumSizeBits = NumBaseBits == 32 ? 5 : (NumBaseBits == 64 ? 6 : SmallNumRawBits);
    public static final int SmallNumDataBits = SmallNumRawBits - SmallNumSizeBits;

    private boolean isSmall() {
        return (this.X & 1L) != 0L;
    }

    private BitVector getPointer() {
        assert (!this.isSmall()) : "to have only one field X we support only Small mode, use BitVector instead or complete this implementation";
        return (BitVector)Casts.reinterpret_cast(BitVector.class, (long)this.X);
    }

    private void switchToSmall(long NewSmallBits, int NewSize) {
        this.X = 1L;
        this.setSmallSize(NewSize);
        this.setSmallBits(NewSmallBits);
    }

    private void switchToLarge(BitVector BV) {
        assert (false) : "not yet supported";
        assert (!this.isSmall()) : "Tried to use an unaligned pointer";
    }

    private long getSmallRawBits() {
        assert (this.isSmall());
        return this.X >>> 1;
    }

    private void setSmallRawBits(long NewRawBits) {
        assert (this.isSmall());
        this.X = NewRawBits << 1 | 1L;
    }

    private int getSmallSize() {
        return Unsigned.$ulong2uint((long)(this.getSmallRawBits() >>> SmallNumDataBits));
    }

    private void setSmallSize(long Size) {
        this.setSmallRawBits(this.getSmallBits() | Size << SmallNumDataBits);
    }

    private long getSmallBits() {
        return this.getSmallRawBits() & (-1L << this.getSmallSize() ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private void setSmallBits(long NewBits) {
        this.setSmallRawBits(NewBits & (-1L << this.getSmallSize() ^ 0xFFFFFFFFFFFFFFFFL) | (long)this.getSmallSize() << SmallNumDataBits);
    }

    public SmallBitVector() {
        this.X = 1L;
    }

    public SmallBitVector(int s) {
        this(s, false);
    }

    public SmallBitVector(int s, boolean t) {
        if (Unsigned.$lesseq_uint_int((int)s, (int)SmallNumDataBits)) {
            this.switchToSmall(t ? -1L : 0L, s);
        } else {
            this.switchToLarge(new BitVector(s, t));
        }
    }

    public SmallBitVector(SmallBitVector RHS) {
        if (RHS.isSmall()) {
            this.X = RHS.X;
        } else {
            this.switchToLarge(new BitVector((BitVector)Native.$Deref((Object)RHS.getPointer())));
        }
    }

    public SmallBitVector(JavaDifferentiators.JD.Move _dparam, SmallBitVector RHS) {
        this.X = RHS.X;
        RHS.X = 1L;
    }

    public void $destroy() {
        if (!this.isSmall() && this.getPointer() != null) {
            this.getPointer().$destroy();
        }
    }

    @Override
    public boolean empty() {
        return this.isSmall() ? this.getSmallSize() == 0 : this.getPointer().empty();
    }

    @Override
    public int size() {
        return this.isSmall() ? this.getSmallSize() : this.getPointer().size();
    }

    public int count() {
        if (this.isSmall()) {
            long Bits = this.getSmallBits();
            return llvm.CountPopulation_64(Bits);
        }
        return this.getPointer().count();
    }

    public boolean any() {
        if (this.isSmall()) {
            return this.getSmallBits() != 0L;
        }
        return this.getPointer().any();
    }

    public boolean all() {
        if (this.isSmall()) {
            return this.getSmallBits() == (1L << this.getSmallSize()) - 1L;
        }
        return this.getPointer().all();
    }

    public boolean none() {
        if (this.isSmall()) {
            return this.getSmallBits() == 0L;
        }
        return this.getPointer().none();
    }

    public int find_first() {
        if (this.isSmall()) {
            long Bits = this.getSmallBits();
            if (Bits == 0L) {
                return -1;
            }
            return llvm.countTrailingZeros_uint64_t_ZeroBehavior(Bits);
        }
        return this.getPointer().find_first();
    }

    public int find_next(int Prev) {
        if (this.isSmall()) {
            long Bits = this.getSmallBits();
            if ((Bits &= -1L << Prev + 1) == 0L || Unsigned.$greatereq_uint((int)(Prev + 1), (int)this.getSmallSize())) {
                return -1;
            }
            return llvm.countTrailingZeros_uint64_t_ZeroBehavior(Bits);
        }
        return this.getPointer().find_next(Prev);
    }

    @Override
    public void clear() {
        if (!this.isSmall() && this.getPointer() != null) {
            this.getPointer().$destroy();
        }
        this.switchToSmall(0L, 0);
    }

    @Override
    public void resize(int N) {
        this.resize(N, false);
    }

    public void resize(int N, boolean t) {
        if (!this.isSmall()) {
            this.getPointer().resize(N, t);
        } else if (Unsigned.$greatereq_int_uint((int)SmallNumDataBits, (int)N)) {
            long NewBits = t ? -1L << this.getSmallSize() : 0L;
            this.setSmallSize(N);
            this.setSmallBits(NewBits | this.getSmallBits());
        } else {
            BitVector BV = new BitVector(N, t);
            long OldBits = this.getSmallBits();
            int e = this.getSmallSize();
            for (int i = 0; i != e; ++i) {
                ((BitVector)Native.$Deref((Object)BV)).$at(i).$assign((OldBits >>> i & 1L) != 0L);
            }
            this.switchToLarge(BV);
        }
    }

    @Override
    public void reserve(int N) {
        if (this.isSmall()) {
            if (Unsigned.$greater_uint_int((int)N, (int)SmallNumDataBits)) {
                long OldBits = this.getSmallRawBits();
                int SmallSize = this.getSmallSize();
                BitVector BV = new BitVector(SmallSize);
                int i = 0;
                while (Unsigned.$less_uint((int)i, (int)SmallSize)) {
                    if ((OldBits >>> i & 1L) != 0L) {
                        BV.set(i);
                    }
                    ++i;
                }
                BV.reserve(N);
                this.switchToLarge(BV);
            }
        } else {
            this.getPointer().reserve(N);
        }
    }

    public SmallBitVector set() {
        if (this.isSmall()) {
            this.setSmallBits(-1L);
        } else {
            this.getPointer().set();
        }
        return this;
    }

    @Override
    public SmallBitVector set(int Idx) {
        if (this.isSmall()) {
            assert (Unsigned.$lesseq_uint((int)Idx, (int)64)) : "undefined behavior";
            this.setSmallBits(this.getSmallBits() | 1L << Idx);
        } else {
            this.getPointer().set(Idx);
        }
        return this;
    }

    public SmallBitVector set(int I, int E) {
        assert (Unsigned.$lesseq_uint((int)I, (int)E)) : "Attempted to set backwards range!";
        assert (Unsigned.$lesseq_uint((int)E, (int)this.size())) : "Attempted to set out-of-bounds range!";
        if (I == E) {
            return this;
        }
        if (this.isSmall()) {
            long EMask = 1L << E;
            long IMask = 1L << I;
            long Mask = EMask - IMask;
            this.setSmallBits(this.getSmallBits() | Mask);
        } else {
            this.getPointer().set(I, E);
        }
        return this;
    }

    @Override
    public SmallBitVector reset() {
        if (this.isSmall()) {
            this.setSmallBits(0L);
        } else {
            this.getPointer().reset();
        }
        return this;
    }

    public SmallBitVector reset(int Idx) {
        if (this.isSmall()) {
            this.setSmallBits(this.getSmallBits() & (1L << Idx ^ 0xFFFFFFFFFFFFFFFFL));
        } else {
            this.getPointer().reset(Idx);
        }
        return this;
    }

    public SmallBitVector reset(int I, int E) {
        assert (Unsigned.$lesseq_uint((int)I, (int)E)) : "Attempted to reset backwards range!";
        assert (Unsigned.$lesseq_uint((int)E, (int)this.size())) : "Attempted to reset out-of-bounds range!";
        if (I == E) {
            return this;
        }
        if (this.isSmall()) {
            long EMask = 1L << E;
            long IMask = 1L << I;
            long Mask = EMask - IMask;
            this.setSmallBits(this.getSmallBits() & (Mask ^ 0xFFFFFFFFFFFFFFFFL));
        } else {
            this.getPointer().reset(I, E);
        }
        return this;
    }

    public SmallBitVector flip() {
        if (this.isSmall()) {
            this.setSmallBits(this.getSmallBits() ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            this.getPointer().flip();
        }
        return this;
    }

    public SmallBitVector flip(int Idx) {
        if (this.isSmall()) {
            this.setSmallBits(this.getSmallBits() ^ 1L << Idx);
        } else {
            this.getPointer().flip(Idx);
        }
        return this;
    }

    public SmallBitVector $bitnot() {
        return new SmallBitVector(this).flip();
    }

    @Override
    public reference $at(int Idx) {
        assert (Unsigned.$less_uint((int)Idx, (int)this.size())) : "Out-of-bounds Bit access.";
        return new reference(this, Idx);
    }

    @Override
    public boolean $at$Const(int Idx) {
        assert (Unsigned.$less_uint((int)Idx, (int)this.size())) : "Out-of-bounds Bit access.";
        if (this.isSmall()) {
            return (this.getSmallBits() >>> Idx & 1L) != 0L;
        }
        return this.getPointer().$at(Idx).$bool();
    }

    public boolean test(int Idx) {
        return this.$at$Const(Idx);
    }

    public boolean anyCommon(SmallBitVector RHS) {
        if (this.isSmall() && RHS.isSmall()) {
            return (this.getSmallBits() & RHS.getSmallBits()) != 0L;
        }
        if (!this.isSmall() && !RHS.isSmall()) {
            return this.getPointer().anyCommon((BitVector)Native.$Deref((Object)RHS.getPointer()));
        }
        int e = std.min_uint((int)this.size(), (int)RHS.size());
        for (int i = 0; i != e; ++i) {
            if (!this.test(i) || !RHS.test(i)) continue;
            return true;
        }
        return false;
    }

    public boolean $eq(SmallBitVector RHS) {
        if (this.size() != RHS.size()) {
            return false;
        }
        if (this.isSmall()) {
            return this.getSmallBits() == RHS.getSmallBits();
        }
        return this.getPointer().$eq((BitVector)Native.$Deref((Object)RHS.getPointer()));
    }

    public boolean $noteq(SmallBitVector RHS) {
        return !this.$eq(RHS);
    }

    public SmallBitVector $andassign(SmallBitVector RHS) {
        this.resize(std.max((int)this.size(), (int)RHS.size()));
        if (this.isSmall()) {
            this.setSmallBits(this.getSmallBits() & RHS.getSmallBits());
        } else if (!RHS.isSmall()) {
            this.getPointer().$andassign((BitVector)Native.$Deref((Object)RHS.getPointer()));
        } else {
            SmallBitVector Copy = new SmallBitVector(RHS);
            Copy.resize(this.size());
            this.getPointer().$andassign((BitVector)Native.$Deref((Object)Copy.getPointer()));
        }
        return this;
    }

    public SmallBitVector reset(SmallBitVector RHS) {
        if (this.isSmall() && RHS.isSmall()) {
            this.setSmallBits(this.getSmallBits() & (RHS.getSmallBits() ^ 0xFFFFFFFFFFFFFFFFL));
        } else if (!this.isSmall() && !RHS.isSmall()) {
            this.getPointer().reset((BitVector)Native.$Deref((Object)RHS.getPointer()));
        } else {
            int e = std.min_uint((int)this.size(), (int)RHS.size());
            for (int i = 0; i != e; ++i) {
                if (!RHS.test(i)) continue;
                this.reset(i);
            }
        }
        return this;
    }

    public boolean test(SmallBitVector RHS) {
        int i;
        if (this.isSmall() && RHS.isSmall()) {
            return (this.getSmallBits() & (RHS.getSmallBits() ^ 0xFFFFFFFFFFFFFFFFL)) != 0L;
        }
        if (!this.isSmall() && !RHS.isSmall()) {
            return this.getPointer().test((BitVector)Native.$Deref((Object)RHS.getPointer()));
        }
        int e = std.min_uint((int)this.size(), (int)RHS.size());
        for (i = 0; i != e; ++i) {
            if (!this.test(i) || RHS.test(i)) continue;
            return true;
        }
        e = this.size();
        while (i != e) {
            if (this.test(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public SmallBitVector $orassign(SmallBitVector RHS) {
        this.resize(std.max((int)this.size(), (int)RHS.size()));
        if (this.isSmall()) {
            this.setSmallBits(this.getSmallBits() | RHS.getSmallBits());
        } else if (!RHS.isSmall()) {
            this.getPointer().$orassign((BitVector)Native.$Deref((Object)RHS.getPointer()));
        } else {
            SmallBitVector Copy = new SmallBitVector(RHS);
            Copy.resize(this.size());
            this.getPointer().$orassign((BitVector)Native.$Deref((Object)Copy.getPointer()));
        }
        return this;
    }

    public SmallBitVector $xorassign(SmallBitVector RHS) {
        this.resize(std.max((int)this.size(), (int)RHS.size()));
        if (this.isSmall()) {
            this.setSmallBits(this.getSmallBits() ^ RHS.getSmallBits());
        } else if (!RHS.isSmall()) {
            this.getPointer().$xorassign((BitVector)Native.$Deref((Object)RHS.getPointer()));
        } else {
            SmallBitVector Copy = new SmallBitVector(RHS);
            Copy.resize(this.size());
            this.getPointer().$xorassign((BitVector)Native.$Deref((Object)Copy.getPointer()));
        }
        return this;
    }

    @Override
    public SmallBitVector $assign(SmallBitVector RHS) {
        if (this.isSmall()) {
            if (RHS.isSmall()) {
                this.X = RHS.X;
            } else {
                this.switchToLarge(new BitVector((BitVector)Native.$Deref((Object)RHS.getPointer())));
            }
        } else if (!RHS.isSmall()) {
            this.getPointer().$assign((BitVector)Native.$Deref((Object)RHS.getPointer()));
        } else {
            if (this.getPointer() != null) {
                this.getPointer().$destroy();
            }
            this.X = RHS.X;
        }
        return this;
    }

    public SmallBitVector $assignMove(SmallBitVector RHS) {
        if (this != Native.$AddrOf((Object)RHS)) {
            this.clear();
            this.swap(RHS);
        }
        return this;
    }

    public void swap(SmallBitVector RHS) {
        std.swap((long)this.X, (long)RHS.X);
    }

    public void setBitsInMask(uint.ptr Mask) {
        this.setBitsInMask(Mask, -1);
    }

    public void setBitsInMask(uint.ptr Mask, int MaskWords) {
        if (this.isSmall()) {
            this.applyMask(true, false, Mask, MaskWords);
        } else {
            this.getPointer().setBitsInMask(Mask, MaskWords);
        }
    }

    public void clearBitsInMask(uint.ptr Mask) {
        this.clearBitsInMask(Mask, -1);
    }

    public void clearBitsInMask(uint.ptr Mask, int MaskWords) {
        if (this.isSmall()) {
            this.applyMask(false, false, Mask, MaskWords);
        } else {
            this.getPointer().clearBitsInMask(Mask, MaskWords);
        }
    }

    public void setBitsNotInMask(uint.ptr Mask) {
        this.setBitsNotInMask(Mask, -1);
    }

    public void setBitsNotInMask(uint.ptr Mask, int MaskWords) {
        if (this.isSmall()) {
            this.applyMask(true, true, Mask, MaskWords);
        } else {
            this.getPointer().setBitsNotInMask(Mask, MaskWords);
        }
    }

    public void clearBitsNotInMask(uint.ptr Mask) {
        this.clearBitsNotInMask(Mask, -1);
    }

    public void clearBitsNotInMask(uint.ptr Mask, int MaskWords) {
        if (this.isSmall()) {
            this.applyMask(false, true, Mask, MaskWords);
        } else {
            this.getPointer().clearBitsNotInMask(Mask, MaskWords);
        }
    }

    private void applyMask(boolean AddBits, boolean InvertMask, uint.ptr Mask, int MaskWords) {
        assert (Unsigned.$lesseq_uint((int)MaskWords, (int)NativeType.$sizeof_UIntptr_t())) : "Mask is larger than base!";
        long M = Mask.$at(0);
        if (NumBaseBits == 64) {
            M |= Unsigned.$uint2ulong((int)Mask.$at(1)) << 32;
        }
        if (InvertMask) {
            M ^= 0xFFFFFFFFFFFFFFFFL;
        }
        if (AddBits) {
            this.setSmallBits(this.getSmallBits() | M);
        } else {
            this.setSmallBits(this.getSmallBits() & (M ^ 0xFFFFFFFFFFFFFFFFL));
        }
    }

    public void swap(NativeSwappable RHS) {
        this.swap((SmallBitVector)RHS);
    }

    public SmallBitVector clone() {
        return new SmallBitVector(this);
    }

    public String toString() {
        return "X=" + this.X;
    }

    static {
        std.static_assert((NumBaseBits == 64 || NumBaseBits == 32 ? 1 : 0) != 0, (char.ptr)NativePointer.$((String)"Unsupported word size"));
    }

    public static class reference
    implements Native.Native$Bool,
    BitVectorTy.reference {
        private final SmallBitVector TheVector;
        private int BitPos;

        public reference(SmallBitVector b, int Idx) {
            this.TheVector = b;
            this.BitPos = Idx;
        }

        public reference(reference $Prm0) {
            this.TheVector = $Prm0.TheVector;
            this.BitPos = $Prm0.BitPos;
        }

        public reference $assign(reference t) {
            this.$assign(t.$bool());
            return this;
        }

        @Override
        public reference $assign(boolean t) {
            if (t) {
                this.TheVector.set(this.BitPos);
            } else {
                this.TheVector.reset(this.BitPos);
            }
            return this;
        }

        @Override
        public boolean $bool() {
            return this.TheVector.$at$Const(this.BitPos);
        }

        public String toString() {
            return "TheVector=" + this.TheVector + ", BitPos=" + this.BitPos;
        }
    }
}

