/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.llvm.adt.BitVectorTy;
import org.llvm.adt.PackedVectorBase;
import org.llvm.adt.PackedVectorBaseTTFalse;
import org.llvm.adt.PackedVectorBaseTTTrue;

public class PackedVector
implements Native.NativeComparable<PackedVector>,
Native.NativePOD<PackedVector> {
    private final PackedVectorBase base;
    private final int BitNum;
    private BitVectorTy Bits;

    public void $destroy() {
    }

    public PackedVector(int BitNum, boolean is_signed, BitVectorTy Bits) {
        this.base = is_signed ? new PackedVectorBaseTTTrue(BitNum) : new PackedVectorBaseTTFalse(BitNum);
        this.BitNum = BitNum;
        this.Bits = Bits;
        Bits.resize(0);
    }

    public PackedVector(int BitNum, boolean is_signed, BitVectorTy Bits, int size) {
        this.base = is_signed ? new PackedVectorBaseTTTrue(BitNum) : new PackedVectorBaseTTFalse(BitNum);
        this.BitNum = BitNum;
        this.Bits = Bits;
        Bits.resize(size << BitNum - 1);
    }

    public PackedVector $assign(PackedVector other) {
        assert (this.base.$eq(other.base));
        assert (this.BitNum == other.BitNum);
        assert (this.Bits.getClass() == other.Bits.getClass());
        this.Bits.$assign(other.Bits);
        return this;
    }

    public boolean empty() {
        return this.Bits.empty();
    }

    public int size() {
        return this.Bits.size() >>> this.BitNum - 1;
    }

    public void clear() {
        this.Bits.clear();
    }

    public void resize(int N) {
        this.Bits.resize(N << this.BitNum - 1);
    }

    public void reserve(int N) {
        this.Bits.reserve(N << this.BitNum - 1);
    }

    public PackedVector reset() {
        this.Bits.reset();
        return (PackedVector)Native.$star((Object)this);
    }

    public void push_back(int val) {
        this.resize(this.size() + 1);
        ((PackedVector)Native.$star((Object)this)).$at(this.size() - 1).$assign(val);
    }

    public reference $at(int Idx) {
        return new reference((PackedVector)Native.$star((Object)this), Idx);
    }

    public int $at$Const(int Idx) {
        return this.base.getValue(this.Bits, Idx);
    }

    public boolean $eq(PackedVector RHS) {
        return Native.$eq((Object)this.Bits, (Object)RHS.Bits);
    }

    public boolean $noteq(PackedVector RHS) {
        return Native.$noteq((Object)this.Bits, (Object)RHS.Bits);
    }

    public PackedVector $orassign(PackedVector RHS) {
        this.Bits.$orassign(RHS.Bits);
        return (PackedVector)Native.$star((Object)this);
    }

    public PackedVector() {
        this.base = null;
        this.BitNum = 0;
    }

    private PackedVector(PackedVector $Prm0) {
        this.base = (PackedVectorBase)Native.$tryClone((NativeCloneable)$Prm0.base);
        this.BitNum = $Prm0.BitNum;
        this.Bits = (BitVectorTy)Native.$tryClone((NativeCloneable)$Prm0.Bits);
    }

    public PackedVector clone() {
        return new PackedVector(this);
    }

    public String toString() {
        return "Bits=" + this.Bits + super.toString();
    }

    public static class reference<T> {
        private PackedVector Vec;
        private int Idx;

        private reference() {
            throw new UnsupportedOperationException("<<<DeclJavaPrinter::VisitFunctionDecl NULL BODY IN USED Translation Unit>>>");
        }

        public reference(PackedVector vec, int idx) {
            this.Vec = vec;
            this.Idx = idx;
        }

        public reference<T> $assign(int val) {
            this.Vec.base.setValue(this.Vec.Bits, this.Idx, val);
            return (reference)Native.$star((Object)this);
        }

        public int $T() {
            return this.Vec.base.getValue(this.Vec.Bits, this.Idx);
        }

        public String toString() {
            return "Vec=" + this.Vec + ", Idx=" + this.Idx;
        }
    }
}

