/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import java.util.Iterator;
import org.clank.support.Native;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.type;
import org.llvm.adt.FoldingSetNodeID;
import org.llvm.adt.ImmutableListImpl;

public class ImmutableList<T>
implements Native.NativeComparable<ImmutableList<T>>,
Iterable<T>,
Native.NativePOD<ImmutableList<T>> {
    private ImmutableListImpl<T> X;

    public ImmutableList() {
        this((ImmutableListImpl)null);
    }

    public ImmutableList(ImmutableListImpl<T> x) {
        this.X = x;
    }

    public ImmutableListImpl<T> getInternalPointer() {
        return this.X;
    }

    public iterator<T> begin() {
        return new iterator(this.X);
    }

    public iterator<T> end() {
        return new iterator();
    }

    public boolean isEmpty() {
        return this.X != null;
    }

    public boolean contains(T V) {
        iterator<T> I = this.begin();
        iterator<T> E = this.end();
        while (Native.$noteq(I, E)) {
            if (Native.$eq((Object)Native.$star(I), V)) {
                return true;
            }
            I.$preInc();
        }
        return false;
    }

    public boolean isEqual(ImmutableList<T> L) {
        return this.X == L.X;
    }

    public boolean $eq(ImmutableList<T> L) {
        return this.isEqual(L);
    }

    public T getHead() {
        assert (Native.$bool((boolean)Native.$not((boolean)this.isEmpty()))) : "Cannot get the head of an empty list.";
        return this.X.getHead();
    }

    public ImmutableList<T> getTail() {
        return new ImmutableList<T>(this.X != null ? this.X.getTail() : null);
    }

    public void Profile(FoldingSetNodeID ID) {
        ID.AddPointer(this.X);
    }

    public ImmutableList(ImmutableList<T> $Prm0) {
        this.X = $Prm0.X;
    }

    public ImmutableList<T> $assign(ImmutableList<T> consVals) {
        assert (this != consVals);
        this.X = consVals.X;
        return this;
    }

    public ImmutableList<T> $assignMove(ImmutableList<T> consVals) {
        assert (this != consVals);
        this.X = consVals.X;
        consVals.X = null;
        return this;
    }

    public ImmutableList<T> clone() {
        return new ImmutableList<T>(this);
    }

    @Override
    public Iterator<T> iterator() {
        return new JavaIterator(this.begin(), this.end());
    }

    public String toString() {
        return "X=" + this.X;
    }

    public static class iterator<T>
    implements Native.NativeComparable,
    type.iterator<iterator<T>, T> {
        private ImmutableListImpl<T> L;

        public iterator() {
            this.L = null;
        }

        public iterator(ImmutableList<T> l) {
            this.L = l.getInternalPointer();
        }

        public iterator<T> $preInc() {
            this.L = this.L.getTail();
            return this;
        }

        public boolean $eq(iterator<T> I) {
            return this.L == I.L;
        }

        public boolean $noteq(iterator<T> I) {
            return this.L != I.L;
        }

        public T $star() {
            return this.L.getHead();
        }

        public ImmutableList<T> getList() {
            return new ImmutableList<T>(this.L);
        }

        private iterator(ImmutableListImpl<T> inner) {
            this.L = inner;
        }

        public iterator<T> clone() {
            return new iterator<T>(this.L);
        }

        public String toString() {
            return "L=" + this.L;
        }
    }
}

