/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import java.util.Arrays;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeSwappable;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uint;
import org.llvm.adt.BitVectorTy;
import org.llvm.support.llvm;

public class BitVector
implements BitVectorTy<BitVector>,
Destructors.ClassWithDestructor,
Native.NativeComparable<BitVector>,
NativeSwappable {
    public static final int BITWORD_SIZE = NativeType.$sizeof_ULong() * 8;
    private long[] Bits;
    private int Size;
    private int Capacity;

    public BitVector() {
        this.Size = 0;
        this.Capacity = 0;
        this.Bits = null;
    }

    public BitVector(int s) {
        this(s, false);
    }

    public BitVector(int s, boolean t) {
        this.Size = s;
        this.Capacity = this.NumBitWords(s);
        this.Bits = new long[this.Capacity];
        this.init_words(this.Bits, t);
        if (t) {
            this.clear_unused_bits();
        }
    }

    public BitVector(BitVector RHS) {
        this.Size = RHS.size();
        if (this.Size == 0) {
            this.Bits = null;
            this.Capacity = 0;
            return;
        }
        this.Capacity = this.NumBitWords(RHS.size());
        this.Bits = new long[this.Capacity];
        NativePointer.copy$Object((long[])RHS.Bits, (int)0, (long[])this.Bits, (int)0, (int)this.Capacity);
    }

    public BitVector(JavaDifferentiators.JD.Move _dparam, BitVector RHS) {
        this.Bits = RHS.Bits;
        this.Size = RHS.Size;
        this.Capacity = RHS.Capacity;
        RHS.Bits = null;
        RHS.Capacity = 0;
        RHS.Size = 0;
    }

    public void $destroy() {
        std.free((Object)this.Bits);
    }

    @Override
    public boolean empty() {
        return this.Size == 0;
    }

    @Override
    public int size() {
        return this.Size;
    }

    public int count() {
        int NumBits = 0;
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)this.NumBitWords(this.size()))) {
            NumBits += llvm.CountPopulation_64(this.Bits[i]);
            ++i;
        }
        return NumBits;
    }

    public boolean any() {
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)this.NumBitWords(this.size()))) {
            if (this.Bits[i] != 0L) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean all() {
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)(this.Size / BITWORD_SIZE))) {
            if (this.Bits[i] != -1L) {
                return false;
            }
            ++i;
        }
        int Remainder = this.Size % BITWORD_SIZE;
        if (Remainder != 0) {
            return this.Bits[this.Size / BITWORD_SIZE] == (1L << Remainder) - 1L;
        }
        return true;
    }

    public boolean none() {
        return !this.any();
    }

    public int find_first() {
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)this.NumBitWords(this.size()))) {
            if (this.Bits[i] != 0L) {
                return i * BITWORD_SIZE + llvm.countTrailingZeros_uint64_t_ZeroBehavior(this.Bits[i]);
            }
            ++i;
        }
        return -1;
    }

    public int find_next(int Prev) {
        if (Unsigned.$greatereq_uint((int)(++Prev), (int)this.Size)) {
            return -1;
        }
        int WordPos = Prev / BITWORD_SIZE;
        int BitPos = Prev % BITWORD_SIZE;
        long Copy = this.Bits[WordPos];
        if ((Copy &= -1L << BitPos) != 0L) {
            return WordPos * BITWORD_SIZE + llvm.countTrailingZeros_uint64_t_ZeroBehavior(Copy);
        }
        int i = WordPos + 1;
        while (Unsigned.$less_uint((int)i, (int)this.NumBitWords(this.size()))) {
            if (this.Bits[i] != 0L) {
                return i * BITWORD_SIZE + llvm.countTrailingZeros_uint64_t_ZeroBehavior(this.Bits[i]);
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void clear() {
        this.Size = 0;
    }

    @Override
    public void resize(int N) {
        this.resize(N, false);
    }

    public void resize(int N, boolean t) {
        if (Unsigned.$greater_uint((int)N, (int)(this.Capacity * BITWORD_SIZE))) {
            int OldCapacity = this.Capacity;
            this.grow(N);
            this.init_words(this.Bits, OldCapacity, this.Capacity - OldCapacity, t);
        }
        if (Unsigned.$greater_uint((int)N, (int)this.Size)) {
            this.set_unused_bits(t);
        }
        int OldSize = this.Size;
        this.Size = N;
        if (t || Unsigned.$less_uint((int)N, (int)OldSize)) {
            this.clear_unused_bits();
        }
    }

    @Override
    public void reserve(int N) {
        if (Unsigned.$greater_uint((int)N, (int)(this.Capacity * BITWORD_SIZE))) {
            this.grow(N);
        }
    }

    public BitVector set() {
        this.init_words(this.Bits, true);
        this.clear_unused_bits();
        return this;
    }

    @Override
    public BitVector set(int Idx) {
        assert (this.Bits != null) : "Bits never allocated";
        int n = Idx / BITWORD_SIZE;
        this.Bits[n] = this.Bits[n] | 1L << Idx % BITWORD_SIZE;
        return this;
    }

    public BitVector set(int I, int E) {
        assert (Unsigned.$lesseq_uint((int)I, (int)E)) : "Attempted to set backwards range!";
        assert (Unsigned.$lesseq_uint((int)E, (int)this.size())) : "Attempted to set out-of-bounds range!";
        if (I == E) {
            return this;
        }
        if (I / BITWORD_SIZE == E / BITWORD_SIZE) {
            long EMask = 1L << E % BITWORD_SIZE;
            long IMask = 1L << I % BITWORD_SIZE;
            long Mask = EMask - IMask;
            int n = I / BITWORD_SIZE;
            this.Bits[n] = this.Bits[n] | Mask;
            return this;
        }
        long PrefixMask = -1L << I % BITWORD_SIZE;
        int n = I / BITWORD_SIZE;
        this.Bits[n] = this.Bits[n] | PrefixMask;
        I = Unsigned.$ulong2uint((long)llvm.alignTo(Unsigned.$uint2ulong((int)I), Unsigned.$uint2ulong((int)BITWORD_SIZE)));
        while (Unsigned.$lesseq_uint((int)(I + BITWORD_SIZE), (int)E)) {
            this.Bits[I / BitVector.BITWORD_SIZE] = -1L;
            I += BITWORD_SIZE;
        }
        long PostfixMask = (1L << E % BITWORD_SIZE) - 1L;
        if (Unsigned.$less_uint((int)I, (int)E)) {
            int n2 = I / BITWORD_SIZE;
            this.Bits[n2] = this.Bits[n2] | PostfixMask;
        }
        return this;
    }

    @Override
    public BitVector reset() {
        this.init_words(this.Bits, false);
        return this;
    }

    public BitVector reset(int Idx) {
        int n = Idx / BITWORD_SIZE;
        this.Bits[n] = this.Bits[n] & (1L << Idx % BITWORD_SIZE ^ 0xFFFFFFFFFFFFFFFFL);
        return this;
    }

    public BitVector reset(int I, int E) {
        assert (Unsigned.$lesseq_uint((int)I, (int)E)) : "Attempted to reset backwards range!";
        assert (Unsigned.$lesseq_uint((int)E, (int)this.size())) : "Attempted to reset out-of-bounds range!";
        if (I == E) {
            return this;
        }
        if (I / BITWORD_SIZE == E / BITWORD_SIZE) {
            long EMask = 1L << E % BITWORD_SIZE;
            long IMask = 1L << I % BITWORD_SIZE;
            long Mask = EMask - IMask;
            int n = I / BITWORD_SIZE;
            this.Bits[n] = this.Bits[n] & (Mask ^ 0xFFFFFFFFFFFFFFFFL);
            return this;
        }
        long PrefixMask = -1L << I % BITWORD_SIZE;
        int n = I / BITWORD_SIZE;
        this.Bits[n] = this.Bits[n] & (PrefixMask ^ 0xFFFFFFFFFFFFFFFFL);
        I = Unsigned.$ulong2uint((long)llvm.alignTo(Unsigned.$uint2ulong((int)I), Unsigned.$uint2ulong((int)BITWORD_SIZE)));
        while (Unsigned.$lesseq_uint((int)(I + BITWORD_SIZE), (int)E)) {
            this.Bits[I / BitVector.BITWORD_SIZE] = 0L;
            I += BITWORD_SIZE;
        }
        long PostfixMask = (1L << E % BITWORD_SIZE) - 1L;
        if (Unsigned.$less_uint((int)I, (int)E)) {
            int n2 = I / BITWORD_SIZE;
            this.Bits[n2] = this.Bits[n2] & (PostfixMask ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return this;
    }

    public BitVector flip() {
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)this.NumBitWords(this.size()))) {
            this.Bits[i] = this.Bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
            ++i;
        }
        this.clear_unused_bits();
        return this;
    }

    public BitVector flip(int Idx) {
        int n = Idx / BITWORD_SIZE;
        this.Bits[n] = this.Bits[n] ^ 1L << Idx % BITWORD_SIZE;
        return this;
    }

    @Override
    public reference $at(int Idx) {
        assert (Unsigned.$less_uint((int)Idx, (int)this.Size)) : "Out-of-bounds Bit access.";
        return new reference(this, Idx);
    }

    @Override
    public boolean $at$Const(int Idx) {
        assert (Unsigned.$less_uint((int)Idx, (int)this.Size)) : "Out-of-bounds Bit access.";
        long Mask = 1L << Idx % BITWORD_SIZE;
        return (this.Bits[Idx / BITWORD_SIZE] & Mask) != 0L;
    }

    public boolean test(int Idx) {
        return this.$at$Const(Idx);
    }

    public boolean anyCommon(BitVector RHS) {
        int ThisWords = this.NumBitWords(this.size());
        int RHSWords = this.NumBitWords(RHS.size());
        int e = std.min((int)ThisWords, (int)RHSWords);
        for (int i = 0; i != e; ++i) {
            if ((this.Bits[i] & RHS.Bits[i]) == 0L) continue;
            return true;
        }
        return false;
    }

    public boolean $eq(BitVector RHS) {
        block6: {
            int i;
            int RHSWords;
            block5: {
                int ThisWords = this.NumBitWords(this.size());
                RHSWords = this.NumBitWords(RHS.size());
                for (i = 0; i != std.min((int)ThisWords, (int)RHSWords); ++i) {
                    if (this.Bits[i] == RHS.Bits[i]) continue;
                    return false;
                }
                if (i == ThisWords) break block5;
                while (i != ThisWords) {
                    if (this.Bits[i] != 0L) {
                        return false;
                    }
                    ++i;
                }
                break block6;
            }
            if (i == RHSWords) break block6;
            while (i != RHSWords) {
                if (RHS.Bits[i] != 0L) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean $noteq(BitVector RHS) {
        return !this.$eq(RHS);
    }

    public BitVector $andassign(BitVector RHS) {
        int i;
        int ThisWords = this.NumBitWords(this.size());
        int RHSWords = this.NumBitWords(RHS.size());
        for (i = 0; i != std.min((int)ThisWords, (int)RHSWords); ++i) {
            int n = i;
            this.Bits[n] = this.Bits[n] & RHS.Bits[i];
        }
        while (i != ThisWords) {
            this.Bits[i] = 0L;
            ++i;
        }
        return this;
    }

    public BitVector reset(BitVector RHS) {
        int ThisWords = this.NumBitWords(this.size());
        int RHSWords = this.NumBitWords(RHS.size());
        for (int i = 0; i != std.min((int)ThisWords, (int)RHSWords); ++i) {
            int n = i;
            this.Bits[n] = this.Bits[n] & (RHS.Bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return this;
    }

    public boolean test(BitVector RHS) {
        int i;
        int ThisWords = this.NumBitWords(this.size());
        int RHSWords = this.NumBitWords(RHS.size());
        for (i = 0; i != std.min((int)ThisWords, (int)RHSWords); ++i) {
            if ((this.Bits[i] & (RHS.Bits[i] ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) continue;
            return true;
        }
        while (i != ThisWords) {
            if (this.Bits[i] != 0L) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public BitVector $orassign(BitVector RHS) {
        if (Unsigned.$less_uint((int)this.size(), (int)RHS.size())) {
            this.resize(RHS.size());
        }
        int e = this.NumBitWords(RHS.size());
        for (int i = 0; i != e; ++i) {
            int n = i;
            this.Bits[n] = this.Bits[n] | RHS.Bits[i];
        }
        return this;
    }

    public BitVector $xorassign(BitVector RHS) {
        if (Unsigned.$less_uint((int)this.size(), (int)RHS.size())) {
            this.resize(RHS.size());
        }
        int e = this.NumBitWords(RHS.size());
        for (int i = 0; i != e; ++i) {
            int n = i;
            this.Bits[n] = this.Bits[n] ^ RHS.Bits[i];
        }
        return this;
    }

    @Override
    public BitVector $assign(BitVector RHS) {
        if (this == Native.$AddrOf((Object)RHS)) {
            return this;
        }
        this.Size = RHS.size();
        int RHSWords = this.NumBitWords(this.Size);
        if (Unsigned.$lesseq_uint((int)this.Size, (int)(this.Capacity * BITWORD_SIZE))) {
            if (this.Size != 0) {
                std.memcpy((long[])this.Bits, (long[])RHS.Bits, (int)(RHSWords * NativeType.$sizeof_ULong()));
            }
            this.clear_unused_bits();
            return this;
        }
        this.Capacity = RHSWords;
        assert (Unsigned.$greater_uint((int)this.Capacity, (int)0)) : "negative capacity?";
        long[] NewBits = new long[this.Capacity];
        NativePointer.copy$Object((long[])RHS.Bits, (int)0, (long[])NewBits, (int)0, (int)this.Capacity);
        std.free((Object)this.Bits);
        this.Bits = NewBits;
        return this;
    }

    public BitVector $assignMove(BitVector RHS) {
        if (this == Native.$AddrOf((Object)RHS)) {
            return this;
        }
        std.free((Object)this.Bits);
        this.Bits = (long[])Native.$tryClone((Object)RHS.Bits);
        this.Size = RHS.Size;
        this.Capacity = RHS.Capacity;
        RHS.Bits = null;
        RHS.Capacity = 0;
        RHS.Size = 0;
        return this;
    }

    public void swap(NativeSwappable _RHS) {
        BitVector RHS = (BitVector)_RHS;
        long[] myBits = this.Bits;
        this.Bits = RHS.Bits;
        RHS.Bits = myBits;
        int mySize = this.Size;
        this.Size = RHS.Size;
        RHS.Size = mySize;
        int myCapacity = this.Capacity;
        this.Capacity = RHS.Capacity;
        RHS.Capacity = myCapacity;
    }

    public void setBitsInMask(uint.ptr Mask) {
        this.setBitsInMask(Mask, -1);
    }

    public void setBitsInMask(uint.ptr Mask, int MaskWords) {
        this.applyMask(true, false, Mask, MaskWords);
    }

    public void clearBitsInMask(uint.ptr Mask) {
        this.clearBitsInMask(Mask, -1);
    }

    public void clearBitsInMask(uint.ptr Mask, int MaskWords) {
        this.applyMask(false, false, Mask, MaskWords);
    }

    public void setBitsNotInMask(uint.ptr Mask) {
        this.setBitsNotInMask(Mask, -1);
    }

    public void setBitsNotInMask(uint.ptr Mask, int MaskWords) {
        this.applyMask(true, true, Mask, MaskWords);
    }

    public void clearBitsNotInMask(uint.ptr Mask) {
        this.clearBitsNotInMask(Mask, -1);
    }

    public void clearBitsNotInMask(uint.ptr Mask, int MaskWords) {
        this.applyMask(false, true, Mask, MaskWords);
    }

    private int NumBitWords(int S2) {
        return (S2 + BITWORD_SIZE - 1) / BITWORD_SIZE;
    }

    private void set_unused_bits() {
        this.set_unused_bits(true);
    }

    private void set_unused_bits(boolean t) {
        int ExtraBits;
        int UsedWords = this.NumBitWords(this.Size);
        if (Unsigned.$greater_uint((int)this.Capacity, (int)UsedWords)) {
            this.init_words(this.Bits, UsedWords, this.Capacity - UsedWords, t);
        }
        if ((ExtraBits = Unsigned.$rem_uint((int)this.Size, (int)BITWORD_SIZE)) != 0) {
            long ExtraBitMask = -1L << ExtraBits;
            if (t) {
                int n = UsedWords - 1;
                this.Bits[n] = this.Bits[n] | ExtraBitMask;
            } else {
                int n = UsedWords - 1;
                this.Bits[n] = this.Bits[n] & (ExtraBitMask ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
    }

    private void clear_unused_bits() {
        this.set_unused_bits(false);
    }

    private void grow(int NewSize) {
        this.Capacity = std.max((int)this.NumBitWords(NewSize), (int)(this.Capacity * 2));
        assert (Unsigned.$greater_uint((int)this.Capacity, (int)0)) : "realloc-ing zero space";
        long[] newBits = new long[this.Capacity];
        if (this.Bits != null) {
            NativePointer.copy$Object((long[])this.Bits, (int)0, (long[])newBits, (int)0, (int)this.Bits.length);
        }
        this.Bits = newBits;
        this.clear_unused_bits();
    }

    private void init_words(long[] B, boolean t) {
        Arrays.fill(B, (long)(0 - (t ? 1 : 0)));
    }

    private void init_words(long[] B, int From, int NumWords, boolean t) {
        Arrays.fill(B, From, From + NumWords, (long)(0 - (t ? 1 : 0)));
    }

    private void applyMask(boolean AddBits, boolean InvertMask, uint.ptr Mask, int MaskWords) {
        std.static_assert((BITWORD_SIZE % 32 == 0 ? 1 : 0) != 0, (char.ptr)NativePointer.$((String)"Unsupported BitWord size."));
        Mask = (uint.ptr)Native.$Clone((NativeCloneable)Mask);
        MaskWords = std.min((int)MaskWords, (int)((this.size() + 31) / 32));
        int Scale = BITWORD_SIZE / 32;
        int i = 0;
        while (Unsigned.$greatereq_uint((int)MaskWords, (int)Scale)) {
            long BW = this.Bits[i];
            for (int b = 0; b != BITWORD_SIZE; b += 32) {
                int M = ((uint.ptr)Mask.$postInc()).$star();
                if (InvertMask) {
                    M ^= 0xFFFFFFFF;
                }
                if (AddBits) {
                    BW |= Unsigned.$uint2ulong((int)M) << b;
                    continue;
                }
                BW &= Unsigned.$uint2ulong((int)M) << b ^ 0xFFFFFFFFFFFFFFFFL;
            }
            this.Bits[i] = BW;
            ++i;
            MaskWords -= Scale;
        }
        int b = 0;
        while (MaskWords != 0) {
            int M = ((uint.ptr)Mask.$postInc()).$star();
            if (InvertMask) {
                M ^= 0xFFFFFFFF;
            }
            if (AddBits) {
                int n = i;
                this.Bits[n] = this.Bits[n] | Unsigned.$uint2ulong((int)M) << b;
            } else {
                int n = i;
                this.Bits[n] = this.Bits[n] & (Unsigned.$uint2ulong((int)M) << b ^ 0xFFFFFFFFFFFFFFFFL);
            }
            b += 32;
            --MaskWords;
        }
        if (AddBits) {
            this.clear_unused_bits();
        }
    }

    public int getMemorySize() {
        return this.Capacity * NativeType.$sizeof_ULong();
    }

    public BitVector clone() {
        return new BitVector(this);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Size=").append(this.Size).append(":");
        for (int i = 0; i < this.Size; ++i) {
            str.append("\n").append(NativeTrace.formatNumber((long)i, (int)3)).append(":").append(this.$at$Const(i) ? " true" : " false");
        }
        return this.getClass().getSimpleName() + str.toString();
    }

    static {
        std.static_assert((BITWORD_SIZE == 64 || BITWORD_SIZE == 32 ? 1 : 0) != 0, (char.ptr)NativePointer.$((String)"Unsupported word size"));
    }

    public static class reference
    implements BitVectorTy.reference,
    Native.Native$Bool {
        private final long[] WordRef;
        private final int WordRefOffset;
        private int BitPos;

        private reference() {
            throw new UnsupportedOperationException("<<<DeclJavaPrinter::VisitFunctionDecl NULL BODY IN USED Translation Unit>>>");
        }

        public reference(BitVector b, int Idx) {
            this.WordRef = b.Bits;
            this.WordRefOffset = Idx / BITWORD_SIZE;
            this.BitPos = Idx % BITWORD_SIZE;
        }

        public reference(reference $Prm0) {
            this.WordRef = $Prm0.WordRef;
            this.WordRefOffset = $Prm0.WordRefOffset;
            this.BitPos = $Prm0.BitPos;
        }

        public reference $assign(reference t) {
            this.$assign(t.$bool());
            return this;
        }

        @Override
        public reference $assign(boolean t) {
            if (t) {
                int n = this.WordRefOffset;
                this.WordRef[n] = this.WordRef[n] | 1L << this.BitPos;
            } else {
                int n = this.WordRefOffset;
                this.WordRef[n] = this.WordRef[n] & (1L << this.BitPos ^ 0xFFFFFFFFFFFFFFFFL);
            }
            return this;
        }

        @Override
        public boolean $bool() {
            return (this.WordRef[this.WordRefOffset] & 1L << this.BitPos) != 0L;
        }

        public String toString() {
            return "WordRef=" + this.WordRef + ", BitPos=" + this.BitPos;
        }
    }
}

