/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.llvm.adt.APInt;
import org.llvm.adt.FoldingSetNodeID;
import org.llvm.adt.FoldingSetTrait;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;

public class APSInt
extends APInt<APSInt>
implements Destructors.ClassWithDestructor,
Native.NativeComparable<APSInt>,
FoldingSetTrait.Profilable {
    private boolean IsUnsigned;

    public APSInt() {
        this.IsUnsigned = false;
    }

    public APSInt(int BitWidth) {
        this(BitWidth, true);
    }

    public APSInt(int BitWidth, boolean isUnsigned) {
        super(BitWidth, 0L);
        this.IsUnsigned = isUnsigned;
    }

    public APSInt(APInt I) {
        this(I, true);
    }

    public APSInt(APInt I, boolean isUnsigned) {
        super(JavaDifferentiators.JD.Move.INSTANCE, (APInt)std.move((Object)I));
        this.IsUnsigned = isUnsigned;
    }

    public APSInt(StringRef Str) {
        assert (!Str.empty()) : "Invalid string length";
        int NumBits = Unsigned.$div_uint((int)(Str.size() * 64), (int)19) + 2;
        APInt Tmp = new APInt(NumBits, new StringRef(Str), 10);
        if (Str.$at(0) == 45) {
            int MinBits = Tmp.getMinSignedBits();
            if (Unsigned.$greater_uint((int)MinBits, (int)0) && Unsigned.$less_uint((int)MinBits, (int)NumBits)) {
                Tmp.$assignMove(Tmp.trunc(MinBits));
            }
            this.$assignMove(new APSInt(new APInt(Tmp), false));
            return;
        }
        int ActiveBits = Tmp.getActiveBits();
        if (Unsigned.$greater_uint((int)ActiveBits, (int)0) && Unsigned.$less_uint((int)ActiveBits, (int)NumBits)) {
            Tmp.$assignMove(Tmp.trunc(ActiveBits));
        }
        this.$assignMove(new APSInt(new APInt(Tmp), true));
    }

    @Override
    public APSInt $assign(APInt RHS) {
        super.$assign(RHS);
        return this;
    }

    @Override
    public APSInt $assign(long RHS) {
        super.$assign(RHS);
        return this;
    }

    @Override
    public APSInt $assign(boolean RHS) {
        super.$assign(RHS);
        return this;
    }

    public boolean isSigned() {
        return !this.IsUnsigned;
    }

    public boolean isUnsigned() {
        return this.IsUnsigned;
    }

    public void setIsUnsigned(boolean Val) {
        this.IsUnsigned = Val;
    }

    public void setIsSigned(boolean Val) {
        this.IsUnsigned = !Val;
    }

    public void __toString(SmallString Str) {
        this.__toString(Str, 10);
    }

    public void __toString(SmallString Str, int Radix) {
        super.__toString(Str, Radix, this.isSigned());
    }

    @Override
    public std.string __toString(int Radix) {
        return super.__toString(Radix, this.isSigned());
    }

    public long getExtValue() {
        assert (Unsigned.$lesseq_uint((int)this.getMinSignedBits(), (int)64)) : "Too many bits for int64_t";
        return this.isSigned() ? this.getSExtValue() : this.getZExtValue();
    }

    @Override
    public APSInt trunc(int width) {
        return new APSInt(super.trunc(width), this.IsUnsigned);
    }

    public APSInt extend(int width) {
        if (this.IsUnsigned) {
            return new APSInt(this.zext(width), this.IsUnsigned);
        }
        return new APSInt(this.sext(width), this.IsUnsigned);
    }

    public APSInt extOrTrunc(int width) {
        if (this.IsUnsigned) {
            return new APSInt(this.zextOrTrunc(width), this.IsUnsigned);
        }
        return new APSInt(this.sextOrTrunc(width), this.IsUnsigned);
    }

    public APSInt $modassign(APSInt RHS) {
        assert (this.IsUnsigned == RHS.IsUnsigned) : "Signedness mismatch!";
        if (this.IsUnsigned) {
            this.$assign(this.urem(RHS));
        } else {
            this.$assign(this.srem(RHS));
        }
        return this;
    }

    public APSInt $slashassign(APSInt RHS) {
        assert (this.IsUnsigned == RHS.IsUnsigned) : "Signedness mismatch!";
        if (this.IsUnsigned) {
            this.$assign(this.udiv(RHS));
        } else {
            this.$assign(this.sdiv(RHS));
        }
        return this;
    }

    public APSInt $mod(APSInt RHS) {
        assert (this.IsUnsigned == RHS.IsUnsigned) : "Signedness mismatch!";
        return this.IsUnsigned ? new APSInt(this.urem(RHS), true) : new APSInt(this.srem(RHS), false);
    }

    public APSInt $slash(APSInt RHS) {
        assert (this.IsUnsigned == RHS.IsUnsigned) : "Signedness mismatch!";
        return this.IsUnsigned ? new APSInt(this.udiv(RHS), true) : new APSInt(this.sdiv(RHS), false);
    }

    public APSInt $in(int Amt) {
        return this.IsUnsigned ? new APSInt(this.lshr(Amt), true) : new APSInt(this.ashr(Amt), false);
    }

    public APSInt $rshiftassign(int Amt) {
        this.$assignMove((APSInt)Native.$Deref((Object)this.$in(Amt)));
        return this;
    }

    public boolean $less(APSInt RHS) {
        assert (this.IsUnsigned == RHS.IsUnsigned) : "Signedness mismatch!";
        return this.IsUnsigned ? this.ult(RHS) : this.slt(RHS);
    }

    public boolean $greater(APSInt RHS) {
        assert (this.IsUnsigned == RHS.IsUnsigned) : "Signedness mismatch!";
        return this.IsUnsigned ? this.ugt(RHS) : this.sgt(RHS);
    }

    public boolean $lesseq(APSInt RHS) {
        assert (this.IsUnsigned == RHS.IsUnsigned) : "Signedness mismatch!";
        return this.IsUnsigned ? this.ule(RHS) : this.sle(RHS);
    }

    public boolean $greatereq(APSInt RHS) {
        assert (this.IsUnsigned == RHS.IsUnsigned) : "Signedness mismatch!";
        return this.IsUnsigned ? this.uge(RHS) : this.sge(RHS);
    }

    public boolean $eq(APSInt RHS) {
        assert (this.IsUnsigned == RHS.IsUnsigned) : "Signedness mismatch!";
        return this.eq(RHS);
    }

    public boolean $noteq(APSInt RHS) {
        return !this.$eq(RHS);
    }

    @Override
    public boolean $eq(long RHS) {
        return APSInt.compareValues(this, APSInt.get(RHS)) == 0;
    }

    @Override
    public boolean $noteq(long RHS) {
        return APSInt.compareValues(this, APSInt.get(RHS)) != 0;
    }

    public boolean $lesseq(long RHS) {
        return APSInt.compareValues(this, APSInt.get(RHS)) <= 0;
    }

    public boolean $greatereq(long RHS) {
        return APSInt.compareValues(this, APSInt.get(RHS)) >= 0;
    }

    public boolean $less(long RHS) {
        return APSInt.compareValues(this, APSInt.get(RHS)) < 0;
    }

    public boolean $greater(long RHS) {
        return APSInt.compareValues(this, APSInt.get(RHS)) > 0;
    }

    @Override
    public APSInt $out(int Bits) {
        return new APSInt(super.$out(Bits), this.IsUnsigned);
    }

    @Override
    public APSInt $lshiftassign(int Amt) {
        this.$assignMove((APSInt)Native.$Deref((Object)this.$out(Amt)));
        return this;
    }

    @Override
    public APSInt $preInc() {
        super.$preInc();
        return this;
    }

    @Override
    public APSInt $preDec() {
        super.$preDec();
        return this;
    }

    @Override
    public APSInt $postInc(int $Prm0) {
        return new APSInt(super.$preInc(), this.IsUnsigned);
    }

    @Override
    public APSInt $postDec(int $Prm0) {
        return new APSInt(super.$preDec(), this.IsUnsigned);
    }

    @Override
    public APSInt $sub() {
        return new APSInt(super.$sub(), this.IsUnsigned);
    }

    public APSInt $addassign(APSInt RHS) {
        assert (this.IsUnsigned == RHS.IsUnsigned) : "Signedness mismatch!";
        super.$addassign(RHS);
        return this;
    }

    public APSInt $minusassign(APSInt RHS) {
        assert (this.IsUnsigned == RHS.IsUnsigned) : "Signedness mismatch!";
        super.$minusassign(RHS);
        return this;
    }

    public APSInt $starassign(APSInt RHS) {
        assert (this.IsUnsigned == RHS.IsUnsigned) : "Signedness mismatch!";
        super.$starassign(RHS);
        return this;
    }

    public APSInt $andassign(APSInt RHS) {
        assert (this.IsUnsigned == RHS.IsUnsigned) : "Signedness mismatch!";
        super.$andassign(RHS);
        return this;
    }

    public APSInt $orassign(APSInt RHS) {
        assert (this.IsUnsigned == RHS.IsUnsigned) : "Signedness mismatch!";
        super.$orassign(RHS);
        return this;
    }

    public APSInt $xorassign(APSInt RHS) {
        assert (this.IsUnsigned == RHS.IsUnsigned) : "Signedness mismatch!";
        super.$xorassign(RHS);
        return this;
    }

    public APSInt $bitand(APSInt RHS) {
        assert (this.IsUnsigned == RHS.IsUnsigned) : "Signedness mismatch!";
        return new APSInt(super.$bitand(RHS), this.IsUnsigned);
    }

    public APSInt And(APSInt RHS) {
        return this.$bitand(RHS);
    }

    public APSInt $bitor(APSInt RHS) {
        assert (this.IsUnsigned == RHS.IsUnsigned) : "Signedness mismatch!";
        return new APSInt(super.$bitor(RHS), this.IsUnsigned);
    }

    public APSInt Or(APSInt RHS) {
        return this.$bitor(RHS);
    }

    public APSInt $bitxor(APSInt RHS) {
        assert (this.IsUnsigned == RHS.IsUnsigned) : "Signedness mismatch!";
        return new APSInt(super.$bitxor(RHS), this.IsUnsigned);
    }

    public APSInt Xor(APSInt RHS) {
        return this.$bitxor(RHS);
    }

    public APSInt $star(APSInt RHS) {
        assert (this.IsUnsigned == RHS.IsUnsigned) : "Signedness mismatch!";
        return new APSInt(super.$star(RHS), this.IsUnsigned);
    }

    public APSInt $add(APSInt RHS) {
        assert (this.IsUnsigned == RHS.IsUnsigned) : "Signedness mismatch!";
        return new APSInt(super.$add(RHS), this.IsUnsigned);
    }

    public APSInt $sub(APSInt RHS) {
        assert (this.IsUnsigned == RHS.IsUnsigned) : "Signedness mismatch!";
        return new APSInt(super.$sub(RHS), this.IsUnsigned);
    }

    @Override
    public APSInt $bitnot() {
        return new APSInt(super.$bitnot(), this.IsUnsigned);
    }

    public static APSInt getMaxValue(int numBits, boolean Unsigned2) {
        return new APSInt(Unsigned2 ? APInt.getMaxValue(numBits) : APInt.getSignedMaxValue(numBits), Unsigned2);
    }

    public static APSInt getMinValue(int numBits, boolean Unsigned2) {
        return new APSInt(Unsigned2 ? APInt.getMinValue(numBits) : APInt.getSignedMinValue(numBits), Unsigned2);
    }

    public static boolean isSameValue(APSInt I1, APSInt I2) {
        return APSInt.compareValues(I1, I2) == 0;
    }

    public static int compareValues(APSInt I1, APSInt I2) {
        if (I1.getBitWidth() == I2.getBitWidth() && I1.isSigned() == I2.isSigned()) {
            return I1.$eq(I2) ? 0 : (I1.$greater(I2) ? 1 : -1);
        }
        if (Unsigned.$greater_uint((int)I1.getBitWidth(), (int)I2.getBitWidth())) {
            return APSInt.compareValues(I1, I2.extend(I1.getBitWidth()));
        }
        if (Unsigned.$greater_uint((int)I2.getBitWidth(), (int)I1.getBitWidth())) {
            return APSInt.compareValues(I1.extend(I2.getBitWidth()), I2);
        }
        if (I1.isSigned()) {
            assert (!I2.isSigned()) : "Expected signed mismatch";
            if (I1.isNegative()) {
                return -1;
            }
        } else {
            assert (I2.isSigned()) : "Expected signed mismatch";
            if (I2.isNegative()) {
                return 1;
            }
        }
        return I1.eq(I2) ? 0 : (I1.ugt(I2) ? 1 : -1);
    }

    public static APSInt get(long X2) {
        return new APSInt(new APInt(64, X2), false);
    }

    public static APSInt getUnsigned(long X2) {
        return new APSInt(new APInt(64, X2), true);
    }

    @Override
    public void Profile(FoldingSetNodeID ID) {
        ID.AddInteger_uint(this.IsUnsigned ? 1 : 0);
        super.Profile(ID);
    }

    public APSInt(JavaDifferentiators.JD.Move _dparam, APSInt $Prm0) {
        super(JavaDifferentiators.JD.Move.INSTANCE, $Prm0);
        this.IsUnsigned = $Prm0.IsUnsigned;
    }

    public APSInt $assignMove(APSInt $Prm0) {
        super.$assignMove((Object)$Prm0);
        this.IsUnsigned = $Prm0.IsUnsigned;
        return this;
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    public APSInt(APSInt $Prm0) {
        super($Prm0);
        this.IsUnsigned = $Prm0.IsUnsigned;
    }

    public APSInt $assign(APSInt $Prm0) {
        super.$assign($Prm0);
        this.IsUnsigned = $Prm0.IsUnsigned;
        return this;
    }

    @Override
    public APSInt clone() {
        return new APSInt(this);
    }

    @Override
    public APSInt move() {
        return new APSInt(JavaDifferentiators.JD.Move.INSTANCE, this);
    }

    @Override
    public String toString() {
        return "IsUnsigned=" + this.IsUnsigned + super.toString();
    }
}

