/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.ui.update;

import fleet.dock.api.DockPaths;
import fleet.dock.connectors.DockPathKeys;
import fleet.frontend.ui.update.SparkleApi;
import fleet.preferences.FleetFromSourcesPaths;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import fleet.util.os.Os;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\t\u0010\u0004\u001a\u00020\u0005H\u0082 J\t\u0010\u0006\u001a\u00020\u0005H\u0086 \u00a8\u0006\b"}, d2={"Lfleet/frontend/ui/update/SparkleApi;", "", "<init>", "()V", "init", "", "checkForUpdates", "Companion", "fleet.frontend.ui"})
@SourceDebugExtension(value={"SMAP\nSparkleApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SparkleApi.kt\nfleet/frontend/ui/update/SparkleApi\n+ 2 KLoggers.kt\nfleet/util/logging/KLoggersKt\n*L\n1#1,89:1\n25#2:90\n*S KotlinDebug\n*F\n+ 1 SparkleApi.kt\nfleet/frontend/ui/update/SparkleApi\n*L\n23#1:90\n*E\n"})
public final class SparkleApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final KLogger log;
    @NotNull
    private static final Lazy<SparkleApi> instance$delegate;

    private SparkleApi() {
        this.init();
    }

    private final native void init();

    public final native void checkForUpdates();

    public /* synthetic */ SparkleApi(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        boolean $i$f$logger = false;
        log = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(SparkleApi.class));
        instance$delegate = LazyKt.lazy((Function0)Companion.instance.2.INSTANCE);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u0004\u0018\u00010\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lfleet/frontend/ui/update/SparkleApi$Companion;", "", "<init>", "()V", "log", "Lfleet/util/logging/KLogger;", "getLog", "()Lfleet/util/logging/KLogger;", "instance", "Lfleet/frontend/ui/update/SparkleApi;", "getInstance", "()Lfleet/frontend/ui/update/SparkleApi;", "instance$delegate", "Lkotlin/Lazy;", "isSupported", "", "isEnabled", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "isInstalledViaToolbox", "fleet.frontend.ui"})
    @SourceDebugExtension(value={"SMAP\nSparkleApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SparkleApi.kt\nfleet/frontend/ui/update/SparkleApi$Companion\n+ 2 KLogger.kt\nfleet/util/logging/KLogger\n*L\n1#1,89:1\n10#2,2:90\n10#2,2:92\n10#2,2:94\n10#2,2:96\n*S KotlinDebug\n*F\n+ 1 SparkleApi.kt\nfleet/frontend/ui/update/SparkleApi$Companion\n*L\n45#1:90,2\n49#1:92,2\n53#1:94,2\n57#1:96,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KLogger getLog() {
            return log;
        }

        @Nullable
        public final SparkleApi getInstance() {
            Lazy lazy = instance$delegate;
            return (SparkleApi)lazy.getValue();
        }

        public final boolean isSupported() {
            return Os.INSTANCE.isMac();
        }

        public final boolean isEnabled(@NotNull CoroutineContext coroutineContext) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
            if (FleetFromSourcesPaths.INSTANCE.isRunningFromSources()) {
                KLogger this_$iv = this.getLog();
                boolean $i$f$debug = false;
                if (this_$iv.isDebugEnabled()) {
                    KLogger kLogger = this_$iv;
                    boolean bl2 = false;
                    kLogger.debug((Object)"Dock auto-update disabled: Fleet is running from sources");
                }
                bl = false;
            } else if (this.isInstalledViaToolbox(coroutineContext)) {
                KLogger this_$iv = this.getLog();
                boolean $i$f$debug = false;
                if (this_$iv.isDebugEnabled()) {
                    KLogger kLogger = this_$iv;
                    boolean bl3 = false;
                    kLogger.debug((Object)"Dock auto-update disabled: Fleet was installed via Toolbox");
                }
                bl = false;
            } else if (Intrinsics.areEqual((Object)System.getProperty("fleet.sparkle.enabled"), (Object)"true")) {
                KLogger this_$iv = this.getLog();
                boolean $i$f$debug = false;
                if (this_$iv.isDebugEnabled()) {
                    KLogger kLogger = this_$iv;
                    boolean bl4 = false;
                    kLogger.debug((Object)"Dock auto-update enabled: System property `fleet.sparkle.enabled=true`");
                }
                bl = true;
            } else {
                KLogger this_$iv = this.getLog();
                boolean $i$f$debug = false;
                if (this_$iv.isDebugEnabled()) {
                    KLogger kLogger = this_$iv;
                    boolean bl5 = false;
                    kLogger.debug((Object)"Dock auto-update disabled: System property `fleet.sparkle.enabled` is missing or `false`");
                }
                bl = false;
            }
            return bl;
        }

        private final boolean isInstalledViaToolbox(CoroutineContext coroutineContext) {
            boolean bl;
            CoroutineContext.Element element = coroutineContext.get((CoroutineContext.Key)DockPaths.Companion);
            if (element == null) {
                boolean bl2 = false;
                String string = "'DockPaths' is missing from coroutine context";
                throw new IllegalArgumentException(string.toString());
            }
            DockPaths dockPaths = (DockPaths)element;
            Path path2 = (Path)dockPaths.getPath(DockPathKeys.INSTANCE.getInstalledViaToolboxPath());
            if (path2 != null) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                bl = Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
            } else {
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

