/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.ui.notifications.commonNotifications;

import com.jetbrains.rhizomedb.ChangeScope;
import fleet.frontend.notifications.NotificationCategory;
import fleet.frontend.notifications.NotificationCategoryId;
import fleet.frontend.notifications.NotificationEntity;
import fleet.frontend.notifications.NotificationIcon;
import fleet.frontend.notifications.NotificationsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u001c\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\f"}, d2={"ProcessErrorCategory", "Lfleet/frontend/notifications/NotificationCategory;", "getProcessErrorCategory", "()Lfleet/frontend/notifications/NotificationCategory;", "buildMessage", "", "processName", "exitCode", "", "createManagedProcessFailedNotification", "Lfleet/frontend/notifications/NotificationEntity;", "Lcom/jetbrains/rhizomedb/ChangeScope;", "fleet.frontend.ui"})
public final class ManagedProcessFailedNotificationKt {
    @NotNull
    private static final NotificationCategory ProcessErrorCategory = new NotificationCategory(NotificationCategoryId.constructor-impl((String)"processExit"), "Fleet Service Failure", null, 4, null);

    @NotNull
    public static final NotificationCategory getProcessErrorCategory() {
        return ProcessErrorCategory;
    }

    private static final String buildMessage(String processName, int exitCode) {
        String string;
        String string2 = processName;
        if (Intrinsics.areEqual((Object)string2, (Object)"backend")) {
            string = StringsKt.trimIndent((String)("\n      Running IJ backend failed: " + (String)(switch (exitCode) {
                case 13, 14, 16 -> "an instance is running already in the system. Check `java` processes in the system.";
                default -> "exit code " + exitCode;
            }) + "\n    "));
        } else {
            string = Intrinsics.areEqual((Object)string2, (Object)"fsd") ? StringsKt.trimIndent((String)("\n      Fleet System Daemon failed: " + (String)(exitCode == 101 ? "rust panic.. did you rebuild after updating sources?" : "exit code " + exitCode) + "\n    ")) : StringsKt.trimIndent((String)("\n      Running " + processName + " failed. Exit code " + exitCode + "\n    "));
        }
        return string + "\n\nSee log for more info.";
    }

    @NotNull
    public static final NotificationEntity createManagedProcessFailedNotification(@NotNull ChangeScope $this$createManagedProcessFailedNotification, @NotNull String processName, int exitCode) {
        Intrinsics.checkNotNullParameter((Object)$this$createManagedProcessFailedNotification, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        return NotificationsKt.showNotification$default((ChangeScope)$this$createManagedProcessFailedNotification, (NotificationCategory)ProcessErrorCategory, (String)"Abnormal process exit", (NotificationIcon)NotificationIcon.Companion.getError(), (String)ManagedProcessFailedNotificationKt.buildMessage(processName, exitCode), (boolean)false, null, null, null, (int)240, null);
    }
}

