/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.ui;

import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.Entity;
import fleet.common.settings.SettingsEntityKt;
import fleet.common.settings.SettingsKey;
import fleet.dock.api.DockExit;
import fleet.frontend.FleetFrontendSettingsKeys;
import fleet.frontend.ui.CloseInterceptor;
import fleet.frontend.ui.CloseInterceptorResult;
import fleet.frontend.ui.CloseType;
import fleet.frontend.ui.QuitHandlerKt;
import fleet.frontend.ui.SafeQuitInterceptor;
import fleet.frontend.ui.SafeQuitInterceptorEntity;
import fleet.frontend.ui.SafeQuitInterceptorKt;
import fleet.kernel.plugins.PluginScope;
import fleet.util.logging.KLogger;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0017H\u0016J\r\u0010\u0018\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lfleet/frontend/ui/SafeQuitInterceptor;", "Lfleet/frontend/ui/CloseInterceptor;", "pluginScope", "Lfleet/kernel/plugins/PluginScope;", "<init>", "(Lfleet/kernel/plugins/PluginScope;)V", "logger", "Lfleet/util/logging/KLogger;", "getLogger", "()Lfleet/util/logging/KLogger;", "logger$delegate", "Lkotlin/Lazy;", "quitting", "", "lastQuitPressed", "Lkotlin/time/Duration;", "J", "processQuitPressed", "", "processQuitPressed$fleet_frontend_ui", "handle", "Lfleet/frontend/ui/CloseInterceptorResult;", "close", "Lkotlin/Function0;", "waitsForSafeQuit", "waitsForSafeQuit$fleet_frontend_ui", "fleet.frontend.ui"})
@SourceDebugExtension(value={"SMAP\nSafeQuitInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SafeQuitInterceptor.kt\nfleet/frontend/ui/SafeQuitInterceptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KLogger.kt\nfleet/util/logging/KLogger\n*L\n1#1,112:1\n1734#2,3:113\n10#3,2:116\n10#3,2:118\n10#3,2:120\n10#3,2:122\n10#3,2:124\n*S KotlinDebug\n*F\n+ 1 SafeQuitInterceptor.kt\nfleet/frontend/ui/SafeQuitInterceptor\n*L\n70#1:113,3\n71#1:116,2\n75#1:118,2\n85#1:120,2\n99#1:122,2\n104#1:124,2\n*E\n"})
public final class SafeQuitInterceptor
implements CloseInterceptor {
    @NotNull
    private final PluginScope pluginScope;
    @NotNull
    private final Lazy logger$delegate;
    private volatile boolean quitting;
    private long lastQuitPressed;

    public SafeQuitInterceptor(@NotNull PluginScope pluginScope) {
        Intrinsics.checkNotNullParameter((Object)pluginScope, (String)"pluginScope");
        this.pluginScope = pluginScope;
        this.logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);
        this.lastQuitPressed = Duration.Companion.getZERO-UwyO8pc();
    }

    private final KLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (KLogger)lazy.getValue();
    }

    public final void processQuitPressed$fleet_frontend_ui() {
        if (((Boolean)SettingsEntityKt.querySettingsKey$default((SettingsKey)FleetFrontendSettingsKeys.INSTANCE.getSafeQuitting(), null, null, (int)6, null)).booleanValue()) {
            long now = DurationKt.toDuration((long)System.nanoTime(), (DurationUnit)DurationUnit.NANOSECONDS);
            long delta = Duration.minus-LRDsOJo((long)now, (long)this.lastQuitPressed);
            if (Duration.compareTo-LRDsOJo((long)delta, (long)SafeQuitInterceptorKt.getSAFE_QUIT_HANDLER_DELAY_MILLIS()) < 0) {
                boolean bl;
                DockExit dockExit;
                block12: {
                    this.quitting = true;
                    CoroutineContext.Element element = this.pluginScope.getCoroutineContext().get((CoroutineContext.Key)DockExit.Companion);
                    Intrinsics.checkNotNull((Object)element);
                    dockExit = (DockExit)element;
                    Iterable $this$all$iv = QuitHandlerKt.sortedInterceptors(CloseType.APPLICATION);
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            CloseInterceptor it = (CloseInterceptor)element$iv;
                            boolean bl2 = false;
                            if (it.handle((Function0<Unit>)((Function0)new Function0<Unit>(dockExit){
                                final /* synthetic */ DockExit $dockExit;
                                {
                                    this.$dockExit = $dockExit;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.$dockExit.quit(0);
                                }
                            })) == CloseInterceptorResult.CONTINUE) continue;
                            bl = false;
                            break block12;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    this_$iv = this.getLogger();
                    $i$f$debug = false;
                    if (this_$iv.isDebugEnabled()) {
                        KLogger kLogger = this_$iv;
                        boolean bl3 = false;
                        kLogger.debug((Object)"Quitting (double \u2318Q)...");
                    }
                    dockExit.quit(0);
                } else {
                    this_$iv = this.getLogger();
                    $i$f$debug = false;
                    if (this_$iv.isDebugEnabled()) {
                        KLogger kLogger = this_$iv;
                        boolean bl4 = false;
                        kLogger.debug((Object)"Quit request ignored because other interceptors block (double \u2318Q)...");
                    }
                }
            } else {
                this.quitting = false;
            }
            this.lastQuitPressed = now;
        } else {
            this.quitting = true;
            KLogger this_$iv = this.getLogger();
            boolean $i$f$debug = false;
            if (this_$iv.isDebugEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                kLogger.debug((Object)"Scheduling quit on \u2318Q...");
            }
        }
    }

    @Override
    @NotNull
    public CloseInterceptorResult handle(@NotNull Function0<Unit> close) {
        CloseInterceptorResult closeInterceptorResult;
        Intrinsics.checkNotNullParameter(close, (String)"close");
        SafeQuitInterceptorEntity stateEntity = (SafeQuitInterceptorEntity)SafeQuitInterceptorEntity.Companion.single();
        long now = DurationKt.toDuration((long)System.nanoTime(), (DurationUnit)DurationUnit.NANOSECONDS);
        this.pluginScope.changeAsync((Function1)new Function1<ChangeScope, Unit>(stateEntity, now){
            final /* synthetic */ SafeQuitInterceptorEntity $stateEntity;
            final /* synthetic */ long $now;
            {
                this.$stateEntity = $stateEntity;
                this.$now = $now;
                super(1);
            }

            public final void invoke(ChangeScope $this$changeAsync) {
                Intrinsics.checkNotNullParameter((Object)$this$changeAsync, (String)"$this$changeAsync");
                $this$changeAsync.set((Entity)this.$stateEntity, SafeQuitInterceptorEntity.Companion.getLastHandledAttr(), (Object)Duration.box-impl((long)this.$now));
            }
        });
        long delta = Duration.minus-LRDsOJo((long)DurationKt.toDuration((long)System.nanoTime(), (DurationUnit)DurationUnit.NANOSECONDS), (long)this.lastQuitPressed);
        if (this.quitting) {
            KLogger this_$iv = this.getLogger();
            boolean $i$f$debug = false;
            if (this_$iv.isDebugEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                kLogger.debug((Object)"Perform quit on previous schedule...");
            }
            closeInterceptorResult = CloseInterceptorResult.CONTINUE;
        } else if (Duration.compareTo-LRDsOJo((long)delta, (long)SafeQuitInterceptorKt.access$getNO_SHORTCUT_PRESSED_THRESHOLD_MILLIS$p()) > 0) {
            KLogger this_$iv = this.getLogger();
            boolean $i$f$debug = false;
            if (this_$iv.isDebugEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                kLogger.debug((Object)"Perform quit supposedly non-shortcut quit...");
            }
            closeInterceptorResult = CloseInterceptorResult.CONTINUE;
        } else {
            closeInterceptorResult = CloseInterceptorResult.CANCEL_CLOSE;
        }
        return closeInterceptorResult;
    }

    public final boolean waitsForSafeQuit$fleet_frontend_ui() {
        return !this.quitting && Duration.compareTo-LRDsOJo((long)((SafeQuitInterceptorEntity)SafeQuitInterceptorEntity.Companion.single()).getLastHandled-UwyO8pc(), (long)this.lastQuitPressed) > 0;
    }
}

