/*
 * Decompiled with CFR 0.152.
 */
package fleet.workspace.run.impl.terminal;

import com.jediterm.terminal.TerminalDisplay;
import com.jediterm.terminal.model.LinesBuffer;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalSelection;
import com.jediterm.terminal.model.TerminalTextBuffer;
import fleet.api.exec.ArrowKeysMode;
import fleet.api.exec.CursorShape;
import fleet.api.exec.KeypadMode;
import fleet.api.exec.Line;
import fleet.api.exec.MouseFormat;
import fleet.api.exec.MouseMode;
import fleet.api.exec.MouseModeInfo;
import fleet.api.exec.ScreenState;
import fleet.workspace.run.impl.terminal.FleetTerminalDisplay;
import fleet.workspace.run.impl.terminal.FleetTerminalDisplayKt;
import fleet.workspace.run.impl.terminal.TerminalModelKt;
import fleet.workspace.run.impl.terminal.TerminalUpdate;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0010\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u0003H\u0016J\u0006\u00101\u001a\u00020.J\u0010\u00102\u001a\u00020.2\b\b\u0002\u00103\u001a\u00020)J\u0012\u00104\u001a\u00020.2\b\u00105\u001a\u0004\u0018\u000106H\u0016J\b\u00107\u001a\u00020.H\u0016J \u00108\u001a\u00020.2\u0006\u00109\u001a\u00020\u00032\u0006\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u0003H\u0016J\u0010\u0010<\u001a\u00020.2\u0006\u0010=\u001a\u00020)H\u0016J\u0010\u0010>\u001a\u00020.2\u0006\u0010>\u001a\u00020)H\u0016J\b\u0010?\u001a\u00020\u0019H\u0016J\b\u0010@\u001a\u00020)H\u0016J\u0010\u0010A\u001a\u00020.2\u0006\u0010B\u001a\u00020\u0019H\u0016J\n\u0010C\u001a\u0004\u0018\u00010DH\u0016J\u0010\u0010E\u001a\u00020.2\u0006\u0010F\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u00020.2\u0006\u0010I\u001a\u00020JH\u0016J\u0014\u0010K\u001a\u00020.2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#J\u0014\u0010L\u001a\u00020.2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0#J\u0006\u0010M\u001a\u00020.J\u0010\u0010N\u001a\u00020\u00112\u0006\u00103\u001a\u00020)H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020&0#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lfleet/workspace/run/impl/terminal/FleetTerminalDisplay;", "Lcom/jediterm/terminal/TerminalDisplay;", "width", "", "height", "<init>", "(II)V", "styleState", "Lcom/jediterm/terminal/model/StyleState;", "getStyleState", "()Lcom/jediterm/terminal/model/StyleState;", "terminalTextBuffer", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "getTerminalTextBuffer", "()Lcom/jediterm/terminal/model/TerminalTextBuffer;", "terminalUpdatesChannelImpl", "Lkotlinx/coroutines/channels/Channel;", "Lfleet/workspace/run/impl/terminal/TerminalUpdate;", "terminalUpdatesChannel", "Lkotlinx/coroutines/channels/ReceiveChannel;", "getTerminalUpdatesChannel", "()Lkotlinx/coroutines/channels/ReceiveChannel;", "cursorX", "cursorY", "title", "", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "mouseMode", "Lfleet/api/exec/MouseMode;", "mouseFormat", "Lfleet/api/exec/MouseFormat;", "arrowKeysModeProvider", "Lkotlin/Function0;", "Lfleet/api/exec/ArrowKeysMode;", "keypadModeProvider", "Lfleet/api/exec/KeypadMode;", "beepCount", "isCursorVisible", "", "isCursorBlinking", "cursorShape", "Lfleet/api/exec/CursorShape;", "setCursor", "", "x", "y", "sendUpdatedStateWithLock", "sendUpdatedState", "clear", "setCursorShape", "shape", "Lcom/jediterm/terminal/CursorShape;", "beep", "scrollArea", "scrollRegionTop", "scrollRegionSize", "dy", "setCursorVisible", "shouldDrawCursor", "useAlternateScreenBuffer", "getWindowTitle", "ambiguousCharsAreDoubleWidth", "setWindowTitle", "name", "getSelection", "Lcom/jediterm/terminal/model/TerminalSelection;", "terminalMouseModeSet", "mode", "Lcom/jediterm/terminal/emulator/mouse/MouseMode;", "setMouseFormat", "format", "Lcom/jediterm/terminal/emulator/mouse/MouseFormat;", "setArrowKeysModeProvider", "setKeypadModeProvider", "close", "readTerminalState", "fleet.run.workspace"})
@SourceDebugExtension(value={"SMAP\nFleetTerminalDisplay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FleetTerminalDisplay.kt\nfleet/workspace/run/impl/terminal/FleetTerminalDisplay\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n1#2:149\n*E\n"})
public class FleetTerminalDisplay
implements TerminalDisplay {
    @NotNull
    private final StyleState styleState = new StyleState();
    @NotNull
    private final TerminalTextBuffer terminalTextBuffer;
    @NotNull
    private final Channel<TerminalUpdate> terminalUpdatesChannelImpl;
    private int cursorX;
    private int cursorY;
    @NotNull
    private String title;
    @NotNull
    private MouseMode mouseMode;
    @NotNull
    private MouseFormat mouseFormat;
    @NotNull
    private Function0<? extends ArrowKeysMode> arrowKeysModeProvider;
    @NotNull
    private Function0<? extends KeypadMode> keypadModeProvider;
    private int beepCount;
    private boolean isCursorVisible;
    private boolean isCursorBlinking;
    @Nullable
    private CursorShape cursorShape;

    public FleetTerminalDisplay(int width, int height) {
        this.terminalTextBuffer = new TerminalTextBuffer(width, height, this.styleState);
        this.terminalUpdatesChannelImpl = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        this.title = "";
        this.mouseMode = FleetTerminalDisplayKt.access$toFleetMouseMode(com.jediterm.terminal.emulator.mouse.MouseMode.MOUSE_REPORTING_NONE);
        this.mouseFormat = FleetTerminalDisplayKt.access$toFleetMouseFormat(com.jediterm.terminal.emulator.mouse.MouseFormat.MOUSE_FORMAT_XTERM);
        this.arrowKeysModeProvider = arrowKeysModeProvider.1.INSTANCE;
        this.keypadModeProvider = keypadModeProvider.1.INSTANCE;
        this.isCursorVisible = true;
        this.isCursorBlinking = true;
    }

    @NotNull
    public final StyleState getStyleState() {
        return this.styleState;
    }

    @NotNull
    public final TerminalTextBuffer getTerminalTextBuffer() {
        return this.terminalTextBuffer;
    }

    @NotNull
    public final ReceiveChannel<TerminalUpdate> getTerminalUpdatesChannel() {
        return (ReceiveChannel)this.terminalUpdatesChannelImpl;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.title = string;
    }

    public void setCursor(int x, int y) {
        this.cursorX = x;
        this.cursorY = y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendUpdatedStateWithLock() {
        this.terminalTextBuffer.lock();
        try {
            FleetTerminalDisplay.sendUpdatedState$default(this, false, 1, null);
        }
        finally {
            this.terminalTextBuffer.unlock();
        }
    }

    public final void sendUpdatedState(boolean clear) {
        this.terminalUpdatesChannelImpl.trySend-JP2dKIU((Object)this.readTerminalState(clear));
    }

    public static /* synthetic */ void sendUpdatedState$default(FleetTerminalDisplay fleetTerminalDisplay, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendUpdatedState");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        fleetTerminalDisplay.sendUpdatedState(bl);
    }

    public void setCursorShape(@Nullable com.jediterm.terminal.CursorShape shape) {
    }

    public void beep() {
        ++this.beepCount;
    }

    public void scrollArea(int scrollRegionTop, int scrollRegionSize, int dy) {
    }

    public void setCursorVisible(boolean shouldDrawCursor) {
        this.isCursorVisible = shouldDrawCursor;
    }

    public void useAlternateScreenBuffer(boolean useAlternateScreenBuffer) {
    }

    @NotNull
    public String getWindowTitle() {
        return this.title;
    }

    public boolean ambiguousCharsAreDoubleWidth() {
        return false;
    }

    public void setWindowTitle(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.title = name;
    }

    @Nullable
    public TerminalSelection getSelection() {
        return null;
    }

    public void terminalMouseModeSet(@NotNull com.jediterm.terminal.emulator.mouse.MouseMode mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        this.mouseMode = FleetTerminalDisplayKt.access$toFleetMouseMode(mode);
    }

    public void setMouseFormat(@NotNull com.jediterm.terminal.emulator.mouse.MouseFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.mouseFormat = FleetTerminalDisplayKt.access$toFleetMouseFormat(format);
    }

    public final void setArrowKeysModeProvider(@NotNull Function0<? extends ArrowKeysMode> arrowKeysModeProvider2) {
        Intrinsics.checkNotNullParameter(arrowKeysModeProvider2, (String)"arrowKeysModeProvider");
        this.arrowKeysModeProvider = arrowKeysModeProvider2;
    }

    public final void setKeypadModeProvider(@NotNull Function0<? extends KeypadMode> keypadModeProvider2) {
        Intrinsics.checkNotNullParameter(keypadModeProvider2, (String)"keypadModeProvider");
        this.keypadModeProvider = keypadModeProvider2;
    }

    public final void close() {
        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.terminalUpdatesChannelImpl), null, (int)1, null);
    }

    private final TerminalUpdate readTerminalState(boolean clear) {
        List<Line> list;
        LinesBuffer linesBuffer = this.terminalTextBuffer.getScreenBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)linesBuffer, (String)"getScreenBuffer(...)");
        List<Line> screenLines = TerminalModelKt.toFleetModel(linesBuffer);
        List list2 = CollectionsKt.take((Iterable)screenLines, (int)this.terminalTextBuffer.getHeight());
        int n = this.terminalTextBuffer.getWidth();
        int n2 = this.terminalTextBuffer.getHeight();
        int n3 = this.cursorX;
        int n4 = this.cursorY;
        MouseModeInfo mouseModeInfo = new MouseModeInfo(this.mouseMode, this.mouseFormat);
        ArrowKeysMode arrowKeysMode = (ArrowKeysMode)this.arrowKeysModeProvider.invoke();
        KeypadMode keypadMode = (KeypadMode)this.keypadModeProvider.invoke();
        boolean bl = this.terminalTextBuffer.isUsingAlternateBuffer();
        int n5 = this.beepCount;
        boolean bl2 = this.isCursorVisible;
        boolean bl3 = this.isCursorBlinking;
        CursorShape cursorShape = this.cursorShape;
        ScreenState screenState = new ScreenState(list2, n, n2, n3, n4, mouseModeInfo, arrowKeysMode, keypadMode, bl2, bl3, cursorShape, bl, clear, n5);
        this.beepCount = 0;
        if (!this.terminalTextBuffer.isUsingAlternateBuffer()) {
            List<Line> list3;
            LinesBuffer historyBuffer = this.terminalTextBuffer.getHistoryBuffer();
            Intrinsics.checkNotNull((Object)historyBuffer);
            List<Line> it = list3 = TerminalModelKt.toFleetModel(historyBuffer);
            boolean bl4 = false;
            if (historyBuffer.getLineCount() > 0) {
                historyBuffer.clearAll();
            }
            list = list3;
        } else {
            list = CollectionsKt.emptyList();
        }
        List<Line> history = list;
        return new TerminalUpdate(screenState, history);
    }
}

