/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.run.impl.terminal;

import andel.text.Text;
import fleet.api.exec.ShellMarker;
import fleet.frontend.run.impl.terminal.ExecutionUnitState;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0011J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\nH\u00c6\u0003J>\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001fJ\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010#\u001a\u00020\u0003H\u0016J\t\u0010$\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lfleet/frontend/run/impl/terminal/TerminalBlock;", "", "charCount", "", "markerStarts", "", "markers", "", "Lfleet/api/exec/ShellMarker;", "relatedState", "Lfleet/frontend/run/impl/terminal/ExecutionUnitState;", "(I[I[Lfleet/api/exec/ShellMarker;Lfleet/frontend/run/impl/terminal/ExecutionUnitState;)V", "getCharCount", "()I", "getMarkerStarts", "()[I", "getMarkers", "()[Lfleet/api/exec/ShellMarker;", "[Lfleet/api/exec/ShellMarker;", "getRelatedState", "()Lfleet/frontend/run/impl/terminal/ExecutionUnitState;", "command", "", "wholeText", "Landel/text/Text;", "blockOffset", "component1", "component2", "component3", "component4", "copy", "(I[I[Lfleet/api/exec/ShellMarker;Lfleet/frontend/run/impl/terminal/ExecutionUnitState;)Lfleet/frontend/run/impl/terminal/TerminalBlock;", "equals", "", "other", "hashCode", "toString", "fleet.run.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalBlockStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalBlockStore.kt\nfleet/frontend/run/impl/terminal/TerminalBlock\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,562:1\n630#2,5:563\n*S KotlinDebug\n*F\n+ 1 TerminalBlockStore.kt\nfleet/frontend/run/impl/terminal/TerminalBlock\n*L\n55#1:563,5\n*E\n"})
public final class TerminalBlock {
    private final int charCount;
    @NotNull
    private final int[] markerStarts;
    @NotNull
    private final ShellMarker[] markers;
    @Nullable
    private final ExecutionUnitState relatedState;

    public TerminalBlock(int charCount, @NotNull int[] markerStarts, @NotNull ShellMarker[] markers, @Nullable ExecutionUnitState relatedState) {
        Intrinsics.checkNotNullParameter((Object)markerStarts, (String)"markerStarts");
        Intrinsics.checkNotNullParameter((Object)markers, (String)"markers");
        this.charCount = charCount;
        this.markerStarts = markerStarts;
        this.markers = markers;
        this.relatedState = relatedState;
    }

    public final int getCharCount() {
        return this.charCount;
    }

    @NotNull
    public final int[] getMarkerStarts() {
        return this.markerStarts;
    }

    @NotNull
    public final ShellMarker[] getMarkers() {
        return this.markers;
    }

    @Nullable
    public final ExecutionUnitState getRelatedState() {
        return this.relatedState;
    }

    @Nullable
    public final String command(@NotNull Text wholeText, int blockOffset) {
        String string;
        Intrinsics.checkNotNullParameter((Object)wholeText, (String)"wholeText");
        ExecutionUnitState executionUnitState = this.relatedState;
        if (executionUnitState instanceof ExecutionUnitState.ExecutionFinished) {
            string = ((ExecutionUnitState.ExecutionFinished)this.relatedState).getCommand();
        } else if (executionUnitState instanceof ExecutionUnitState.ExecutionInProgress) {
            string = ((ExecutionUnitState.ExecutionInProgress)this.relatedState).getCommand();
        } else {
            CharSequence charSequence;
            block6: {
                int commandMarkerIdx = ArraysKt.indexOf((Object[])this.markers, (Object)ShellMarker.COMMAND);
                if (commandMarkerIdx == -1) {
                    return null;
                }
                long startOffset2 = this.markerStarts[commandMarkerIdx];
                long endOffset2 = commandMarkerIdx < ArraysKt.getLastIndex((Object[])this.markers) ? (long)this.markerStarts[commandMarkerIdx + 1] : (long)this.charCount;
                CharSequence $this$takeWhile$iv = (CharSequence)wholeText.charSequence((long)blockOffset + startOffset2, (long)blockOffset + endOffset2);
                boolean $i$f$takeWhile = false;
                int n = $this$takeWhile$iv.length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char it = $this$takeWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (it != '\n') continue;
                    charSequence = $this$takeWhile$iv.subSequence(0, index$iv);
                    break block6;
                }
                charSequence = $this$takeWhile$iv.subSequence(0, $this$takeWhile$iv.length());
            }
            CharSequence commandWithSuffix = StringsKt.trimEnd((CharSequence)charSequence);
            int spacesIdx = StringsKt.indexOf$default((CharSequence)commandWithSuffix, (String)"   ", (int)0, (boolean)false, (int)6, null);
            string = spacesIdx == -1 ? ((Object)commandWithSuffix).toString() : ((Object)commandWithSuffix.subSequence(0, spacesIdx)).toString();
        }
        return string;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof TerminalBlock && this.charCount == ((TerminalBlock)other).charCount && Arrays.equals(this.markerStarts, ((TerminalBlock)other).markerStarts) && Arrays.equals(this.markers, ((TerminalBlock)other).markers) && Intrinsics.areEqual((Object)this.relatedState, (Object)((TerminalBlock)other).relatedState);
    }

    public int hashCode() {
        int result = this.charCount;
        result = 31 * result + Arrays.hashCode(this.markerStarts);
        result = 31 * result + Arrays.hashCode(this.markers);
        ExecutionUnitState executionUnitState = this.relatedState;
        result = 31 * result + (executionUnitState != null ? executionUnitState.hashCode() : 0);
        return result;
    }

    public final int component1() {
        return this.charCount;
    }

    @NotNull
    public final int[] component2() {
        return this.markerStarts;
    }

    @NotNull
    public final ShellMarker[] component3() {
        return this.markers;
    }

    @Nullable
    public final ExecutionUnitState component4() {
        return this.relatedState;
    }

    @NotNull
    public final TerminalBlock copy(int charCount, @NotNull int[] markerStarts, @NotNull ShellMarker[] markers, @Nullable ExecutionUnitState relatedState) {
        Intrinsics.checkNotNullParameter((Object)markerStarts, (String)"markerStarts");
        Intrinsics.checkNotNullParameter((Object)markers, (String)"markers");
        return new TerminalBlock(charCount, markerStarts, markers, relatedState);
    }

    public static /* synthetic */ TerminalBlock copy$default(TerminalBlock terminalBlock, int n, int[] nArray, ShellMarker[] shellMarkerArray, ExecutionUnitState executionUnitState, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = terminalBlock.charCount;
        }
        if ((n2 & 2) != 0) {
            nArray = terminalBlock.markerStarts;
        }
        if ((n2 & 4) != 0) {
            shellMarkerArray = terminalBlock.markers;
        }
        if ((n2 & 8) != 0) {
            executionUnitState = terminalBlock.relatedState;
        }
        return terminalBlock.copy(n, nArray, shellMarkerArray, executionUnitState);
    }

    @NotNull
    public String toString() {
        return "TerminalBlock(charCount=" + this.charCount + ", markerStarts=" + Arrays.toString(this.markerStarts) + ", markers=" + Arrays.toString(this.markers) + ", relatedState=" + this.relatedState + ")";
    }
}

