/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.phonetics.metaphone;

import ai.grazie.nlp.phonetics.PhoneticEncoder;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0019\b\u0007\u0018\u0000 .2\u00020\u0001:\u0002./B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0014\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u001e\u0010\u0012\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u0013\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\u0015\u001a\u00020\u00042\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00002\u0006\u0010\t\u001a\u00020\u0004H\u0002J$\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00002\u0006\u0010\t\u001a\u00020\u0004H\u0002J$\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00002\u0006\u0010\t\u001a\u00020\u0004H\u0002J$\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00002\u0006\u0010\t\u001a\u00020\u0004H\u0002J$\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00002\u0006\u0010\t\u001a\u00020\u0004H\u0002J,\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00002\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\rH\u0002J$\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00002\u0006\u0010\t\u001a\u00020\u0004H\u0002J$\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00002\u0006\u0010\t\u001a\u00020\u0004H\u0002J,\u0010 \u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00002\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\rH\u0002J$\u0010!\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00002\u0006\u0010\t\u001a\u00020\u0004H\u0002J$\u0010\"\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00002\u0006\u0010\t\u001a\u00020\u0004H\u0002J,\u0010#\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00002\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\rH\u0002J,\u0010$\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00002\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\rH\u0002J$\u0010%\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00002\u0006\u0010\t\u001a\u00020\u0004H\u0002J$\u0010&\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00002\u0006\u0010\t\u001a\u00020\u0004H\u0002J$\u0010'\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00002\u0006\u0010\t\u001a\u00020\u0004H\u0002J$\u0010(\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00002\u0006\u0010\t\u001a\u00020\u0004H\u0002J,\u0010)\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00002\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\rH\u0002J\u0010\u0010*\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010+\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lai/grazie/nlp/phonetics/metaphone/DoubleMetaphone;", "Lai/grazie/nlp/phonetics/PhoneticEncoder;", "()V", "maxCodeLen", "", "charAt", "", "value", "", "index", "cleanInput", "input", "conditionC0", "", "conditionCH0", "conditionCH1", "conditionL0", "conditionM0", "doubleMetaphone", "alternate", "encode", "handleAEIOUY", "result", "Lai/grazie/nlp/phonetics/metaphone/DoubleMetaphone$DoubleMetaphoneResult;", "handleC", "handleCC", "handleCH", "handleD", "handleG", "slavoGermanic", "handleGH", "handleH", "handleJ", "handleL", "handleP", "handleR", "handleS", "handleSC", "handleT", "handleW", "handleX", "handleZ", "isSilentStart", "isSlavoGermanic", "isVowel", "ch", "Companion", "DoubleMetaphoneResult", "nlp-phonetics"})
@SourceDebugExtension(value={"SMAP\nDoubleMetaphone.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DoubleMetaphone.kt\nai/grazie/nlp/phonetics/metaphone/DoubleMetaphone\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,926:1\n107#2:927\n79#2,22:928\n*S KotlinDebug\n*F\n+ 1 DoubleMetaphone.kt\nai/grazie/nlp/phonetics/metaphone/DoubleMetaphone\n*L\n801#1:927\n801#1:928,22\n*E\n"})
public final class DoubleMetaphone
implements PhoneticEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxCodeLen;
    @NotNull
    private static final String VOWELS = "AEIOUY";
    @NotNull
    private static final String[] SILENT_START;
    @NotNull
    private static final String[] L_R_N_M_B_H_F_V_W_SPACE;
    @NotNull
    private static final String[] ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER;
    @NotNull
    private static final String[] L_T_K_S_N_M_B_Z;

    public DoubleMetaphone() {
        this.maxCodeLen = 12;
    }

    @Override
    @NotNull
    public String encode(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = DoubleMetaphone.doubleMetaphone$default(this, value, false, 2, null);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private final String doubleMetaphone(String value, boolean alternate) {
        String value2 = value;
        if ((value2 = this.cleanInput(value2)) == null) {
            return null;
        }
        boolean slavoGermanic = this.isSlavoGermanic(value2);
        int index = this.isSilentStart(value2) ? 1 : 0;
        DoubleMetaphoneResult result = new DoubleMetaphoneResult(this.maxCodeLen);
        while (!result.isComplete() && index <= value2.length() - 1) {
            char c = value2.charAt(index);
            if (((((c == 'A' ? true : c == 'E') ? true : c == 'I') ? true : c == 'O') ? true : c == 'U') ? true : c == 'Y') {
                index = this.handleAEIOUY(result, index);
                continue;
            }
            if (c == 'B') {
                result.append$nlp_phonetics('P');
                index = this.charAt(value2, index + 1) == 'B' ? index + 2 : index + 1;
                continue;
            }
            if (c == '\u00c7') {
                result.append$nlp_phonetics('S');
                ++index;
                continue;
            }
            if (c == 'C') {
                index = this.handleC(value2, result, index);
                continue;
            }
            if (c == 'D') {
                index = this.handleD(value2, result, index);
                continue;
            }
            if (c == 'F') {
                result.append$nlp_phonetics('F');
                index = this.charAt(value2, index + 1) == 'F' ? index + 2 : index + 1;
                continue;
            }
            if (c == 'G') {
                index = this.handleG(value2, result, index, slavoGermanic);
                continue;
            }
            if (c == 'H') {
                index = this.handleH(value2, result, index);
                continue;
            }
            if (c == 'J') {
                index = this.handleJ(value2, result, index, slavoGermanic);
                continue;
            }
            if (c == 'K') {
                result.append$nlp_phonetics('K');
                index = this.charAt(value2, index + 1) == 'K' ? index + 2 : index + 1;
                continue;
            }
            if (c == 'L') {
                index = this.handleL(value2, result, index);
                continue;
            }
            if (c == 'M') {
                result.append$nlp_phonetics('M');
                index = this.conditionM0(value2, index) ? index + 2 : index + 1;
                continue;
            }
            if (c == 'N') {
                result.append$nlp_phonetics('N');
                index = this.charAt(value2, index + 1) == 'N' ? index + 2 : index + 1;
                continue;
            }
            if (c == '\u00d1') {
                result.append$nlp_phonetics('N');
                ++index;
                continue;
            }
            if (c == 'P') {
                index = this.handleP(value2, result, index);
                continue;
            }
            if (c == 'Q') {
                result.append$nlp_phonetics('K');
                index = this.charAt(value2, index + 1) == 'Q' ? index + 2 : index + 1;
                continue;
            }
            if (c == 'R') {
                index = this.handleR(value2, result, index, slavoGermanic);
                continue;
            }
            if (c == 'S') {
                index = this.handleS(value2, result, index, slavoGermanic);
                continue;
            }
            if (c == 'T') {
                index = this.handleT(value2, result, index);
                continue;
            }
            if (c == 'V') {
                result.append$nlp_phonetics('F');
                index = this.charAt(value2, index + 1) == 'V' ? index + 2 : index + 1;
                continue;
            }
            if (c == 'W') {
                index = this.handleW(value2, result, index);
                continue;
            }
            if (c == 'X') {
                index = this.handleX(value2, result, index);
                continue;
            }
            if (c == 'Z') {
                index = this.handleZ(value2, result, index, slavoGermanic);
                continue;
            }
            ++index;
        }
        return alternate ? result.getAlternate() : result.getPrimary();
    }

    static /* synthetic */ String doubleMetaphone$default(DoubleMetaphone doubleMetaphone, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return doubleMetaphone.doubleMetaphone(string, bl);
    }

    private final int handleAEIOUY(DoubleMetaphoneResult result, int index) {
        if (index == 0) {
            result.append$nlp_phonetics('A');
        }
        return index + 1;
    }

    private final int handleC(String value, DoubleMetaphoneResult result, int index) {
        String[] stringArray;
        int index2 = index;
        if (this.conditionC0(value, index2)) {
            result.append$nlp_phonetics('K');
            index2 += 2;
        } else if (index2 == 0 && DoubleMetaphone.Companion.contains(value, index2, 6, stringArray = new String[]{"CAESAR"})) {
            result.append$nlp_phonetics('S');
            index2 += 2;
        } else {
            stringArray = new String[]{"CH"};
            if (DoubleMetaphone.Companion.contains(value, index2, 2, stringArray)) {
                index2 = this.handleCH(value, result, index2);
            } else {
                stringArray = new String[]{"CZ"};
                if (DoubleMetaphone.Companion.contains(value, index2, 2, stringArray) && !DoubleMetaphone.Companion.contains(value, index2 - 2, 4, stringArray = new String[]{"WICZ"})) {
                    result.append$nlp_phonetics('S', 'X');
                    index2 += 2;
                } else {
                    stringArray = new String[]{"CIA"};
                    if (DoubleMetaphone.Companion.contains(value, index2 + 1, 3, stringArray)) {
                        result.append$nlp_phonetics('X');
                        index2 += 3;
                    } else {
                        stringArray = new String[]{"CC"};
                        if (DoubleMetaphone.Companion.contains(value, index2, 2, stringArray) && (index2 != 1 || this.charAt(value, 0) != 'M')) {
                            return this.handleCC(value, result, index2);
                        }
                        stringArray = new String[]{"CK", "CG", "CQ"};
                        if (DoubleMetaphone.Companion.contains(value, index2, 2, stringArray)) {
                            result.append$nlp_phonetics('K');
                            index2 += 2;
                        } else {
                            stringArray = new String[]{"CI", "CE", "CY"};
                            if (DoubleMetaphone.Companion.contains(value, index2, 2, stringArray)) {
                                stringArray = new String[]{"CIO", "CIE", "CIA"};
                                if (DoubleMetaphone.Companion.contains(value, index2, 3, stringArray)) {
                                    result.append$nlp_phonetics('S', 'X');
                                } else {
                                    result.append$nlp_phonetics('S');
                                }
                                index2 += 2;
                            } else {
                                result.append$nlp_phonetics('K');
                                stringArray = new String[]{" C", " Q", " G"};
                                index2 = DoubleMetaphone.Companion.contains(value, index2 + 1, 2, stringArray) ? (index2 += 3) : (DoubleMetaphone.Companion.contains(value, index2 + 1, 1, stringArray = new String[]{"C", "K", "Q"}) && !DoubleMetaphone.Companion.contains(value, index2 + 1, 2, stringArray = new String[]{"CE", "CI"}) ? (index2 += 2) : ++index2);
                            }
                        }
                    }
                }
            }
        }
        return index2;
    }

    private final int handleCC(String value, DoubleMetaphoneResult result, int index) {
        int index2 = index;
        String[] stringArray = new String[]{"I", "E", "H"};
        if (DoubleMetaphone.Companion.contains(value, index2 + 2, 1, stringArray) && !DoubleMetaphone.Companion.contains(value, index2 + 2, 2, stringArray = new String[]{"HU"})) {
            if (index2 == 1 && this.charAt(value, index2 - 1) == 'A' || DoubleMetaphone.Companion.contains(value, index2 - 1, 5, stringArray = new String[]{"UCCEE", "UCCES"})) {
                result.append$nlp_phonetics("KS");
            } else {
                result.append$nlp_phonetics('X');
            }
            index2 += 3;
        } else {
            result.append$nlp_phonetics('K');
            index2 += 2;
        }
        return index2;
    }

    private final int handleCH(String value, DoubleMetaphoneResult result, int index) {
        String[] stringArray;
        if (index > 0) {
            stringArray = new String[]{"CHAE"};
            if (DoubleMetaphone.Companion.contains(value, index, 4, stringArray)) {
                result.append$nlp_phonetics('K', 'X');
                return index + 2;
            }
        }
        if (this.conditionCH0(value, index)) {
            result.append$nlp_phonetics('K');
            return index + 2;
        }
        if (this.conditionCH1(value, index)) {
            result.append$nlp_phonetics('K');
            return index + 2;
        }
        if (index > 0) {
            stringArray = new String[]{"MC"};
            if (DoubleMetaphone.Companion.contains(value, 0, 2, stringArray)) {
                result.append$nlp_phonetics('K');
            } else {
                result.append$nlp_phonetics('X', 'K');
            }
        } else {
            result.append$nlp_phonetics('X');
        }
        return index + 2;
    }

    private final int handleD(String value, DoubleMetaphoneResult result, int index) {
        int index2 = index;
        String[] stringArray = new String[]{"DG"};
        if (DoubleMetaphone.Companion.contains(value, index2, 2, stringArray)) {
            stringArray = new String[]{"I", "E", "Y"};
            if (DoubleMetaphone.Companion.contains(value, index2 + 2, 1, stringArray)) {
                result.append$nlp_phonetics('J');
                index2 += 3;
            } else {
                result.append$nlp_phonetics("TK");
                index2 += 2;
            }
        } else {
            stringArray = new String[]{"DT", "DD"};
            if (DoubleMetaphone.Companion.contains(value, index2, 2, stringArray)) {
                result.append$nlp_phonetics('T');
                index2 += 2;
            } else {
                result.append$nlp_phonetics('T');
                ++index2;
            }
        }
        return index2;
    }

    private final int handleG(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        int index2 = index;
        if (this.charAt(value, index2 + 1) == 'H') {
            index2 = this.handleGH(value, result, index2);
        } else if (this.charAt(value, index2 + 1) == 'N') {
            if (index2 == 1 && this.isVowel(this.charAt(value, 0)) && !slavoGermanic) {
                result.append$nlp_phonetics("KN", "N");
            } else {
                String[] stringArray = new String[]{"EY"};
                if (!DoubleMetaphone.Companion.contains(value, index2 + 2, 2, stringArray) && this.charAt(value, index2 + 1) != 'Y' && !slavoGermanic) {
                    result.append$nlp_phonetics("N", "KN");
                } else {
                    result.append$nlp_phonetics("KN");
                }
            }
            index2 += 2;
        } else {
            String[] stringArray = new String[]{"LI"};
            if (DoubleMetaphone.Companion.contains(value, index2 + 1, 2, stringArray) && !slavoGermanic) {
                result.append$nlp_phonetics("KL", "L");
                index2 += 2;
            } else if (index2 == 0 && (this.charAt(value, index2 + 1) == 'Y' || DoubleMetaphone.Companion.contains(value, index2 + 1, 2, Arrays.copyOf(stringArray = DoubleMetaphone.ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER, stringArray.length)))) {
                result.append$nlp_phonetics('K', 'J');
                index2 += 2;
            } else {
                stringArray = new String[]{"ER"};
                if (!(!DoubleMetaphone.Companion.contains(value, index2 + 1, 2, stringArray) && this.charAt(value, index2 + 1) != 'Y' || DoubleMetaphone.Companion.contains(value, 0, 6, stringArray = new String[]{"DANGER", "RANGER", "MANGER"}) || DoubleMetaphone.Companion.contains(value, index2 - 1, 1, stringArray = new String[]{"E", "I"}) || DoubleMetaphone.Companion.contains(value, index2 - 1, 3, stringArray = new String[]{"RGY", "OGY"}))) {
                    result.append$nlp_phonetics('K', 'J');
                    index2 += 2;
                } else {
                    stringArray = new String[]{"E", "I", "Y"};
                    if (DoubleMetaphone.Companion.contains(value, index2 + 1, 1, stringArray) || DoubleMetaphone.Companion.contains(value, index2 - 1, 4, stringArray = new String[]{"AGGI", "OGGI"})) {
                        stringArray = new String[]{"VAN ", "VON "};
                        if (DoubleMetaphone.Companion.contains(value, 0, 4, stringArray) || DoubleMetaphone.Companion.contains(value, 0, 3, stringArray = new String[]{"SCH"}) || DoubleMetaphone.Companion.contains(value, index2 + 1, 2, stringArray = new String[]{"ET"})) {
                            result.append$nlp_phonetics('K');
                        } else {
                            stringArray = new String[]{"IER"};
                            if (DoubleMetaphone.Companion.contains(value, index2 + 1, 3, stringArray)) {
                                result.append$nlp_phonetics('J');
                            } else {
                                result.append$nlp_phonetics('J', 'K');
                            }
                        }
                        index2 += 2;
                    } else if (this.charAt(value, index2 + 1) == 'G') {
                        index2 += 2;
                        result.append$nlp_phonetics('K');
                    } else {
                        ++index2;
                        result.append$nlp_phonetics('K');
                    }
                }
            }
        }
        return index2;
    }

    private final int handleGH(String value, DoubleMetaphoneResult result, int index) {
        String[] stringArray;
        int index2 = index;
        if (index2 > 0 && !this.isVowel(this.charAt(value, index2 - 1))) {
            result.append$nlp_phonetics('K');
            index2 += 2;
        } else if (index2 == 0) {
            if (this.charAt(value, index2 + 2) == 'I') {
                result.append$nlp_phonetics('J');
            } else {
                result.append$nlp_phonetics('K');
            }
            index2 += 2;
        } else if (index2 > 1 && DoubleMetaphone.Companion.contains(value, index2 - 2, 1, stringArray = new String[]{"B", "H", "D"}) || index2 > 2 && DoubleMetaphone.Companion.contains(value, index2 - 3, 1, stringArray = new String[]{"B", "H", "D"}) || index2 > 3 && DoubleMetaphone.Companion.contains(value, index2 - 4, 1, stringArray = new String[]{"B", "H"})) {
            index2 += 2;
        } else {
            if (index2 > 2 && this.charAt(value, index2 - 1) == 'U' && DoubleMetaphone.Companion.contains(value, index2 - 3, 1, stringArray = new String[]{"C", "G", "L", "R", "T"})) {
                result.append$nlp_phonetics('F');
            } else if (index2 > 0 && this.charAt(value, index2 - 1) != 'I') {
                result.append$nlp_phonetics('K');
            }
            index2 += 2;
        }
        return index2;
    }

    private final int handleH(String value, DoubleMetaphoneResult result, int index) {
        int index2 = index;
        if ((index2 == 0 || this.isVowel(this.charAt(value, index2 - 1))) && this.isVowel(this.charAt(value, index2 + 1))) {
            result.append$nlp_phonetics('H');
            index2 += 2;
        } else {
            ++index2;
        }
        return index2;
    }

    private final int handleJ(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        int index2 = index;
        String[] stringArray = new String[]{"JOSE"};
        if (DoubleMetaphone.Companion.contains(value, index2, 4, stringArray) || DoubleMetaphone.Companion.contains(value, 0, 4, stringArray = new String[]{"SAN "})) {
            if (index2 == 0 && this.charAt(value, index2 + 4) == ' ' || value.length() == 4 || DoubleMetaphone.Companion.contains(value, 0, 4, stringArray = new String[]{"SAN "})) {
                result.append$nlp_phonetics('H');
            } else {
                result.append$nlp_phonetics('J', 'H');
            }
            ++index2;
        } else {
            if (index2 == 0 && !DoubleMetaphone.Companion.contains(value, index2, 4, stringArray = new String[]{"JOSE"})) {
                result.append$nlp_phonetics('J', 'A');
            } else if (this.isVowel(this.charAt(value, index2 - 1)) && !slavoGermanic && (this.charAt(value, index2 + 1) == 'A' || this.charAt(value, index2 + 1) == 'O')) {
                result.append$nlp_phonetics('J', 'H');
            } else if (index2 == value.length() - 1) {
                result.append$nlp_phonetics('J', ' ');
            } else {
                stringArray = L_T_K_S_N_M_B_Z;
                if (!DoubleMetaphone.Companion.contains(value, index2 + 1, 1, Arrays.copyOf(stringArray, stringArray.length)) && !DoubleMetaphone.Companion.contains(value, index2 - 1, 1, stringArray = new String[]{"S", "K", "L"})) {
                    result.append$nlp_phonetics('J');
                }
            }
            index2 = this.charAt(value, index2 + 1) == 'J' ? (index2 += 2) : ++index2;
        }
        return index2;
    }

    private final int handleL(String value, DoubleMetaphoneResult result, int index) {
        int index2 = index;
        if (this.charAt(value, index2 + 1) == 'L') {
            if (this.conditionL0(value, index2)) {
                result.appendPrimary$nlp_phonetics('L');
            } else {
                result.append$nlp_phonetics('L');
            }
            index2 += 2;
        } else {
            ++index2;
            result.append$nlp_phonetics('L');
        }
        return index2;
    }

    private final int handleP(String value, DoubleMetaphoneResult result, int index) {
        int index2 = index;
        if (this.charAt(value, index2 + 1) == 'H') {
            result.append$nlp_phonetics('F');
            index2 += 2;
        } else {
            result.append$nlp_phonetics('P');
            String[] stringArray = new String[]{"P", "B"};
            index2 = DoubleMetaphone.Companion.contains(value, index2 + 1, 1, stringArray) ? index2 + 2 : index2 + 1;
        }
        return index2;
    }

    private final int handleR(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        String[] stringArray;
        if (index == value.length() - 1 && !slavoGermanic && DoubleMetaphone.Companion.contains(value, index - 2, 2, stringArray = new String[]{"IE"}) && !DoubleMetaphone.Companion.contains(value, index - 4, 2, stringArray = new String[]{"ME", "MA"})) {
            result.appendAlternate$nlp_phonetics('R');
        } else {
            result.append$nlp_phonetics('R');
        }
        return this.charAt(value, index + 1) == 'R' ? index + 2 : index + 1;
    }

    private final int handleS(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        int index2 = index;
        String[] stringArray = new String[]{"ISL", "YSL"};
        if (DoubleMetaphone.Companion.contains(value, index2 - 1, 3, stringArray)) {
            ++index2;
        } else if (index2 == 0 && DoubleMetaphone.Companion.contains(value, index2, 5, stringArray = new String[]{"SUGAR"})) {
            result.append$nlp_phonetics('X', 'S');
            ++index2;
        } else {
            stringArray = new String[]{"SH"};
            if (DoubleMetaphone.Companion.contains(value, index2, 2, stringArray)) {
                stringArray = new String[]{"HEIM", "HOEK", "HOLM", "HOLZ"};
                if (DoubleMetaphone.Companion.contains(value, index2 + 1, 4, stringArray)) {
                    result.append$nlp_phonetics('S');
                } else {
                    result.append$nlp_phonetics('X');
                }
                index2 += 2;
            } else {
                stringArray = new String[]{"SIO", "SIA"};
                if (DoubleMetaphone.Companion.contains(value, index2, 3, stringArray) || DoubleMetaphone.Companion.contains(value, index2, 4, stringArray = new String[]{"SIAN"})) {
                    if (slavoGermanic) {
                        result.append$nlp_phonetics('S');
                    } else {
                        result.append$nlp_phonetics('S', 'X');
                    }
                    index2 += 3;
                } else if (index2 == 0 && DoubleMetaphone.Companion.contains(value, index2 + 1, 1, stringArray = new String[]{"M", "N", "L", "W"}) || DoubleMetaphone.Companion.contains(value, index2 + 1, 1, stringArray = new String[]{"Z"})) {
                    result.append$nlp_phonetics('S', 'X');
                    stringArray = new String[]{"Z"};
                    index2 = DoubleMetaphone.Companion.contains(value, index2 + 1, 1, stringArray) ? index2 + 2 : index2 + 1;
                } else {
                    stringArray = new String[]{"SC"};
                    if (DoubleMetaphone.Companion.contains(value, index2, 2, stringArray)) {
                        index2 = this.handleSC(value, result, index2);
                    } else {
                        if (index2 == value.length() - 1 && DoubleMetaphone.Companion.contains(value, index2 - 2, 2, stringArray = new String[]{"AI", "OI"})) {
                            result.appendAlternate$nlp_phonetics('S');
                        } else {
                            result.append$nlp_phonetics('S');
                        }
                        stringArray = new String[]{"S", "Z"};
                        index2 = DoubleMetaphone.Companion.contains(value, index2 + 1, 1, stringArray) ? index2 + 2 : index2 + 1;
                    }
                }
            }
        }
        return index2;
    }

    private final int handleSC(String value, DoubleMetaphoneResult result, int index) {
        if (this.charAt(value, index + 2) == 'H') {
            String[] stringArray = new String[]{"OO", "ER", "EN", "UY", "ED", "EM"};
            if (DoubleMetaphone.Companion.contains(value, index + 3, 2, stringArray)) {
                stringArray = new String[]{"ER", "EN"};
                if (DoubleMetaphone.Companion.contains(value, index + 3, 2, stringArray)) {
                    result.append$nlp_phonetics("X", "SK");
                } else {
                    result.append$nlp_phonetics("SK");
                }
            } else if (index == 0 && !this.isVowel(this.charAt(value, 3)) && this.charAt(value, 3) != 'W') {
                result.append$nlp_phonetics('X', 'S');
            } else {
                result.append$nlp_phonetics('X');
            }
        } else {
            String[] stringArray = new String[]{"I", "E", "Y"};
            if (DoubleMetaphone.Companion.contains(value, index + 2, 1, stringArray)) {
                result.append$nlp_phonetics('S');
            } else {
                result.append$nlp_phonetics("SK");
            }
        }
        return index + 3;
    }

    private final int handleT(String value, DoubleMetaphoneResult result, int index) {
        int index2 = index;
        String[] stringArray = new String[]{"TION"};
        if (DoubleMetaphone.Companion.contains(value, index2, 4, stringArray)) {
            result.append$nlp_phonetics('X');
            index2 += 3;
        } else {
            stringArray = new String[]{"TIA", "TCH"};
            if (DoubleMetaphone.Companion.contains(value, index2, 3, stringArray)) {
                result.append$nlp_phonetics('X');
                index2 += 3;
            } else {
                stringArray = new String[]{"TH"};
                if (DoubleMetaphone.Companion.contains(value, index2, 2, stringArray) || DoubleMetaphone.Companion.contains(value, index2, 3, stringArray = new String[]{"TTH"})) {
                    stringArray = new String[]{"OM", "AM"};
                    if (DoubleMetaphone.Companion.contains(value, index2 + 2, 2, stringArray) || DoubleMetaphone.Companion.contains(value, 0, 4, stringArray = new String[]{"VAN ", "VON "}) || DoubleMetaphone.Companion.contains(value, 0, 3, stringArray = new String[]{"SCH"})) {
                        result.append$nlp_phonetics('T');
                    } else {
                        result.append$nlp_phonetics('0', 'T');
                    }
                    index2 += 2;
                } else {
                    result.append$nlp_phonetics('T');
                    stringArray = new String[]{"T", "D"};
                    index2 = DoubleMetaphone.Companion.contains(value, index2 + 1, 1, stringArray) ? index2 + 2 : index2 + 1;
                }
            }
        }
        return index2;
    }

    private final int handleW(String value, DoubleMetaphoneResult result, int index) {
        int index2 = index;
        String[] stringArray = new String[]{"WR"};
        if (DoubleMetaphone.Companion.contains(value, index2, 2, stringArray)) {
            result.append$nlp_phonetics('R');
            index2 += 2;
        } else if (index2 == 0 && (this.isVowel(this.charAt(value, index2 + 1)) || DoubleMetaphone.Companion.contains(value, index2, 2, stringArray = new String[]{"WH"}))) {
            if (this.isVowel(this.charAt(value, index2 + 1))) {
                result.append$nlp_phonetics('A', 'F');
            } else {
                result.append$nlp_phonetics('A');
            }
            ++index2;
        } else if (index2 == value.length() - 1 && this.isVowel(this.charAt(value, index2 - 1)) || DoubleMetaphone.Companion.contains(value, index2 - 1, 5, stringArray = new String[]{"EWSKI", "EWSKY", "OWSKI", "OWSKY"}) || DoubleMetaphone.Companion.contains(value, 0, 3, stringArray = new String[]{"SCH"})) {
            result.appendAlternate$nlp_phonetics('F');
            ++index2;
        } else {
            stringArray = new String[]{"WICZ", "WITZ"};
            if (DoubleMetaphone.Companion.contains(value, index2, 4, stringArray)) {
                result.append$nlp_phonetics("TS", "FX");
                index2 += 4;
            } else {
                ++index2;
            }
        }
        return index2;
    }

    private final int handleX(String value, DoubleMetaphoneResult result, int index) {
        int index2 = index;
        if (index2 == 0) {
            result.append$nlp_phonetics('S');
            ++index2;
        } else {
            String[] stringArray;
            if (index2 != value.length() - 1 || !DoubleMetaphone.Companion.contains(value, index2 - 3, 3, stringArray = new String[]{"IAU", "EAU"}) && !DoubleMetaphone.Companion.contains(value, index2 - 2, 2, stringArray = new String[]{"AU", "OU"})) {
                result.append$nlp_phonetics("KS");
            }
            stringArray = new String[]{"C", "X"};
            index2 = DoubleMetaphone.Companion.contains(value, index2 + 1, 1, stringArray) ? index2 + 2 : index2 + 1;
        }
        return index2;
    }

    private final int handleZ(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        int index2 = index;
        if (this.charAt(value, index2 + 1) == 'H') {
            result.append$nlp_phonetics('J');
            index2 += 2;
        } else {
            String[] stringArray = new String[]{"ZO", "ZI", "ZA"};
            if (DoubleMetaphone.Companion.contains(value, index2 + 1, 2, stringArray) || slavoGermanic && index2 > 0 && this.charAt(value, index2 - 1) != 'T') {
                result.append$nlp_phonetics("S", "TS");
            } else {
                result.append$nlp_phonetics('S');
            }
            index2 = this.charAt(value, index2 + 1) == 'Z' ? index2 + 2 : index2 + 1;
        }
        return index2;
    }

    private final boolean conditionC0(String value, int index) {
        String[] stringArray;
        String[] stringArray2 = new String[]{"CHIA"};
        if (DoubleMetaphone.Companion.contains(value, index, 4, stringArray2)) {
            return true;
        }
        if (index <= 1) {
            return false;
        }
        if (this.isVowel(this.charAt(value, index - 2))) {
            return false;
        }
        stringArray2 = new String[]{"ACH"};
        if (!DoubleMetaphone.Companion.contains(value, index - 1, 3, stringArray2)) {
            return false;
        }
        char c = this.charAt(value, index + 2);
        return c != 'I' && c != 'E' || DoubleMetaphone.Companion.contains(value, index - 2, 6, stringArray = new String[]{"BACHER", "MACHER"});
    }

    private final boolean conditionCH0(String value, int index) {
        if (index != 0) {
            return false;
        }
        String[] stringArray = new String[]{"HARAC", "HARIS"};
        if (!DoubleMetaphone.Companion.contains(value, index + 1, 5, stringArray) && !DoubleMetaphone.Companion.contains(value, index + 1, 3, stringArray = new String[]{"HOR", "HYM", "HIA", "HEM"})) {
            return false;
        }
        stringArray = new String[]{"CHORE"};
        return !DoubleMetaphone.Companion.contains(value, 0, 5, stringArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean conditionCH1(String value, int index) {
        String[] stringArray = new String[]{"VAN ", "VON "};
        if (DoubleMetaphone.Companion.contains(value, 0, 4, stringArray)) return true;
        stringArray = new String[]{"SCH"};
        if (DoubleMetaphone.Companion.contains(value, 0, 3, stringArray)) return true;
        stringArray = new String[]{"ORCHES", "ARCHIT", "ORCHID"};
        if (DoubleMetaphone.Companion.contains(value, index - 2, 6, stringArray)) return true;
        stringArray = new String[]{"T", "S"};
        if (DoubleMetaphone.Companion.contains(value, index + 2, 1, stringArray)) return true;
        stringArray = new String[]{"A", "O", "U", "E"};
        if (!DoubleMetaphone.Companion.contains(value, index - 1, 1, stringArray)) {
            if (index != 0) return false;
        }
        if (DoubleMetaphone.Companion.contains(value, index + 2, 1, Arrays.copyOf(stringArray = DoubleMetaphone.L_R_N_M_B_H_F_V_W_SPACE, stringArray.length))) return true;
        if (index + 1 != value.length() - 1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean conditionL0(String value, int index) {
        String[] stringArray;
        if (index == value.length() - 3) {
            stringArray = new String[]{"ILLO", "ILLA", "ALLE"};
            if (DoubleMetaphone.Companion.contains(value, index - 1, 4, stringArray)) {
                return true;
            }
        }
        stringArray = new String[]{"AS", "OS"};
        if (!DoubleMetaphone.Companion.contains(value, value.length() - 2, 2, stringArray)) {
            stringArray = new String[]{"A", "O"};
            if (!DoubleMetaphone.Companion.contains(value, value.length() - 1, 1, stringArray)) return false;
        }
        stringArray = new String[]{"ALLE"};
        if (!DoubleMetaphone.Companion.contains(value, index - 1, 4, stringArray)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean conditionM0(String value, int index) {
        if (this.charAt(value, index + 1) == 'M') {
            return true;
        }
        String[] stringArray = new String[]{"UMB"};
        if (!DoubleMetaphone.Companion.contains(value, index - 1, 3, stringArray)) return false;
        if (index + 1 == value.length() - 1) return true;
        stringArray = new String[]{"ER"};
        if (!DoubleMetaphone.Companion.contains(value, index + 2, 2, stringArray)) return false;
        return true;
    }

    private final boolean isSlavoGermanic(String value) {
        return StringsKt.indexOf$default((CharSequence)value, (char)'W', (int)0, (boolean)false, (int)6, null) > -1 || StringsKt.indexOf$default((CharSequence)value, (char)'K', (int)0, (boolean)false, (int)6, null) > -1 || StringsKt.indexOf$default((CharSequence)value, (String)"CZ", (int)0, (boolean)false, (int)6, null) > -1 || StringsKt.indexOf$default((CharSequence)value, (String)"WITZ", (int)0, (boolean)false, (int)6, null) > -1;
    }

    private final boolean isVowel(char ch) {
        return StringsKt.indexOf$default((CharSequence)VOWELS, (char)ch, (int)0, (boolean)false, (int)6, null) != -1;
    }

    private final boolean isSilentStart(String value) {
        boolean result = false;
        for (String element : SILENT_START) {
            if (!StringsKt.startsWith$default((String)value, (String)element, (boolean)false, (int)2, null)) continue;
            result = true;
            break;
        }
        return result;
    }

    private final String cleanInput(String input) {
        String string;
        String input2;
        String string2 = input;
        if (string2 == null) {
            return null;
        }
        String $this$trim$iv = input2 = string2;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if ((input2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0) {
            string = null;
        } else {
            String string3 = input2.toUpperCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        }
        return string;
    }

    private final char charAt(String value, int index) {
        return index < 0 || index >= value.length() ? (char)'\u0000' : value.charAt(index);
    }

    static {
        String[] stringArray = new String[]{"GN", "KN", "PN", "WR", "PS"};
        SILENT_START = stringArray;
        stringArray = new String[]{"L", "R", "N", "M", "B", "H", "F", "V", "W", " "};
        L_R_N_M_B_H_F_V_W_SPACE = stringArray;
        stringArray = new String[]{"ES", "EP", "EB", "EL", "EY", "IB", "IL", "IN", "IE", "EI", "ER"};
        ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER = stringArray;
        stringArray = new String[]{"L", "T", "K", "S", "N", "M", "B", "Z"};
        L_T_K_S_N_M_B_Z = stringArray;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0012R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\n\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lai/grazie/nlp/phonetics/metaphone/DoubleMetaphone$Companion;", "", "()V", "ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER", "", "", "[Ljava/lang/String;", "L_R_N_M_B_H_F_V_W_SPACE", "L_T_K_S_N_M_B_Z", "SILENT_START", "VOWELS", "contains", "", "value", "start", "", "length", "criteria", "(Ljava/lang/String;II[Ljava/lang/String;)Z", "nlp-phonetics"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean contains(String value, int start, int length, String ... criteria) {
            boolean result = false;
            if (start >= 0 && start + length <= value.length()) {
                String string = value.substring(start, start + length);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String target = string;
                for (String element : criteria) {
                    if (!Intrinsics.areEqual((Object)target, (Object)element)) continue;
                    result = true;
                    break;
                }
            }
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0010J\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0010J\u0015\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0013J\u0015\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0013J\u0015\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0015J\u0006\u0010\u0016\u001a\u00020\u0011J\u0006\u0010\u0017\u001a\u00020\u0011R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lai/grazie/nlp/phonetics/metaphone/DoubleMetaphone$DoubleMetaphoneResult;", "", "maxLength", "", "(Lai/grazie/nlp/phonetics/metaphone/DoubleMetaphone;I)V", "alternate", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "isComplete", "", "()Z", "primary", "append", "", "value", "", "append$nlp_phonetics", "", "appendAlternate", "appendAlternate$nlp_phonetics", "appendPrimary", "appendPrimary$nlp_phonetics", "getAlternate", "getPrimary", "nlp-phonetics"})
    private final class DoubleMetaphoneResult {
        private final int maxLength;
        @NotNull
        private final StringBuilder primary;
        @NotNull
        private final StringBuilder alternate;

        public DoubleMetaphoneResult(int maxLength) {
            this.maxLength = maxLength;
            this.primary = new StringBuilder(DoubleMetaphone.this.maxCodeLen);
            this.alternate = new StringBuilder(DoubleMetaphone.this.maxCodeLen);
        }

        public final void append$nlp_phonetics(char value) {
            this.appendPrimary$nlp_phonetics(value);
            this.appendAlternate$nlp_phonetics(value);
        }

        public final void append$nlp_phonetics(char primary, char alternate) {
            this.appendPrimary$nlp_phonetics(primary);
            this.appendAlternate$nlp_phonetics(alternate);
        }

        public final void appendPrimary$nlp_phonetics(char value) {
            if (this.primary.length() < this.maxLength) {
                this.primary.append(value);
            }
        }

        public final void appendAlternate$nlp_phonetics(char value) {
            if (this.alternate.length() < this.maxLength) {
                this.alternate.append(value);
            }
        }

        public final void append$nlp_phonetics(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.appendPrimary$nlp_phonetics(value);
            this.appendAlternate$nlp_phonetics(value);
        }

        public final void append$nlp_phonetics(@NotNull String primary, @NotNull String alternate) {
            Intrinsics.checkNotNullParameter((Object)primary, (String)"primary");
            Intrinsics.checkNotNullParameter((Object)alternate, (String)"alternate");
            this.appendPrimary$nlp_phonetics(primary);
            this.appendAlternate$nlp_phonetics(alternate);
        }

        public final void appendPrimary$nlp_phonetics(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            int addChars = this.maxLength - this.primary.length();
            if (value.length() <= addChars) {
                this.primary.append(value);
            } else {
                String string = value.substring(0, addChars);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                this.primary.append(string);
            }
        }

        public final void appendAlternate$nlp_phonetics(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            int addChars = this.maxLength - this.alternate.length();
            if (value.length() <= addChars) {
                this.alternate.append(value);
            } else {
                String string = value.substring(0, addChars);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                this.alternate.append(string);
            }
        }

        @NotNull
        public final String getPrimary() {
            String string = this.primary.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"primary.toString()");
            return string;
        }

        @NotNull
        public final String getAlternate() {
            String string = this.alternate.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"alternate.toString()");
            return string;
        }

        public final boolean isComplete() {
            return this.primary.length() >= this.maxLength && this.alternate.length() >= this.maxLength;
        }
    }
}

