/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.debug;

import androidx.compose.foundation.layout.RowScope;
import androidx.compose.ui.graphics.Color;
import fleet.common.debug.DebugBreakpointEntity;
import fleet.frontend.debug.BreakpointRenderer;
import fleet.frontend.icons.IconKeys;
import fleet.protocol.debug.ExceptionBreakpoint;
import fleet.protocol.debug.FleetBreakpoint;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import noria.model.ThemeKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004j\u0004\u0018\u0001`\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lfleet/frontend/debug/ExceptionBreakpointRenderer;", "Lfleet/frontend/debug/BreakpointRenderer;", "()V", "getIcon", "Lnoria/model/ThemeKey;", "", "Lnoria/model/IconKey;", "breakpoint", "Lfleet/protocol/debug/FleetBreakpoint;", "registered", "", "getTitle", "fleet.debug.frontend"})
public abstract class ExceptionBreakpointRenderer
implements BreakpointRenderer {
    @Override
    @Nullable
    public ThemeKey<String> getIcon(@NotNull FleetBreakpoint breakpoint, boolean registered) {
        Intrinsics.checkNotNullParameter((Object)breakpoint, (String)"breakpoint");
        return breakpoint.getEnabled() && registered ? IconKeys.Breakpoints.INSTANCE.getExceptionBreakpoint() : IconKeys.Breakpoints.INSTANCE.getExceptionBreakpointInactive();
    }

    @Override
    @NotNull
    public String getTitle(@NotNull FleetBreakpoint breakpoint) {
        Intrinsics.checkNotNullParameter((Object)breakpoint, (String)"breakpoint");
        ExceptionBreakpoint exceptionBreakpoint = (ExceptionBreakpoint)breakpoint;
        return exceptionBreakpoint.getExceptionClassName();
    }

    @Override
    @Nullable
    public ThemeKey<Color> getTitleColor(@NotNull FleetBreakpoint breakpoint) {
        return BreakpointRenderer.DefaultImpls.getTitleColor(this, breakpoint);
    }

    @Override
    @Nullable
    public String getTailText(@NotNull FleetBreakpoint breakpoint) {
        return BreakpointRenderer.DefaultImpls.getTailText(this, breakpoint);
    }

    @Override
    @Nullable
    public Function1<RowScope, Unit> settingsView(@NotNull DebugBreakpointEntity breakpointEntity) {
        return BreakpointRenderer.DefaultImpls.settingsView(this, breakpointEntity);
    }
}

