module fleet.frontend {
    requires fleet.kernel.plugins;
    requires fleet.bundles;
    requires kotlin.stdlib;
    requires fleet.noria.ui;
    requires fleet.util.core;
    requires kotlinx.coroutines.core;
    requires fleet.protocol;
    requires org.jetbrains.annotations;
    requires fleet.andel;
    requires fleet.rhizomedb;
    /* transitive */ requires fleet.common;
    requires bifurcan;
    requires fleet.noria.windowManagement.api;
    requires fleet.noria.windowManagement.extensions;
    requires fleet.dock.api;
    requires fleet.rpc;
    requires fleet.preferences;
    requires kotlinx.serialization.core;
    requires io.ktor.server.host.common;
    requires io.ktor.server.core;
    requires io.ktor.http;
    requires kotlinx.serialization.json;
    requires fleet.util.network;
    requires fleet.noria.cells;
    requires util.base.squashed;
    requires io.ktor.server.cio;
    requires fleet.rpc.relay;
    requires io.ktor.client.core;
    requires skiko.awt;
    requires fleet.schema.protocol;
    requires fleet.schema.common;
    requires fleet.reporting.api;
    requires fleet.dock.connectors;
    requires fleet.reporting.fus.api;
    requires fleet.themes;
    requires fleet.reporting.shared;
    requires java.management;
    requires jdk.management;
    /* transitive */ requires ec4j.core;
    requires fleet.util.os;
    /* transitive */ requires fleet.navigation.frontend.api;

    exports fleet.frontend.actions;
    exports fleet.frontend.auth;
    exports fleet.frontend.core;
    exports fleet.frontend.editor;
    exports fleet.frontend.editor.editorconfig;
    exports fleet.frontend.editor.actions;
    exports fleet.frontend.editor.components;
    exports fleet.frontend.editor.typing;
    exports fleet.frontend.following;
    exports fleet.frontend.fsd;
    exports fleet.frontend.fus;
    exports fleet.frontend.fus.reports;
    exports fleet.frontend.keymap;
    exports fleet.frontend.language;
    exports fleet.frontend.layout;
    exports fleet.frontend.layout.recovery;
    exports fleet.frontend.navigation;
    exports fleet.frontend.notifications;
    exports fleet.frontend.places;
    exports fleet.frontend.settings;
    exports fleet.frontend.smartMode;
    exports fleet.frontend.template;
    exports fleet.frontend.theme;
    exports fleet.frontend.topology;
    exports fleet.frontend.undo;
    exports fleet.frontend.user;
    exports fleet.frontend.util;
    exports fleet.frontend.workspace;
    exports fleet.frontend;
    exports fleet.frontend.icons;
    exports fleet.frontend.editor.scratch;
    exports fleet.frontend.clipboard;
    exports fleet.frontend.notifications.exceptions;
    exports fleet.frontend.help;
    exports fleet.frontend.license;
    exports fleet.frontend.ai;
    exports fleet.frontend.document;
    exports fleet.frontend.reporting;
    exports fleet.frontend.connection to fleet.frontend.ui, fleet.git.frontend, fleet.rhizomedb, fleet.ship.desktop;
    exports fleet.frontend.fsd.chooser to fleet.rhizomedb, fleet.filetree.frontend;

    provides Plugin with FrontendPlugin;

}

