/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.notifications;

import fleet.frontend.notifications.NotificationTime$;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0087\b\u0018\u0000 &2\u00020\u0001:\u0004#$%&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B#\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J%\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0001\u00a2\u0006\u0002\b\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006'"}, d2={"Lfleet/frontend/notifications/NotificationTime;", "", "epochTime", "", "<init>", "(J)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IJLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getEpochTime", "()J", "getDate", "Lfleet/frontend/notifications/NotificationTime$RenderedDate;", "getTime", "Lfleet/frontend/notifications/NotificationTime$RenderedTime;", "localDateTime", "Ljava/time/LocalDateTime;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$fleet_frontend", "RenderedTime", "RenderedDate", "$serializer", "Companion", "fleet.frontend"})
public final class NotificationTime {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long epochTime;

    public NotificationTime(long epochTime) {
        this.epochTime = epochTime;
    }

    public final long getEpochTime() {
        return this.epochTime;
    }

    @NotNull
    public final RenderedDate getDate() {
        RenderedDate renderedDate;
        LocalDateTime timeNow = LocalDateTime.now();
        LocalDateTime msgTime = this.localDateTime();
        if (Intrinsics.areEqual((Object)msgTime.toLocalDate(), (Object)timeNow.toLocalDate())) {
            renderedDate = RenderedDate.Today.INSTANCE;
        } else if (Intrinsics.areEqual((Object)msgTime.toLocalDate(), (Object)timeNow.toLocalDate().minusDays(1L))) {
            renderedDate = RenderedDate.Yesterday.INSTANCE;
        } else {
            String string = msgTime.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            renderedDate = new RenderedDate.JustDate(string);
        }
        return renderedDate;
    }

    @NotNull
    public final RenderedTime getTime() {
        Instant msgInstant = Instant.ofEpochMilli(this.epochTime);
        ZoneOffset offset = ZoneId.systemDefault().getRules().getOffset(msgInstant);
        LocalDateTime dt = LocalDateTime.ofInstant(msgInstant, offset);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm");
        String string = dt.format(formatter);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return new RenderedTime.JustTime(string);
    }

    private final LocalDateTime localDateTime() {
        Instant msgInstant = Instant.ofEpochMilli(this.epochTime);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(msgInstant, ZoneId.systemDefault().getRules().getOffset(msgInstant));
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"ofInstant(...)");
        return localDateTime;
    }

    public final long component1() {
        return this.epochTime;
    }

    @NotNull
    public final NotificationTime copy(long epochTime) {
        return new NotificationTime(epochTime);
    }

    public static /* synthetic */ NotificationTime copy$default(NotificationTime notificationTime, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = notificationTime.epochTime;
        }
        return notificationTime.copy(l);
    }

    @NotNull
    public String toString() {
        return "NotificationTime(epochTime=" + this.epochTime + ")";
    }

    public int hashCode() {
        return Long.hashCode(this.epochTime);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NotificationTime)) {
            return false;
        }
        NotificationTime notificationTime = (NotificationTime)other;
        return this.epochTime == notificationTime.epochTime;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$fleet_frontend(NotificationTime self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeLongElement(serialDesc, 0, self.epochTime);
    }

    public /* synthetic */ NotificationTime(int seen0, long epochTime, SerializationConstructorMarker serializationConstructorMarker) {
        if (1 != (1 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.epochTime = epochTime;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lfleet/frontend/notifications/NotificationTime$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lfleet/frontend/notifications/NotificationTime;", "fleet.frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<NotificationTime> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0006\u0007\bB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&\u0082\u0001\u0003\t\n\u000b\u00a8\u0006\f"}, d2={"Lfleet/frontend/notifications/NotificationTime$RenderedDate;", "", "<init>", "()V", "getCaption", "", "Today", "Yesterday", "JustDate", "Lfleet/frontend/notifications/NotificationTime$RenderedDate$JustDate;", "Lfleet/frontend/notifications/NotificationTime$RenderedDate$Today;", "Lfleet/frontend/notifications/NotificationTime$RenderedDate$Yesterday;", "fleet.frontend"})
    public static abstract class RenderedDate {
        private RenderedDate() {
        }

        @NotNull
        public abstract String getCaption();

        public /* synthetic */ RenderedDate(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lfleet/frontend/notifications/NotificationTime$RenderedDate$JustDate;", "Lfleet/frontend/notifications/NotificationTime$RenderedDate;", "date", "", "<init>", "(Ljava/lang/String;)V", "getDate", "()Ljava/lang/String;", "getCaption", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "fleet.frontend"})
        public static final class JustDate
        extends RenderedDate {
            @NotNull
            private final String date;

            public JustDate(@NotNull String date) {
                Intrinsics.checkNotNullParameter((Object)date, (String)"date");
                super(null);
                this.date = date;
            }

            @NotNull
            public final String getDate() {
                return this.date;
            }

            @Override
            @NotNull
            public String getCaption() {
                return this.date;
            }

            @NotNull
            public final String component1() {
                return this.date;
            }

            @NotNull
            public final JustDate copy(@NotNull String date) {
                Intrinsics.checkNotNullParameter((Object)date, (String)"date");
                return new JustDate(date);
            }

            public static /* synthetic */ JustDate copy$default(JustDate justDate, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = justDate.date;
                }
                return justDate.copy(string);
            }

            @NotNull
            public String toString() {
                return "JustDate(date=" + this.date + ")";
            }

            public int hashCode() {
                return this.date.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof JustDate)) {
                    return false;
                }
                JustDate justDate = (JustDate)other;
                return Intrinsics.areEqual((Object)this.date, (Object)justDate.date);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lfleet/frontend/notifications/NotificationTime$RenderedDate$Today;", "Lfleet/frontend/notifications/NotificationTime$RenderedDate;", "<init>", "()V", "getCaption", "", "fleet.frontend"})
        public static final class Today
        extends RenderedDate {
            @NotNull
            public static final Today INSTANCE = new Today();

            private Today() {
                super(null);
            }

            @Override
            @NotNull
            public String getCaption() {
                return "Today";
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lfleet/frontend/notifications/NotificationTime$RenderedDate$Yesterday;", "Lfleet/frontend/notifications/NotificationTime$RenderedDate;", "<init>", "()V", "getCaption", "", "fleet.frontend"})
        public static final class Yesterday
        extends RenderedDate {
            @NotNull
            public static final Yesterday INSTANCE = new Yesterday();

            private Yesterday() {
                super(null);
            }

            @Override
            @NotNull
            public String getCaption() {
                return "Yesterday";
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0006\u0007B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&\u0082\u0001\u0002\b\t\u00a8\u0006\n"}, d2={"Lfleet/frontend/notifications/NotificationTime$RenderedTime;", "", "<init>", "()V", "getCaption", "", "Ago", "JustTime", "Lfleet/frontend/notifications/NotificationTime$RenderedTime$Ago;", "Lfleet/frontend/notifications/NotificationTime$RenderedTime$JustTime;", "fleet.frontend"})
    public static abstract class RenderedTime {
        private RenderedTime() {
        }

        @NotNull
        public abstract String getCaption();

        public /* synthetic */ RenderedTime(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lfleet/frontend/notifications/NotificationTime$RenderedTime$Ago;", "Lfleet/frontend/notifications/NotificationTime$RenderedTime;", "count", "", "name", "", "<init>", "(ILjava/lang/String;)V", "getCount", "()I", "getName", "()Ljava/lang/String;", "getCaption", "fleet.frontend"})
        public static final class Ago
        extends RenderedTime {
            private final int count;
            @NotNull
            private final String name;

            public Ago(int count, @NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                super(null);
                this.count = count;
                this.name = name;
            }

            public final int getCount() {
                return this.count;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @Override
            @NotNull
            public String getCaption() {
                return "" + this.count + this.name.charAt(0);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lfleet/frontend/notifications/NotificationTime$RenderedTime$JustTime;", "Lfleet/frontend/notifications/NotificationTime$RenderedTime;", "time", "", "<init>", "(Ljava/lang/String;)V", "getTime", "()Ljava/lang/String;", "getCaption", "fleet.frontend"})
        public static final class JustTime
        extends RenderedTime {
            @NotNull
            private final String time;

            public JustTime(@NotNull String time) {
                Intrinsics.checkNotNullParameter((Object)time, (String)"time");
                super(null);
                this.time = time;
            }

            @NotNull
            public final String getTime() {
                return this.time;
            }

            @Override
            @NotNull
            public String getCaption() {
                return this.time;
            }
        }
    }
}

