/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.javascript.parsing;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.javascript.DialectOptionHolder;
import fleet.com.intellij.lang.javascript.JSKeywordSets;
import fleet.com.intellij.lang.javascript.JSLanguageDialect;
import fleet.com.intellij.lang.javascript.JSTokenTypes;
import fleet.com.intellij.lang.javascript.dialects.JSLanguageFeature;
import fleet.com.intellij.lang.javascript.parsing.ExpressionParser;
import fleet.com.intellij.lang.javascript.parsing.FunctionParser;
import fleet.com.intellij.lang.javascript.parsing.JSParsingContextUtil;
import fleet.com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import fleet.com.intellij.lang.javascript.parsing.JSXmlParser;
import fleet.com.intellij.lang.javascript.parsing.JSXmlTokensParser;
import fleet.com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import fleet.com.intellij.lang.javascript.parsing.StatementParser;
import fleet.com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import fleet.com.intellij.psi.PsiElement;
import fleet.com.intellij.psi.tree.IElementType;
import java.util.EnumSet;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class JavaScriptParser<E extends ExpressionParser, S extends StatementParser, F extends FunctionParser, T extends JSPsiTypeParser> {
    @NotNull
    private final JSLanguageDialect myLanguage;
    protected final PsiBuilder builder;
    protected E myExpressionParser;
    protected S myStatementParser;
    protected F myFunctionParser;
    protected T myTypeParser;
    protected JSXmlParser myXmlParser;

    public JavaScriptParser(@NotNull JSLanguageDialect language, PsiBuilder builder) {
        this.builder = builder;
        this.myLanguage = language;
        this.myExpressionParser = new ExpressionParser<JavaScriptParser>(this);
        this.myStatementParser = new StatementParser<JavaScriptParser>(this);
        this.myFunctionParser = new FunctionParser<JavaScriptParser>(this);
        this.myTypeParser = new JSPsiTypeParser<JavaScriptParser>(this);
        this.myXmlParser = !language.getOptionHolder().hasFeature(JSLanguageFeature.E4X) ? JSXmlParser.DUMMY : new JSXmlTokensParser(this);
    }

    public void parseJS(IElementType root) {
        PsiBuilder.Marker rootMarker = this.builder.mark();
        JavaScriptParserBase.ForceContext forceContext = (JavaScriptParserBase.ForceContext)((Object)this.builder.getUserData(JavaScriptParserBase.FORCE_CONTEXT_KEY));
        if (forceContext != null) {
            if (forceContext == JavaScriptParserBase.ForceContext.Parameter && this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
                this.builder.advanceLexer();
            } else {
                if (forceContext == JavaScriptParserBase.ForceContext.TypeAllowEmpty && this.builder.eof()) {
                    rootMarker.done(root);
                    return;
                }
                ((JSPsiTypeParser)this.myTypeParser).parseType();
            }
        } else {
            this.builder.putUserData(JSParsingContextUtil.ASYNC_METHOD_KEY, (Object)true);
        }
        this.doParseJS();
        rootMarker.done(root);
    }

    protected void doParseJS() {
        while (!this.builder.eof()) {
            ((StatementParser)this.getStatementParser()).parseStatement();
        }
    }

    public void fillBuilderDataFromContext(@NotNull PsiElement context) {
        JSParsingContextUtil.fillBuilderData(context, this.builder, this.getFunctionParser());
    }

    public void fillBuilderData(boolean isAsyncContext, boolean isGeneratorContext) {
        this.builder.putUserData(JSParsingContextUtil.ASYNC_METHOD_KEY, (Object)isAsyncContext);
        JSParsingContextUtil.setIsGenerator(isGeneratorContext, this.builder);
    }

    public E getExpressionParser() {
        return this.myExpressionParser;
    }

    public S getStatementParser() {
        return this.myStatementParser;
    }

    public F getFunctionParser() {
        return this.myFunctionParser;
    }

    public T getTypeParser() {
        return this.myTypeParser;
    }

    public JSXmlParser getXmlParser() {
        return this.myXmlParser;
    }

    public boolean isIdentifierToken(IElementType tokenType) {
        return JSKeywordSets.JS_IDENTIFIER_TOKENS_SET.contains(tokenType);
    }

    public boolean isIdentifierName(IElementType firstToken) {
        return JSKeywordSets.IDENTIFIER_NAMES.contains(firstToken);
    }

    @NotNull
    public DialectOptionHolder getDialect() {
        return this.myLanguage.getOptionHolder();
    }

    public void buildTokenElement(@NotNull IElementType type) {
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        marker.done(type);
    }

    @NotNull
    public EnumSet<JSModifiersStructure.JSModifiersParseResult> parseModifiers(@NotNull JSModifiersStructure structure, boolean dropIfEmpty, @NotNull Predicate<? super PsiBuilder> isPossibleStateAfterModifiers) {
        boolean lexerAdvanced;
        int offsetBefore = this.builder.getCurrentOffset();
        PsiBuilder.Marker attrList = this.builder.mark();
        ((FunctionParser)this.getFunctionParser()).tryParseES7Decorators();
        EnumSet<JSModifiersStructure.JSModifiersParseResult> parseResults = structure.parseOptimistically(this.builder);
        if (parseResults.contains((Object)JSModifiersStructure.JSModifiersParseResult.LEXER_ADVANCED) && !isPossibleStateAfterModifiers.test((PsiBuilder)this.builder)) {
            attrList.rollbackTo();
            attrList = this.builder.mark();
            ((FunctionParser)this.getFunctionParser()).tryParseES7Decorators();
            parseResults = structure.parse(this.builder, isPossibleStateAfterModifiers);
        }
        boolean bl = lexerAdvanced = this.builder.getCurrentOffset() > offsetBefore;
        if (lexerAdvanced) {
            parseResults.add(JSModifiersStructure.JSModifiersParseResult.LEXER_ADVANCED);
        } else {
            parseResults.remove((Object)JSModifiersStructure.JSModifiersParseResult.LEXER_ADVANCED);
        }
        if (dropIfEmpty && !lexerAdvanced) {
            attrList.drop();
        } else {
            attrList.done(((FunctionParser)this.myFunctionParser).getAttributeListElementType());
        }
        return parseResults;
    }

    @NotNull
    protected JSLanguageDialect getLanguage() {
        return this.myLanguage;
    }
}

