/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.javascript.parsing;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.WhitespacesAndCommentsBinder;
import fleet.com.intellij.lang.javascript.JSElementTypes;
import fleet.com.intellij.lang.javascript.JSStubElementTypes;
import fleet.com.intellij.lang.javascript.JSTokenTypes;
import fleet.com.intellij.lang.javascript.JavaScriptBundle;
import fleet.com.intellij.lang.javascript.parsing.ExpressionParser;
import fleet.com.intellij.lang.javascript.parsing.JSXmlParser;
import fleet.com.intellij.lang.javascript.parsing.JavaScriptParser;
import fleet.com.intellij.openapi.util.text.StringUtil;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.intellij.psi.xml.XmlTokenType;
import fleet.com.intellij.util.containers.Stack;
import fleet.com.intellij.util.text.CharSequenceSubSequence;
import fleet.com.intellij.xml.psi.XmlPsiBundle;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXmlTokensParser
implements JSXmlParser {
    private static final WhitespacesAndCommentsBinder INCOMPLETE_TAG_WHITESPACE_BINDER = new WhitespacesAndCommentsBinder(){

        public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            IElementType last = tokens.get(tokens.size() - 1);
            IElementType prev = tokens.get(tokens.size() - 2);
            return last == JSTokenTypes.WHITE_SPACE && prev != JSTokenTypes.XML_TAG_END && prev != JSTokenTypes.XML_END_TAG_LIST && prev != JSTokenTypes.XML_EMPTY_TAG_END && !JSTokenTypes.COMMENTS.contains(prev) ? 1 : 0;
        }
    };
    protected PsiBuilder builder;
    private final TokenSet myEmbeddedJsxElementTypes;
    private boolean myEmptyTagNameAllowed = false;
    @Nullable
    private final JavaScriptParser<?, ?, ?, ?> myParser;

    public JSXmlTokensParser(@NotNull JavaScriptParser<?, ?, ?, ?> parser) {
        this.builder = parser.builder;
        this.myEmbeddedJsxElementTypes = TokenSet.EMPTY;
        this.myParser = parser;
    }

    public JSXmlTokensParser(PsiBuilder builder, @NotNull TokenSet embeddedJsxElementTypes) {
        this.builder = builder;
        this.myEmbeddedJsxElementTypes = embeddedJsxElementTypes;
        this.myParser = null;
    }

    public JSXmlTokensParser withEmptyTagNameAllowed(boolean emptyTagNameAllowed) {
        this.myEmptyTagNameAllowed = emptyTagNameAllowed;
        return this;
    }

    @Override
    public boolean isXmlTagStart(IElementType currentToken) {
        return currentToken == JSTokenTypes.XML_START_TAG_START || currentToken == JSTokenTypes.XML_START_TAG_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean parseTag(@NotNull Stack<String> tagNames) {
        String name;
        IElementType tokenType = this.builder.getTokenType();
        assert (JSTokenTypes.XML_START_TAG_START == tokenType || JSTokenTypes.XML_START_TAG_LIST == tokenType);
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == JSTokenTypes.XML_LBRACE) {
            StringBuilder nameBuilder = new StringBuilder();
            this.parseXmlJsScript(nameBuilder);
            name = nameBuilder.toString();
        } else {
            name = this.builder.getTokenText();
        }
        boolean seenEnd = JSTokenTypes.XML_START_TAG_LIST == tokenType;
        tagNames.push((Object)name);
        boolean hasErrors = false;
        try {
            IElementType currentTokenType = this.builder.getTokenType();
            while (currentTokenType != null) {
                if (!JSTokenTypes.XML_TOKENS.contains(currentTokenType) && !this.myEmbeddedJsxElementTypes.contains(currentTokenType) && currentTokenType != JSTokenTypes.XML_LBRACE) {
                    if (!this.parseSpecialTagEntity(currentTokenType)) {
                        if (!seenEnd) {
                            this.builder.error(XmlPsiBundle.message((String)"xml.parsing.tag.start.is.not.closed", (Object[])new Object[0]));
                            boolean bl = false;
                            return bl;
                        }
                        PsiBuilder.Marker errorMarker = this.builder.mark();
                        this.builder.advanceLexer();
                        errorMarker.error(JavaScriptBundle.message("javascript.parser.message.expected.xml.element", new Object[0]));
                    }
                } else if (currentTokenType == JSTokenTypes.XML_START_TAG_START || currentTokenType == JSTokenTypes.XML_START_TAG_LIST) {
                    this.parseTag(tagNames);
                } else {
                    if (currentTokenType == JSTokenTypes.XML_EMPTY_TAG_END || currentTokenType == JSTokenTypes.XML_END_TAG_LIST) {
                        this.builder.advanceLexer();
                        boolean errorMarker = !hasErrors;
                        return errorMarker;
                    }
                    if (currentTokenType == JSTokenTypes.XML_END_TAG_START) {
                        if (!seenEnd) {
                            this.builder.error(XmlPsiBundle.message((String)"xml.parsing.tag.start.is.not.closed", (Object[])new Object[0]));
                            boolean errorMarker = false;
                            return errorMarker;
                        }
                        PsiBuilder.Marker endTagStart = this.builder.mark();
                        this.builder.advanceLexer();
                        IElementType type = this.builder.getTokenType();
                        if (type == XmlTokenType.XML_TAG_NAME || this.myEmbeddedJsxElementTypes.contains(type) || type == JSTokenTypes.XML_LBRACE) {
                            String endName;
                            if (type == JSTokenTypes.XML_LBRACE) {
                                StringBuilder nameBuilder = new StringBuilder();
                                this.parseXmlJsScript(nameBuilder);
                                endName = nameBuilder.toString();
                            } else {
                                endName = this.builder.getTokenText();
                            }
                            if (!(StringUtil.equals((CharSequence)name, (CharSequence)endName) || endName != null && endName.endsWith("IntellijIdeaRulezzz"))) {
                                if (tagNames.contains((Object)endName)) {
                                    endTagStart.rollbackTo();
                                    this.builder.error(XmlPsiBundle.message((String)"xml.parsing.named.element.is.not.closed", (Object[])new Object[]{name}));
                                    boolean bl = !hasErrors;
                                    return bl;
                                }
                                this.builder.error(XmlPsiBundle.message((String)"xml.parsing.closing.tag.matches.nothing", (Object[])new Object[0]));
                                hasErrors = true;
                            }
                            if (type != JSTokenTypes.XML_LBRACE) {
                                this.builder.advanceLexer();
                            }
                        } else if (!this.myEmptyTagNameAllowed && JSTokenTypes.XML_START_TAG_LIST != tokenType) {
                            this.builder.error(XmlPsiBundle.message((String)"xml.parsing.closing.tag.name.missing", (Object[])new Object[0]));
                            hasErrors = true;
                        }
                        if (this.builder.getTokenType() != XmlTokenType.XML_TAG_END) {
                            this.builder.error(XmlPsiBundle.message((String)"xml.parsing.closing.tag.is.not.done", (Object[])new Object[0]));
                            hasErrors = true;
                        } else {
                            this.builder.advanceLexer();
                        }
                        endTagStart.drop();
                        boolean bl = !hasErrors;
                        return bl;
                    }
                    if (currentTokenType == JSTokenTypes.XML_NAME) {
                        this.parseAttribute();
                    } else if (currentTokenType == JSTokenTypes.XML_TAG_CONTENT) {
                        PsiBuilder.Marker xmlTextMarker = this.builder.mark();
                        this.builder.advanceLexer();
                        xmlTextMarker.done(JSElementTypes.XML_TEXT);
                    } else {
                        if (currentTokenType == JSTokenTypes.XML_TAG_END) {
                            seenEnd = true;
                        }
                        if (currentTokenType == JSTokenTypes.XML_LBRACE) {
                            this.parseXmlJsScript(null);
                        } else {
                            if (currentTokenType == JSTokenTypes.XML_RBRACE) {
                                this.builder.error(JavaScriptBundle.message("javascript.parser.message.unexpected.token", this.builder.getTokenText()));
                            }
                            this.builder.advanceLexer();
                        }
                        if (currentTokenType != JSTokenTypes.XML_LBRACE && this.builder.getTokenType() == JSTokenTypes.XML_ATTR_EQUAL) {
                            this.builder.error(JavaScriptBundle.message("javascript.parser.message.missing.attribute.name", new Object[0]));
                            hasErrors = true;
                        }
                    }
                }
                currentTokenType = this.builder.getTokenType();
            }
            boolean bl = !hasErrors;
            return bl;
        }
        finally {
            tagNames.pop();
            marker.done(this.getXmlLiteralExpression());
            marker.setCustomEdgeTokenBinders(null, INCOMPLETE_TAG_WHITESPACE_BINDER);
        }
    }

    private void parseXmlJsScript(@Nullable StringBuilder text) {
        int textStart = this.builder.getCurrentOffset();
        if (this.myParser != null) {
            ((ExpressionParser)this.myParser.getExpressionParser()).parseScriptExpression(false);
        } else {
            assert (this.builder.getTokenType() == JSTokenTypes.XML_LBRACE);
            if (text != null) {
                text.append(this.builder.getTokenText());
            }
            PsiBuilder.Marker xmlJsScript = this.builder.mark();
            this.builder.advanceLexer();
            int braceBalance = 1;
            while (braceBalance > 0 && !this.builder.eof()) {
                IElementType tokenType = this.builder.getTokenType();
                if (tokenType == JSTokenTypes.XML_LBRACE) {
                    ++braceBalance;
                } else if (tokenType == JSTokenTypes.XML_RBRACE) {
                    --braceBalance;
                }
                if (text != null) {
                    text.append(this.builder.getTokenText());
                }
                this.builder.advanceLexer();
            }
            xmlJsScript.collapse(JSStubElementTypes.XML_JS_SCRIPT);
        }
        if (text != null) {
            text.append(StringUtil.trim((CharSequence)new CharSequenceSubSequence(this.builder.getOriginalText(), textStart, this.builder.getCurrentOffset())));
        }
    }

    @NotNull
    protected IElementType getXmlLiteralExpression() {
        return JSElementTypes.XML_LITERAL_EXPRESSION;
    }

    protected boolean parseSpecialTagEntity(IElementType currentTokenType) {
        return false;
    }

    private void parseAttribute() {
        assert (this.builder.getTokenType() == XmlTokenType.XML_NAME);
        PsiBuilder.Marker att = this.builder.mark();
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == XmlTokenType.XML_EQ) {
            this.builder.advanceLexer();
            this.parseAttributeValue();
        }
        att.done((IElementType)JSStubElementTypes.XML_ATTRIBUTE);
    }

    private void parseAttributeValue() {
        PsiBuilder.Marker attValue = this.builder.mark();
        if (this.builder.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            IElementType tt;
            while ((tt = this.builder.getTokenType()) != null && tt != XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER && tt != XmlTokenType.XML_END_TAG_START && tt != XmlTokenType.XML_EMPTY_ELEMENT_END && tt != XmlTokenType.XML_START_TAG_START) {
                this.builder.advanceLexer();
            }
            if (this.builder.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                this.builder.advanceLexer();
            } else {
                this.builder.error(XmlPsiBundle.message((String)"xml.parsing.unclosed.attribute.value", (Object[])new Object[0]));
            }
        } else if (this.builder.getTokenType() != XmlTokenType.XML_TAG_END && this.builder.getTokenType() != XmlTokenType.XML_EMPTY_ELEMENT_END) {
            if (this.builder.getTokenType() == JSTokenTypes.XML_LBRACE) {
                this.parseXmlJsScript(null);
            } else {
                this.builder.advanceLexer();
            }
        }
        attValue.done(JSElementTypes.XML_ATTRIBUTE_VALUE);
    }
}

