/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.javascript.flow.psi;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.WhitespacesBinders;
import fleet.com.intellij.lang.ecmascript6.parsing.ES6FunctionParser;
import fleet.com.intellij.lang.ecmascript6.parsing.ES6Parser;
import fleet.com.intellij.lang.ecmascript6.parsing.ES6StatementParser;
import fleet.com.intellij.lang.javascript.JSKeywordSets;
import fleet.com.intellij.lang.javascript.JSStubElementTypes;
import fleet.com.intellij.lang.javascript.JSTokenTypes;
import fleet.com.intellij.lang.javascript.JavaScriptBundle;
import fleet.com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptPsiTypeParser;
import fleet.com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptStatementParser;
import fleet.com.intellij.lang.javascript.flow.FlowJSStubElementTypes;
import fleet.com.intellij.lang.javascript.flow.psi.FlowInJSPsiTypeParser;
import fleet.com.intellij.lang.javascript.flow.psi.FlowJSParser;
import fleet.com.intellij.lang.javascript.flow.psi.FlowJSPsiTypeParser;
import fleet.com.intellij.lang.javascript.parsing.FunctionParser;
import fleet.com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import fleet.com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructureLeaf;
import fleet.com.intellij.lang.javascript.parsing.modifiers.JSOneOfModifiersStructure;
import fleet.com.intellij.lang.javascript.parsing.modifiers.JSOrderedModifiersStructure;
import fleet.com.intellij.psi.tree.IElementType;
import java.util.EnumSet;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlowJSStatementParser
extends ES6StatementParser<FlowJSParser> {
    private static final JSModifiersStructure DECLARE_CLASS_MEMBER_MODIFIERS = new JSOrderedModifiersStructure(new JSModifiersStructureLeaf(JSTokenTypes.STATIC_KEYWORD), new JSModifiersStructureLeaf(JSTokenTypes.PROTO_KEYWORD), new JSOneOfModifiersStructure(JSTokenTypes.PLUS, JSTokenTypes.MINUS), new JSOneOfModifiersStructure(JSTokenTypes.GET_KEYWORD, JSTokenTypes.SET_KEYWORD));
    private static final Predicate<PsiBuilder> IS_MEMBER_NAME_START = builder -> {
        IElementType type = builder.getTokenType();
        return type == JSTokenTypes.LBRACKET || JSKeywordSets.PROPERTY_NAMES.contains(type);
    };
    private static final JSModifiersStructure CLASS_DECLARE_FIELD_MODIFIERS = new JSOrderedModifiersStructure(new JSModifiersStructureLeaf(JSTokenTypes.DECLARE_KEYWORD), new JSModifiersStructureLeaf(JSTokenTypes.STATIC_KEYWORD), new JSOneOfModifiersStructure(JSTokenTypes.PLUS, JSTokenTypes.MINUS));
    private static final JSModifiersStructure CLASS_MEMBER_MODIFIERS_STRUCTURE = new JSOrderedModifiersStructure(new JSOneOfModifiersStructure(JSTokenTypes.PRIVATE_KEYWORD, JSTokenTypes.PUBLIC_KEYWORD), new JSModifiersStructureLeaf(JSTokenTypes.STATIC_KEYWORD), new JSModifiersStructureLeaf(JSTokenTypes.ACCESSOR_KEYWORD), new JSOneOfModifiersStructure(JSTokenTypes.PLUS, JSTokenTypes.MINUS), new JSModifiersStructureLeaf(JSTokenTypes.ASYNC_KEYWORD), new JSOneOfModifiersStructure(JSTokenTypes.GET_KEYWORD, JSTokenTypes.SET_KEYWORD), new JSModifiersStructureLeaf(JSTokenTypes.MULT));

    public FlowJSStatementParser(FlowJSParser parser) {
        super(parser);
    }

    @Override
    protected void parseInterfaceNoMarker(@NotNull PsiBuilder.Marker clazz) {
        TypeScriptStatementParser.parseInterface(clazz, this, (ES6Parser)this.myJavaScriptParser, this.builder);
    }

    @Override
    public void parseStatement() {
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken == JSTokenTypes.TYPE_KEYWORD && this.isIdentifierToken(this.builder.lookAhead(1)) || firstToken == JSTokenTypes.OPAQUE_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.TYPE_KEYWORD) {
            PsiBuilder.Marker marker = this.startAttributeListOwner();
            this.parseTypeAlias(marker, firstToken);
            return;
        }
        if (firstToken == JSTokenTypes.ENUM_KEYWORD) {
            PsiBuilder.Marker marker = this.startAttributeListOwner();
            this.parseEnumNoMarker(marker);
            return;
        }
        if (this.builder.getTokenType() == JSTokenTypes.DECLARE_KEYWORD) {
            @Nullable FunctionParser.MethodEmptiness functionType = (FunctionParser.MethodEmptiness)((Object)this.builder.getUserData(FunctionParser.methodsEmptinessKey));
            this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)FunctionParser.MethodEmptiness.ALWAYS);
            boolean parsed = this.parseDeclareStatement();
            this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)functionType);
            if (parsed) {
                return;
            }
        }
        super.parseStatement();
    }

    private boolean parseDeclareStatement() {
        if (this.builder.lookAhead(1) == JSTokenTypes.MODULE_KEYWORD) {
            this.parseDeclareModule();
            this.checkForSemicolon();
            return true;
        }
        if (this.builder.lookAhead(1) == JSTokenTypes.EXPORT_KEYWORD && !EXPORTABLE_ELEMENTS_KEYWORDS.contains(this.builder.lookAhead(2)) && this.builder.lookAhead(2) != JSTokenTypes.INTERFACE_KEYWORD) {
            PsiBuilder.Marker attrList = this.builder.mark();
            this.builder.advanceLexer();
            attrList.done(((ES6FunctionParser)((FlowJSParser)this.myJavaScriptParser).getFunctionParser()).getAttributeListElementType());
            PsiBuilder.Marker marker = attrList.precede();
            if (this.builder.lookAhead(1) == JSTokenTypes.DEFAULT_KEYWORD && this.builder.lookAhead(2) != JSTokenTypes.FUNCTION_KEYWORD && this.builder.lookAhead(2) != JSTokenTypes.CLASS_KEYWORD) {
                this.builder.advanceLexer();
                LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.DEFAULT_KEYWORD);
                this.builder.advanceLexer();
                ((FlowInJSPsiTypeParser)((FlowJSParser)this.myJavaScriptParser).getTypeParser()).parseType();
                this.forceCheckForSemicolon();
                marker.done((IElementType)FlowJSStubElementTypes.DECLARE_EXPORT_DECLARATION);
                marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
            } else {
                this.tryParseES6ExportStatement(marker);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean parseDialectSpecificSourceElements(PsiBuilder.Marker marker) {
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken == JSTokenTypes.TYPE_KEYWORD || firstToken == JSTokenTypes.OPAQUE_KEYWORD) {
            this.parseTypeAlias(marker, firstToken);
            return true;
        }
        return super.parseDialectSpecificSourceElements(marker);
    }

    private void parseTypeAlias(@NotNull PsiBuilder.Marker marker, @NotNull IElementType firstToken) {
        if (firstToken == JSTokenTypes.OPAQUE_KEYWORD) {
            this.builder.advanceLexer();
            if (this.builder.getTokenType() != JSTokenTypes.TYPE_KEYWORD) {
                this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.type.keyword", new Object[0]));
                marker.done((IElementType)JSStubElementTypes.TYPESCRIPT_TYPE_ALIAS);
                return;
            }
        }
        this.builder.putUserData(FlowJSPsiTypeParser.OPAQUE_TYPE_KEY, (Object)(firstToken == JSTokenTypes.OPAQUE_KEYWORD ? 1 : 0));
        TypeScriptStatementParser.parseTypeAlias(marker, this.builder, (ES6Parser)this.myJavaScriptParser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseDeclareModule() {
        PsiBuilder.Marker module = this.builder.mark();
        PsiBuilder.Marker attrList = this.builder.mark();
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.DECLARE_KEYWORD);
        this.builder.advanceLexer();
        attrList.done(((ES6FunctionParser)((FlowJSParser)this.myJavaScriptParser).getFunctionParser()).getAttributeListElementType());
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.MODULE_KEYWORD);
        this.builder.advanceLexer();
        if (JSTokenTypes.STRING_LITERALS.contains(this.builder.getTokenType())) {
            ((FlowJSParser)this.myJavaScriptParser).buildTokenElement(JSStubElementTypes.LITERAL_EXPRESSION);
        } else if (this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.advanceLexer();
        } else {
            if (this.builder.getTokenType() == JSTokenTypes.DOT && this.builder.lookAhead(1) == JSTokenTypes.IDENTIFIER) {
                this.builder.advanceLexer();
                if (!"exports".equals(this.builder.getTokenText())) {
                    this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.exports", new Object[0]));
                }
                this.builder.advanceLexer();
                FlowJSStatementParser.checkMatches(this.builder, JSTokenTypes.COLON, "javascript.parser.message.expected.colon");
                ((FlowInJSPsiTypeParser)((FlowJSParser)this.myJavaScriptParser).getTypeParser()).parseType();
                module.done((IElementType)FlowJSStubElementTypes.FLOW_MODULE);
                module.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
                return;
            }
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.name", new Object[0]));
            module.drop();
            return;
        }
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.lbrace", new Object[0]));
            module.drop();
            return;
        }
        this.builder.advanceLexer();
        @Nullable FunctionParser.MethodEmptiness methodsMustBeEmpty = (FunctionParser.MethodEmptiness)((Object)this.builder.getUserData(FunctionParser.methodsEmptinessKey));
        Boolean forcedType = (Boolean)this.builder.getUserData(FlowJSPsiTypeParser.FORCED_TYPE_KEY);
        try {
            this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)FunctionParser.MethodEmptiness.ALWAYS);
            this.builder.putUserData(FlowJSPsiTypeParser.FORCED_TYPE_KEY, (Object)Boolean.TRUE);
            while (this.builder.getTokenType() != JSTokenTypes.RBRACE) {
                if (this.builder.eof()) {
                    this.builder.error(JavaScriptBundle.message("javascript.parser.message.missing.rbrace", new Object[0]));
                    module.drop();
                    return;
                }
                if (this.builder.getTokenType() != JSTokenTypes.DECLARE_KEYWORD && this.builder.getTokenType() != JSTokenTypes.IMPORT_KEYWORD) {
                    this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.declare", new Object[0]));
                }
                this.parseStatement();
            }
            this.builder.advanceLexer();
        }
        finally {
            this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)methodsMustBeEmpty);
            this.builder.putUserData(FlowJSPsiTypeParser.FORCED_TYPE_KEY, (Object)forcedType);
        }
        module.done((IElementType)FlowJSStubElementTypes.FLOW_MODULE);
        module.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    @Override
    protected void parseClassMember() {
        if (this.builder.getUserData(FunctionParser.methodsEmptinessKey) == FunctionParser.MethodEmptiness.ALWAYS) {
            PsiBuilder.Marker classMember = this.builder.mark();
            boolean lexerAdvanced = ((FlowJSParser)this.myJavaScriptParser).parseModifiers(DECLARE_CLASS_MEMBER_MODIFIERS, true, IS_MEMBER_NAME_START).contains((Object)JSModifiersStructure.JSModifiersParseResult.LEXER_ADVANCED);
            IElementType memberStart = this.builder.getTokenType();
            if (memberStart == JSTokenTypes.LBRACKET) {
                TypeScriptPsiTypeParser.parseIndexSignatureNoMarker(classMember, this.builder, (ES6Parser)this.myJavaScriptParser, false, false);
                this.parseClassMembersSeparator();
                return;
            }
            if (JSKeywordSets.PROPERTY_NAMES.contains(memberStart)) {
                this.builder.advanceLexer();
                lexerAdvanced = true;
                ((FlowInJSPsiTypeParser)((FlowJSParser)this.myJavaScriptParser).getTypeParser()).parseInterfaceSimplePropertyOrFunction(classMember);
            } else if (memberStart == JSTokenTypes.LPAR || memberStart == JSTokenTypes.LT) {
                lexerAdvanced = !((ES6FunctionParser)((FlowJSParser)this.myJavaScriptParser).getFunctionParser()).parseParameterList((boolean)false).hasErrors;
                lexerAdvanced |= this.builder.getTokenType() != JSTokenTypes.COLON || ((FlowInJSPsiTypeParser)((FlowJSParser)this.myJavaScriptParser).getTypeParser()).tryParseType();
                classMember.done((IElementType)JSStubElementTypes.CALL_SIGNATURE);
            } else {
                classMember.drop();
                this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.declaration", new Object[0]));
            }
            if (!lexerAdvanced) {
                this.builder.advanceLexer();
            }
            this.parseClassMembersSeparator();
            return;
        }
        if (this.builder.getTokenType() == JSTokenTypes.DECLARE_KEYWORD) {
            PsiBuilder.Marker classMember = this.builder.mark();
            boolean lexerAdvanced = ((FlowJSParser)this.myJavaScriptParser).parseModifiers(CLASS_DECLARE_FIELD_MODIFIERS, true, b -> JSKeywordSets.IDENTIFIER_NAMES.contains(b.getTokenType())).contains((Object)JSModifiersStructure.JSModifiersParseResult.LEXER_ADVANCED);
            if (lexerAdvanced) {
                this.parseMemberVariable(this.builder.mark(), classMember, false);
                return;
            }
            classMember.drop();
        }
        super.parseClassMember();
    }

    private void parseClassMembersSeparator() {
        if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
            this.builder.advanceLexer();
        } else {
            this.forceCheckForSemicolon();
        }
    }

    @Override
    @NotNull
    protected EnumSet<JSModifiersStructure.JSModifiersParseResult> parseClassMemberModifiers() {
        return ((FlowJSParser)this.myJavaScriptParser).parseModifiers(CLASS_MEMBER_MODIFIERS_STRUCTURE, false, IS_MEMBER_NAME_START);
    }

    @Override
    protected boolean shouldParseTypeImports(IElementType type) {
        return type == JSTokenTypes.TYPE_KEYWORD || type == JSTokenTypes.TYPEOF_KEYWORD;
    }

    @Override
    protected boolean shouldParseTypeExports(IElementType type) {
        return type == JSTokenTypes.TYPE_KEYWORD;
    }

    @Override
    protected void parseReferencesList() {
        super.parseReferencesList();
        if (this.builder.getTokenType() == JSTokenTypes.MIXINS_KEYWORD) {
            this.parseReferenceList(this.getClassExtendListElementType());
        }
    }

    @Override
    protected boolean parseES6ImportOrExportSpecifier(boolean isImport, @NotNull PsiBuilder.Marker marker, boolean stopOnFirstError) {
        IElementType tokenType = this.builder.getTokenType();
        if ((tokenType == JSTokenTypes.TYPE_KEYWORD || tokenType == JSTokenTypes.TYPEOF_KEYWORD) && this.isIdentifierToken(this.builder.lookAhead(1))) {
            this.builder.advanceLexer();
        }
        return super.parseES6ImportOrExportSpecifier(isImport, marker, stopOnFirstError);
    }

    @Override
    protected IElementType getClassElementType() {
        return FlowJSStubElementTypes.FLOW_JS_CLASS;
    }

    @Override
    protected IElementType getClassExpressionElementType() {
        return FlowJSStubElementTypes.FLOW_JS_CLASS_EXPRESSION;
    }
}

