/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.javascript.ecmascript6.parsing;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.javascript.JSStubElementTypes;
import fleet.com.intellij.lang.javascript.JSTokenTypes;
import fleet.com.intellij.lang.javascript.ecmascript6.JSXXmlTokensParser;
import fleet.com.intellij.lang.javascript.parsing.JavaScriptParser;
import fleet.com.intellij.lang.typescript.TypeScriptElementTypes;
import fleet.com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptXmlTokensParser
extends JSXXmlTokensParser {
    public TypeScriptXmlTokensParser(@NotNull JavaScriptParser<?, ?, ?, ?> parser) {
        super(parser);
    }

    @Nullable
    private IElementType lookbehindSkipWhitespaces() {
        IElementType elementType;
        int i = -1;
        while ((elementType = this.builder.rawLookup(i)) != null && JSTokenTypes.COMMENTS_AND_WHITESPACES.contains(elementType)) {
            --i;
        }
        return elementType;
    }

    @Override
    protected boolean parseSpecialTagEntity(IElementType firstTokenType) {
        if (firstTokenType == JSTokenTypes.LT && this.lookbehindSkipWhitespaces() == JSTokenTypes.XML_TAG_NAME) {
            PsiBuilder.Marker genericArguments = this.builder.mark();
            this.builder.advanceLexer();
            this.parseTagGenericArgumentsBody();
            IElementType afterNameAndGenericArgumentsType = this.builder.getTokenType();
            if (afterNameAndGenericArgumentsType == JSTokenTypes.XML_TAG_END) {
                this.builder.remapCurrentToken(JSTokenTypes.GT);
            } else if (afterNameAndGenericArgumentsType == JSTokenTypes.GT) {
                this.builder.advanceLexer();
            }
            genericArguments.done((IElementType)TypeScriptElementTypes.TSX_TAG_TYPE_ARGUMENTS_LIST);
            return true;
        }
        if (firstTokenType == JSTokenTypes.GT && this.lookbehindSkipWhitespaces() == JSStubElementTypes.XML_JS_GENERIC_ARG_SCRIPT) {
            this.builder.advanceLexer();
            return true;
        }
        return false;
    }

    private void parseTagGenericArgumentsBody() {
        PsiBuilder.Marker genericArgument = this.builder.mark();
        IElementType tokenType = this.builder.getTokenType();
        int ltGtBalance = 1;
        int braceBalance = 0;
        int parenBalance = 0;
        int bracketBalance = 0;
        while (tokenType != null && tokenType != JSTokenTypes.XML_TAG_END) {
            if (tokenType == JSTokenTypes.LBRACE) {
                ++braceBalance;
            } else if (tokenType == JSTokenTypes.RBRACE) {
                --braceBalance;
            } else if (tokenType == JSTokenTypes.XML_LBRACE) {
                ++braceBalance;
            } else if (tokenType == JSTokenTypes.XML_RBRACE) {
                --braceBalance;
            } else if (tokenType == JSTokenTypes.LBRACKET) {
                ++bracketBalance;
            } else if (tokenType == JSTokenTypes.RBRACKET) {
                --bracketBalance;
            } else if (tokenType == JSTokenTypes.LPAR) {
                ++parenBalance;
            } else if (tokenType == JSTokenTypes.RPAR) {
                --parenBalance;
            } else if (tokenType == JSTokenTypes.LT) {
                ++ltGtBalance;
            } else if (tokenType == JSTokenTypes.GT) {
                if (--ltGtBalance == 0) {
                    genericArgument.collapse(JSStubElementTypes.XML_JS_GENERIC_ARG_SCRIPT);
                    return;
                }
            } else if (tokenType == JSTokenTypes.COMMA && ltGtBalance == 1 && braceBalance == 0 && parenBalance == 0 && bracketBalance == 0) {
                genericArgument.collapse(JSStubElementTypes.XML_JS_GENERIC_ARG_SCRIPT);
                this.builder.advanceLexer();
                tokenType = this.builder.getTokenType();
                genericArgument = this.builder.mark();
                continue;
            }
            this.builder.advanceLexer();
            tokenType = this.builder.getTokenType();
        }
        genericArgument.collapse(JSStubElementTypes.XML_JS_GENERIC_ARG_SCRIPT);
    }
}

