/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.javascript;

import fleet.com.intellij.lexer.StringLiteralLexer;
import fleet.com.intellij.openapi.util.text.StringUtil;
import fleet.com.intellij.psi.StringEscapesTokenTypes;
import fleet.com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public final class JSStringLiteralLexer
extends StringLiteralLexer {
    private final boolean myAllowUnicodeEscapesWithinBraces;
    private final boolean myAllowNonEscapesAfterSlash;

    public JSStringLiteralLexer(char quoteChar, IElementType originalLiteralToken, String additionalValidEscapes, boolean allowOctal, boolean allowUnicodeEscapesWithinBraces, boolean allowNonEscapesAfterSlash) {
        super(quoteChar, originalLiteralToken, true, additionalValidEscapes, allowOctal, true);
        this.myAllowUnicodeEscapesWithinBraces = allowUnicodeEscapesWithinBraces;
        this.myAllowNonEscapesAfterSlash = allowNonEscapesAfterSlash;
    }

    @NotNull
    protected IElementType getUnicodeEscapeSequenceType() {
        if (this.myAllowUnicodeEscapesWithinBraces && this.myStart + 2 < this.myEnd && this.myBuffer.charAt(this.myStart + 2) == '{') {
            int i = this.myStart + 3;
            boolean foundHex = false;
            boolean hadDigitBefore = false;
            while (i < this.myEnd) {
                char c = this.myBuffer.charAt(i);
                if (hadDigitBefore && c == '_') {
                    ++i;
                    hadDigitBefore = false;
                    continue;
                }
                if (!StringUtil.isHexDigit((char)c)) break;
                foundHex = true;
                hadDigitBefore = true;
                ++i;
            }
            return foundHex && i < this.myEnd && this.myBuffer.charAt(i) == '}' ? StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN : StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
        }
        int digitsCount = 0;
        boolean hadDigitBefore = false;
        int i = this.myStart + 2;
        while (digitsCount < 4) {
            if (i >= this.myEnd) {
                return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            }
            char c = this.myBuffer.charAt(i);
            if (!StringUtil.isHexDigit((char)c)) {
                if (!hadDigitBefore || c != '_') {
                    return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                }
                hadDigitBefore = false;
            } else {
                hadDigitBefore = true;
                ++digitsCount;
            }
            ++i;
        }
        return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
    }

    @NotNull
    protected IElementType handleSingleSlashEscapeSequence() {
        return this.myAllowNonEscapesAfterSlash ? this.myOriginalLiteralToken : super.handleSingleSlashEscapeSequence();
    }

    protected int locateHexEscapeSequence(int start, int i) {
        if (!this.myAllowNonEscapesAfterSlash) {
            return super.locateHexEscapeSequence(start, i);
        }
        ++i;
        boolean isValid = true;
        while (i < start + 4) {
            if (i == this.myBufferEnd) {
                isValid = isValid && i == start + 3;
                return !isValid ? start + 1 : i;
            }
            char c = this.myBuffer.charAt(i);
            if (!StringUtil.isHexDigit((char)c)) {
                isValid = false;
            }
            if (c == '\n' || this.myBuffer.charAt(i) == this.myQuoteChar) {
                return !isValid ? start + 1 : i;
            }
            ++i;
        }
        return !isValid ? start + 1 : i;
    }

    protected int locateUnicodeEscapeSequence(int start, int i) {
        if (this.myAllowUnicodeEscapesWithinBraces && ++i < this.myBufferEnd && this.myBuffer.charAt(i) == '{') {
            ++i;
            boolean hadDigitBefore = false;
            boolean isValid = true;
            while (i < this.myBufferEnd) {
                char c = this.myBuffer.charAt(i);
                if (!StringUtil.isHexDigit((char)c)) {
                    if (!hadDigitBefore || c != '_') {
                        if (c == '}') break;
                        isValid = false;
                        break;
                    }
                    ++i;
                    hadDigitBefore = false;
                    continue;
                }
                hadDigitBefore = true;
                ++i;
            }
            if (i < this.myBufferEnd && this.myBuffer.charAt(i) == '}') {
                ++i;
            }
            return this.myAllowNonEscapesAfterSlash && !isValid ? start + 1 : i;
        }
        int digitsCount = 0;
        boolean isValid = true;
        while (digitsCount < 4) {
            if (i == this.myBufferEnd) {
                return this.myAllowNonEscapesAfterSlash ? start + 1 : i;
            }
            char c = this.myBuffer.charAt(i);
            if (c == '\n' || c == this.myQuoteChar) {
                return this.myAllowNonEscapesAfterSlash && !isValid ? start + 1 : i;
            }
            if (StringUtil.isHexDigit((char)c)) {
                ++digitsCount;
            } else {
                isValid = false;
            }
            ++i;
        }
        return this.myAllowNonEscapesAfterSlash && !isValid ? start + 1 : i;
    }
}

